/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import devCovering.PgCovering;
import devCovering.PgFrameField;
import devCovering.PnFrameField;
import devGraph.PgGraphOnElementSet;
import devGraph.PnAbstractGraph;
import devGraph.PnGraphOnElementSet;
import java.awt.Color;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.vecmath.PbVector;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;

public class PnCovering {
    public static PiVector[] makeVertexRotation(PgCovering cov) {
        int numLayers = cov.getSymmetryOrder();
        PgElementSet geom = cov.getGeometry();
        int numElements = geom.getNumElements();
        int numVertices = geom.getNumVertices();
        PiVector[] vertexRotation = new PiVector[numElements];
        PgVertexStar star = new PgVertexStar();
        int e = 0;
        while (e < numElements) {
            vertexRotation[e] = new PiVector(geom.getDimOfElement(e));
            vertexRotation[e].setConstant(Integer.MAX_VALUE);
            ++e;
        }
        PiVector incidentElement = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        PiVector branchPoints = cov.getBranchPoints();
        PiVector branchTypes = cov.getBranchTypes();
        int v = 0;
        while (v < numVertices) {
            star.makeVertexStar(geom, v, incidentElement.m_data[v]);
            PiVector elem = star.getElement();
            PiVector locInd = star.getVertexLocInd();
            int dimOfStar = star.getSize();
            int r = 0;
            int arrayIndex = branchPoints.getIndexOf(v);
            if (arrayIndex == -1 || branchTypes.getEntry(arrayIndex) % numLayers == 0) {
                vertexRotation[elem.m_data[0]].m_data[locInd.getEntry((int)0)] = 0;
                int j = 0;
                while (j < dimOfStar - 1) {
                    int el = elem.m_data[j];
                    int eLocInd = (locInd.getEntry(j) + 1) % geom.getDimOfElement(el);
                    vertexRotation[elem.m_data[j + 1]].m_data[locInd.getEntry((int)(j + 1))] = r += cov.getMatching(el, eLocInd);
                    ++j;
                }
            }
            ++v;
        }
        return vertexRotation;
    }

    public static PgElementSet calcCoveringGeometry(PgCovering cov) {
        return PnCovering.calcElementBasedCoveringGeometry(cov, null, 0.0);
    }

    public static PgElementSet calcCoveringGeometry(PgFrameField field) {
        return PnCovering.calcElementBasedCoveringGeometry(field);
    }

    public static PgElementSet calcCoveringGeometry(PgFrameField field, double distance) {
        return PnCovering.calcElementBasedCoveringGeometry(field.getCovering(), field, distance);
    }

    private static PgElementSet calcElementBasedCoveringGeometry(PgFrameField field) {
        return PnCovering.calcElementBasedCoveringGeometry(field.getCovering(), field, 0.0);
    }

    private static PgElementSet calcElementBasedCoveringGeometry(PgCovering inputCov, PgFrameField field, double distance) {
        int j;
        if (inputCov == null) {
            return null;
        }
        PgElementSet geom = inputCov.getGeometry();
        int numLayers = inputCov.getSymmetryOrder();
        int numVertices = geom.getNumVertices();
        int numElements = geom.getNumElements();
        geom.assureVertexNormals();
        PgElementSet cov = new PgElementSet(3);
        cov.setName("Covering of " + geom.getName());
        cov.setNumVertices(numVertices * numLayers);
        int v = 0;
        while (v < numVertices) {
            PdVector vertex = geom.getVertex(v);
            int i = 0;
            while (i < numLayers) {
                PdVector covVertex = cov.getVertex(i * numVertices + v);
                covVertex.blend(1.0, vertex, distance * (double)(i - numLayers / 2), geom.getVertexNormal(v));
                cov.setVertexNormal(i * numVertices + v, geom.getVertexNormal(v));
                ++i;
            }
            ++v;
        }
        cov.setNumElements(numLayers * numElements);
        int e = 0;
        while (e < numElements * numLayers) {
            cov.setElement(e, 0, 0, 0);
            ++e;
        }
        PdVector[][] tex = null;
        if (numLayers == 4) {
            tex = geom.getElementTextures();
            cov.setTexture(geom.getTexture());
            cov.assureElementTextures();
            cov.showElementTexture(true);
        }
        PgVertexStar star = new PgVertexStar();
        boolean[] vertexVisited = new boolean[numVertices];
        int initialE = 0;
        while (initialE < numElements) {
            PiVector initialElement = geom.getElement(initialE);
            int ieSize = initialElement.getSize();
            int j2 = 0;
            while (j2 < ieSize) {
                int v2 = initialElement.m_data[j2];
                if (!vertexVisited[v2]) {
                    int e2;
                    int eIdx;
                    int i;
                    vertexVisited[v2] = true;
                    star.makeVertexStar(geom, v2, initialE);
                    PiVector elements = star.getElement();
                    PiVector locVInd = star.getVertexLocInd();
                    int starSize = star.getSize();
                    int vertexLayer = 0;
                    int elementLayer = 0;
                    if (star.isClosed()) {
                        i = 0;
                        while (i < numLayers) {
                            eIdx = 0;
                            while (eIdx < starSize) {
                                e2 = elements.m_data[eIdx];
                                int ne = elements.m_data[(eIdx + 1) % starSize];
                                int neighbIdx = geom.getNeighbour(e2).getIndexOf(ne);
                                int oppNeighIndex = geom.getOppVertexLocInd(e2, neighbIdx);
                                int covEIdx = PuMath.modulo((int)(elementLayer + vertexLayer), (int)numLayers) * numElements + e2;
                                PiVector covElement = cov.getElement(covEIdx);
                                covElement.m_data[locVInd.m_data[eIdx]] = vertexLayer * numVertices + v2;
                                int m = inputCov.getMatching(e2, neighbIdx);
                                elementLayer = PuMath.modulo((int)(elementLayer + m), (int)numLayers);
                                cov.getNeighbour((int)covEIdx).m_data[neighbIdx] = ne + PuMath.modulo((int)(elementLayer + vertexLayer), (int)numLayers) * numElements;
                                cov.getNeighbour((int)(ne + PuMath.modulo((int)(elementLayer + vertexLayer), (int)numLayers) * numElements)).m_data[oppNeighIndex] = covEIdx;
                                ++eIdx;
                            }
                            if (elementLayer == 0) {
                                ++vertexLayer;
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < numLayers) {
                            eIdx = 0;
                            while (eIdx < starSize) {
                                e2 = elements.m_data[eIdx];
                                int covEIdx = PuMath.modulo((int)(elementLayer + vertexLayer), (int)numLayers) * numElements + e2;
                                PiVector covElement = cov.getElement(covEIdx);
                                covElement.m_data[locVInd.m_data[eIdx]] = vertexLayer * numVertices + v2;
                                if (eIdx < starSize - 1) {
                                    int ne = elements.m_data[(eIdx + 1) % starSize];
                                    int neighbIdx = geom.getNeighbour(e2).getIndexOf(ne);
                                    int oppNeighIndex = geom.getOppVertexLocInd(e2, neighbIdx);
                                    elementLayer = PuMath.modulo((int)(elementLayer + inputCov.getMatching(e2, neighbIdx)), (int)numLayers);
                                    cov.getNeighbour((int)covEIdx).m_data[neighbIdx] = ne + PuMath.modulo((int)(elementLayer + vertexLayer), (int)numLayers) * numElements;
                                    cov.getNeighbour((int)(ne + PuMath.modulo((int)(elementLayer + vertexLayer), (int)numLayers) * numElements)).m_data[oppNeighIndex] = covEIdx;
                                }
                                PiVector neigh = geom.getNeighbour(e2);
                                int k = 0;
                                while (k < 3) {
                                    if (neigh.m_data[k] == -1) {
                                        cov.getNeighbour((int)covEIdx).m_data[k] = -1;
                                    }
                                    ++k;
                                }
                                ++eIdx;
                            }
                            elementLayer = 0;
                            ++vertexLayer;
                            ++i;
                        }
                    }
                }
                ++j2;
            }
            ++initialE;
        }
        if (field != null) {
            PgVectorField covField = new PgVectorField(3, 1);
            covField.setGeometry((PgPointSet)cov);
            int i = 0;
            while (i < numLayers) {
                int e3 = 0;
                while (e3 < numElements) {
                    covField.setVector(i * numElements + e3, field.getVector(e3, i, 0, null));
                    ++e3;
                }
                ++i;
            }
            cov.addVectorField(covField);
        }
        if (tex != null) {
            int i = 0;
            while (i < numLayers) {
                int e4 = 0;
                while (e4 < numElements) {
                    PdVector[] covTex = cov.getElementTexture(i * numElements + e4);
                    int elementSize = cov.getElement(e4).getSize();
                    j = 0;
                    while (j < elementSize) {
                        covTex[j].copy(tex[e4][j]);
                        switch (i) {
                            case 0: {
                                covTex[j].m_data[1] = 0.5;
                                break;
                            }
                            case 1: {
                                covTex[j].m_data[0] = 0.5;
                                break;
                            }
                            case 2: {
                                covTex[j].m_data[1] = 0.5;
                                covTex[j].m_data[0] = covTex[j].m_data[0] * -1.0;
                                break;
                            }
                            case 3: {
                                covTex[j].m_data[0] = 0.5;
                                covTex[j].m_data[1] = covTex[j].m_data[1] * -1.0;
                            }
                        }
                        ++j;
                    }
                    ++e4;
                }
                ++i;
            }
        }
        cov.assureDimOfElements();
        int numEdges = 0;
        int i = 0;
        while (i < numElements * numLayers) {
            PiVector neigh = cov.getNeighbour(i);
            int j3 = 0;
            while (j3 < 3) {
                if (neigh.m_data[j3] < i) {
                    ++numEdges;
                }
                ++j3;
            }
            ++i;
        }
        PgEdgeStar[] edgeStar = new PgEdgeStar[numEdges];
        numEdges = 0;
        int i2 = 0;
        while (i2 < numElements * numLayers) {
            PiVector neigh = cov.getNeighbour(i2);
            PiVector element = cov.getElement(i2);
            j = 0;
            while (j < 3) {
                if (neigh.m_data[j] < i2) {
                    edgeStar[numEdges] = new PgEdgeStar(element.m_data[(j + 1) % 3], element.m_data[(j + 2) % 3]);
                    if (neigh.m_data[j] == -1) {
                        edgeStar[numEdges].setValence(1);
                    } else {
                        edgeStar[numEdges].setValence(2);
                        edgeStar[numEdges].setElementInd(1, neigh.m_data[j]);
                        edgeStar[numEdges].setNeighbourLocInd(1, cov.getOppVertexLocInd(i2, j));
                    }
                    edgeStar[numEdges].setElementInd(0, i2);
                    edgeStar[numEdges].setNeighbourLocInd(0, j);
                    ++numEdges;
                }
                ++j;
            }
            ++i2;
        }
        cov.allocateEdgeStars();
        cov.makeElementNormals();
        return cov;
    }

    public static PgCovering makeCoveringFromBranchPoints(PgElementSet geom, PiVector bPoints, PiVector bTypes, int symmetryOrder, PgGraphOnElementSet outTree) {
        if (bTypes.sum() != 0) {
            PsDebug.warning((String)"Branch types must sum to 0)");
            return null;
        }
        int numBPoints = bPoints.getSize();
        PgCovering cov = new PgCovering(geom, symmetryOrder);
        cov.setBranchPoints(bPoints, bTypes);
        if (bPoints.getSize() == 0) {
            return cov;
        }
        int root = bPoints.m_data[0];
        PgGraphOnElementSet tree = outTree != null ? outTree : new PgGraphOnElementSet(geom, 0);
        PnGraphOnElementSet.makeSteinerTreeDNH(tree, geom, 0, root, bPoints);
        int i = 0;
        while (i < numBPoints) {
            geom.setTagVertex(bPoints.m_data[i], 1);
            ++i;
        }
        PnAbstractGraph.removeStubs(tree, bPoints);
        i = 0;
        while (i < numBPoints) {
            geom.clearTagVertex(bPoints.m_data[i], 1);
            ++i;
        }
        int numHandledEdges = 0;
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int numVertices = geom.getNumVertices();
        PbVector markedNodes = new PbVector(numVertices);
        int i2 = 0;
        while (i2 < numBPoints) {
            markedNodes.m_data[bPoints.m_data[i2]] = true;
            ++i2;
        }
        while (numHandledEdges < numBPoints - 1) {
            int bp = 1;
            while (bp < numBPoints) {
                int actNode = bPoints.m_data[bp];
                if (tree.getValence(actNode) == 1) {
                    ++numHandledEdges;
                    int m = bTypes.m_data[bp] - cov.calcIndex(actNode, elementPerVertex.m_data[actNode]);
                    PiVector path = PnAbstractGraph.pathToRoot(tree, actNode);
                    int len = path.getSize();
                    int i3 = 0;
                    while (i3 < len - 1) {
                        PgVertexStar star = new PgVertexStar();
                        int v = path.m_data[i3];
                        star.makeVertexStar(geom, v, elementPerVertex.m_data[v]);
                        PiVector link = star.getLink();
                        int loc = link.getIndexOf(path.m_data[i3 + 1]);
                        if (loc < 0) {
                            PsDebug.warning((String)"Error in neighbours");
                            return null;
                        }
                        int e = star.getElement().m_data[loc];
                        int dim = geom.getDimOfElement(e);
                        int locVInd = (dim + star.getVertexLocInd().m_data[loc] - 1) % dim;
                        cov.setMatching(e, locVInd, m + cov.getMatching(e, locVInd));
                        ++i3;
                    }
                    markedNodes.m_data[actNode] = false;
                    PnAbstractGraph.removeStub(tree, actNode, markedNodes);
                }
                ++bp;
            }
        }
        return cov;
    }

    public static PgCovering makeCoveringFromBranchPoints2(PgElementSet geom, PiVector bPoints, PiVector bTypes, int symmetryOrder, PgGraphOnElementSet tree) {
        if (bTypes.sum() != 0) {
            PsDebug.warning((String)"Branch types must sum to 0)");
            return null;
        }
        int numBPoints = bPoints.getSize();
        PgCovering cov = new PgCovering(geom, symmetryOrder);
        cov.setBranchPoints(bPoints, bTypes);
        if (bPoints.getSize() == 0) {
            return cov;
        }
        tree = tree == null ? PnGraphOnElementSet.makeShortestCutGraph(geom, null, bPoints) : PgGraphOnElementSet.copyNew(tree);
        PnAbstractGraph.makeSubtree(tree, tree, bPoints);
        PnAbstractGraph.removeStubs(tree, bPoints);
        int numHandledEdges = 0;
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)geom);
        int numVertices = geom.getNumVertices();
        PbVector markedNodes = new PbVector(numVertices);
        int i = 0;
        while (i < numBPoints) {
            markedNodes.m_data[bPoints.m_data[i]] = true;
            ++i;
        }
        while (numHandledEdges < numBPoints - 1) {
            boolean done = true;
            int bp = 1;
            while (bp < numBPoints) {
                int actNode = bPoints.m_data[bp];
                if (tree.getValence(actNode) == 1) {
                    done = false;
                    ++numHandledEdges;
                    int m = bTypes.m_data[bp] - cov.calcIndex(actNode, elementPerVertex.m_data[actNode]);
                    PiVector path = PnAbstractGraph.pathToRoot(tree, actNode);
                    int len = path.getSize();
                    int i2 = 0;
                    while (i2 < len - 1) {
                        PgVertexStar star = new PgVertexStar();
                        int v = path.m_data[i2];
                        star.makeVertexStar(geom, v, elementPerVertex.m_data[v]);
                        PiVector link = star.getLink();
                        int loc = link.getIndexOf(path.m_data[i2 + 1]);
                        if (loc < 0) {
                            PsDebug.warning((String)"Error in neighbours");
                            return null;
                        }
                        int e = star.getElement().m_data[loc];
                        int dim = geom.getDimOfElement(e);
                        int locVInd = (dim + star.getVertexLocInd().m_data[loc] - 1) % dim;
                        cov.setMatching(e, locVInd, m + cov.getMatching(e, locVInd));
                        ++i2;
                    }
                    markedNodes.m_data[actNode] = false;
                    PnAbstractGraph.removeStub(tree, actNode, markedNodes);
                }
                ++bp;
            }
            if (done) break;
        }
        return cov;
    }

    public static void filterBranchPoints(PgCovering covering, PiVector branchPoints, PiVector branchTypes, int numLayers) {
        if (covering == null) {
            PsDebug.warning((String)"missing arguments.");
            return;
        }
        PiVector bp = covering.getBranchPoints();
        PiVector bt = covering.getBranchTypes();
        if (branchPoints != null) {
            branchPoints.setSize(bp.getSize());
        }
        if (branchTypes != null) {
            branchTypes.setSize(bt.getSize());
        }
        int numEntries = 0;
        int i = 0;
        while (i < bt.getSize()) {
            if (bt.getEntry(i) % numLayers != 0) {
                if (branchPoints != null) {
                    branchPoints.m_data[numEntries] = bp.m_data[i];
                }
                if (branchTypes != null) {
                    branchTypes.m_data[numEntries] = PuMath.modulo((int)bt.m_data[i], (int)numLayers);
                }
                ++numEntries;
            }
            ++i;
        }
        if (branchPoints != null) {
            branchPoints.setSize(numEntries);
        }
        if (branchTypes != null) {
            branchTypes.setSize(numEntries);
        }
    }

    public static void makeCoveringFromVectorField(PgCovering covering, PgVectorField mField) {
        if (covering == null) {
            PsDebug.warning((String)"No covering.");
            return;
        }
        PgElementSet geom = covering.getGeometry();
        if (geom == null) {
            PsDebug.warning((String)"No geometry set.");
            return;
        }
        int numElements = geom.getNumElements();
        PiVector[] neighb = geom.getNeighbours();
        PiVector[] matching = covering.getMatching();
        int e = 0;
        while (e < numElements) {
            PiVector element = geom.getElement(e);
            int dim = element.getSize();
            PdVector vector = mField.getVector(e);
            int i = 0;
            while (i < dim) {
                int m = (int)vector.m_data[i];
                int ne = neighb[e].m_data[i];
                matching[e].m_data[i] = ne < 0 ? Integer.MAX_VALUE : m;
                ++i;
            }
            ++e;
        }
        covering.updateBranchpoints();
    }

    public static Color[] makeMatchingColors(int numLayers) {
        Color[] c = new Color[numLayers];
        c[0] = Color.black;
        int i = 0;
        while (i < numLayers - 1) {
            c[i + 1] = Color.getHSBColor((float)((double)i * 2.0 / 3.0 / (double)(numLayers - 2)), 1.0f, 1.0f);
            ++i;
        }
        return c;
    }

    public static PgPolygonSet[] makeMatchingGeometry(PgCovering covering) {
        if (covering == null) {
            return null;
        }
        PgElementSet geom = covering.getGeometry();
        if (geom == null) {
            return null;
        }
        int numLayers = covering.getSymmetryOrder();
        int numVertices = geom.getNumVertices();
        PgPolygonSet[] edges = new PgPolygonSet[numLayers];
        Color[] matchingColors = PnCovering.makeMatchingColors(numLayers);
        int i = 0;
        while (i < numLayers) {
            edges[i] = new PgPolygonSet(3);
            edges[i].setNumVertices(numVertices);
            edges[i].setVertices(geom.getVertices());
            int v = 0;
            while (v < numVertices) {
                edges[i].clearTagVertex(v, 1);
                ++v;
            }
            edges[i].setName("Edges r = " + i);
            edges[i].showVertices(false);
            edges[i].setGlobalPolygonColor(matchingColors[i]);
            ++i;
        }
        edges[0].setVisible(false);
        int numE = geom.getNumElements();
        int e = 0;
        while (e < numE) {
            int i2 = 0;
            while (i2 < 3) {
                if (geom.getNeighbour((int)e).m_data[i2] >= e) {
                    int edgeInd = geom.getElementEdge(e, i2);
                    PgEdgeStar edge = geom.getEdgeStar(edgeInd);
                    int m = PuMath.modulo((int)covering.getMatching(e, i2), (int)numLayers);
                    edges[m].addPolygon(new PiVector(edge.getVertexInd(0), edge.getVertexInd(1)));
                }
                ++i2;
            }
            ++e;
        }
        return edges;
    }

    public static void parseMatchingFromVectorField(PgElementSet geom, PgCovering cov) {
        int num = geom.getNumVectorFields();
        PgVectorField matchingField = null;
        int i = 0;
        while (i < num) {
            PgVectorField field = geom.getVectorField(i);
            if (field.getName().equals("matching")) {
                matchingField = field;
                break;
            }
            ++i;
        }
        if (matchingField == null) {
            PsDebug.warning((String)"No matching field found");
            return;
        }
        PnCovering.parseMatchingFromVectorField(geom, matchingField, cov);
    }

    public static void parseMatchingFromVectorField(PgElementSet geom, PgVectorField field, PgCovering cov) {
        int numE = geom.getNumElements();
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                double m = field.getVector((int)e).m_data[i];
                if (m - (double)((int)m) != 0.0) {
                    PsDebug.warning((String)"All matchings must be integers.");
                    return;
                }
                int intM = (int)m;
                int ne = geom.getNeighbour((int)e).m_data[i];
                if (ne >= 0 && e >= ne) {
                    int nLocInd = geom.getOppVertexLocInd(e, i);
                    int neighbM = (int)field.getVector((int)ne).m_data[nLocInd];
                    if (neighbM != -intM) {
                        PsDebug.warning((String)"Matching not valid");
                        return;
                    }
                    cov.setMatching(e, i, intM);
                }
                ++i;
            }
            ++e;
        }
        cov.updateBranchpoints();
    }

    public static void makeMatchingField(PgElementSet geom, PgCovering cov) {
        PgVectorField field = new PgVectorField(3, 1);
        field.setGeometry((PgPointSet)geom);
        field.setName("matching");
        field.setVisible(false);
        int numE = geom.getNumElements();
        int e = 0;
        while (e < numE) {
            int i = 0;
            while (i < 3) {
                field.getVector((int)e).m_data[i] = geom.getNeighbour((int)e).m_data[i] < 0 ? 0.0 : (double)cov.getMatching(e, i);
                ++i;
            }
            ++e;
        }
        geom.addVectorField(field);
    }

    public static void alignMatchings(PgCovering cov, PgGraphOnElementSet tree) {
        PgElementSet geom = cov.getGeometry();
        if (tree == null) {
            tree = new PgGraphOnElementSet(geom, 1);
            PnGraphOnElementSet.makeShortestPathTree(tree);
        }
        PiVector successors = PnAbstractGraph.makeSuccessors(tree);
        int e = tree.getRoots().m_data[0];
        while (e >= 0) {
            int locInd;
            int r;
            int pe = tree.getParent(e);
            if (pe >= 0 && (r = cov.getMatching(e, locInd = geom.getNeighbour(e).getIndexOf(pe))) != 0) {
                int i = 0;
                while (i < 3) {
                    int m = cov.getMatching(e, i);
                    if (m != Integer.MAX_VALUE) {
                        cov.setMatching(e, i, m - r);
                    }
                    ++i;
                }
            }
            e = successors.m_data[e];
        }
    }

    public static void alignMatchingsAndGaps(PgCovering cov, PdVector[] uGaps, PdVector[] vGaps, PgGraphOnElementSet tree) {
        PgElementSet geom = cov.getGeometry();
        if (tree == null) {
            tree = new PgGraphOnElementSet(geom, 1);
            PnGraphOnElementSet.makeShortestPathTree(tree);
        }
        PiVector successors = PnAbstractGraph.makeSuccessors(tree);
        PdVector tmp = new PdVector(2);
        int symmetryOrder = cov.getSymmetryOrder();
        int e = tree.getRoots().m_data[0];
        while (e >= 0) {
            int pe = tree.getParent(e);
            if (pe >= 0) {
                int locInd = geom.getNeighbour(e).getIndexOf(pe);
                int r = cov.getMatching(e, locInd);
                double s = uGaps[e].m_data[locInd];
                double t = vGaps[e].m_data[locInd];
                PiVector neigh = geom.getNeighbour(e);
                int i = 0;
                while (i < 3) {
                    int ne;
                    int m = cov.getMatching(e, i);
                    if (m != Integer.MAX_VALUE && (ne = neigh.m_data[i]) >= 0) {
                        int nLocNeighbInd = geom.getNeighbour(ne).getIndexOf(e);
                        if (r != 0) {
                            cov.setMatching(e, i, m - r);
                        }
                        tmp.m_data[0] = s;
                        tmp.m_data[1] = t;
                        PnFrameField.rot(tmp, m - r, symmetryOrder);
                        int n = i;
                        uGaps[e].m_data[n] = uGaps[e].m_data[n] - tmp.m_data[0];
                        int n2 = i;
                        vGaps[e].m_data[n2] = vGaps[e].m_data[n2] - tmp.m_data[1];
                        tmp.m_data[0] = uGaps[e].m_data[i];
                        tmp.m_data[1] = vGaps[e].m_data[i];
                        PnFrameField.rot(tmp, r - m, symmetryOrder);
                        uGaps[ne].m_data[nLocNeighbInd] = -tmp.m_data[0];
                        vGaps[ne].m_data[nLocNeighbInd] = -tmp.m_data[1];
                    }
                    ++i;
                }
            }
            e = successors.m_data[e];
        }
    }

    public static PgCovering makeCoveringFromParameterization(PgElementSet geom, int symmetryOrder, PdVector[] uGaps, PdVector[] vGaps) {
        PdVector[][] tex = geom.getElementTextures();
        if (tex == null) {
            PsDebug.warning((String)"No element textures given.");
            return null;
        }
        double eps = 0.01;
        PgCovering cov = new PgCovering(geom, symmetryOrder);
        int numElements = geom.getNumElements();
        PdVector edge = new PdVector(2);
        PdVector nEdge = new PdVector(2);
        int e = 0;
        while (e < numElements) {
            int i = 0;
            while (i < 3) {
                int ne = geom.getNeighbour((int)e).m_data[i];
                if (ne >= 0) {
                    int r;
                    double diffAngle;
                    int ni = geom.getOppVertexLocInd(e, i);
                    edge.sub(tex[e][(i + 2) % 3], tex[e][(i + 1) % 3]);
                    nEdge.sub(tex[ne][(ni + 1) % 3], tex[ne][(ni + 2) % 3]);
                    double edgeLen = edge.length();
                    double nEdgeLen = nEdge.length();
                    if (Math.abs(edgeLen - nEdgeLen) > 0.01) {
                        PsDebug.warning((String)"Edges do not have same length in texture space");
                        return null;
                    }
                    if (edgeLen < 0.01) {
                        PsDebug.warning((String)"Edge length is zero in texture space.");
                        return null;
                    }
                    double angle = Math.acos(edge.m_data[0] / edgeLen);
                    if (edge.m_data[1] < 0.0) {
                        angle = Math.PI * 2 - angle;
                    }
                    double nAngle = Math.acos(nEdge.m_data[0] / nEdgeLen);
                    if (nEdge.m_data[1] < 0.0) {
                        nAngle = Math.PI * 2 - nAngle;
                    }
                    if (Math.abs((diffAngle = (nAngle - angle) * (double)symmetryOrder / (Math.PI * 2)) - (double)(r = (int)Math.round(diffAngle))) >= 0.01) {
                        PsDebug.warning((String)"Edges are not rotated by multiples of symmetry order");
                        return null;
                    }
                    cov.setMatching(e, i, r);
                    if (uGaps != null && vGaps != null) {
                        edge.copy(tex[e][(i + 2) % 3]);
                        PnFrameField.rot(edge, r, symmetryOrder);
                        nEdge.copy(tex[ne][(ni + 1) % 3]);
                        nEdge.sub(edge);
                        uGaps[e].m_data[i] = nEdge.m_data[0];
                        vGaps[e].m_data[i] = nEdge.m_data[1];
                        nEdge.copy(tex[ne][(ni + 1) % 3]);
                        PnFrameField.rot(nEdge, -r, symmetryOrder);
                        edge.copy(tex[e][(i + 2) % 3]);
                        edge.sub(nEdge);
                        uGaps[ne].m_data[ni] = edge.m_data[0];
                        vGaps[ne].m_data[ni] = edge.m_data[1];
                    }
                }
                ++i;
            }
            ++e;
        }
        return cov;
    }
}

