/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import devCovering.PgCovering;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;

public class PgPathOnCovering
extends PgPolygon {
    protected PgElementSet m_geom;
    protected PgCovering m_covering;
    protected PiVector m_vertexInd = new PiVector();
    protected PiVector m_edgeInd = new PiVector();
    protected PiVector[] m_elementNeighbour;
    protected PiVector[] m_vertexLocInd;
    protected PiVector[] m_elementLayer;
    protected PgVertexStar m_star = new PgVertexStar();
    protected boolean m_boundaryStart;
    protected int m_numLayers;

    public PgPathOnCovering() {
        this(3);
    }

    public PgPathOnCovering(int aVertexDim) {
        super(aVertexDim);
        if (((Object)((Object)this)).getClass() == PgPathOnCovering.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.showVertices(false);
    }

    public void updatePolygon() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return;
        }
        int i = 0;
        while (i < this.m_numVertices) {
            this.setVertex(i, this.m_geom.getVertex(this.m_vertexInd.getEntry(i)));
            ++i;
        }
    }

    public static PgPathOnCovering copyNew(PgPathOnCovering path) {
        PgPathOnCovering newPath = new PgPathOnCovering();
        newPath.copy(path);
        return newPath;
    }

    public void copy(PgPathOnCovering path) {
        if (path == null) {
            PsDebug.warning((String)"missing path.");
            return;
        }
        this.m_geom = path.m_geom;
        this.m_covering = path.m_covering;
        int length = path.getNumVertices();
        this.setMaxNumVertices(length);
        this.setNumVertices(length);
        this.m_vertexInd.copy(path.m_vertexInd);
        this.m_edgeInd.copy(path.m_edgeInd);
        this.m_elementNeighbour = PiVector.copyNew((PiVector[])path.m_elementNeighbour);
        this.m_vertexLocInd = PiVector.copyNew((PiVector[])path.m_vertexLocInd);
        this.m_elementLayer = PiVector.copyNew((PiVector[])path.m_elementLayer);
        this.m_boundaryStart = path.m_boundaryStart;
        this.m_numLayers = path.m_numLayers;
    }

    public boolean setGeometry(PgElementSet geom, PgCovering covering) {
        if (geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return false;
        }
        if (geom.getEdgeStars() == null) {
            PsDebug.warning((String)"Edges of geometry are null.");
            return false;
        }
        this.m_geom = geom;
        this.setCovering(covering);
        return true;
    }

    public void setCovering(PgCovering covering) {
        this.m_covering = covering;
        this.m_numLayers = covering.getSymmetryOrder();
    }

    public void setMaxNumVertices(int maxNumVertices) {
        if (maxNumVertices == this.m_maxNumVertices) {
            return;
        }
        this.m_vertexInd.setSize(maxNumVertices);
        this.m_edgeInd.setSize(maxNumVertices - 1);
        this.m_elementNeighbour = PiVector.realloc((PiVector[])this.m_elementNeighbour, (int)maxNumVertices, (int)0);
        this.m_vertexLocInd = PiVector.realloc((PiVector[])this.m_vertexLocInd, (int)maxNumVertices, (int)0);
        this.m_elementLayer = PiVector.realloc((PiVector[])this.m_elementLayer, (int)maxNumVertices, (int)0);
        super.setMaxNumVertices(maxNumVertices);
    }

    public boolean makePath(PiVector path, PiVector elementPerVertex) {
        int endVertexInd;
        int endVertex;
        int startVertex;
        if (path == null || path.getSize() < 1) {
            PsDebug.warning((String)"missing or empty path.");
            return false;
        }
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return false;
        }
        int length = path.getSize();
        this.setMaxNumVertices(length);
        this.setNumVertices(length);
        this.m_vertexInd.copy(path);
        if (elementPerVertex == null) {
            elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        }
        if (length == 1) {
            return this.makeSingleVertexPath(path, elementPerVertex);
        }
        this.m_star.makeVertexStar(this.m_geom, path.getFirstEntry(), elementPerVertex.getEntry(path.getFirstEntry()));
        this.m_boundaryStart = !this.m_star.isClosed();
        boolean bClosed = !this.m_boundaryStart && path.getFirstEntry() == path.getLastEntry();
        int layer = 0;
        boolean bError = false;
        if (this.m_boundaryStart) {
            int startVertex2 = this.m_star.getLink().getFirstEntry();
            int endVertex2 = path.getEntry(1);
            layer = this.makePathAroundVertex(0, startVertex2, endVertex2, layer, -1, elementPerVertex.getEntry(path.getFirstEntry()));
            int elemInd = this.m_elementNeighbour[0].getLastEntry();
            int elemSize = this.m_geom.getDimOfElement(elemInd);
            int edgeInd = this.m_geom.getElementEdge(elemInd, (this.m_vertexLocInd[0].getLastEntry() + 1) % elemSize);
            this.m_edgeInd.setEntry(0, edgeInd);
            bError |= layer < -1;
        } else {
            int endVertex3 = path.getEntry(1);
            int endVertexInd2 = this.m_star.getLink().getIndexOf(endVertex3);
            int startVertexInd = (endVertexInd2 - 1 + this.m_star.getSize()) % this.m_star.getSize();
            startVertex = this.m_star.getLink().getEntry(startVertexInd);
            layer = this.makePathAroundVertex(0, startVertex, endVertex3, layer, -1, elementPerVertex.getEntry(path.getFirstEntry()));
            bError |= layer < -1;
        }
        int i = 1;
        while (i < length - 1) {
            int endVertex4;
            int startVertex3 = path.getEntry(i - 1);
            layer = this.makePathAroundVertex(i, startVertex3, endVertex4 = path.getEntry(i + 1), layer, -1, elementPerVertex.getEntry(path.getEntry(i)));
            bError |= layer < -1;
            ++i;
        }
        int centerVertex = path.getLastEntry();
        this.m_star.makeVertexStar(this.m_geom, centerVertex, elementPerVertex.getEntry(centerVertex));
        boolean bBoundaryEnd = !this.m_star.isClosed();
        int len = length - 1;
        startVertex = path.getEntry(len - 1);
        int targetLayer = -1;
        if (bBoundaryEnd) {
            endVertex = this.m_star.getLink().getLastEntry();
        } else if (bClosed) {
            int nextVertexInd = this.m_star.getLink().getIndexOf(path.getEntry(1));
            endVertexInd = (nextVertexInd - 1 + this.m_star.getSize()) % this.m_star.getSize();
            endVertex = this.m_star.getLink().getEntry(endVertexInd);
            targetLayer = 0;
        } else {
            int prevVertexInd = this.m_star.getLink().getIndexOf(path.getEntry(len - 1));
            endVertexInd = (prevVertexInd + 1) % this.m_star.getSize();
            endVertex = this.m_star.getLink().getEntry(endVertexInd);
        }
        layer = this.makePathAroundVertex(len, startVertex, endVertex, layer, targetLayer, elementPerVertex.getEntry(centerVertex));
        if (bError |= layer < -1) {
            return false;
        }
        int i2 = 1;
        while (i2 < length) {
            int elemInd = this.m_elementNeighbour[i2].getEntry(0);
            int elemSize = this.m_geom.getDimOfElement(elemInd);
            int locInd = (this.m_vertexLocInd[i2].getEntry(0) + elemSize - 1) % elemSize;
            int edgeInd = this.m_geom.getElementEdge(elemInd, locInd);
            this.m_edgeInd.setEntry(i2 - 1, edgeInd);
            ++i2;
        }
        return true;
    }

    private boolean makeSingleVertexPath(PiVector path, PiVector elementPerVertex) {
        int v = path.getFirstEntry();
        this.m_star.makeVertexStar(this.m_geom, v, elementPerVertex.m_data[v]);
        int linkSize = this.m_star.getSize();
        int nextLayer = this.makePartialVertexStar(0, 0, linkSize, 0);
        while (nextLayer != 0 && nextLayer != Integer.MAX_VALUE) {
            nextLayer = this.makePartialVertexStar(0, 0, linkSize, nextLayer);
        }
        return true;
    }

    private int makePathAroundVertex(int index, int startVertex, int endVertex, int initialLayer, int targetLayer, int elementAtCenterVertex) {
        boolean bClose;
        int centerVertex = this.m_vertexInd.getEntry(index);
        PiVector element = this.m_elementNeighbour[index];
        PiVector vertexLocInd = this.m_vertexLocInd[index];
        PiVector elementLayer = this.m_elementLayer[index];
        boolean bl = bClose = targetLayer >= 0;
        if (bClose && this.m_covering == null) {
            PsDebug.warning((String)"Target layer specified but no covering is set.");
            return -2;
        }
        if (this.m_covering != null) {
            targetLayer %= this.m_numLayers;
        }
        int numVertices = this.m_geom.getNumVertices();
        if (centerVertex < 0 || centerVertex > numVertices || startVertex < 0 || startVertex > numVertices || endVertex < 0 || endVertex > numVertices) {
            PsDebug.warning((String)"Vertex index out of range.");
            return -2;
        }
        if (element == null || vertexLocInd == null) {
            PsDebug.warning((String)"Missing output arguments.");
            return -2;
        }
        this.m_star.makeVertexStar(this.m_geom, centerVertex, elementAtCenterVertex);
        if (bClose && !this.m_star.isClosed()) {
            PsDebug.warning((String)"Can't close path, because center vertex is at boundary.");
            return -2;
        }
        PiVector starLink = this.m_star.getLink();
        int linkSize = starLink.getSize();
        int startInd = starLink.getIndexOf(startVertex);
        int endInd = starLink.getIndexOf(endVertex);
        if (startInd < 0 || endInd < 0) {
            PsDebug.warning((String)"Start or end vertex is not contained in link.");
            return -2;
        }
        int numElements = (endInd + linkSize - startInd - 1) % linkSize + 1;
        if (startInd > endInd && !this.m_star.isClosed()) {
            PsDebug.message((String)"There is a boundary on the right side of the path.");
            return -2;
        }
        int nextLayer = this.makePartialVertexStar(index, startInd, numElements, initialLayer);
        if (bClose) {
            while (nextLayer != targetLayer) {
                int layerChange = nextLayer;
                if ((layerChange -= (nextLayer = this.makePartialVertexStar(index, endInd, linkSize, nextLayer))) == 0) {
                    PsDebug.warning((String)("Closing of path " + index + " is impossible, since there was no layer change during " + "last winding around center vertex " + this.m_vertexInd.getEntry(index) + "."));
                    return -2;
                }
                int n = this.m_covering.getSymmetryOrder();
                int d = PuMath.modulo((int)layerChange, (int)n);
                int z = PuMath.modulo((int)(targetLayer - nextLayer), (int)n);
                if (z % PuMath.gcd((int)n, (int)d) == 0) continue;
                PsDebug.warning((String)"Target layer is not reached.");
                return -2;
            }
        }
        return elementLayer.getLastEntry();
    }

    private int makePartialVertexStar(int index, int startInd, int numElements, int initialLayer) {
        PiVector element = this.m_elementNeighbour[index];
        PiVector vertexLocInd = this.m_vertexLocInd[index];
        PiVector elementLayer = this.m_elementLayer[index];
        int oldSize = element.getSize();
        int newSize = oldSize + numElements;
        element.setSize(newSize);
        vertexLocInd.setSize(newSize);
        elementLayer.setSize(newSize);
        PiVector starLocInd = this.m_star.getVertexLocInd();
        int ind = startInd;
        int layer = initialLayer;
        int i = 0;
        while (i < numElements) {
            int elemInd = this.m_star.getElement().m_data[ind];
            int elemSize = this.m_geom.getDimOfElement(elemInd);
            int nextElemLocInd = (starLocInd.m_data[ind] - 2 + elemSize) % elemSize;
            element.m_data[oldSize + i] = elemInd;
            vertexLocInd.m_data[oldSize + i] = starLocInd.m_data[ind];
            elementLayer.m_data[oldSize + i] = layer;
            if (this.m_covering != null) {
                if (this.m_geom.getNeighbour((int)elemInd).m_data[nextElemLocInd] == -1) {
                    return Integer.MAX_VALUE;
                }
                int m = this.m_covering.getMatching(elemInd, nextElemLocInd);
                layer = PuMath.modulo((int)(layer + m), (int)this.m_numLayers);
            }
            ind = (ind + 1) % this.m_star.getLink().getSize();
            ++i;
        }
        return layer;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public PiVector getVertexIndices() {
        return this.m_vertexInd;
    }

    public PiVector getEdgeIndices() {
        return this.m_edgeInd;
    }

    public PgCovering getCovering() {
        return this.m_covering;
    }

    public PiVector[] getElementNeighbours() {
        return this.m_elementNeighbour;
    }

    public PiVector[] getVertexLocInd() {
        return this.m_vertexLocInd;
    }

    public PiVector[] getElementLayers() {
        return this.m_elementLayer;
    }

    public boolean isStartAtBoundary() {
        return this.m_boundaryStart;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer();
        str.append("****** PgNewPathOnCovering ********\n");
        str.append("Vertices");
        if (this.m_vertexInd == null) {
            str.append("(0):\n\nnull");
        } else {
            str.append("(" + this.m_vertexInd.getSize() + "):\n" + this.m_vertexInd.toShortString() + "\n");
        }
        str.append("Edges");
        if (this.m_edgeInd == null) {
            str.append(":\nnull");
        } else {
            str.append("(" + this.m_edgeInd.getSize() + "):\n" + this.m_edgeInd.toShortString() + "\n");
        }
        str.append("Elements");
        if (this.m_elementNeighbour == null) {
            str.append(":\nnull");
        } else {
            str.append("(" + this.m_elementNeighbour.length + "):\n");
            i = 0;
            while (i < this.m_elementNeighbour.length) {
                str.append(this.m_elementNeighbour[i].toShortString());
                ++i;
            }
        }
        str.append("\nVertexLocInd");
        if (this.m_vertexLocInd == null) {
            str.append(":\nnull");
        } else {
            str.append("(" + this.m_vertexLocInd.length + "):\n");
            i = 0;
            while (i < this.m_vertexLocInd.length) {
                str.append(this.m_vertexLocInd[i].toShortString());
                ++i;
            }
        }
        str.append("\nElementLayer");
        if (this.m_elementLayer == null) {
            str.append(":\nnull");
        } else {
            str.append("(" + this.m_elementLayer.length + "):\n");
            i = 0;
            while (i < this.m_elementLayer.length) {
                str.append(this.m_elementLayer[i].toShortString());
                ++i;
            }
        }
        return str.toString();
    }
}

