/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import devCovering.PgCovering;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PvGeometryIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;

public class PgFrameField
extends PsObject {
    private static final int NUM_FIELDS = 2;
    private PgElementSet m_geom;
    protected PgCovering m_covering;
    protected PgVectorField[] m_fields = new PgVectorField[2];

    private PgFrameField() {
        if (((Object)((Object)this)).getClass() == PgFrameField.class) {
            this.init();
        }
    }

    public PgFrameField(PgCovering covering) {
        this();
        this.setCovering(covering);
    }

    public void init() {
        super.init();
    }

    public void copy(PgFrameField field) {
        if (field == null || field.getField(0) == null) {
            PsDebug.warning((String)"Input field is null.");
            return;
        }
        this.setCovering(field.getCovering());
        int i = 0;
        while (i < this.getNumFields()) {
            if (this.m_fields[i] == null) {
                this.m_fields[i] = new PgVectorField(field.getField(i).getDimOfVectors());
            }
            this.m_fields[i].copy((PsObject)field.getField(i));
            this.m_fields[i].setGeometry(field.getField(i).getGeometry());
            ++i;
        }
    }

    public static PgFrameField copyNew(PgFrameField field) {
        PgFrameField field2 = new PgFrameField();
        field2.copy(field);
        return field2;
    }

    public static PgFrameField subNew(PgFrameField f1, PgFrameField f2) {
        PgFrameField field = PgFrameField.copyNew(f1);
        field.sub(f2);
        return field;
    }

    public PgVectorField[] getFields() {
        return this.m_fields;
    }

    public int getNumFields() {
        return 2;
    }

    public PgVectorField getField(int id) {
        if (this.m_fields == null) {
            PsDebug.warning((String)"No vector fields set!");
            return null;
        }
        if (id < 0 || id > 2) {
            PsDebug.warning((String)"Field index out of range!");
            return null;
        }
        return this.m_fields[id];
    }

    public PdVector getVector(int elementInd, int layer, int vectorField, PdVector buffer) {
        int symmOrder = this.m_covering.getSymmetryOrder();
        if (symmOrder != 4 && symmOrder != 6 && symmOrder != 12) {
            PsDebug.message((String)"symmetry order not supported");
            return null;
        }
        if (buffer == null) {
            buffer = new PdVector(3);
        }
        int r = PuMath.modulo((int)layer, (int)symmOrder);
        if (symmOrder == 4) {
            if (r == 0) {
                buffer.copyArray(this.m_fields[vectorField].getVector(elementInd));
            } else if (r == 1) {
                if (vectorField == 0) {
                    buffer.copyArray(this.m_fields[1].getVector(elementInd));
                } else {
                    buffer.multScalar(this.m_fields[0].getVector(elementInd), -1.0);
                }
            } else if (r == 2) {
                buffer.multScalar(this.m_fields[vectorField].getVector(elementInd), -1.0);
            } else if (r == 3) {
                if (vectorField == 0) {
                    buffer.multScalar(this.m_fields[1].getVector(elementInd), -1.0);
                } else {
                    buffer.copyArray(this.m_fields[0].getVector(elementInd));
                }
            }
        } else if (symmOrder == 6) {
            int rot12 = PuMath.modulo((int)(2 * r + vectorField * 3), (int)12);
            double sqrt3_2 = Math.sqrt(3.0) / 2.0;
            double[] sin = new double[]{0.0, 0.5, sqrt3_2, 1.0, sqrt3_2, 0.5, 0.0, -0.5, -sqrt3_2, -1.0, -sqrt3_2, -0.5};
            double[] cos = new double[]{1.0, sqrt3_2, 0.5, 0.0, -0.5, -sqrt3_2, -1.0, -sqrt3_2, -0.5, 0.0, 0.5, sqrt3_2};
            buffer.blend(cos[rot12], this.m_fields[0].getVector(elementInd), sin[rot12], this.m_fields[1].getVector(elementInd));
        } else if (symmOrder == 12) {
            int rot12 = PuMath.modulo((int)(r + vectorField * 3), (int)12);
            double sqrt3_2 = Math.sqrt(3.0) / 2.0;
            double[] sin = new double[]{0.0, 0.5, sqrt3_2, 1.0, sqrt3_2, 0.5, 0.0, -0.5, -sqrt3_2, -1.0, -sqrt3_2, -0.5};
            double[] cos = new double[]{1.0, sqrt3_2, 0.5, 0.0, -0.5, -sqrt3_2, -1.0, -sqrt3_2, -0.5, 0.0, 0.5, sqrt3_2};
            buffer.blend(cos[rot12], this.m_fields[0].getVector(elementInd), sin[rot12], this.m_fields[1].getVector(elementInd));
        }
        return buffer;
    }

    public PgElementSet getGeometry() {
        if (this.m_covering == null) {
            return null;
        }
        return this.m_covering.getGeometry();
    }

    public PgCovering getCovering() {
        return this.m_covering;
    }

    public void setCovering(PgCovering cov) {
        if (cov == null) {
            PsDebug.warning((String)"missing covering.");
            return;
        }
        if (cov.getGeometry() == null) {
            PsDebug.warning((String)"covering has no geometry.");
            return;
        }
        if (cov == this.m_covering) {
            return;
        }
        this.m_covering = cov;
        this.m_geom = this.m_covering.getGeometry();
        int i = 0;
        while (i < 2) {
            if (this.m_fields[i] != null) {
                this.m_fields[i].setGeometry((PgPointSet)this.m_geom);
            }
            ++i;
        }
    }

    public void setField(int ind, PgVectorField field) {
        if (ind < 0 || ind >= 2) {
            PsDebug.warning((String)"Index out of range.");
            return;
        }
        if (this.m_covering == null) {
            PsDebug.warning((String)"Missing covering.");
            return;
        }
        this.m_fields[ind] = field;
        if (this.m_fields[ind] != null) {
            this.m_fields[ind].setGeometry((PgPointSet)this.m_geom);
        }
    }

    public void setFields(PgVectorField[] fields) {
        if (this.m_covering == null) {
            PsDebug.warning((String)"Missing covering.");
            return;
        }
        if (fields == null) {
            PsDebug.warning((String)"Missing fields.");
            return;
        }
        if (fields.length != 2) {
            PsDebug.warning((String)"Number of fields must be 2.");
            return;
        }
        int i = 0;
        while (i < 2) {
            this.setField(i, fields[i]);
            ++i;
        }
    }

    public void assureFields() {
        if (this.m_covering == null) {
            PsDebug.warning((String)"Missing covering.");
            return;
        }
        if (this.m_fields == null || this.m_fields.length != 2) {
            this.m_fields = new PgVectorField[2];
        }
        int i = 0;
        while (i < 2) {
            if (this.m_fields[i] == null) {
                this.m_fields[i] = new PgVectorField(3, 1);
            }
            if (this.m_fields[i].getNumVectors() != this.m_geom.getNumElements() || this.m_fields[i].getGeometry() != this.m_geom) {
                this.m_fields[i].setGeometry((PgPointSet)this.m_geom);
                this.m_fields[i].setName(String.valueOf(this.getName()) + " (" + i + ")");
            }
            ++i;
        }
    }

    public void add(PgFrameField field) {
        if (field.m_geom != this.m_geom) {
            PsDebug.warning((String)"Frame field has not the same geometry set.");
            return;
        }
        int numElements = this.m_geom.getNumElements();
        if (field.m_geom.getNumElements() != numElements) {
            PsDebug.warning((String)"Frame fields are not compatible.");
            return;
        }
        int i = 0;
        while (i < 2) {
            int e = 0;
            while (e < numElements) {
                this.getField(i).getVector(e).add(field.getField(i).getVector(e));
                ++e;
            }
            ++i;
        }
    }

    public void sub(PgFrameField field) {
        if (field.m_geom != this.m_geom) {
            PsDebug.warning((String)"Frame field has not the same geometry set.");
            return;
        }
        int numElements = this.m_geom.getNumElements();
        if (field.m_geom.getNumElements() != numElements) {
            PsDebug.warning((String)"Frame fields are not compatible.");
            return;
        }
        int i = 0;
        while (i < 2) {
            int e = 0;
            while (e < numElements) {
                this.getField(i).getVector(e).sub(field.getField(i).getVector(e));
                ++e;
            }
            ++i;
        }
    }

    public void multScalar(double scalar) {
        int i = 0;
        while (i < 2) {
            this.getField(i).multScalar(scalar);
            ++i;
        }
    }

    public void normalize() {
        int i = 0;
        while (i < 2) {
            PgVectorField vf = this.getField(i);
            int numV = vf.getNumVectors();
            int j = 0;
            while (j < numV) {
                vf.getVector(j).normalize();
                ++j;
            }
            ++i;
        }
    }

    public void setName(String name) {
        super.setName(name);
        int i = 0;
        while (i < 2) {
            if (this.m_fields[i] != null) {
                this.m_fields[i].setName(String.valueOf(name) + " (" + i + ")");
            }
            ++i;
        }
    }

    public void clearVectors() {
        int numElements = this.m_geom.getNumElements();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < numElements) {
                this.m_fields[i].getVector(j).setConstant(0.0);
                ++j;
            }
            ++i;
        }
    }

    public boolean applyModelingMatrix() {
        boolean retVal = true;
        int i = 0;
        while (i < 2) {
            retVal &= this.m_fields[i].applyModelingMatrix();
            ++i;
        }
        return retVal;
    }

    public void paint(PvGeometryIf dc) {
        int i = 0;
        while (i < 2) {
            this.m_fields[i].setIndex(i);
            this.m_fields[i].paint(dc);
            ++i;
        }
    }

    public double distL2(PgFrameField field) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set");
            return -1.0;
        }
        if (this.m_geom != field.m_geom) {
            PsDebug.warning((String)"fields must live on same geometry");
            return -1.0;
        }
        double sum = 0.0;
        PgVectorField[] f = field.m_fields;
        int numElements = this.m_geom.getNumElements();
        PdVector tmp = new PdVector(this.m_fields[0].getDimOfVectors());
        int e = 0;
        while (e < numElements) {
            double area = this.m_geom.getAreaOfElement(e);
            int i = 0;
            while (i < 2) {
                tmp.sub(this.m_fields[i].getVector(e), f[i].getVector(e));
                sum += tmp.sqrLength() * area;
                ++i;
            }
            ++e;
        }
        return Math.sqrt(sum);
    }

    public double normL2() {
        if (this.m_covering == null) {
            PsDebug.warning((String)"Missing covering.");
            return -1.0;
        }
        double sum = 0.0;
        int numElements = this.m_geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            double area = this.m_geom.getAreaOfElement(e);
            int i = 0;
            while (i < 2) {
                sum += this.m_fields[i].getVector(e).sqrLength() * area;
                ++i;
            }
            ++e;
        }
        return Math.sqrt(sum);
    }

    public double dotL2(PgFrameField field) {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No geometry set");
            return -1.0;
        }
        if (this.m_geom != field.m_geom) {
            PsDebug.warning((String)"fields must live on same geometry");
            return -1.0;
        }
        double sum = 0.0;
        PgVectorField[] f = field.m_fields;
        int numElements = this.m_geom.getNumElements();
        int e = 0;
        while (e < numElements) {
            double area = this.m_geom.getAreaOfElement(e);
            int i = 0;
            while (i < 2) {
                sum += PdVector.dot((PdVector)this.m_fields[i].getVector(e), (PdVector)f[i].getVector(e)) * area;
                ++i;
            }
            ++e;
        }
        return sum;
    }
}

