/*
 * Decompiled with CFR 0.152.
 */
package devCovering;

import dev.vecmath.PiDynVector;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jvx.geom.PgVertexStar;

public class PgCovering {
    public static final int ERROR = Integer.MAX_VALUE;
    private PgElementSet m_geom;
    private int m_symmetryOrder;
    private PiVector[] m_matching;
    private PiVector m_branchPoints;
    private PiVector m_branchTypes;

    public PgCovering(PgElementSet geom, int symmetryOrder) {
        this.m_geom = geom;
        this.m_symmetryOrder = symmetryOrder;
        this.m_branchPoints = new PiVector();
        this.m_branchTypes = new PiVector();
        if (geom != null) {
            this.m_matching = PiVector.realloc((PiVector[])this.m_matching, (int)geom.getNumElements(), (int)3);
        }
    }

    public void reset() {
        this.m_branchPoints.setSize(0);
        this.m_branchTypes.setSize(0);
        this.m_matching = this.m_geom != null ? PiVector.realloc((PiVector[])this.m_matching, (int)this.m_geom.getNumElements(), (int)3) : null;
    }

    public void copy(PgCovering cov) {
        if (cov == null) {
            PsDebug.warning((String)"Input covering is null.");
            return;
        }
        this.setGeometry(cov.getGeometry());
        this.m_symmetryOrder = cov.m_symmetryOrder;
        this.setMatching(cov.getMatching(), cov.getBranchPoints(), cov.getBranchTypes());
    }

    public static PgCovering copyNew(PgCovering cov) {
        if (cov == null) {
            PsDebug.warning((String)"missing covering.");
            return null;
        }
        PgCovering cov2 = new PgCovering(cov.getGeometry(), cov.getSymmetryOrder());
        cov2.copy(cov);
        return cov2;
    }

    public int getSymmetryOrder() {
        return this.m_symmetryOrder;
    }

    public void setSymmetryOrder(int symmetryOrder) {
        this.m_symmetryOrder = symmetryOrder;
    }

    public int getNumBranchPoints() {
        return this.m_branchPoints.getSize();
    }

    public PiVector getBranchPoints() {
        return this.m_branchPoints;
    }

    public void setBranchPoints(PiVector branchPoints, PiVector branchTypes) {
        this.setBranchPoints(branchPoints);
        this.setBranchTypes(branchTypes);
    }

    public void setBranchPoints(PiVector branchPoints) {
        if (branchPoints == null) {
            this.m_branchPoints.setSize(0);
            return;
        }
        this.m_branchPoints.setSize(branchPoints.getSize());
        this.m_branchPoints.copy(branchPoints);
    }

    public PiVector getBranchTypes() {
        return this.m_branchTypes;
    }

    public int getBranchType(int vertex) {
        int pos = this.m_branchPoints.getIndexOf(vertex);
        if (pos == -1) {
            return 0;
        }
        return this.m_branchTypes.m_data[pos];
    }

    public void setBranchTypes(PiVector branchTypes) {
        if (branchTypes == null) {
            this.m_branchTypes.setSize(0);
            return;
        }
        this.m_branchTypes.setSize(branchTypes.getSize());
        this.m_branchTypes.copy(branchTypes);
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgElementSet geom) {
        if (this.m_geom == geom) {
            return;
        }
        this.m_geom = geom;
        if (geom == null) {
            this.m_matching = null;
            return;
        }
        this.reset();
    }

    public PiVector[] getMatching() {
        return this.m_matching;
    }

    public void setMatching(PiVector[] matching) {
        this.m_matching = matching;
    }

    protected void setMatching(PiVector[] matching, PiVector branchPoints, PiVector branchTypes) {
        if (matching == null) {
            this.m_matching = null;
            this.m_branchPoints.setSize(0);
            this.m_branchTypes.setSize(0);
            return;
        }
        int numE = this.m_geom.getNumElements();
        if (matching.length != numE) {
            PsDebug.warning((String)"Wrong size of matching.");
            return;
        }
        PiVector.copy((PiVector[])this.m_matching, (int)0, (PiVector[])matching, (int)0, (int)numE);
        if (branchPoints == null || branchTypes == null) {
            this.updateBranchpoints();
        } else {
            this.m_branchPoints.setSize(branchPoints.getSize());
            this.m_branchPoints.copy(branchPoints);
            this.m_branchTypes.setSize(branchTypes.getSize());
            this.m_branchTypes.copy(branchTypes);
        }
    }

    public int getMatching(int elem, int locNeighbIdx) {
        PiVector neigh = this.m_geom.getNeighbour(elem);
        if (neigh == null) {
            PsDebug.warning((String)"Missing neighbour array!");
            return Integer.MAX_VALUE;
        }
        if (locNeighbIdx < 0 || locNeighbIdx >= neigh.getSize()) {
            PsDebug.warning((String)"Local neighbour index out of range!");
            return Integer.MAX_VALUE;
        }
        int ne = neigh.m_data[locNeighbIdx];
        if (ne < 0) {
            return Integer.MAX_VALUE;
        }
        return this.m_matching[elem].m_data[locNeighbIdx];
    }

    public void setMatching(int elem, int locNeighbInd, int matching) {
        PiVector neigh = this.m_geom.getNeighbour(elem);
        if (neigh == null) {
            PsDebug.warning((String)"Error in neighbour array!");
            return;
        }
        if (locNeighbInd < 0 || locNeighbInd >= neigh.getSize()) {
            PsDebug.warning((String)"Local neighbour index out of range!");
            return;
        }
        int ne = neigh.m_data[locNeighbInd];
        if (ne < 0) {
            PsDebug.warning((String)"Can't set a matching at the boundary!");
            return;
        }
        int nLocNeighbInd = this.m_geom.getNeighbour(ne).getIndexOf(elem);
        this.m_matching[elem].m_data[locNeighbInd] = matching;
        this.m_matching[ne].m_data[nLocNeighbInd] = matching == Integer.MAX_VALUE ? matching : -matching;
    }

    public void filterBranchPoints(int symmetryOrder) {
        int num = this.m_branchPoints.getSize();
        int pos = 0;
        int i = 0;
        while (i < num) {
            this.m_branchTypes.m_data[i] = PuMath.modulo((int)this.m_branchTypes.m_data[i], (int)symmetryOrder);
            if (this.m_branchTypes.m_data[i] != 0) {
                this.m_branchTypes.m_data[pos] = this.m_branchTypes.m_data[i];
                this.m_branchPoints.m_data[pos] = this.m_branchPoints.m_data[i];
                ++pos;
            }
            ++i;
        }
        this.m_branchPoints.setSize(pos);
        this.m_branchTypes.setSize(pos);
    }

    public int updateBranchpoints() {
        if (this.m_matching == null) {
            this.m_branchPoints.setSize(0);
            this.m_branchTypes.setSize(0);
            return -1;
        }
        PiDynVector branchPoints = new PiDynVector(0);
        PiDynVector branchTypes = new PiDynVector(0);
        int numVertices = this.m_geom.getNumVertices();
        PiVector elementPerVertex = PgVertexStar.getElementPerVertex((PgElementSet)this.m_geom);
        int v = 0;
        while (v < numVertices) {
            int index = this.calcIndex(v, elementPerVertex.m_data[v]);
            if (index != 0 && index != Integer.MAX_VALUE) {
                branchPoints.appendEntry(v);
                branchTypes.appendEntry(index);
            }
            ++v;
        }
        int size = branchPoints.getSize();
        this.m_branchPoints.setSize(size);
        this.m_branchTypes.setSize(size);
        int i = 0;
        while (i < size) {
            this.m_branchPoints.setEntry(i, branchPoints.getEntry(i));
            this.m_branchTypes.setEntry(i, branchTypes.getEntry(i));
            ++i;
        }
        return size;
    }

    public void updateBranchpoint(int v, int element) {
        int index = this.calcIndex(v, element);
        int pos = this.m_branchPoints.getIndexOf(v);
        if (pos == -1) {
            if (index == 0 || index == Integer.MAX_VALUE) {
                return;
            }
            this.m_branchPoints.addEntry(v);
            this.m_branchTypes.addEntry(index);
            return;
        }
        if (index == 0 || index == Integer.MAX_VALUE) {
            this.m_branchPoints.m_data[pos] = this.m_branchPoints.getLastEntry();
            this.m_branchTypes.m_data[pos] = this.m_branchTypes.getLastEntry();
            int old_size = this.getNumBranchPoints();
            this.m_branchPoints.setSize(old_size - 1);
            this.m_branchTypes.setSize(old_size - 1);
            return;
        }
        this.getBranchTypes().m_data[pos] = index;
    }

    public int calcIndex(int v, int e) {
        PgVertexStar star = new PgVertexStar();
        star.makeVertexStar(this.m_geom, v, e);
        if (!star.isClosed()) {
            return Integer.MAX_VALUE;
        }
        int r = 0;
        PiVector elements = star.getElement();
        PiVector locInd = star.getVertexLocInd();
        int starSize = elements.getSize();
        int j = 0;
        while (j < starSize) {
            PiVector elem = this.m_geom.getElement(elements.m_data[j]);
            int idOfV = locInd.m_data[j];
            int elSize = elem.getSize();
            r += this.getMatching(elements.m_data[j], (elSize + idOfV - 2) % elSize);
            ++j;
        }
        return this.m_symmetryOrder == 0 ? r : PuMath.modulo((int)r, (int)this.m_symmetryOrder);
    }
}

