/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import devCompress.PuCompress;

public class TestBooleanEncoding {
    public static void main(String[] args) {
        boolean[] bMessage = TestBooleanEncoding.getRandomMessage(100);
        System.out.println("generated random booleans:");
        TestBooleanEncoding.printBooleans(bMessage);
        byte[] bCode = PuCompress.encode(bMessage, bMessage.length);
        System.out.println("encoded booleans:");
        TestBooleanEncoding.printBytes(bCode);
        boolean[] decodedBools = PuCompress.decodeBoolean(bCode);
        System.out.println("decoded booleans:");
        TestBooleanEncoding.printBooleans(decodedBools);
        int[] iMessage = PuCompress.booleansToInts(bMessage, bMessage.length);
        byte[] iCode = PuCompress.encode(iMessage, iMessage.length);
        System.out.println("encoded ints:");
        TestBooleanEncoding.printBytes(iCode);
        int[] decodedInts = PuCompress.decode(iCode);
        System.out.println("decoded ints:");
        TestBooleanEncoding.printBooleans(PuCompress.intsToBooleans(decodedInts));
    }

    protected static void printBytes(byte[] code) {
        System.out.print("[" + code.length + "](");
        int i = 0;
        while (i < code.length - 1) {
            System.out.print(String.valueOf(code[i] + 128) + " ");
            ++i;
        }
        System.out.println(String.valueOf(code[code.length - 1] + 128) + ")");
    }

    protected static void printBooleans(boolean[] code) {
        System.out.print("[" + code.length + "](");
        int i = 0;
        while (i < code.length - 1) {
            System.out.print(code[i] ? 1 : 0);
            ++i;
        }
        if (code.length > 0) {
            System.out.print(code[code.length - 1] ? 1 : 0);
        }
        System.out.println(")");
    }

    protected static boolean[] getRandomMessage(int length) {
        boolean[] message = new boolean[length];
        int i = 0;
        while (i < length) {
            message[i] = Math.random() < 0.3;
            ++i;
        }
        return message;
    }
}

