/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import devCompress.PuCompress;
import devCompress.TestBooleanEncoding;

public class TestBooleanArrayEncoding {
    public static void main(String[] args) {
        int numArrays = 10;
        boolean[][] bMessage = new boolean[10][];
        int[] length = new int[10];
        System.out.println("generated random booleans:");
        int i = 0;
        while (i < 10) {
            length[i] = (int)(2.0 * Math.exp(0.3 * (double)i));
            bMessage[i] = TestBooleanEncoding.getRandomMessage(length[i]);
            TestBooleanEncoding.printBooleans(bMessage[i]);
            ++i;
        }
        System.out.println();
        byte[] cCode = PuCompress.encodeCompact(bMessage, length, null);
        System.out.println("compactly encoded boolean arrays:");
        TestBooleanEncoding.printBytes(cCode);
        System.out.println("decoded compact boolean arrays:");
        boolean[][] decodedBools = PuCompress.decodeCompactBooleanArray(cCode);
        int i2 = 0;
        while (i2 < 10) {
            TestBooleanEncoding.printBooleans(decodedBools[i2]);
            ++i2;
        }
        System.out.println();
        byte[] bCode = PuCompress.encode(bMessage, length);
        System.out.println("encoded boolean arrays:");
        TestBooleanEncoding.printBytes(bCode);
        System.out.println("decoded boolean arrays:");
        decodedBools = PuCompress.decodeBooleanArray(bCode);
        int i3 = 0;
        while (i3 < 10) {
            TestBooleanEncoding.printBooleans(decodedBools[i3]);
            ++i3;
        }
        System.out.println();
        int[][] iMessage = new int[10][];
        int i4 = 0;
        while (i4 < 10) {
            iMessage[i4] = PuCompress.booleansToInts(bMessage[i4], bMessage[i4].length);
            ++i4;
        }
        byte[] iCode = PuCompress.encode(iMessage, length);
        System.out.println("encoded ints:");
        TestBooleanEncoding.printBytes(iCode);
        int[][] decodedInts = PuCompress.decodeArray(iCode);
        System.out.println("decoded ints:");
        int i5 = 0;
        while (i5 < 10) {
            TestBooleanEncoding.printBooleans(PuCompress.intsToBooleans(decodedInts[i5]));
            ++i5;
        }
    }
}

