/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import devCompress.PgJvzCode;
import devCompress.PuCompress;
import devCompress.PuFrontVertex;
import devCompress.PuJvzDecoder;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PwCleanMesh;
import jvx.loader.PsJvzConfig;
import jvx.util.PuPriorityQueue;

public class PuJvzEncoder
extends PuJvzDecoder {
    protected boolean m_bResizeDecimal = true;
    protected static final int m_resolutionBits = 12;
    protected static final int m_resolution = 4096;
    protected int m_doubleResolutionBits = 12;
    protected double m_resizeFactor = 1.0;
    protected PgJvzCode m_geomCode = null;
    protected PiVector m_freeEdges = null;
    private PiVector m_outputAngle = null;
    private PiVector m_outputValue = null;
    private int m_numVertexOutputs = 0;
    protected static int[] m_originalVertexIndex = null;
    protected int[] m_newElementIndex = null;
    protected int m_elIndexCounter;
    private int m_arrayIncrement;
    private static final int m_numVertexSymbols = 13;
    private static final int m_discreteAngle = 1;
    private static final int m_maxAngle = 600;
    protected static final int m_contextPenalty = 64;
    private int m_firstElement = 0;
    private PgVertexStar m_vs = new PgVertexStar();

    public PuJvzEncoder() {
        if (((Object)((Object)this)).getClass() == PuJvzEncoder.class) {
            this.init();
        }
    }

    public PgJvzCode encodeGeometry(PgJvxSrc geom) {
        long tStart = System.currentTimeMillis();
        this.m_mem = PsDebug.getMemoryTotal();
        PsDebug.initMemory();
        this.m_geom = new PgElementSet();
        this.m_geom.setEnabledInstanceSharing(true);
        this.m_geom.setJvx(geom);
        this.m_geom.setNeighbours(PiVector.copyNew((PiVector[])this.m_geom.getNeighbours(), (int)this.m_geom.getNumElements()));
        this.m_geom.setElements(PiVector.copyNew((PiVector[])this.m_geom.getElements(), (int)this.m_geom.getNumElements()));
        this.m_geomCode = new PgJvzCode();
        this.m_geom.setEnabledInstanceSharing(true);
        this.m_geomCode.setEnabledInstanceSharing(true);
        this.m_geomCode.copy(geom);
        this.m_geomCode.setName(geom.getName());
        this.m_geom.setEnabledInstanceSharing(false);
        this.m_geomCode.setEnabledInstanceSharing(false);
        this.m_numVertices = this.m_geom.getNumVertices();
        this.m_numElements = this.m_geom.getNumElements();
        this.m_dim = this.m_geom.getDimOfVertices();
        if (!PwCleanMesh.checkManifold((PgElementSet)this.m_geom, (boolean)false)) {
            PsDebug.message((String)"Geometry must be manifold for compression. Geometry is saved as JVX.");
            return null;
        }
        if (this.hasValence2Vertices()) {
            PsDebug.message((String)"Can't handle interior vertices of valence 2. Geometry is saved as JVX.");
            return null;
        }
        this.encode();
        PsDebug.message((String)this.m_geomCode.getDetailInfo());
        return this.m_geomCode;
    }

    /*
     * Unable to fully structure code
     */
    private void encode() {
        tStart = System.currentTimeMillis();
        if (this.m_bResizeDecimal && PsJvzConfig.getDoubleResolution() != 0) {
            this.resizeGeometry();
        }
        tStart = System.currentTimeMillis();
        this.initCompression();
        tStart = System.currentTimeMillis();
        eTex = null;
        if (this.m_geom.hasElementTextures()) {
            eTex = new PdVector[this.m_numElements][];
            i = 0;
            while (i < this.m_numElements) {
                eTex[i] = (PdVector[])this.m_geom.getElementTexture(i).clone();
                ++i;
            }
        }
        this.initComponent();
        ** GOTO lbl26
        {
            focus = this.m_queueFront[this.m_queue.extractMin()];
            if (focus.m_next != null) {
                this.processFocus(focus);
            } else {
                focus.removeFromFrontLinks();
                this.m_queueFront[focus.m_queueIndex] = null;
            }
            do {
                if (this.m_queue.getHeapSize() != 0) continue block1;
                this.initComponent();
lbl26:
                // 2 sources

            } while (this.m_queue.getHeapSize() != 0);
        }
        tStart = System.currentTimeMillis();
        i = 0;
        while (i < this.m_numVertices) {
            if (!this.m_geom.hasTagVertex(i, 0)) {
                this.encodeGeometry(-1, -1, i, true);
            }
            ++i;
        }
        if (this.m_numElements != this.m_geomCode.getNumElements()) {
            this.m_numElements = this.m_geomCode.getNumElements();
            this.m_geom.setNumElements(this.m_numElements);
            this.m_geom.setElements(this.m_geomCode.getElements());
            this.m_geom.setNeighbours(this.m_geomCode.getNeighbours());
            this.m_geom.assureDimOfElements();
        }
        this.m_geom.setElementTextures((PdVector[][])eTex);
        this.compressCode();
    }

    private void compressCode() {
        PdVector[] normals;
        PdVector[] originalNormal;
        int i;
        PdVector[] textures;
        byte[] code;
        Color[] colors;
        int[] elementOrder = PuJvzEncoder.invertPermutation(this.m_newElementIndex);
        int[] parentVertex = this.makeVertexParentVector(this.m_parentVertex, m_originalVertexIndex);
        int[] parentElement = this.makeElementParentVector(elementOrder);
        this.m_geomCode.setDoubleResolution(this.m_doubleResolutionBits);
        this.improveThreshold();
        this.makeContextArrays();
        this.m_geomCode.setAxisResolution(this.m_axisResolution.m_data);
        if (this.m_bResizeDecimal && this.m_doubleResolutionBits != 0) {
            this.m_geomCode.setResizeFactor(this.m_resizeFactor);
        } else {
            this.m_geomCode.setResizeFactor(1.0);
        }
        this.m_geomCode.setNumStoredVertices(this.m_numVertices);
        this.m_geomCode.setNumStoredElements(this.m_numElements);
        this.m_geomCode.setNumContexts(this.m_numVertexContexts);
        this.m_geomCode.setContextThresholds(this.m_contextThreshold);
        this.m_geomCode.setBndBox(this.m_bndBox);
        this.m_geomCode.setVertexSymbolCode(PuCompress.encode(this.m_vertexSymbols, this.m_vvCounter));
        this.m_geomCode.setElementSymbolCode(PuCompress.encode(this.m_elementSymbols, this.m_fdCounter));
        this.m_geomCode.setSplitSymbolCode(PuCompress.encode(this.m_splitSymbols, this.m_numSplits));
        int bytesPerFirstCoordinate = 2;
        int bytesForFirstCoordinates = 9 * bytesPerFirstCoordinate;
        byte[] firstCoordinates = new byte[bytesForFirstCoordinates];
        int i2 = 0;
        while (i2 < 9) {
            int j = 0;
            while (j < bytesPerFirstCoordinate) {
                firstCoordinates[bytesPerFirstCoordinate * i2 + j] = (byte)(this.m_vertexData[i2] >> j * 8);
                ++j;
            }
            ++i2;
        }
        int[] tmp = new int[this.m_vertexData.length - 9];
        System.arraycopy(this.m_vertexData, 9, tmp, 0, tmp.length);
        this.m_vertexData = tmp;
        byte[] partialVertexDataCode = PuCompress.encode(this.m_vertexData, this.m_vertexData.length);
        byte[] vertexDataCode = new byte[bytesForFirstCoordinates + partialVertexDataCode.length];
        System.arraycopy(firstCoordinates, 0, vertexDataCode, 0, bytesForFirstCoordinates);
        System.arraycopy(partialVertexDataCode, 0, vertexDataCode, bytesForFirstCoordinates, partialVertexDataCode.length);
        this.m_geomCode.setVertexDataCode(vertexDataCode);
        if (PsJvzConfig.getStoreVertexColors() && this.m_geom.hasVertexColors()) {
            colors = this.m_geom.getVertexColors();
            code = PuCompress.encodeColors(parentVertex, m_originalVertexIndex, colors, this.m_doubleResolutionBits);
            this.m_geomCode.setVertexColorCode(code);
        }
        if (PsJvzConfig.getStoreElementColors() && this.m_geom.hasElementColors()) {
            colors = this.m_geom.getElementColors();
            code = PuCompress.encodeColors(parentElement, elementOrder, colors, this.m_doubleResolutionBits);
            this.m_geomCode.setElementColorCode(code);
        }
        if (PsJvzConfig.getStoreElementBackColors() && this.m_geom.hasElementBackColors()) {
            colors = this.m_geom.getElementBackColors();
            code = PuCompress.encodeColors(parentElement, elementOrder, colors, this.m_doubleResolutionBits);
            this.m_geomCode.setElementBackColorCode(code);
        }
        if (PsJvzConfig.getStoreVertexTextures() && this.m_geom.hasVertexTextures()) {
            textures = this.m_geom.getVertexTextures();
            code = PuCompress.encodeTextures(parentVertex, m_originalVertexIndex, textures, this.m_doubleResolutionBits);
            this.m_geomCode.setVertexTextureCode(code);
        }
        if (PsJvzConfig.getStoreElementTextures() && this.m_geom.hasElementTextures()) {
            textures = this.m_geom.getElementTextures();
            int numIndices = this.m_geom.getNumElementIndices();
            int counter = 0;
            PdVector[] coordinates = new PdVector[numIndices];
            i = 0;
            while (i < this.m_numElements) {
                int j = 0;
                while (j < ((PdVector)textures[elementOrder[i]]).length) {
                    coordinates[counter++] = textures[elementOrder[i]][j];
                    ++j;
                }
                ++i;
            }
            this.m_geomCode.setElementTextureCode(PuCompress.PdVectorEncode(coordinates, this.m_doubleResolutionBits, false));
        }
        if (PsJvzConfig.getStoreVertexNormals() && this.m_geomCode.getVertexNormals() != null) {
            if (this.m_dim == 3) {
                originalNormal = PdVector.copyNew((PdVector[])this.m_geomCode.getVertexNormals(), (int)this.m_numVertices);
                this.m_geom.makeVertexNormals();
                PdVector[] normal = this.m_geom.getVertexNormals();
                PdVector[] vn = new PdVector[this.m_numVertices];
                int i3 = 0;
                while (i3 < this.m_numVertices) {
                    originalNormal[i3].sub(normal[i3]);
                    ++i3;
                }
                i3 = 0;
                while (i3 < this.m_numVertices) {
                    vn[i3] = originalNormal[m_originalVertexIndex[i3]];
                    ++i3;
                }
                this.m_geomCode.setVertexNormalCode(PuCompress.PdVectorEncode(vn, this.m_doubleResolutionBits, false));
            } else {
                normals = this.m_geom.getVertexNormals();
                PdVector[] vn = new PdVector[this.m_numVertices];
                int i4 = 0;
                while (i4 < this.m_numVertices) {
                    vn[i4] = normals[m_originalVertexIndex[i4]];
                    ++i4;
                }
                this.m_geomCode.setVertexNormalCode(PuCompress.PdVectorEncode(vn, this.m_doubleResolutionBits, false));
            }
        }
        if (PsJvzConfig.getStoreElementNormals() && this.m_geomCode.getElementNormals() != null) {
            if (this.m_dim == 3) {
                originalNormal = PdVector.copyNew((PdVector[])this.m_geomCode.getElementNormals(), (int)this.m_numElements);
                this.m_geom.makeElementNormals();
                PdVector[] normal = this.m_geom.getElementNormals();
                PdVector[] en = new PdVector[this.m_numElements];
                int i5 = 0;
                while (i5 < this.m_numElements) {
                    originalNormal[i5].sub(normal[i5]);
                    en[this.m_newElementIndex[i5]] = originalNormal[i5];
                    ++i5;
                }
                this.m_geomCode.setElementNormalCode(PuCompress.PdVectorEncode(en, this.m_doubleResolutionBits, false));
            } else {
                normals = this.m_geom.getElementNormals();
                PdVector[] en = new PdVector[this.m_numElements];
                int i6 = 0;
                while (i6 < this.m_numElements) {
                    en[this.m_newElementIndex[i6]] = normals[i6];
                    ++i6;
                }
                this.m_geomCode.setElementNormalCode(PuCompress.PdVectorEncode(en, this.m_doubleResolutionBits, false));
            }
        }
        if (this.m_doubleResolutionBits != 12 && this.m_doubleResolutionBits <= 52) {
            int extraBits = this.m_doubleResolutionBits - 12;
            double roundingTerm = 0.5 / (double)(1L << extraBits);
            long[][] errors = new long[this.m_numVertices][this.m_dim];
            i = 0;
            while (i < this.m_numVertices) {
                int ind = m_originalVertexIndex[i];
                PdVector vec = this.m_geom.getVertex(ind);
                int j = 0;
                while (j < this.m_dim) {
                    errors[i][j] = (long)((double)(1L << extraBits) * (roundingTerm + (vec.m_data[j] - this.m_bndBox[0].m_data[j]) * (double)this.m_axisResolution.m_data[j] / this.m_boxSize.m_data[j]));
                    long[] lArray = errors[i];
                    int n = j++;
                    lArray[n] = lArray[n] << 64 - extraBits;
                }
                ++i;
            }
            int[] lengths = new int[this.m_numVertices];
            int i7 = 0;
            while (i7 < this.m_numVertices) {
                lengths[i7] = this.m_dim;
                ++i7;
            }
            this.m_geomCode.setDiscrErrorCode(PuCompress.encode(errors));
        }
        if (PsJvzConfig.getStoreVertexVF() || PsJvzConfig.getStoreElementVF()) {
            int noVF = this.m_geom.getNumVectorFields();
            int noStoredVF = 0;
            int i8 = 0;
            while (i8 < noVF) {
                if (PsJvzConfig.getStoreElementVF() && this.m_geomCode.isVectorElementBased(i8) || PsJvzConfig.getStoreVertexVF() && !this.m_geomCode.isVectorElementBased(i8)) {
                    ++noStoredVF;
                }
                ++i8;
            }
            this.m_geomCode.setNumStoredVectorFields(noStoredVF);
            int vfIndex = 0;
            int i9 = 0;
            while (i9 < noVF) {
                if (PsJvzConfig.getStoreElementVF() && this.m_geomCode.isVectorElementBased(i9) || PsJvzConfig.getStoreVertexVF() && !this.m_geomCode.isVectorElementBased(i9)) {
                    PdVector[] vectors = this.m_geom.getVectorField(i9).getVectors();
                    byte[] code2 = PuCompress.PdVectorEncode(vectors, this.m_doubleResolutionBits, true);
                    this.m_geomCode.copyVectorFieldAttributes(vfIndex, this.m_geom.getVectorField(i9));
                    this.m_geomCode.setVectorFieldCode(vfIndex, code2);
                    ++vfIndex;
                }
                ++i9;
            }
        }
        if (PsJvzConfig.getStoreVertexIndices()) {
            this.m_geomCode.setVertexIndexCode(PuCompress.encodePermutation(m_originalVertexIndex, this.m_numVertices));
        }
        if (PsJvzConfig.getStoreElementIndices()) {
            this.m_geomCode.setElementIndexCode(PuCompress.encodePermutation(elementOrder, this.m_numElements));
        }
        if (PsJvzConfig.getStoreLocalIndex()) {
            int[] newVertexIndex = PuJvzEncoder.invertPermutation(m_originalVertexIndex);
            int[] index = new int[this.m_numElements];
            int i10 = 0;
            while (i10 < elementOrder.length) {
                PiVector element = this.m_geom.getElement(elementOrder[i10]);
                index[i10] = 0;
                int min = newVertexIndex[element.m_data[0]];
                int elSize = element.getSize();
                int j = 1;
                while (j < elSize) {
                    if (newVertexIndex[element.m_data[j]] < min) {
                        index[i10] = j;
                        min = newVertexIndex[element.m_data[j]];
                    }
                    ++j;
                }
                ++i10;
            }
            this.m_geomCode.setLocalIndexCode(PuCompress.encode(index, index.length));
        }
    }

    public static void quantizeVertices(PgPointSet geom) {
        int dim = geom.getDimOfVertices();
        int numVertices = geom.getNumVertices();
        PdVector[] vertices = geom.getVertices();
        PdVector[] bndBox = PuJvzEncoder.calculateBoundingBox(geom);
        PdVector boxSize = PdVector.subNew((PdVector)bndBox[1], (PdVector)bndBox[0]);
        int resolution = PsJvzConfig.getDoubleResolution();
        if (resolution == -1) {
            resolution = Math.max(12, (int)Math.log(numVertices) + 8);
        }
        PdVector[] restored = new PdVector[numVertices];
        PdVector[] error = new PdVector[numVertices];
        int i = 0;
        while (i < numVertices) {
            restored[i] = new PdVector(dim);
            int j = 0;
            while (j < dim) {
                int rounded = (int)(0.5 + (vertices[i].m_data[j] - bndBox[0].m_data[j]) * 4096.0 / boxSize.m_data[j]);
                restored[i].m_data[j] = bndBox[0].m_data[j] + (double)rounded * boxSize.m_data[j] / 4096.0;
                ++j;
            }
            error[i] = PdVector.subNew((PdVector)vertices[i], (PdVector)restored[i]);
            ++i;
        }
        error = PuCompress.PdVectorDecode(PuCompress.PdVectorEncode(error, bndBox, resolution, true));
        i = 0;
        while (i < numVertices) {
            vertices[i].add(restored[i], error[i]);
            ++i;
        }
    }

    private boolean hasValence2Vertices() {
        this.m_freeEdges = PgElementSet.getVertexValence((PgElementSet)this.m_geom);
        PiVector incidentElements = new PiVector(this.m_numVertices);
        int i = 0;
        while (i < this.m_numElements) {
            PiVector el = this.m_geom.getElement(i);
            int elSize = el.getSize();
            int j = 0;
            while (j < elSize) {
                if (el.m_data[j] != -1) {
                    int n = el.m_data[j];
                    incidentElements.m_data[n] = incidentElements.m_data[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            if (this.m_freeEdges.m_data[i] == 2 && incidentElements.m_data[i] == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int calculateResolution() {
        return Math.max(12, (int)Math.log(this.m_numVertices) + 8);
    }

    private void resizeGeometry() {
        double factor = 1.0;
        int bestSize = Integer.MAX_VALUE;
        byte[] code = null;
        int numVerts = Math.max(this.m_numVertices / 20, 1000);
        numVerts = Math.min(numVerts, this.m_numVertices);
        PdVector[] geomVerts = this.m_geom.getVertices();
        PdVector[] vertices = PdVector.copyNew((PdVector[])geomVerts, (int)numVerts);
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < numVerts) {
                vertices[j].copy(geomVerts[j]);
                ++j;
            }
            if (i != 0) {
                j = 0;
                while (j < vertices.length) {
                    vertices[j].multScalar(factor);
                    ++j;
                }
            }
            if ((code = PuCompress.PdVectorEncode(vertices, PsJvzConfig.getDoubleResolution(), false)) != null && code.length < bestSize) {
                bestSize = code.length;
                this.m_resizeFactor = factor;
            }
            factor *= 10.0;
            ++i;
        }
        PdVector[] vertex = this.m_geom.getVertices();
        int i2 = 0;
        while (i2 < this.m_numVertices) {
            vertex[i2].multScalar(this.m_resizeFactor);
            ++i2;
        }
    }

    private static PdVector[] calculateBoundingBox(PgPointSet geom) {
        PdVector[] bndBox = geom.getAmbientBounds();
        int dim = geom.getDimOfVertices();
        double maxWidth = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < dim) {
            double interval = bndBox[1].m_data[i] - bndBox[0].m_data[i];
            double width = 1.0;
            while (width / 2.0 > interval) {
                width /= 2.0;
            }
            if (interval != 0.0) {
                while (width <= interval) {
                    width *= 2.0;
                }
            }
            width = interval;
            maxWidth = Math.max(maxWidth, width);
            ++i;
        }
        i = 0;
        while (i < dim) {
            bndBox[1].m_data[i] = bndBox[0].m_data[i] + maxWidth;
            ++i;
        }
        return bndBox;
    }

    private void initCompression() {
        this.m_bndBox = PuJvzEncoder.calculateBoundingBox((PgPointSet)this.m_geom);
        this.m_boxSize = PdVector.subNew((PdVector)this.m_bndBox[1], (PdVector)this.m_bndBox[0]);
        this.m_axisResolution = new PiVector(this.m_dim);
        this.m_axisResolution.setConstant(4096);
        this.m_doubleResolutionBits = PsJvzConfig.getDoubleResolution();
        if (this.m_doubleResolutionBits == -1) {
            this.m_doubleResolutionBits = this.calculateResolution();
        }
        if (this.m_doubleResolutionBits < 12) {
            this.m_doubleResolutionBits = 12;
        }
        this.m_discreteVertex = new PiVector[this.m_numVertices];
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_discreteVertex[i] = new PiVector(this.m_dim);
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            this.m_geom.clearTagVertex(i, 0);
            ++i;
        }
        this.m_numVertexContexts = 1;
        this.m_contextThreshold = new int[0];
        this.m_front = new PuFrontVertex[this.m_numVertices];
        this.m_queueFront = new PuFrontVertex[2 * this.m_numVertices];
        this.m_maxNumSplits = (int)(0.2 * (double)this.m_numVertices + 100.0);
        this.m_maxNumVertices = this.m_numVertices + this.m_maxNumSplits;
        this.m_arrayIncrement = this.m_numVertices / 10 + 1;
        this.m_outputAngle = new PiVector(this.m_maxNumVertices);
        this.m_outputValue = new PiVector(this.m_maxNumVertices);
        this.m_numVertexOutputs = 0;
        this.m_numSplits = 0;
        this.m_queue = new PuPriorityQueue(this.m_maxNumVertices);
        PiVector[] neigh = this.m_geom.getNeighbours();
        if (neigh == null) {
            this.m_geom.makeNeighbour();
        }
        this.m_freeEdges = PgElementSet.getVertexValence((PgElementSet)this.m_geom);
        this.m_vertexSymbols = new int[this.m_numVertexContexts][this.m_maxNumVertices];
        this.m_elementSymbols = new int[this.m_numElements];
        this.m_splitSymbols = new int[this.m_maxNumSplits];
        this.m_vvCounter = new int[this.m_numVertexContexts];
        this.m_vertexData = new int[this.m_numVertices * this.m_dim];
        m_originalVertexIndex = new int[this.m_numVertices];
        this.m_parentVertex = new int[this.m_numVertices];
        this.m_newElementIndex = new int[this.m_numElements];
        int i2 = 0;
        while (i2 < this.m_numElements) {
            this.m_newElementIndex[i2] = -1;
            ++i2;
        }
        this.m_fdCounter = 0;
        this.m_vdCounter = 0;
        this.m_elIndexCounter = 0;
        if (this.m_dim != 3) {
            this.m_position.setSize(this.m_dim);
            this.m_vector1.setSize(this.m_dim);
            this.m_vector2.setSize(this.m_dim);
            this.m_prediction.setSize(this.m_dim);
        }
        int extraBits = this.m_doubleResolutionBits - 12;
        double roundingTerm = 0.5 / (double)(1L << extraBits);
        int i3 = 0;
        while (i3 < this.m_numVertices) {
            PdVector vec = this.m_geom.getVertex(i3);
            int j = 0;
            while (j < this.m_dim) {
                this.m_discreteVertex[i3].m_data[j] = (int)(roundingTerm + (vec.m_data[j] - this.m_bndBox[0].m_data[j]) * (double)this.m_axisResolution.m_data[j] / this.m_boxSize.m_data[j]);
                ++j;
            }
            ++i3;
        }
    }

    private void initComponent() {
        while (this.m_firstElement < this.m_newElementIndex.length && this.m_newElementIndex[this.m_firstElement] != -1) {
            ++this.m_firstElement;
        }
        if (this.m_firstElement == this.m_newElementIndex.length) {
            return;
        }
        int firstElement = this.m_firstElement;
        PiVector el = this.m_geom.getElement(firstElement);
        int elSize = el.getSize();
        int i = 0;
        while (i < elSize) {
            this.m_front[el.m_data[i]] = new PuFrontVertex(el.m_data[i]);
            this.m_front[el.m_data[i]].m_freeEdges = this.m_freeEdges.m_data[el.m_data[i]] - 2;
            this.m_front[el.m_data[i]].m_incidentFaceIndex = firstElement;
            this.m_queueFront[el.m_data[i]] = this.m_front[el.m_data[i]];
            this.m_queueFront[el.m_data[i]].m_queueIndex = el.m_data[i];
            this.encodeGeometry(-1, -1, el.m_data[i], true);
            this.m_parentVertex[el.m_data[i]] = i == 0 ? -1 : el.m_data[0];
            ++i;
        }
        i = 0;
        while (i < elSize) {
            this.m_front[el.m_data[i]].setLinked(this.m_front[el.m_data[(i + 1) % elSize]]);
            this.m_front[el.m_data[i]].setAngle(this.discreteAngle(el.m_data[i], el.m_data[(i + elSize - 1) % elSize], el.m_data[(i + 1) % elSize]));
            this.m_front[el.m_data[i]].computeKey();
            this.enqueue(this.m_front[el.m_data[i]]);
            ++i;
        }
        this.m_newElementIndex[firstElement] = this.m_elIndexCounter++;
        this.outputFaceDegree(elSize);
    }

    private int closeFullNeighbour(PuFrontVertex focus) {
        int close = 0;
        if (this.getNextFace(focus.m_next) != -1 && focus.m_freeEdges > 0 && focus.m_next.m_freeEdges == 0) {
            close = focus.m_next.m_key > focus.m_previous.m_key ? -1 : -2;
            this.closeFocus(focus.m_next);
            return close;
        }
        if (this.getNextFace(focus.m_previous) != -1 && focus.m_freeEdges > 0 && focus.m_previous.m_freeEdges == 0) {
            close = focus.m_next.m_key > focus.m_previous.m_key ? -2 : -1;
            this.closeFocus(focus.m_previous);
            return close;
        }
        return close;
    }

    private void storeOutput(int angle, int val) {
        if (this.m_numVertexOutputs == this.m_outputValue.getSize()) {
            this.m_outputValue.setSize(this.m_numVertexOutputs + this.m_arrayIncrement);
            this.m_outputAngle.setSize(this.m_numVertexOutputs + this.m_arrayIncrement);
        }
        this.m_outputAngle.m_data[this.m_numVertexOutputs] = -angle;
        this.m_outputValue.m_data[this.m_numVertexOutputs] = val;
        ++this.m_numVertexOutputs;
    }

    private void processFocus(PuFrontVertex focus) {
        int angle = focus.getAngle();
        int closeNeighbour = this.closeFullNeighbour(focus);
        if (closeNeighbour != 0) {
            this.storeOutput(angle, closeNeighbour);
            this.enqueue(focus);
            return;
        }
        int freeEdges = focus.m_freeEdges;
        int i = 0;
        while (i < freeEdges) {
            PuFrontVertex next = focus.m_next;
            PuFrontVertex prev = focus.m_previous;
            boolean bBoundary = focus.m_bIsBoundary;
            int faceType = bBoundary ? this.addNewFace(false, prev, false) : (i < freeEdges - 1 ? this.addNewFace(false, focus, false) : this.addNewFace(false, focus, true));
            if (faceType != -4) {
                --focus.m_freeEdges;
                if (bBoundary) {
                    --prev.m_freeEdges;
                } else {
                    --next.m_freeEdges;
                }
            }
            if (faceType != 0) {
                this.enqueue(focus);
                if (faceType == -4) {
                    this.storeOutput(angle, -4);
                    angle -= 180;
                    this.increaseProcessedAngle(focus, 180);
                    this.updateKey(focus);
                    this.increaseProcessedAngle(focus.m_next, 180);
                    this.updateKey(focus.m_next);
                } else {
                    this.storeOutput(angle, faceType);
                }
                this.storeOutput(angle, i);
                return;
            }
            ++i;
        }
        if (focus.m_bIsBoundary || focus.m_previous.m_bIsBoundary) {
            this.closeBoundaryFocus(focus);
        } else if (!this.closeFocus(focus)) {
            this.storeOutput(angle, -4);
            angle -= 180;
            this.increaseProcessedAngle(focus, 180);
            this.updateKey(focus);
            this.increaseProcessedAngle(focus.m_next, 180);
            this.updateKey(focus.m_next);
        } else {
            this.m_queueFront[focus.m_queueIndex] = null;
        }
        this.storeOutput(angle, freeEdges);
    }

    private void closeBoundaryFocus(PuFrontVertex focus) {
        focus.m_previous.m_bIsBoundary = true;
        if (!focus.m_bIsBoundary) {
            focus.m_bIsBoundary = true;
            this.increaseProcessedAngle(focus.m_next, 180);
            this.updateKey(focus.m_next);
        }
        if (this.m_front[focus.m_index] == focus) {
            this.m_front[focus.m_index] = focus.m_split;
        }
        focus.removeFromFrontLinks();
    }

    private boolean closeFocus(PuFrontVertex focus) {
        PuFrontVertex next = focus.m_next;
        PuFrontVertex prev = focus.m_previous;
        int type = this.addNewFace(true, focus, false);
        if (type == -4) {
            this.enqueue(focus);
            return false;
        }
        focus.removeFromFront();
        if (this.m_front[focus.m_index] == focus) {
            this.m_front[focus.m_index] = focus.m_split;
        }
        focus.removeFromFrontLinks();
        if (next.m_next == prev) {
            if (this.m_front[prev.m_index] == prev) {
                this.m_front[prev.m_index] = prev.m_split;
            }
            if (this.m_front[next.m_index] == next) {
                this.m_front[next.m_index] = next.m_split;
            }
            prev.m_frontAngle = 0;
            next.m_frontAngle = 0;
            next.deleteList();
            return true;
        }
        --prev.m_freeEdges;
        --next.m_freeEdges;
        return true;
    }

    private void splitFace(int faceInd, int locInd1, int locInd2) {
        PiVector face = this.m_geom.getElement(faceInd);
        PiVector neigh = this.m_geom.getNeighbour(faceInd);
        int faceSize = face.getSize();
        int vertex1 = face.m_data[locInd1];
        int vertex2 = face.m_data[locInd2];
        int f1Size = (faceSize + locInd1 - locInd2 + 1) % faceSize;
        PiVector f1 = new PiVector(f1Size);
        PiVector n1 = new PiVector(f1Size);
        int f2Size = (faceSize + locInd2 - locInd1 + 1) % faceSize;
        PiVector f2 = new PiVector(f2Size);
        PiVector n2 = new PiVector(f2Size);
        int i = 0;
        while (i < f2Size) {
            f2.m_data[i] = face.m_data[(locInd1 + i) % faceSize];
            ++i;
        }
        i = 0;
        while (i < f2Size - 2) {
            n2.m_data[i] = neigh.m_data[(locInd1 + i) % faceSize];
            if (n2.m_data[i] != -1) {
                int ind = n2.m_data[i];
                this.m_geom.setNeighbour(ind, PiVector.copyNew((PiVector)this.m_geom.getNeighbour(ind)));
                this.m_geom.getNeighbour((int)ind).m_data[this.m_geom.getOppVertexLocInd((int)faceInd, (int)((locInd1 + i) % faceSize))] = this.m_numElements;
            }
            ++i;
        }
        n2.m_data[f2Size - 2] = faceInd;
        n2.m_data[f2Size - 1] = neigh.m_data[(locInd1 + faceSize - 1) % faceSize];
        if (n2.m_data[f2Size - 1] != -1) {
            int ind = n2.m_data[f2Size - 1];
            this.m_geom.setNeighbour(ind, PiVector.copyNew((PiVector)this.m_geom.getNeighbour(ind)));
            this.m_geom.getNeighbour((int)ind).m_data[this.m_geom.getOppVertexLocInd((int)faceInd, (int)((locInd1 + faceSize - 1) % faceSize))] = this.m_numElements;
        }
        i = 0;
        while (i < f1Size) {
            f1.m_data[i] = face.m_data[(locInd2 + i) % faceSize];
            ++i;
        }
        i = 0;
        while (i < f1Size - 2) {
            n1.m_data[i] = neigh.m_data[(locInd2 + i) % faceSize];
            ++i;
        }
        n1.m_data[f1Size - 2] = this.m_numElements++;
        n1.m_data[f1Size - 1] = neigh.m_data[(locInd2 + faceSize - 1) % faceSize];
        this.m_geom.setNumElements(this.m_numElements);
        this.m_geom.setElement(faceInd, f1);
        this.m_geom.setNeighbour(faceInd, n1);
        this.m_geom.setElement(this.m_numElements - 1, f2);
        this.m_geom.setNeighbour(this.m_numElements - 1, n2);
        if (this.m_front[vertex1].m_split != null) {
            ++this.findSplitVertexInstance((int)vertex2, (int)vertex1).m_freeEdges;
        } else {
            ++this.m_front[vertex1].m_freeEdges;
        }
        if (this.m_front[vertex2].m_split != null) {
            ++this.findSplitVertexInstance((int)vertex1, (int)vertex2).m_freeEdges;
        } else {
            ++this.m_front[vertex2].m_freeEdges;
        }
    }

    private boolean checkForInteriorSplits(int faceInd, PuFrontVertex focus, boolean bClose) {
        boolean bSplitFace;
        block13: {
            int faceSize;
            int focusLocInd;
            PiVector face;
            block16: {
                block14: {
                    block15: {
                        bSplitFace = false;
                        face = this.m_geom.getElement(faceInd);
                        focusLocInd = face.getIndexOf(focus.m_index);
                        faceSize = face.getSize();
                        boolean bOriented = true;
                        if (face.m_data[(focusLocInd + 1) % faceSize] == focus.m_next.m_index) {
                            bOriented = false;
                        }
                        if (!bOriented) break block14;
                        if (!bClose) break block15;
                        if (this.m_front[face.m_data[(focusLocInd + faceSize - 2) % faceSize]] != null) {
                            this.splitFace(faceInd, (focusLocInd + 1) % faceSize, (focusLocInd + faceSize - 1) % faceSize);
                            bSplitFace = true;
                        } else {
                            int i = faceSize - 3;
                            while (i > 2) {
                                if (this.m_front[face.m_data[(focusLocInd + i) % faceSize]] != null) {
                                    this.splitFace(faceInd, (focusLocInd + 1) % faceSize, (focusLocInd + i) % faceSize);
                                    bSplitFace = true;
                                    break;
                                }
                                --i;
                            }
                        }
                        if (bSplitFace || this.m_front[face.m_data[(focusLocInd + 2) % faceSize]] == null) break block13;
                        this.splitFace(faceInd, (focusLocInd + 1) % faceSize, (focusLocInd + faceSize - 1) % faceSize);
                        bSplitFace = true;
                        break block13;
                    }
                    int i = faceSize - 2;
                    while (i > 1) {
                        if (this.m_front[face.m_data[(focusLocInd + i) % faceSize]] != null) {
                            this.splitFace(faceInd, focusLocInd, (focusLocInd + i) % faceSize);
                            bSplitFace = true;
                            break block13;
                        }
                        --i;
                    }
                    break block13;
                }
                if (!bClose) break block16;
                if (this.m_front[face.m_data[(focusLocInd + 2) % faceSize]] != null) {
                    this.splitFace(faceInd, (focusLocInd + 1) % faceSize, (focusLocInd + faceSize - 1) % faceSize);
                    bSplitFace = true;
                } else {
                    int i = 3;
                    while (i < faceSize - 2) {
                        if (this.m_front[face.m_data[(focusLocInd + i) % faceSize]] != null) {
                            this.splitFace(faceInd, (focusLocInd + faceSize - 1) % faceSize, (focusLocInd + i) % faceSize);
                            bSplitFace = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (bSplitFace || this.m_front[face.m_data[(focusLocInd + faceSize - 2) % faceSize]] == null) break block13;
                this.splitFace(faceInd, (focusLocInd + 1) % faceSize, (focusLocInd + faceSize - 1) % faceSize);
                bSplitFace = true;
                break block13;
            }
            int i = 2;
            while (i < faceSize - 1) {
                if (this.m_front[face.m_data[(focusLocInd + i) % faceSize]] != null) {
                    this.splitFace(faceInd, focusLocInd, (focusLocInd + i) % faceSize);
                    bSplitFace = true;
                    break;
                }
                ++i;
            }
        }
        return bSplitFace;
    }

    private int addNewFace(boolean bClose, PuFrontVertex focus, boolean bNewPrediction) {
        int angle;
        int faceInd = this.getNextFace(focus);
        if (faceInd == -1) {
            focus.m_bIsBoundary = true;
            return -4;
        }
        PiVector face = this.m_geom.getElement(faceInd);
        int faceSize = face.getSize();
        if (faceSize > 3 || this.m_geom.getNeighbour((int)faceInd).m_data[face.getIndexOf(focus.m_next.m_index)] == -1) {
            bNewPrediction = false;
        }
        boolean bSplitFace = false;
        if (faceInd < this.m_newElementIndex.length && this.m_newElementIndex[faceInd] < 0) {
            this.m_newElementIndex[faceInd] = this.m_elIndexCounter++;
        }
        if (faceSize > 3 && (bSplitFace = this.checkForInteriorSplits(faceInd, focus, bClose))) {
            faceInd = this.getNextFace(focus);
            face = this.m_geom.getElement(faceInd);
            faceSize = face.getSize();
        }
        int pFaceInd = focus.m_incidentFaceIndex;
        PiVector pFace = this.m_geom.getElement(pFaceInd);
        int pLocalInd = pFace.getIndexOf(focus.m_index);
        int pFaceSize = pFace.getSize();
        boolean bPOriented = true;
        if (pFace.m_data[(pLocalInd + 1) % pFaceSize] != focus.m_next.m_index) {
            bPOriented = false;
        }
        focus.m_incidentFaceIndex = faceInd;
        boolean bSplitVertex = false;
        PuFrontVertex previous = focus.m_previous;
        int numNew = faceSize - 2;
        int focusLocInd = face.getIndexOf(focus.m_index);
        boolean bOriented = true;
        if (face.m_data[(focusLocInd + 1) % faceSize] == focus.m_next.m_index) {
            bOriented = false;
        }
        boolean bSplitIsOriented = true;
        if (bClose) {
            --numNew;
            previous.m_incidentFaceIndex = faceInd;
        }
        PuFrontVertex newSplit = null;
        int i = 0;
        while (i < numNew) {
            int newVertex = bOriented ? face.m_data[(focusLocInd + faceSize - 2 - i) % faceSize] : face.m_data[(focusLocInd + 2 + i) % faceSize];
            if (this.m_front[newVertex] == null) {
                this.m_front[newVertex] = bClose ? previous.insertNewVertex(newVertex) : focus.insertNewVertex(newVertex);
                this.m_front[newVertex].m_freeEdges = this.m_freeEdges.m_data[newVertex] - 2;
                this.m_front[newVertex].m_queueIndex = newVertex;
                this.m_queueFront[newVertex] = this.m_front[newVertex];
                if (bNewPrediction) {
                    this.encodeGeometryFreelencePrediction(pFaceInd, focus, newVertex);
                } else {
                    this.encodeGeometry(pFaceInd, focus.m_index, newVertex, bPOriented);
                }
                this.m_front[newVertex].m_incidentFaceIndex = faceInd;
            } else {
                int newIndex;
                int distance;
                PuFrontVertex splitVertex;
                bSplitVertex = true;
                if (bClose) {
                    splitVertex = this.findSplitVertexInstance(previous.m_index, newVertex);
                    distance = this.distanceQueueIndex(previous, splitVertex);
                    newIndex = this.m_numVertices + this.m_numSplits;
                    ++this.m_numSplits;
                    newSplit = previous.insertSplitVertex(splitVertex);
                } else {
                    splitVertex = this.findSplitVertexInstance(focus.m_index, newVertex);
                    distance = this.distanceQueueIndex(focus, splitVertex);
                    newIndex = this.m_numVertices + this.m_numSplits;
                    ++this.m_numSplits;
                    newSplit = focus.insertSplitVertex(splitVertex);
                }
                this.m_queueFront[newIndex] = newSplit;
                newSplit.m_queueIndex = newIndex;
                newSplit.m_incidentFaceIndex = splitVertex.m_incidentFaceIndex;
                splitVertex.m_incidentFaceIndex = faceInd;
                if (splitVertex.m_bIsBoundary) {
                    splitVertex.m_bIsBoundary = false;
                    newSplit.m_bIsBoundary = true;
                }
                if (!(bSplitIsOriented = this.splitIsOriented(splitVertex, newSplit))) {
                    splitVertex.flipFront(newSplit);
                }
                PiVector link = this.getLink(splitVertex.m_index);
                int linkSize = link.getSize();
                PiVector incFace = this.m_geom.getElement(splitVertex.m_incidentFaceIndex);
                int incFaceSize = incFace.getSize();
                int splitLocInd = incFace.getIndexOf(splitVertex.m_index);
                int pe = splitVertex.m_next.m_index == incFace.m_data[(splitLocInd + 1) % incFaceSize] ? incFace.m_data[(splitLocInd + incFaceSize - 1) % incFaceSize] : incFace.m_data[(splitLocInd + 1) % incFaceSize];
                int free = link.m_data[(link.getIndexOf(splitVertex.m_next.m_index) + 1) % linkSize] == pe ? (linkSize + link.getIndexOf(splitVertex.m_next.m_index) - link.getIndexOf(splitVertex.m_previous.m_index) - 1) % linkSize : (linkSize + link.getIndexOf(splitVertex.m_previous.m_index) - link.getIndexOf(splitVertex.m_next.m_index) - 1) % linkSize;
                splitVertex.m_freeEdges = free;
                newSplit.m_freeEdges -= free + 2;
                this.outputSplitCode(distance);
            }
            ++i;
        }
        if (bSplitVertex) {
            --numNew;
        }
        if (bOriented) {
            i = 0;
            while (i < faceSize) {
                angle = this.discreteAngle(face.m_data[(focusLocInd + i) % faceSize], face.m_data[(focusLocInd + i + faceSize - 1) % faceSize], face.m_data[(focusLocInd + i + 1) % faceSize]);
                this.increaseProcessedAngle(this.m_front[face.m_data[(focusLocInd + i) % faceSize]], angle);
                ++i;
            }
        } else {
            i = 0;
            while (i < faceSize) {
                angle = this.discreteAngle(face.m_data[(focusLocInd + faceSize - i) % faceSize], face.m_data[(focusLocInd + faceSize - i - 1) % faceSize], face.m_data[(focusLocInd + faceSize - i + 1) % faceSize]);
                this.increaseProcessedAngle(this.m_front[face.m_data[(focusLocInd + faceSize - i) % faceSize]], angle);
                ++i;
            }
        }
        if (bOriented) {
            i = 0;
            while (i < numNew) {
                this.enqueue(this.m_front[face.m_data[(focusLocInd + faceSize - 2 - i) % faceSize]]);
                ++i;
            }
        } else {
            i = 0;
            while (i < numNew) {
                this.enqueue(this.m_front[face.m_data[(focusLocInd + 2 + i) % faceSize]]);
                ++i;
            }
        }
        if (newSplit != null) {
            this.enqueue(newSplit);
        }
        if (bOriented) {
            i = 0;
            while (i < faceSize) {
                this.updateKey(this.m_front[face.m_data[(i + focusLocInd) % faceSize]]);
                ++i;
            }
        } else {
            i = 0;
            while (i < faceSize) {
                this.updateKey(this.m_front[face.m_data[(focusLocInd + faceSize - i) % faceSize]]);
                ++i;
            }
        }
        if (bSplitFace) {
            this.outputFaceDegree(-faceSize);
        } else {
            this.outputFaceDegree(faceSize);
        }
        if (bSplitVertex) {
            if (bSplitIsOriented) {
                return -3;
            }
            return -5;
        }
        return 0;
    }

    private boolean splitIsOriented(PuFrontVertex v, PuFrontVertex w) {
        PiVector link = this.getLink(v.m_index);
        int linkSize = link.getSize();
        int vnLocInd = link.getIndexOf(v.m_next.m_index);
        boolean vpFound = false;
        boolean wpFound = false;
        boolean wnFound = false;
        int i = 1;
        while (i < linkSize) {
            if (link.m_data[(vnLocInd + i) % linkSize] == v.m_previous.m_index) {
                if (wpFound != wnFound) {
                    return false;
                }
                vpFound = true;
            }
            if (link.m_data[(vnLocInd + i) % linkSize] == w.m_previous.m_index) {
                if (wnFound != vpFound) {
                    return false;
                }
                wpFound = true;
            }
            if (link.m_data[(vnLocInd + i) % linkSize] == w.m_next.m_index) {
                if (wpFound == vpFound) {
                    return false;
                }
                wnFound = true;
            }
            ++i;
        }
        return true;
    }

    private PuFrontVertex findSplitVertexInstance(int linkVertex, int centerVertex) {
        PiVector link = this.getLink(centerVertex);
        PuFrontVertex center = this.m_front[centerVertex];
        int linkSize = link.getSize();
        while (true) {
            if (center.m_next != null) {
                int end;
                int locInd;
                int elSize;
                PiVector el = this.m_geom.getElement(center.m_incidentFaceIndex);
                int localIndex = el.getIndexOf(centerVertex);
                int pe = el.m_data[(localIndex + (elSize = el.getSize()) - 1) % elSize];
                if (pe == center.m_next.m_index) {
                    pe = el.m_data[(localIndex + 1) % elSize];
                }
                if (link.getIndexOf(center.m_next.m_index) == (link.getIndexOf(pe) + 1) % linkSize) {
                    locInd = link.getIndexOf(center.m_next.m_index);
                    end = center.m_previous.m_index;
                } else {
                    locInd = link.getIndexOf(center.m_previous.m_index);
                    end = center.m_next.m_index;
                }
                boolean bFound = false;
                int i = 0;
                while (i < linkSize) {
                    if (link.m_data[(locInd + i) % linkSize] == linkVertex) {
                        bFound = true;
                        break;
                    }
                    if (link.m_data[(locInd + i) % linkSize] == end) break;
                    ++i;
                }
                if (bFound) break;
            }
            center = center.m_split;
        }
        return center;
    }

    private int getNextFace(PuFrontVertex v) {
        int elementSize;
        PiVector el = this.m_geom.getElement(v.m_incidentFaceIndex);
        int locInd = el.getIndexOf(v.m_index);
        if (el.m_data[(locInd + 1) % (elementSize = el.getSize())] == v.m_next.m_index) {
            return this.m_geom.getNeighbour((int)v.m_incidentFaceIndex).m_data[(locInd - 1 + elementSize) % elementSize];
        }
        return this.m_geom.getNeighbour((int)v.m_incidentFaceIndex).m_data[(locInd - 2 + elementSize) % elementSize];
    }

    private PiVector getLink(int vertex) {
        this.m_vs.makeVertexStar(this.m_geom, vertex, this.m_front[vertex].m_incidentFaceIndex);
        return this.m_vs.getLink();
    }

    private int distanceQueueIndex(PuFrontVertex v1, PuFrontVertex v2) {
        int index = 0;
        int nv = this.m_queue.getHeapSize();
        int[] vertexIndex = this.m_queue.getElements();
        PuPriorityQueue queue = new PuPriorityQueue(this.m_maxNumVertices);
        int i = 0;
        while (i < nv) {
            int sqrDist = this.m_discreteVertex[this.m_queueFront[vertexIndex[i]].m_index].sqrDist(this.m_discreteVertex[v1.m_index]);
            queue.enqueue(vertexIndex[i], (double)sqrDist);
            ++i;
        }
        while (queue.extractMin() != v2.m_queueIndex) {
            ++index;
        }
        return index;
    }

    private void outputFaceDegree(int fd) {
        if (fd >= 3) {
            fd -= 3;
        } else if (fd <= -3) {
            fd += 2;
        } else if (-3 < fd && fd < 3) {
            PsDebug.warning((String)("Illegal face degree of " + fd));
        }
        if (this.m_elementSymbols.length == this.m_fdCounter) {
            int[] esn = new int[this.m_fdCounter + this.m_arrayIncrement];
            System.arraycopy(this.m_elementSymbols, 0, esn, 0, this.m_fdCounter);
            this.m_elementSymbols = esn;
        }
        this.m_elementSymbols[this.m_fdCounter] = fd;
        ++this.m_fdCounter;
    }

    private void outputVertexData(PiVector data) {
        int i = 0;
        while (i < this.m_dim) {
            this.m_vertexData[this.m_dim * this.m_vdCounter + i] = data.m_data[i];
            ++i;
        }
        ++this.m_vdCounter;
    }

    private void outputSplitCode(int distIndex) {
        if (this.m_splitSymbols.length == this.m_numSplits - 1) {
            int[] ssn = new int[this.m_numSplits + this.m_arrayIncrement];
            System.arraycopy(this.m_splitSymbols, 0, ssn, 0, this.m_numSplits - 1);
            this.m_splitSymbols = ssn;
        }
        this.m_splitSymbols[this.m_numSplits - 1] = distIndex;
    }

    private void encodeGeometryFreelencePrediction(int pFaceInd, PuFrontVertex focus, int newVertex) {
        if (focus == null) {
            PsDebug.message((String)"Focus argument is null!");
            return;
        }
        this.m_parentVertex[newVertex] = focus.m_index;
        PuJvzEncoder.m_originalVertexIndex[this.m_vdCounter] = newVertex;
        this.m_geom.setTagVertex(newVertex, 0);
        int prev = focus.m_previous.m_index;
        int next = focus.m_next.m_next.m_index;
        PiVector diff = this.freeLencePrediction(pFaceInd, focus, prev, next);
        diff.sub(this.m_discreteVertex[newVertex]);
        this.outputVertexData(diff);
    }

    private void encodeGeometry(int pFaceInd, int focus, int newVertex, boolean bOriented) {
        if (focus != -1) {
            this.m_parentVertex[newVertex] = focus;
        }
        PuJvzEncoder.m_originalVertexIndex[this.m_vdCounter] = newVertex;
        this.m_geom.setTagVertex(newVertex, 0);
        if (pFaceInd < 0) {
            this.outputVertexData(this.m_discreteVertex[newVertex]);
            return;
        }
        PiVector pFace = this.m_geom.getElement(pFaceInd);
        int faceSize = pFace.getSize();
        if (faceSize == 3 && this.m_fdCounter != 0) {
            PiVector diff = this.predictVertexPosition(pFace, focus, bOriented);
            diff.sub(this.m_discreteVertex[newVertex]);
            this.outputVertexData(diff);
        } else {
            this.outputVertexData(this.m_discreteVertex[newVertex]);
        }
    }

    private int[][] integrateValues() {
        int numDiscreteAngles = 601;
        int[][] numEntries = new int[13][numDiscreteAngles];
        int i = 0;
        while (i < this.m_numVertexOutputs) {
            int pos = this.m_outputAngle.m_data[i] / 1;
            if (pos > numDiscreteAngles - 1) {
                pos = numDiscreteAngles - 1;
            }
            if (this.m_outputValue.m_data[i] + 5 < 13) {
                int[] nArray = numEntries[this.m_outputValue.m_data[i] + 5];
                int n = pos;
                nArray[n] = nArray[n] + 1;
            } else {
                int[] nArray = numEntries[12];
                int n = pos;
                nArray[n] = nArray[n] + 1;
            }
            ++i;
        }
        return numEntries;
    }

    private void improveThreshold() {
        double size = 9.223372036854776E18;
        double oldSize = Double.POSITIVE_INFINITY;
        int numIntervals = 1;
        int numDiscreteAngles = 601;
        int[][] numEntries = this.integrateValues();
        int[] discreteThreshold = new int[numIntervals + 1];
        int[] nvLeft = new int[13];
        int[] nvRight = new int[13];
        discreteThreshold[0] = 0;
        discreteThreshold[numIntervals] = numDiscreteAngles - 1;
        while (size < oldSize) {
            oldSize = size;
            size = 0.0;
            int[] newDiscrThreshold = new int[(numIntervals *= 2) + 1];
            int i = 0;
            while (i < numIntervals / 2) {
                newDiscrThreshold[2 * i] = discreteThreshold[i];
                newDiscrThreshold[2 * i + 1] = discreteThreshold[i + 1];
                ++i;
            }
            newDiscrThreshold[numIntervals] = numDiscreteAngles - 1;
            discreteThreshold = newDiscrThreshold;
            double optRightSize = 0.0;
            int i2 = 0;
            while (i2 < numIntervals - 1) {
                int j = 0;
                while (j < 13) {
                    nvLeft[j] = 0;
                    nvRight[j] = 0;
                    int k = discreteThreshold[i2];
                    while (k < discreteThreshold[i2 + 2]) {
                        int n = j;
                        nvRight[n] = nvRight[n] + numEntries[j][k];
                        ++k;
                    }
                    ++j;
                }
                discreteThreshold[i2 + 1] = discreteThreshold[i2];
                double optSize = PuCompress.computeCompressedSize(nvRight) - 64.0;
                double optLeftSize = 0.0;
                optRightSize = optSize + 64.0;
                int th = discreteThreshold[i2] + 1;
                while (th < discreteThreshold[i2 + 2] - 1) {
                    double rightSize;
                    int j2 = 0;
                    while (j2 < 13) {
                        int n = j2;
                        nvLeft[n] = nvLeft[n] + numEntries[j2][th - 1];
                        int n2 = j2;
                        nvRight[n2] = nvRight[n2] - numEntries[j2][th - 1];
                        ++j2;
                    }
                    double leftSize = PuCompress.computeCompressedSize(nvLeft);
                    if (leftSize + (rightSize = PuCompress.computeCompressedSize(nvRight)) < optSize) {
                        discreteThreshold[i2 + 1] = th;
                        optSize = leftSize + rightSize;
                        optLeftSize = leftSize;
                        optRightSize = rightSize;
                    }
                    ++th;
                }
                size += optLeftSize;
                ++i2;
            }
            size += optRightSize;
            int count = 1;
            int i3 = 1;
            while (i3 < numIntervals) {
                if (discreteThreshold[i3] > 0 && discreteThreshold[i3] < discreteThreshold[i3 + 1]) {
                    discreteThreshold[count++] = discreteThreshold[i3];
                }
                ++i3;
            }
            discreteThreshold[count] = numDiscreteAngles - 1;
            numIntervals = count;
            size += (double)((count - 1) * 64);
        }
        this.m_numVertexContexts = numIntervals;
        this.m_contextThreshold = new int[this.m_numVertexContexts - 1];
        int i = 1;
        while (i < this.m_numVertexContexts) {
            this.m_contextThreshold[i - 1] = discreteThreshold[i] * 1;
            ++i;
        }
    }

    private void makeContextArrays() {
        this.m_vertexSymbols = new int[this.m_numVertexContexts][this.m_numVertexOutputs];
        this.m_vvCounter = new int[this.m_numVertexContexts];
        int i = 0;
        while (i < this.m_numVertexOutputs) {
            int context;
            if (this.m_numVertexContexts == 1 || this.m_contextThreshold[0] > this.m_outputAngle.m_data[i]) {
                context = 0;
            } else {
                context = this.m_numVertexContexts - 1;
                while (this.m_contextThreshold[context - 1] > this.m_outputAngle.m_data[i]) {
                    --context;
                }
            }
            this.m_vertexSymbols[context][this.m_vvCounter[context]] = this.m_outputValue.m_data[i];
            int n = context;
            this.m_vvCounter[n] = this.m_vvCounter[n] + 1;
            ++i;
        }
    }

    private int[] makeVertexParentVector(int[] parent, int[] traversalOrder) {
        int[] origParent = new int[this.m_numVertices];
        int[] inverse = PuJvzEncoder.invertPermutation(traversalOrder);
        int i = 0;
        while (i < this.m_numVertices) {
            if (traversalOrder[i] >= 0) {
                origParent[i] = -1;
                if (parent[traversalOrder[i]] >= 0) {
                    origParent[i] = inverse[parent[traversalOrder[i]]];
                }
            }
            ++i;
        }
        return origParent;
    }

    private int[] makeElementParentVector(int[] elementOrder) {
        int[] parent = new int[this.m_numElements];
        parent[0] = -1;
        int i = 1;
        while (i < this.m_numElements) {
            int min = Integer.MAX_VALUE;
            PiVector neigh = this.m_geom.getNeighbour(elementOrder[i]);
            int j = 0;
            while (j < neigh.getSize()) {
                if (neigh.m_data[j] >= 0 && this.m_newElementIndex[neigh.m_data[j]] < min) {
                    min = this.m_newElementIndex[neigh.m_data[j]];
                }
                ++j;
            }
            if (min > i) {
                min = -1;
            }
            parent[i] = min;
            ++i;
        }
        return parent;
    }

    private static int[] invertPermutation(int[] index) {
        int[] inv = new int[index.length];
        int i = 0;
        while (i < index.length) {
            inv[index[i]] = i;
            ++i;
        }
        return inv;
    }
}

