/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import devCompress.PgJvzCode;
import devCompress.PuCompress;
import devCompress.PuFrontVertex;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.util.PuPriorityQueue;

public class PuJvzDecoder
extends PsObject {
    protected static final PiVector m_FreelenceFaces = new PiVector(new int[]{5, 6, 7, 8});
    protected static final int CLOSE_NARROW = -1;
    protected static final int CLOSE_WIDE = -2;
    protected static final int SPLIT = -3;
    protected static final int BOUNDARY = -4;
    protected static final int UNORIENTED_SPLIT = -5;
    protected static final int BND_ANGLE = 180;
    protected long m_mem = 0L;
    protected PiVector m_axisResolution;
    protected PdVector[] m_bndBox;
    protected PdVector m_boxSize;
    protected int m_dim = 3;
    protected PgElementSet m_geom;
    protected int m_numVertices;
    protected int m_maxNumVertices;
    protected int m_numElements;
    protected int m_maxNumSplits;
    protected int m_numSplits;
    protected int[][] m_vertexSymbols;
    protected int[] m_elementSymbols;
    protected int[] m_splitSymbols;
    protected int[] m_vertexData;
    protected int[] m_contextThreshold;
    protected int m_numVertexContexts;
    protected int[] m_parentVertex;
    protected PiVector[] m_discreteVertex;
    protected PuPriorityQueue m_queue;
    protected PuFrontVertex[] m_queueFront;
    protected PuFrontVertex[] m_front;
    protected int m_fdCounter;
    protected int[] m_vvCounter;
    protected int m_vdCounter;
    protected PiVector m_prediction = new PiVector(this.m_dim);
    private PiVector m_data;
    protected PdVector m_position = new PdVector(this.m_dim);
    protected PiVector m_vector1;
    protected PiVector m_vector2;
    private PiVector m_diff;
    private static final int m_angleFactor = 10000;
    private static final int[] m_sqrCos = new int[]{9999, 9993, 9981, 9963, 9938, 9908, 9872, 9830, 9782, 9728, 9668, 9603, 9532, 9455, 9373, 9286, 9193, 9096, 8993, 8886, 8774, 8657, 8536, 8410, 8280, 8147, 8009, 7868, 7723, 7575, 7424, 7270, 7113, 6954, 6792, 6628, 6462, 6294, 6125, 5954, 5782, 5609, 5436, 5262, 5087, 4912, 4738, 4564, 4391, 4218, 4046, 3875, 3706, 3538, 3372, 3208, 3046, 2887, 2730, 2576, 2425, 2277, 2132, 1991, 1853, 1720, 1590, 1464, 1343, 1226, 1114, 1007, 904, 807, 714, 627, 545, 468, 397, 322, 272, 218, 170, 128, 92, 62, 37, 19, 7, 1, -1};

    public PuJvzDecoder() {
        this.m_data = new PiVector(this.m_dim);
        this.m_vector1 = new PiVector(this.m_dim);
        this.m_vector2 = new PiVector(this.m_dim);
        this.m_diff = new PiVector(this.m_dim);
        if (((Object)((Object)this)).getClass() == PuJvzDecoder.class) {
            this.init();
        }
    }

    public PgJvxSrc decodeGeometry(PgJvzCode geomCode) {
        long tStart = System.currentTimeMillis();
        this.m_mem = PsDebug.getMemoryTotal();
        PsDebug.initMemory();
        this.m_geom = new PgElementSet();
        this.m_dim = geomCode.getDimOfVertices();
        this.m_bndBox = geomCode.getBndBox();
        this.m_vertexSymbols = PuCompress.decodeArray(geomCode.getVertexSymbolCode());
        this.m_elementSymbols = PuCompress.decode(geomCode.getElementSymbolCode());
        this.m_splitSymbols = PuCompress.decode(geomCode.getSplitSymbolCode());
        byte[] vertexDataCode = geomCode.getVertexDataCode();
        int[] firstCoordinates = new int[9];
        int bytesPerFirstCoordinate = 2;
        int bytesForFirstCoordinates = 9 * bytesPerFirstCoordinate;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < bytesPerFirstCoordinate) {
                int n = i;
                firstCoordinates[n] = firstCoordinates[n] | (vertexDataCode[bytesPerFirstCoordinate * i + j] & 0xFF) << 8 * j;
                ++j;
            }
            ++i;
        }
        byte[] partialVertexDataCode = new byte[vertexDataCode.length - bytesForFirstCoordinates];
        System.arraycopy(vertexDataCode, bytesForFirstCoordinates, partialVertexDataCode, 0, partialVertexDataCode.length);
        int[] tmp = PuCompress.decode(partialVertexDataCode);
        this.m_vertexData = new int[9 + tmp.length];
        System.arraycopy(firstCoordinates, 0, this.m_vertexData, 0, 9);
        System.arraycopy(tmp, 0, this.m_vertexData, 9, tmp.length);
        this.m_axisResolution = new PiVector(geomCode.getAxisResolution());
        this.m_numVertexContexts = geomCode.getNumContexts();
        this.m_contextThreshold = geomCode.getContextThresholds();
        this.m_numVertices = geomCode.getNumStoredVertices();
        this.m_numElements = geomCode.getNumStoredElements();
        this.m_geom.setEnabledInstanceSharing(true);
        this.m_geom.setJvx(geomCode.getJvx());
        this.m_geom.setEnabledInstanceSharing(false);
        this.m_geom.setNumVertices(this.m_numVertices);
        this.m_geom.setNumElements(this.m_elementSymbols.length);
        this.m_geom.setNumElements(this.m_numElements);
        this.decode();
        this.decompressAttributes(geomCode);
        this.m_geom.setEnabledInstanceSharing(true);
        return this.m_geom.getJvx();
    }

    /*
     * Unable to fully structure code
     */
    private void decode() {
        this.initDecompression();
        this.decInitComponent();
        ** GOTO lbl13
        {
            focus = this.m_queueFront[this.m_queue.extractMin()];
            if (focus.m_next == null) {
                focus.removeFromFrontLinks();
                this.m_queueFront[focus.m_queueIndex] = null;
            } else {
                this.decProcessFocus(focus);
            }
            do {
                if (this.m_queue.getHeapSize() != 0) continue block0;
                this.decInitComponent();
lbl13:
                // 2 sources

            } while (this.m_queue.getHeapSize() != 0);
        }
        while (this.m_vdCounter < this.m_numVertices) {
            this.decodeGeometry(-1, -1, this.m_vdCounter, true);
        }
        i = 0;
        ** GOTO lbl29
        {
            faceInd = i;
            neighInd = this.m_geom.getNeighbour((int)faceInd).m_data[0];
            while (this.m_geom.hasTagElement(neighInd, 1)) {
                faceInd = neighInd;
                neighInd = this.m_geom.getNeighbour((int)faceInd).m_data[0];
            }
            this.joinFace(faceInd, 0);
            do {
                if (this.m_geom.hasTagElement(i, 1) && !this.m_geom.hasTagElement(i, 2)) continue block3;
                ++i;
lbl29:
                // 2 sources

            } while (i < this.m_geom.getNumElements());
        }
        this.m_geom.removeMarkedElements();
        this.m_geom.assureDimOfElements();
    }

    private void decompressAttributes(PgJvzCode geomCode) {
        byte[] code;
        Color[] ebColors;
        Color[] eColors;
        PdVector[] vTex;
        PiVector element;
        int i;
        int[] originalVertexIndex = PuCompress.decodePermutation(geomCode.getVertexIndexCode());
        int[] elementIndex = PuCompress.decodePermutation(geomCode.getElementIndexCode());
        int[] parentElement = this.decMakeElementParentVector();
        int[] localIndex = PuCompress.decode(geomCode.getLocalIndexCode());
        if (localIndex != null) {
            i = 0;
            while (i < this.m_numElements) {
                element = this.m_geom.getElement(i);
                PiVector neighbor = this.m_geom.getNeighbour(i);
                int shift = (localIndex[i] - element.indexOfMin() + element.getSize()) % element.getSize();
                element.shift(shift);
                neighbor.shift(shift);
                ++i;
            }
        }
        if (originalVertexIndex != null) {
            i = 0;
            while (i < this.m_numElements) {
                element = this.m_geom.getElement(i);
                int size = element.getSize();
                int j = 0;
                while (j < size) {
                    element.m_data[j] = originalVertexIndex[element.m_data[j]];
                    ++j;
                }
                ++i;
            }
        } else {
            originalVertexIndex = new int[this.m_numVertices];
            i = 0;
            while (i < this.m_numVertices) {
                originalVertexIndex[i] = i;
                ++i;
            }
        }
        if (elementIndex != null) {
            PiVector[] oldElem = PiVector.copyNew((PiVector[])this.m_geom.getElements(), (int)this.m_numElements);
            PiVector[] newElem = this.m_geom.getElements();
            int i2 = 0;
            while (i2 < this.m_numElements) {
                newElem[elementIndex[i2]] = oldElem[i2];
                ++i2;
            }
            this.m_geom.setElements(newElem);
            this.m_geom.makeNeighbour();
        } else {
            elementIndex = new int[this.m_numElements];
            i = 0;
            while (i < this.m_numElements) {
                elementIndex[i] = i;
                ++i;
            }
        }
        long[][] error = PuCompress.decodeLongArray(geomCode.getDiscrErrorCode());
        if (error == null) {
            int i3 = 0;
            while (i3 < this.m_numVertices) {
                this.m_geom.setVertex(originalVertexIndex[i3], this.computeVertexPosition(this.m_discreteVertex[i3]));
                ++i3;
            }
        } else {
            int extraBits = 42;
            int i4 = 0;
            while (i4 < this.m_numVertices) {
                this.m_geom.setVertex(originalVertexIndex[i4], this.computeVertexPosition(this.m_discreteVertex[i4], error[i4], extraBits));
                ++i4;
            }
        }
        Color[] vColors = PuCompress.decodeColors(this.m_parentVertex, geomCode.getVertexColorCode());
        if (vColors != null) {
            int i5 = 0;
            while (i5 < this.m_numVertices) {
                this.m_geom.setVertexColor(originalVertexIndex[i5], vColors[i5]);
                ++i5;
            }
        }
        if ((vTex = PuCompress.decodeTextures(this.m_parentVertex, geomCode.getVertexTextureCode())) != null) {
            int i6 = 0;
            while (i6 < this.m_numVertices) {
                this.m_geom.setVertexTexture(originalVertexIndex[i6], vTex[i6]);
                ++i6;
            }
        }
        if ((eColors = PuCompress.decodeColors(parentElement, geomCode.getElementColorCode())) != null) {
            int i7 = 0;
            while (i7 < this.m_numElements) {
                this.m_geom.setElementColor(elementIndex[i7], eColors[i7]);
                ++i7;
            }
        }
        if ((ebColors = PuCompress.decodeColors(parentElement, geomCode.getElementBackColorCode())) != null) {
            int i8 = 0;
            while (i8 < this.m_numElements) {
                this.m_geom.setElementBackColor(elementIndex[i8], ebColors[i8]);
                ++i8;
            }
        }
        if ((code = geomCode.getElementTextureCode()) != null) {
            int counter = 0;
            PiVector[] elements = this.m_geom.getElements();
            PdVector[] coordinates = PuCompress.PdVectorDecode(code);
            PdVector[][] textures = new PdVector[this.m_numElements][];
            int i9 = 0;
            while (i9 < this.m_numElements) {
                int size = elements[elementIndex[i9]].getSize();
                textures[elementIndex[i9]] = new PdVector[size];
                int j = 0;
                while (j < size) {
                    textures[elementIndex[i9]][j] = coordinates[counter++];
                    ++j;
                }
                ++i9;
            }
            this.m_geom.setElementTextures((PdVector[][])textures);
        }
        this.m_geom.makeVertexNormals();
        this.m_geom.makeElementNormals();
        PdVector[] normal = PuCompress.PdVectorDecode(geomCode.getVertexNormalCode());
        if (normal != null) {
            int i10 = 0;
            while (i10 < this.m_numVertices) {
                this.m_geom.getVertexNormal(originalVertexIndex[i10]).add(normal[i10]);
                ++i10;
            }
        }
        if ((normal = PuCompress.PdVectorDecode(geomCode.getElementNormalCode())) != null) {
            int i11 = 0;
            while (i11 < this.m_numElements) {
                this.m_geom.getElementNormal(elementIndex[i11]).add(normal[i11]);
                ++i11;
            }
        }
        int noVF = geomCode.getNumStoredVectorFields();
        int i12 = 0;
        while (i12 < noVF) {
            PdVector[] vecs = PuCompress.PdVectorDecode(geomCode.getVectorFieldCode(i12));
            PgVectorField vf = this.m_geom.getVectorField(i12);
            vf.setVectors(vecs);
            ++i12;
        }
        double factor = geomCode.getResizeFactor();
        if (factor != 1.0 && factor != 0.0) {
            PdVector[] vertex = this.m_geom.getVertices();
            int i13 = 0;
            while (i13 < this.m_numVertices) {
                vertex[i13].multScalar(1.0 / factor);
                ++i13;
            }
        }
    }

    private void initDecompression() {
        this.m_parentVertex = new int[this.m_numVertices];
        this.m_boxSize = PdVector.subNew((PdVector)this.m_bndBox[1], (PdVector)this.m_bndBox[0]);
        this.m_discreteVertex = PiVector.realloc(null, (int)this.m_numVertices, (int)this.m_dim);
        this.m_front = new PuFrontVertex[this.m_numVertices];
        this.m_queueFront = new PuFrontVertex[2 * this.m_numVertices];
        this.m_maxNumSplits = this.m_splitSymbols.length;
        this.m_maxNumVertices = this.m_numVertices + this.m_maxNumSplits;
        this.m_numSplits = 0;
        this.m_queue = new PuPriorityQueue(this.m_maxNumVertices);
        this.m_vvCounter = new int[this.m_numVertexContexts];
        this.m_fdCounter = 0;
        this.m_vdCounter = 0;
        if (this.m_dim != 3) {
            this.m_position.setSize(this.m_dim);
            this.m_vector1.setSize(this.m_dim);
            this.m_vector2.setSize(this.m_dim);
            this.m_prediction.setSize(this.m_dim);
            this.m_data.setSize(this.m_dim);
            this.m_diff.setSize(this.m_dim);
        }
    }

    private void decInitComponent() {
        if (this.m_fdCounter >= this.m_numElements) {
            return;
        }
        int elSize = this.getFaceDegree();
        PiVector el = new PiVector(elSize);
        int newVertex = this.m_vdCounter;
        int i = 0;
        while (i < elSize) {
            el.m_data[i] = newVertex + i;
            this.m_front[newVertex + i] = new PuFrontVertex(newVertex + i);
            this.m_front[newVertex + i].m_incidentFaceIndex = this.m_fdCounter - 1;
            this.m_queueFront[newVertex + i] = this.m_front[newVertex + i];
            this.m_queueFront[newVertex + i].m_queueIndex = newVertex + i;
            this.decodeGeometry(-1, -1, newVertex + i, true);
            this.m_parentVertex[el.m_data[i]] = i == 0 ? -1 : el.m_data[0];
            ++i;
        }
        this.m_geom.setElement(this.m_fdCounter - 1, el);
        i = 0;
        while (i < elSize) {
            this.m_front[newVertex + i].setLinked(this.m_front[newVertex + (i + 1) % elSize]);
            this.m_front[newVertex + i].setAngle(this.discreteAngle(newVertex + i, newVertex + (i + elSize - 1) % elSize, newVertex + (i + 1) % elSize));
            this.m_front[newVertex + i].computeKey();
            this.enqueue(this.m_front[newVertex + i]);
            ++i;
        }
    }

    private void decProcessFocus(PuFrontVertex focus) {
        int context = this.context(focus);
        int code = this.getVertexCode(context);
        if (code == -1) {
            if (focus.m_next.m_key > focus.m_previous.m_key) {
                this.decCloseFocus(focus.m_next);
            } else {
                this.decCloseFocus(focus.m_previous);
            }
            this.enqueue(focus);
        } else if (code == -2) {
            if (focus.m_next.m_key > focus.m_previous.m_key) {
                this.decCloseFocus(focus.m_previous);
            } else {
                this.decCloseFocus(focus.m_next);
            }
            this.enqueue(focus);
        } else if (code == -3) {
            code = this.getVertexCode(context);
            if (focus.m_bIsBoundary) {
                int i = 0;
                while (i < code) {
                    this.decAddNewFace(false, false, true, focus.m_previous, false);
                    ++i;
                }
                this.decAddNewFace(false, true, true, focus.m_previous, false);
            } else {
                int i = 0;
                while (i < code) {
                    this.decAddNewFace(false, false, true, focus, false);
                    ++i;
                }
                this.decAddNewFace(false, true, true, focus, false);
            }
            this.enqueue(focus);
        } else if (code == -5) {
            code = this.getVertexCode(context);
            if (focus.m_bIsBoundary) {
                int i = 0;
                while (i < code) {
                    this.decAddNewFace(false, false, true, focus.m_previous, false);
                    ++i;
                }
                this.decAddNewFace(false, true, false, focus.m_previous, false);
            } else {
                int i = 0;
                while (i < code) {
                    this.decAddNewFace(false, false, true, focus, false);
                    ++i;
                }
                this.decAddNewFace(false, true, false, focus, false);
            }
            this.enqueue(focus);
        } else if (code == -4) {
            focus.m_key += 180;
            context = this.context(focus);
            focus.m_key -= 180;
            code = this.getVertexCode(context);
            int i = 0;
            while (i < code) {
                this.decAddNewFace(false, false, true, focus, false);
                ++i;
            }
            focus.m_bIsBoundary = true;
            this.enqueue(focus);
            this.increaseProcessedAngle(focus, 180);
            this.updateKey(focus);
            this.increaseProcessedAngle(focus.m_next, 180);
            this.updateKey(focus.m_next);
        } else if (focus.m_bIsBoundary) {
            int i = 0;
            while (i < code) {
                this.decAddNewFace(false, false, true, focus.m_previous, false);
                ++i;
            }
            this.decCloseBoundaryFocus(focus);
        } else {
            int i = 0;
            while (i < code - 1) {
                this.decAddNewFace(false, false, true, focus, false);
                ++i;
            }
            if (focus.m_previous.m_bIsBoundary) {
                if (code != 0) {
                    this.decAddNewFace(false, false, true, focus, false);
                }
                this.decCloseBoundaryFocus(focus);
            } else {
                if (code != 0) {
                    this.decAddNewFace(false, false, true, focus, true);
                }
                this.decCloseFocus(focus);
                this.m_queueFront[focus.m_queueIndex] = null;
            }
        }
    }

    private void decAddNewFace(boolean bClose, boolean bSplit, boolean bSplitIsOriented, PuFrontVertex focus, boolean bNewPrediction) {
        int focusLocInd;
        int i;
        int close;
        int faceSize = this.getFaceDegree();
        boolean bFaceReady = true;
        if (faceSize < 0) {
            if (faceSize < -3 && bClose) {
                bSplit = true;
            }
            faceSize *= -1;
            bFaceReady = false;
        }
        if (faceSize != 3) {
            bNewPrediction = false;
        }
        int newVertex = this.m_vdCounter;
        PuFrontVertex splitVertex = null;
        if (bSplit) {
            splitVertex = bClose ? this.getVertexFromDistanceQueue(focus.m_previous, this.m_splitSymbols[this.m_numSplits]) : this.getVertexFromDistanceQueue(focus, this.m_splitSymbols[this.m_numSplits]);
        }
        PiVector face = new PiVector(faceSize);
        int pFaceInd = focus.m_incidentFaceIndex;
        int split = bSplit ? 1 : 0;
        int n = close = bClose ? 1 : 0;
        if (bClose) {
            face.setEntry(0, focus.m_index);
            face.setEntry(1, focus.m_previous.m_index);
            face.setEntry(faceSize - 1, focus.m_next.m_index);
        } else {
            face.setEntry(0, focus.m_next.m_index);
            face.setEntry(1, focus.m_index);
        }
        int i2 = 0;
        while (i2 < faceSize - 2 - close - split) {
            face.setEntry(faceSize - 1 - close - i2, newVertex + i2);
            ++i2;
        }
        if (bSplit) {
            face.setEntry(2, splitVertex.m_index);
        }
        PiVector pFace = this.m_geom.getElement(pFaceInd);
        int pLocalInd = pFace.getIndexOf(focus.m_index);
        int pFaceSize = pFace.getSize();
        boolean bPOriented = true;
        if (pFace.m_data[(pLocalInd + 1) % pFaceSize] != focus.m_next.m_index) {
            bPOriented = false;
        }
        if (bNewPrediction) {
            i = 0;
            while (i < faceSize - 2 - close - split) {
                this.decodeGeometryFreeLencePrediction(pFaceInd, focus, newVertex + i);
                ++i;
            }
        } else {
            i = 0;
            while (i < faceSize - 2 - close - split) {
                this.decodeGeometry(pFaceInd, focus.m_index, newVertex + i, bPOriented);
                ++i;
            }
        }
        if (this.m_fdCounter > this.m_numElements) {
            this.m_geom.setNumElements(this.m_fdCounter);
        }
        this.m_geom.setElement(this.m_fdCounter - 1, face);
        if (!bFaceReady) {
            this.m_geom.setTagElement(this.m_fdCounter - 1, 1);
        }
        this.setNeighbour(pFaceInd, this.m_fdCounter - 1, focus.m_index, focus.m_next.m_index);
        focus.m_incidentFaceIndex = this.m_fdCounter - 1;
        PuFrontVertex previous = focus.m_previous;
        int numNew = faceSize - 2;
        if (bClose) {
            this.setNeighbour(previous.m_incidentFaceIndex, this.m_fdCounter - 1, previous.m_index, focus.m_index);
            previous.m_incidentFaceIndex = this.m_fdCounter - 1;
            --numNew;
        }
        PuFrontVertex newSplit = null;
        int i3 = 0;
        while (i3 < numNew) {
            if (!bSplit || i3 < numNew - 1) {
                this.m_front[newVertex] = bClose ? previous.insertNewVertex(newVertex) : focus.insertNewVertex(newVertex);
                this.m_queueFront[newVertex] = this.m_front[newVertex];
                this.m_queueFront[newVertex].m_queueIndex = newVertex;
                this.m_front[newVertex].m_incidentFaceIndex = this.m_fdCounter - 1;
                ++newVertex;
            } else {
                int newIndex = this.m_numVertices + this.m_numSplits;
                newSplit = bClose ? previous.insertSplitVertex(splitVertex) : focus.insertSplitVertex(splitVertex);
                ++this.m_numSplits;
                this.m_queueFront[newIndex] = newSplit;
                newSplit.m_queueIndex = newIndex;
                newSplit.m_incidentFaceIndex = splitVertex.m_incidentFaceIndex;
                splitVertex.m_incidentFaceIndex = this.m_fdCounter - 1;
                if (splitVertex.m_bIsBoundary) {
                    newSplit.m_bIsBoundary = true;
                }
                splitVertex.m_bIsBoundary = false;
                if (!bSplitIsOriented) {
                    splitVertex.flipFront(newSplit);
                }
            }
            ++i3;
        }
        int n2 = focusLocInd = bClose ? 0 : 1;
        if (bSplit) {
            --numNew;
        }
        int i4 = 0;
        while (i4 < faceSize) {
            this.increaseProcessedAngle(this.m_front[face.m_data[(focusLocInd + i4) % faceSize]], this.discreteAngle(face.m_data[(focusLocInd + i4) % faceSize], face.m_data[(focusLocInd + i4 + faceSize - 1) % faceSize], face.m_data[(focusLocInd + i4 + 1) % faceSize]));
            ++i4;
        }
        i4 = 0;
        while (i4 < numNew) {
            this.enqueue(this.m_front[face.m_data[(focusLocInd + faceSize - 2 - i4) % faceSize]]);
            ++i4;
        }
        if (newSplit != null) {
            this.enqueue(newSplit);
        }
        i4 = 0;
        while (i4 < faceSize) {
            this.updateKey(this.m_front[face.m_data[(i4 + focusLocInd) % faceSize]]);
            ++i4;
        }
    }

    private void decCloseFocus(PuFrontVertex focus) {
        PuFrontVertex next = focus.m_next;
        PuFrontVertex prev = focus.m_previous;
        this.decAddNewFace(true, false, true, focus, true);
        focus.removeFromFront();
        if (this.m_front[focus.m_index] == focus) {
            this.m_front[focus.m_index] = focus.m_split;
        }
        focus.removeFromFrontLinks();
        if (next.m_next == prev) {
            if (this.m_front[prev.m_index] == prev) {
                this.m_front[prev.m_index] = prev.m_split;
            }
            if (this.m_front[next.m_index] == next) {
                this.m_front[next.m_index] = next.m_split;
            }
            prev.m_frontAngle = 0;
            next.m_frontAngle = 0;
            next.deleteList();
            this.setNeighbour(prev.m_incidentFaceIndex, next.m_incidentFaceIndex, prev.m_index, next.m_index);
        }
    }

    private void decCloseBoundaryFocus(PuFrontVertex focus) {
        PuFrontVertex prev = focus.m_previous;
        prev.m_bIsBoundary = true;
        if (!focus.m_bIsBoundary) {
            focus.m_bIsBoundary = true;
            this.increaseProcessedAngle(focus.m_next, 180);
            this.updateKey(focus.m_next);
        }
        if (this.m_front[focus.m_index] == focus) {
            this.m_front[focus.m_index] = focus.m_split;
        }
        focus.removeFromFrontLinks();
    }

    private void joinFace(int faceInd, int locInd) {
        PiVector face = this.m_geom.getElement(faceInd);
        PiVector neigh = this.m_geom.getNeighbour(faceInd);
        int faceSize = face.getSize();
        int neighInd = neigh.m_data[locInd];
        PiVector nFace = this.m_geom.getElement(neighInd);
        PiVector nNeigh = this.m_geom.getNeighbour(neighInd);
        int nFaceSize = nFace.getSize();
        int nLocInd = nFace.getIndexOf(face.m_data[(locInd + 1) % faceSize]);
        if (nFace.m_data[(nLocInd + nFaceSize - 1) % nFaceSize] != face.m_data[(locInd + 2) % faceSize]) {
            PiVector newNFace = new PiVector(nFaceSize);
            PiVector newNNeigh = new PiVector(nFaceSize);
            int i = 0;
            while (i < nFaceSize) {
                newNFace.m_data[(nLocInd + i) % nFaceSize] = nFace.m_data[(nLocInd + nFaceSize - i) % nFaceSize];
                newNNeigh.m_data[(nLocInd + i) % nFaceSize] = nNeigh.m_data[(nLocInd + nFaceSize * 2 - 3 - i) % nFaceSize];
                ++i;
            }
            nFace.copy(newNFace);
            nNeigh.copy(newNNeigh);
        }
        int newFaceSize = faceSize + nFaceSize - 2;
        PiVector newFace = new PiVector(newFaceSize);
        PiVector newNeigh = new PiVector(newFaceSize);
        int i = 0;
        while (i < nFaceSize - 1) {
            newFace.m_data[i + 1] = nFace.m_data[(nLocInd + i) % nFaceSize];
            newNeigh.m_data[i] = nNeigh.m_data[(nLocInd + nFaceSize + i - 1) % nFaceSize];
            if (newNeigh.m_data[i] != -1) {
                int oppInd = this.m_geom.getOppVertexLocInd(neighInd, (nLocInd + nFaceSize + i - 1) % nFaceSize);
                this.m_geom.getNeighbour(newNeigh.m_data[i]).setEntry(oppInd, faceInd);
            }
            ++i;
        }
        i = 0;
        while (i < faceSize - 1) {
            newFace.m_data[(nFaceSize + i) % newFaceSize] = face.m_data[(locInd + 2 + i) % faceSize];
            newNeigh.m_data[nFaceSize + i - 1] = neigh.m_data[(locInd + 1 + i) % faceSize];
            ++i;
        }
        this.m_geom.setElement(faceInd, newFace);
        this.m_geom.getNeighbour(faceInd).copy(newNeigh);
        this.m_geom.setTagElement(neighInd, 2);
    }

    private void decodeGeometryFreeLencePrediction(int pFaceInd, PuFrontVertex focus, int newVertex) {
        if (focus == null) {
            PsDebug.message((String)"Focus argument is null!");
            return;
        }
        this.m_parentVertex[newVertex] = focus.m_index;
        int prev = focus.m_previous.m_index;
        int next = focus.m_next.m_index;
        PiVector diff = this.freeLencePrediction(pFaceInd, focus, prev, next);
        PiVector data = this.getVertexData();
        this.m_discreteVertex[newVertex].sub(diff, data);
    }

    protected PiVector freeLencePrediction(int pFaceInd, PuFrontVertex focus, int prev, int next) {
        PiVector pFace = this.m_geom.getElement(pFaceInd);
        PiVector ppFace = this.m_geom.getElement(focus.m_previous.m_incidentFaceIndex);
        if (m_FreelenceFaces.getIndexOf(pFace.getSize() + ppFace.getSize()) != -1) {
            this.m_diff.blend(2, this.m_discreteVertex[prev], 2, this.m_discreteVertex[next]);
            this.m_diff.add(this.m_discreteVertex[focus.m_index]);
            int i = 0;
            while (i < 3) {
                if (pFace.m_data[i] != focus.m_index && pFace.m_data[i] != next) {
                    this.m_diff.sub(this.m_discreteVertex[pFace.m_data[i]]);
                }
                ++i;
            }
            i = 0;
            while (i < 3) {
                if (ppFace.m_data[i] != focus.m_index && ppFace.m_data[i] != prev) {
                    this.m_diff.sub(this.m_discreteVertex[ppFace.m_data[i]]);
                }
                ++i;
            }
            i = 0;
            while (i < this.m_dim) {
                this.m_diff.m_data[i] = (this.m_diff.m_data[i] + 1) / 3;
                ++i;
            }
        } else {
            this.m_diff.add(this.m_discreteVertex[prev], this.m_discreteVertex[next]);
            this.m_diff.sub(this.m_discreteVertex[focus.m_index]);
        }
        return this.m_diff;
    }

    private void decodeGeometry(int pFaceInd, int focus, int newVertex, boolean bOriented) {
        if (focus != -1) {
            this.m_parentVertex[newVertex] = focus;
        }
        if (pFaceInd < 0) {
            this.m_discreteVertex[newVertex].copy(this.getVertexData());
            return;
        }
        PiVector pFace = this.m_geom.getElement(pFaceInd);
        int pFaceSize = pFace.getSize();
        if (pFaceSize == 3 && this.m_fdCounter > 1) {
            this.m_prediction = this.predictVertexPosition(pFace, focus, bOriented);
            PiVector data = this.getVertexData();
            this.m_discreteVertex[newVertex].sub(this.m_prediction, data);
        } else {
            this.m_discreteVertex[newVertex].copy(this.getVertexData());
        }
    }

    protected PiVector predictVertexPosition(PiVector face, int focus, boolean bOriented) {
        int focusLocalInd = face.getIndexOf(focus);
        if (bOriented) {
            this.m_prediction.add(this.m_discreteVertex[face.m_data[focusLocalInd]], this.m_discreteVertex[face.m_data[(focusLocalInd + 1) % 3]]);
            this.m_prediction.sub(this.m_discreteVertex[face.m_data[(focusLocalInd + 2) % 3]]);
        } else {
            this.m_prediction.sub(this.m_discreteVertex[face.m_data[focusLocalInd]], this.m_discreteVertex[face.m_data[(focusLocalInd + 1) % 3]]);
            this.m_prediction.add(this.m_discreteVertex[face.m_data[(focusLocalInd + 2) % 3]]);
        }
        return this.m_prediction;
    }

    private PiVector getVertexData() {
        int i = 0;
        while (i < this.m_dim) {
            this.m_data.m_data[i] = this.m_vertexData[this.m_dim * this.m_vdCounter + i];
            ++i;
        }
        ++this.m_vdCounter;
        return this.m_data;
    }

    protected PdVector computeVertexPosition(PiVector vec) {
        int i = 0;
        while (i < this.m_dim) {
            this.m_position.m_data[i] = this.m_bndBox[0].m_data[i] + (double)vec.m_data[i] * this.m_boxSize.m_data[i] / (double)this.m_axisResolution.m_data[i];
            ++i;
        }
        return this.m_position;
    }

    protected PdVector computeVertexPosition(PiVector vec, long[] error, int extraBits) {
        int i = 0;
        while (i < this.m_dim) {
            double doubleError = (double)(error[i] >>> 2) / 4.611686018427388E18;
            double hiResGridPosition = (double)vec.m_data[i] + doubleError;
            this.m_position.m_data[i] = this.m_bndBox[0].m_data[i] + hiResGridPosition * this.m_boxSize.m_data[i] / (double)this.m_axisResolution.m_data[i];
            ++i;
        }
        return this.m_position;
    }

    private int getFaceDegree() {
        int fd;
        if ((fd = this.m_elementSymbols[this.m_fdCounter++]) >= 0) {
            fd += 3;
        }
        if (fd < 0) {
            fd -= 2;
        }
        return fd;
    }

    protected int discreteAngle(int v1, int v2, int v3) {
        int i;
        this.m_vector1.sub(this.m_discreteVertex[v2], this.m_discreteVertex[v1]);
        this.m_vector2.sub(this.m_discreteVertex[v3], this.m_discreteVertex[v1]);
        while (this.m_vector1.maxAbs() > 1024.0) {
            i = 0;
            while (i < this.m_dim) {
                int n = i++;
                this.m_vector1.m_data[n] = this.m_vector1.m_data[n] / 2;
            }
        }
        while (this.m_vector2.maxAbs() > 1024.0) {
            i = 0;
            while (i < this.m_dim) {
                int n = i++;
                this.m_vector2.m_data[n] = this.m_vector2.m_data[n] / 2;
            }
        }
        long dot = PiVector.dot((PiVector)this.m_vector1, (PiVector)this.m_vector2);
        if (dot == 0L) {
            return 90;
        }
        long sqr1 = this.m_vector1.sqrLength();
        long sqr2 = this.m_vector2.sqrLength();
        int arg = (int)(dot * dot * 10000L / (sqr1 * sqr2));
        int angle = 0;
        int i2 = 64;
        while (i2 > 0) {
            if (angle - 1 + i2 <= 90 && m_sqrCos[angle - 1 + i2] >= arg) {
                angle += i2;
            }
            i2 >>= 1;
        }
        if (dot < 0L) {
            angle = 180 - angle;
        }
        return angle;
    }

    protected void enqueue(PuFrontVertex v) {
        this.m_queue.enqueue(v.m_queueIndex, (double)v.getAngle());
    }

    private int context(PuFrontVertex v) {
        if (this.m_numVertexContexts == 1) {
            return 0;
        }
        int angle = v.m_key;
        if (this.m_contextThreshold[0] > angle) {
            return 0;
        }
        int context = this.m_numVertexContexts - 1;
        while (this.m_contextThreshold[context - 1] > angle) {
            --context;
        }
        return context;
    }

    private int getVertexCode(int context) {
        int n = context;
        this.m_vvCounter[n] = this.m_vvCounter[n] + 1;
        return this.m_vertexSymbols[context][this.m_vvCounter[context] - 1];
    }

    protected void updateKey(PuFrontVertex v) {
        int key = v.getAngle();
        if ((double)key < this.m_queue.getKey(v.m_queueIndex)) {
            this.m_queue.decreaseKey(v.m_queueIndex, (double)key);
        }
        if (v.m_split != null) {
            PuFrontVertex s = v.m_split;
            while (s != v) {
                key = s.getAngle();
                if ((double)key < this.m_queue.getKey(s.m_queueIndex)) {
                    this.m_queue.decreaseKey(s.m_queueIndex, (double)key);
                }
                s = s.m_split;
            }
        }
    }

    protected void increaseProcessedAngle(PuFrontVertex vertex, int angle) {
        vertex.setAngle(vertex.m_angle + angle);
        if (vertex.m_split != null) {
            this.computeSplitAngle(vertex);
            PuFrontVertex s = vertex.m_split;
            while (s != vertex) {
                this.computeSplitAngle(s);
                s = s.m_split;
            }
        }
        vertex.computeKey();
    }

    private PuFrontVertex getVertexFromDistanceQueue(PuFrontVertex v1, int position) {
        int index = 0;
        int nv = this.m_queue.getHeapSize();
        int[] vertexIndex = this.m_queue.getElements();
        PuPriorityQueue queue = new PuPriorityQueue(this.m_maxNumVertices);
        int i = 0;
        while (i < nv) {
            int sqrDist = this.m_discreteVertex[this.m_queueFront[vertexIndex[i]].m_index].sqrDist(this.m_discreteVertex[v1.m_index]);
            queue.enqueue(vertexIndex[i], (double)sqrDist);
            ++i;
        }
        i = 0;
        while (i <= position) {
            index = queue.extractMin();
            ++i;
        }
        return this.m_queueFront[index];
    }

    private void setNeighbour(int oldFaceInd, int newFaceInd, int vertex1, int vertex2) {
        PiVector face = this.m_geom.getElement(oldFaceInd);
        int locInd = face.getIndexOf(vertex1);
        int size = face.getSize();
        PiVector[] neighbour = this.m_geom.getNeighbours();
        if (neighbour[oldFaceInd] == null) {
            neighbour[oldFaceInd] = new PiVector(size);
            neighbour[oldFaceInd].setConstant(-1);
        } else if (neighbour[oldFaceInd].getSize() != size) {
            neighbour[oldFaceInd].setSize(size);
            neighbour[oldFaceInd].setConstant(-1);
        }
        if (oldFaceInd == newFaceInd) {
            return;
        }
        if (face.m_data[(locInd + 1) % size] == vertex2) {
            neighbour[oldFaceInd].setEntry((locInd - 1 + size) % size, newFaceInd);
        } else {
            neighbour[oldFaceInd].setEntry((locInd - 2 + size) % size, newFaceInd);
        }
        face = this.m_geom.getElement(newFaceInd);
        locInd = face.getIndexOf(vertex2);
        size = face.getSize();
        if (neighbour[newFaceInd] == null) {
            neighbour[newFaceInd] = new PiVector(size);
            neighbour[newFaceInd].setConstant(-1);
        } else if (neighbour[newFaceInd].getSize() != size) {
            neighbour[newFaceInd].setSize(size);
            neighbour[newFaceInd].setConstant(-1);
        }
        if (face.m_data[(locInd + 1) % size] == vertex1) {
            neighbour[newFaceInd].setEntry((locInd - 1 + size) % size, oldFaceInd);
        } else {
            neighbour[newFaceInd].setEntry((locInd - 2 + size) % size, oldFaceInd);
        }
    }

    private void computeSplitAngle(PuFrontVertex vertex) {
        PuFrontVertex pv = vertex.m_previous;
        PuFrontVertex nv = vertex.m_next;
        if (pv == null || nv == null || vertex.m_bIsBoundary) {
            return;
        }
        vertex.m_frontAngle = this.discreteAngle(vertex.m_index, pv.m_index, nv.m_index);
    }

    private int[] decMakeElementParentVector() {
        PiVector neigh = new PiVector();
        int[] parent = new int[this.m_numElements];
        parent[0] = -1;
        int i = 1;
        while (i < this.m_numElements) {
            neigh.setSize(this.m_geom.getNeighbour(i).getSize());
            neigh.copy(this.m_geom.getNeighbour(i));
            neigh.changeValue(-1, Integer.MAX_VALUE);
            parent[i] = neigh.min();
            if (parent[i] > i) {
                parent[i] = -1;
            }
            ++i;
        }
        return parent;
    }
}

