/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

public final class PuFrontVertex {
    protected PuFrontVertex m_previous;
    protected PuFrontVertex m_next;
    protected PuFrontVertex m_split;
    protected int m_index;
    protected int m_angle;
    protected int m_frontAngle;
    protected int m_key;
    protected int m_freeEdges;
    protected int m_incidentFaceIndex;
    protected boolean m_bIsBoundary;
    protected int m_queueIndex;

    public PuFrontVertex(int index) {
        this.m_index = index;
        this.m_freeEdges = 0;
        this.m_frontAngle = 0;
        this.m_split = null;
        this.m_bIsBoundary = false;
        this.m_key = 0;
    }

    protected void setAngle(int angle) {
        this.m_angle = angle;
        PuFrontVertex s = this.m_split;
        while (s != null && s != this) {
            s.m_angle = angle;
            s = s.m_split;
        }
    }

    public int getAngle() {
        return -this.m_key;
    }

    protected void setLinked(PuFrontVertex v) {
        this.m_next = v;
        v.m_previous = this;
    }

    protected void computeKey() {
        int sum = this.m_angle;
        sum += this.m_frontAngle;
        PuFrontVertex s = this.m_split;
        while (s != null && s != this) {
            sum += s.m_frontAngle;
            s = s.m_split;
        }
        s = this.m_split;
        if (this.m_key != -1) {
            this.m_key = sum - this.m_frontAngle;
        }
        while (s != null && s != this) {
            if (s.m_key != -1) {
                s.m_key = sum - s.m_frontAngle;
            }
            s = s.m_split;
        }
    }

    protected PuFrontVertex insertNewVertex(int newVertex) {
        PuFrontVertex newFrontVertex = new PuFrontVertex(newVertex);
        newFrontVertex.setLinked(this.m_next);
        this.setLinked(newFrontVertex);
        return newFrontVertex;
    }

    protected PuFrontVertex insertSplitVertex(PuFrontVertex newVertex) {
        PuFrontVertex oldSucc = this.m_next;
        PuFrontVertex newInstance = newVertex.split();
        this.setLinked(newInstance);
        newInstance.setLinked(newVertex.m_next);
        newVertex.setLinked(oldSucc);
        return newInstance;
    }

    private PuFrontVertex split() {
        PuFrontVertex newFrontVertex = new PuFrontVertex(this.m_index);
        newFrontVertex.m_freeEdges = this.m_freeEdges;
        newFrontVertex.m_angle = this.m_angle;
        newFrontVertex.m_split = this.m_split == null ? this : this.m_split;
        this.m_split = newFrontVertex;
        return newFrontVertex;
    }

    protected void removeFromFront() {
        this.m_previous.setLinked(this.m_next);
        this.m_previous = null;
        this.m_next = null;
    }

    protected void deleteList() {
        PuFrontVertex vertex = this;
        while (vertex.m_next != null) {
            PuFrontVertex next = vertex.m_next;
            vertex.m_next = null;
            vertex.m_previous = null;
            vertex = next;
        }
    }

    protected void removeFromFrontLinks() {
        if (this.m_split != null) {
            PuFrontVertex s = this.m_split;
            if (s.m_split == this) {
                s.m_split = null;
            } else {
                PuFrontVertex s2 = s.m_split;
                while (s2.m_split != this) {
                    s2 = s2.m_split;
                }
                s2.m_split = s;
            }
        }
        this.m_split = null;
    }

    public void flipFront(PuFrontVertex newSplit) {
        PuFrontVertex v = this.m_previous;
        PuFrontVertex oldV = newSplit;
        int incident = v.m_incidentFaceIndex;
        boolean bBoundary = v.m_bIsBoundary;
        while (v != newSplit && v != this) {
            v.m_incidentFaceIndex = v.m_previous.m_incidentFaceIndex;
            v.m_bIsBoundary = v.m_previous.m_bIsBoundary;
            v.m_next = v.m_previous;
            v.m_previous = oldV;
            oldV = v;
            v = v.m_next;
        }
        v = newSplit.m_next;
        newSplit.m_next = this.m_previous;
        if (oldV == this.m_next) {
            this.m_incidentFaceIndex = newSplit.m_incidentFaceIndex;
            this.m_bIsBoundary = newSplit.m_bIsBoundary;
            this.m_previous = oldV;
            oldV.m_next = this;
            this.m_next = v;
            v.m_previous = this;
        } else {
            this.m_previous = v;
            v.m_next = this;
        }
        newSplit.m_incidentFaceIndex = incident;
        newSplit.m_bIsBoundary = bBoundary;
    }
}

