/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

public final class PuCumulatedTree {
    private int[] m_data;
    private int m_size;
    private int m_depth;

    public PuCumulatedTree(int aSize) {
        if (aSize < 0) {
            return;
        }
        this.m_depth = this.m_size = aSize;
        if (this.m_depth > 2) {
            int i = 1;
            while (i < 32) {
                if (this.m_size - 1 >> i - 1 != 0) {
                    this.m_depth = i;
                }
                ++i;
            }
        }
        this.m_data = new int[this.m_size];
    }

    public void setConstant(int value) {
        int i = 0;
        while (i < this.m_size) {
            this.m_data[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.m_size) {
            this.changeValue(i, value);
            ++i;
        }
    }

    public void changeValue(int index, int value) {
        if (index < 0 || index >= this.m_size) {
            return;
        }
        this.m_data[0] = this.m_data[0] + value;
        int i = 0;
        while (i < this.m_depth) {
            if ((index & 1 << i) != 0) {
                int n = index;
                this.m_data[n] = this.m_data[n] + value;
                index ^= 1 << i;
            }
            ++i;
        }
    }

    public int getIndex(int aValue) {
        if (aValue > this.m_data[0]) {
            return this.m_size;
        }
        int right = 0;
        int mask = 1 << this.m_depth - 1;
        int index = 0;
        while (mask != 0) {
            right = (index | mask) < this.m_size ? this.m_data[index | mask] : 0;
            if (aValue > this.m_data[0] - right) {
                index |= mask;
            } else {
                aValue += right;
            }
            mask >>>= 1;
        }
        return index;
    }

    public int getValue(int index) {
        if (index < 0 || index >= this.m_size) {
            return 0;
        }
        int value = this.m_data[index];
        int i = 0;
        while (i < this.m_depth) {
            if ((index & 1 << i) == 0) {
                if (index + (1 << i) < this.m_size) {
                    value -= this.m_data[index + (1 << i)];
                }
            } else {
                return value;
            }
            ++i;
        }
        return value;
    }

    public int getTotalSum() {
        return this.m_data[0];
    }

    public int getCumulatedValue(int index) {
        if (index < 0) {
            return 0;
        }
        if (index >= this.m_size) {
            return this.m_data[0];
        }
        int value = this.m_data[0];
        int i = 0;
        while (i < this.m_depth) {
            if ((index & 1 << i) == 0) {
                if (index + (1 << i) < this.m_size) {
                    value -= this.m_data[index + (1 << i)];
                }
            } else {
                index ^= 1 << i;
            }
            ++i;
        }
        return value;
    }
}

