/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import devCompress.PuArithmeticCoder;
import java.awt.Color;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PuCompress {
    private PuCompress() {
    }

    public static byte[] encode(int[][] message, int[] length) {
        if (message == null) {
            return null;
        }
        byte[][] stream = new byte[message.length][];
        int outputLength = 0;
        int i = 0;
        while (i < message.length) {
            stream[i] = PuCompress.encode(message[i], length[i]);
            if (stream[i] == null) {
                return null;
            }
            outputLength += stream[i].length;
            ++i;
        }
        byte[] shortStream = new byte[outputLength];
        int position = 0;
        int i2 = 0;
        while (i2 < message.length) {
            System.arraycopy(stream[i2], 0, shortStream, position, stream[i2].length);
            position += stream[i2].length;
            ++i2;
        }
        return shortStream;
    }

    public static byte[] encode(boolean[][] message, int[] length) {
        if (message == null) {
            return null;
        }
        byte[][] stream = new byte[message.length][];
        int outputLength = 0;
        int i = 0;
        while (i < message.length) {
            stream[i] = PuCompress.encode(message[i], length[i]);
            if (stream[i] == null) {
                return null;
            }
            outputLength += stream[i].length;
            ++i;
        }
        byte[] shortStream = new byte[outputLength];
        int position = 0;
        int i2 = 0;
        while (i2 < message.length) {
            System.arraycopy(stream[i2], 0, shortStream, position, stream[i2].length);
            position += stream[i2].length;
            ++i2;
        }
        return shortStream;
    }

    public static byte[] encodeCompact(boolean[][] message, int[] length, PiVector usedBits) {
        if (message == null) {
            return null;
        }
        byte[][] stream = new byte[message.length][];
        int[] bitLength = new int[message.length];
        int i = 0;
        while (i < message.length) {
            int[] msg = PuCompress.booleansToInts(message[i], length[i]);
            PuArithmeticCoder ac = new PuArithmeticCoder();
            stream[i] = ac.encode(msg, length[i], false, 0, 1);
            bitLength[i] = ac.getNumUsedBits();
            if (stream[i] == null) {
                return null;
            }
            ++i;
        }
        byte[] shortStream = PuCompress.concatenateBytes(stream, bitLength);
        if (usedBits != null) {
            usedBits.setSize(bitLength.length);
            usedBits.set(bitLength);
        }
        return shortStream;
    }

    private static byte[] concatenateBytes(byte[][] stream, int[] bitLength) {
        int numBits = 0;
        int i = 0;
        while (i < stream.length) {
            numBits += bitLength[i];
            ++i;
        }
        byte[] shortStream = new byte[(numBits - 1) / 8 + 1];
        int outBit = 0;
        int i2 = 0;
        while (i2 < stream.length) {
            int bit = 0;
            while (bit < bitLength[i2]) {
                int readByte = bit / 8;
                int readBit = 7 - bit % 8;
                int writeByte = outBit / 8;
                int writeBit = 7 - outBit % 8;
                int n = writeByte;
                shortStream[n] = (byte)(shortStream[n] | (1 & stream[i2][readByte] >> readBit) << writeBit);
                ++outBit;
                ++bit;
            }
            ++i2;
        }
        return shortStream;
    }

    public static byte[] encode(long[][] message) {
        if (message == null) {
            return null;
        }
        if (message[0] == null) {
            PsDebug.warning((String)"Message array contains null entries.");
            return null;
        }
        int dim = message[0].length;
        int len = message.length;
        int i = 0;
        while (i < len) {
            if (message[i] == null || dim != message[i].length) {
                PsDebug.warning((String)"Message array contains null entries or has different lengths.");
                return null;
            }
            ++i;
        }
        int[][] intArray = new int[8 * dim][message.length];
        int i2 = 0;
        while (i2 < len) {
            int j = 0;
            while (j < dim) {
                int k = 0;
                while (k < 8) {
                    intArray[j * 8 + k][i2] = (int)(message[i2][j] >> (7 - k) * 8 & 0xFFL);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        int[] lengths = new int[dim * 8];
        int i3 = 0;
        while (i3 < dim * 8) {
            lengths[i3] = len;
            ++i3;
        }
        return PuCompress.encode(intArray, lengths);
    }

    public static boolean[][] decodeBooleanArray(byte[] code) {
        PuArithmeticCoder ac = new PuArithmeticCoder();
        int[][] intMessage = ac.decodeArray(code, true);
        if (intMessage == null) {
            return null;
        }
        boolean[][] boolMessage = new boolean[intMessage.length][];
        int i = 0;
        while (i < intMessage.length) {
            boolMessage[i] = PuCompress.intsToBooleans(intMessage[i]);
            ++i;
        }
        return boolMessage;
    }

    public static boolean[][] decodeCompactBooleanArray(byte[] code) {
        int i;
        PuArithmeticCoder ac = new PuArithmeticCoder();
        int count = 0;
        int[][] message = new int[20][];
        while (ac.getNumUsedBits() < 8 * code.length) {
            if (count == message.length) {
                int[][] m = new int[2 * count][];
                i = 0;
                while (i < count) {
                    m[i] = message[i];
                    ++i;
                }
                message = m;
            }
            message[count] = ac.decode(code, false, true, true, true);
            int usedBits = ac.getNumUsedBits() - 29;
            ac.m_streamBytes = usedBits / 8 + 1;
            ac.m_streamBitsLeft = 8 - usedBits % 8;
            ++count;
        }
        boolean[][] boolMessage = new boolean[count][];
        i = 0;
        while (i < count) {
            boolMessage[i] = message[i] == null ? new boolean[]{} : PuCompress.intsToBooleans(message[i]);
            ++i;
        }
        return boolMessage;
    }

    public static long[][] decodeLongArray(byte[] code) {
        int[][] intArray = PuCompress.decodeArray(code);
        if (intArray == null || intArray.length == 0 || intArray[0] == null) {
            return null;
        }
        int len = intArray[0].length;
        int dim = intArray.length / 8;
        long[][] message = new long[len][dim];
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < dim) {
                int k = 0;
                while (k < 8) {
                    long[] lArray = message[i];
                    int n = j;
                    lArray[n] = lArray[n] | (long)intArray[j * 8 + k][i] << (7 - k) * 8;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return message;
    }

    public static int[][] decodeArray(byte[] code) {
        PuArithmeticCoder ac = new PuArithmeticCoder();
        return ac.decodeArray(code, false);
    }

    public static byte[] encode(int[] message, int length) {
        return PuCompress.encode(message, length, false);
    }

    public static byte[] encodePermutation(int[] message, int length) {
        return PuCompress.encode(message, length, true);
    }

    private static byte[] encode(int[] message, int length, boolean permutation) {
        int min = 0;
        int max = 0;
        if (message == null) {
            return null;
        }
        if (length < 0) {
            length = message.length;
        } else if (length > message.length) {
            return null;
        }
        if (message.length > 0) {
            min = message[0];
            max = message[0];
            int i = 1;
            while (i < length) {
                if (message[i] < min) {
                    min = message[i];
                }
                if (message[i] > max) {
                    max = message[i];
                }
                ++i;
            }
        }
        PuArithmeticCoder ac = new PuArithmeticCoder();
        ac.encodeBounds(min, max -= min);
        return ac.encode(message, length, permutation, min, max);
    }

    public static byte[] encode(boolean[] message, int length) {
        if (message == null || length > message.length) {
            PsDebug.warning((String)"Input message is missing or has wrong size.");
        }
        int[] msg = PuCompress.booleansToInts(message, length);
        PuArithmeticCoder ac = new PuArithmeticCoder();
        return ac.encode(msg, length, false, 0, 1);
    }

    public static int[] decode(byte[] code) {
        PuArithmeticCoder ac = new PuArithmeticCoder();
        return ac.decode(code, false, false, false, false);
    }

    public static int[] decodePermutation(byte[] code) {
        PuArithmeticCoder ac = new PuArithmeticCoder();
        return ac.decode(code, true, false, false, false);
    }

    public static boolean[] decodeBoolean(byte[] code) {
        PuArithmeticCoder ac = new PuArithmeticCoder();
        int[] msg = ac.decode(code, false, false, true, false);
        boolean[] bools = PuCompress.intsToBooleans(msg);
        return bools;
    }

    private static int getExponent(double d) {
        return (int)(Double.doubleToLongBits(d) >> 52 & 0x7FFL);
    }

    public static int[] getBoxMaxExponent(PdVector[] box, int dim) {
        int[] me = new int[dim];
        if (box == null) {
            int i = 0;
            while (i < dim) {
                me[i] = 1023;
                ++i;
            }
        } else {
            int i = 0;
            while (i < dim) {
                me[i] = Math.max(PuCompress.getExponent(box[0].m_data[i]), PuCompress.getExponent(box[1].m_data[i]));
                ++i;
            }
        }
        return me;
    }

    public static byte[] PdVectorEncode(PdVector[] data, int resolution, boolean bEncodeIfZero) {
        return PuCompress.PdVectorEncode(data, null, resolution, bEncodeIfZero);
    }

    public static byte[] PdVectorEncode(PdVector[] data, PdVector[] bndBox, int resolution, boolean bEncodeIfZero) {
        if (data == null || data.length == 0) {
            return null;
        }
        int dim = data[0].getSize();
        int numEntries = data.length;
        int[] maxExponent = PuCompress.getBoxMaxExponent(bndBox, dim);
        int[][] intArray = new int[8 * dim][numEntries];
        int[] len = new int[8 * dim];
        boolean allZero = true;
        int i = 0;
        while (i < numEntries) {
            int j = 0;
            while (j < dim) {
                int cutBits;
                long longBits = Double.doubleToLongBits(data[i].m_data[j]);
                if (resolution != 0 && (cutBits = 52 - resolution + maxExponent[j] - PuCompress.getExponent(data[i].m_data[j]) - 1) >= 0) {
                    longBits = cutBits > 52 ? 0L : (longBits &= -1L << cutBits);
                }
                allZero &= longBits == 0L;
                intArray[0 + j * 8][i] = (int)(longBits >> 63) & 1;
                intArray[1 + j * 8][i] = (int)(longBits >> 52) & 0x7FF;
                intArray[2 + j * 8][i] = (int)(longBits >> 44) & 0xFF;
                intArray[3 + j * 8][i] = (int)(longBits >> 36) & 0xFF;
                intArray[4 + j * 8][i] = (int)(longBits >> 28) & 0xFF;
                intArray[5 + j * 8][i] = (int)(longBits >> 20) & 0xFF;
                intArray[6 + j * 8][i] = (int)(longBits >> 10) & 0x3FF;
                intArray[7 + j * 8][i] = (int)longBits & 0x3FF;
                if (intArray[1 + j * 8][i] < 1024) {
                    int[] nArray = intArray[1 + j * 8];
                    int n = i;
                    nArray[n] = nArray[n] - 1;
                }
                if (intArray[1 + j * 8][i] == -1) {
                    intArray[1 + j * 8][i] = 1023;
                }
                ++j;
            }
            ++i;
        }
        if (allZero && !bEncodeIfZero) {
            return null;
        }
        i = 0;
        while (i < 8 * dim) {
            len[i] = numEntries;
            ++i;
        }
        return PuCompress.encode(intArray, len);
    }

    public static byte[] encodePdVector(PdVector data, int resolution) {
        if (data == null) {
            return null;
        }
        double min = data.min();
        double interval = data.max() - min;
        double width = 1.0;
        while (width / 2.0 > interval) {
            width /= 2.0;
        }
        if (interval != 0.0) {
            while (width <= interval) {
                width *= 2.0;
            }
        }
        int maxExponent = Math.max(PuCompress.getExponent(min), PuCompress.getExponent(min + width));
        int size = data.getSize();
        int[][] intArray = new int[8][size];
        int i = 0;
        while (i < size) {
            int cutBits;
            long longBits = Double.doubleToLongBits(data.m_data[i]);
            if (resolution != 0 && (cutBits = 52 - resolution + maxExponent - PuCompress.getExponent(data.m_data[i]) - 1) >= 0) {
                longBits = cutBits > 52 ? 0L : (longBits &= -1L << cutBits);
            }
            intArray[0][i] = (int)(longBits >> 63) & 1;
            intArray[1][i] = (int)(longBits >> 52) & 0x7FF;
            intArray[2][i] = (int)(longBits >> 44) & 0xFF;
            intArray[3][i] = (int)(longBits >> 36) & 0xFF;
            intArray[4][i] = (int)(longBits >> 28) & 0xFF;
            intArray[5][i] = (int)(longBits >> 20) & 0xFF;
            intArray[6][i] = (int)(longBits >> 10) & 0x3FF;
            intArray[7][i] = (int)longBits & 0x3FF;
            if (intArray[1][i] < 1024) {
                int[] nArray = intArray[1];
                int n = i;
                nArray[n] = nArray[n] - 1;
            }
            if (intArray[1][i] == -1) {
                intArray[1][i] = 1023;
            }
            ++i;
        }
        return PuCompress.encode(intArray, new int[]{size, size, size, size, size, size, size, size});
    }

    public static PdVector decodePdVector(byte[] code) {
        if (code == null) {
            return null;
        }
        int[][] intArray = PuCompress.decodeArray(code);
        int numEntries = intArray[0].length;
        PdVector data = new PdVector(numEntries);
        int i = 0;
        while (i < numEntries) {
            if (intArray[1][i] == 1023) {
                intArray[1][i] = -1;
            }
            if (intArray[1][i] < 1024) {
                int[] nArray = intArray[1];
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
            long lde = intArray[7][i];
            lde |= (long)intArray[6][i] << 10;
            lde |= (long)intArray[5][i] << 20;
            lde |= (long)intArray[4][i] << 28;
            lde |= (long)intArray[3][i] << 36;
            lde |= (long)intArray[2][i] << 44;
            lde |= (long)intArray[1][i] << 52;
            data.m_data[i] = Double.longBitsToDouble(lde |= (long)intArray[0][i] << 63);
            ++i;
        }
        return data;
    }

    public static PdVector[] PdVectorDecode(byte[] code) {
        if (code == null) {
            return null;
        }
        int[][] intArray = PuCompress.decodeArray(code);
        int numEntries = intArray[0].length;
        int dim = intArray.length / 8;
        PdVector[] PdVectorArray = new PdVector[numEntries];
        int i = 0;
        while (i < numEntries) {
            PdVectorArray[i] = new PdVector(dim);
            int j = 0;
            while (j < dim) {
                if (intArray[1 + j * 8][i] == 1023) {
                    intArray[1 + j * 8][i] = -1;
                }
                if (intArray[1 + j * 8][i] < 1024) {
                    int[] nArray = intArray[1 + j * 8];
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                }
                long lde = intArray[7][i];
                lde |= (long)intArray[6][i] << 10;
                lde |= (long)intArray[5][i] << 20;
                lde |= (long)intArray[4][i] << 28;
                lde |= (long)intArray[3][i] << 36;
                lde |= (long)intArray[2][i] << 44;
                lde |= (long)intArray[1][i] << 52;
                PdVectorArray[i].m_data[j] = Double.longBitsToDouble(lde |= (long)intArray[0][i] << 63);
                ++j;
            }
            ++i;
        }
        return PdVectorArray;
    }

    public static byte[] encodeColors(int[] parent, int[] traversalOrder, Color[] colors, int doubleResolution) {
        if (parent == null || traversalOrder == null || colors == null) {
            return null;
        }
        int[] rgb = new int[parent.length];
        int mask = 0xFFFFFF;
        int[][] a = new int[3][];
        if (doubleResolution <= 12) {
            mask = 0xFCFCFC;
        } else if (doubleResolution <= 16) {
            mask = 0xFEFEFE;
        }
        int i = 0;
        while (i < parent.length) {
            rgb[i] = colors[traversalOrder[i]].getRGB() & mask;
            ++i;
        }
        int j = 0;
        while (j < 3) {
            int shift = 16 - j * 8;
            a[j] = new int[parent.length];
            int i2 = 0;
            while (i2 < parent.length) {
                a[j][i2] = parent[i2] >= 0 ? (rgb[i2] >> shift & 0xFF) - (rgb[parent[i2]] >> shift & 0xFF) : rgb[i2] >> shift & 0xFF;
                ++i2;
            }
            ++j;
        }
        return PuCompress.encode(a, new int[]{parent.length, parent.length, parent.length});
    }

    public static Color[] decodeColors(int[] parent, byte[] code) {
        if (code == null || parent == null) {
            return null;
        }
        Color[] colors = new Color[parent.length];
        int[][] rgb = PuCompress.decodeArray(code);
        int j = 0;
        while (j < rgb.length) {
            int i = 0;
            while (i < rgb[j].length) {
                if (parent[i] >= 0) {
                    int[] nArray = rgb[j];
                    int n = i;
                    nArray[n] = nArray[n] + rgb[j][parent[i]];
                }
                ++i;
            }
            ++j;
        }
        int i = 0;
        while (i < parent.length) {
            colors[i] = new Color(rgb[0][i], rgb[1][i], rgb[2][i]);
            ++i;
        }
        return colors;
    }

    public static byte[] encodeTextures(int[] parent, int[] traversalOrder, PdVector[] tex, int doubleResolution) {
        if (parent == null || traversalOrder == null || tex == null) {
            return null;
        }
        PdVector[] a = new PdVector[tex.length];
        int i = 0;
        while (i < parent.length) {
            a[i] = parent[i] >= 0 ? PdVector.subNew((PdVector)tex[traversalOrder[i]], (PdVector)tex[traversalOrder[parent[i]]]) : tex[traversalOrder[i]];
            ++i;
        }
        return PuCompress.PdVectorEncode(a, doubleResolution, false);
    }

    public static PdVector[] decodeTextures(int[] parent, byte[] code) {
        if (code == null || parent == null) {
            return null;
        }
        PdVector[] tex = PuCompress.PdVectorDecode(code);
        int i = 0;
        while (i < parent.length) {
            if (parent[i] >= 0) {
                tex[i].add(tex[parent[i]]);
            }
            ++i;
        }
        return tex;
    }

    protected static boolean[] intsToBooleans(int[] msg) {
        if (msg == null) {
            return null;
        }
        int length = msg.length;
        boolean[] bools = new boolean[length];
        int i = 0;
        while (i < length) {
            bools[i] = msg[i] != 0;
            ++i;
        }
        return bools;
    }

    protected static int[] booleansToInts(boolean[] message, int length) {
        int[] msg = new int[length];
        int i = 0;
        while (i < length) {
            msg[i] = message[i] ? 1 : 0;
            ++i;
        }
        return msg;
    }

    public static double computeCompressedSize(int[] nv) {
        double entropy = 0.0;
        int sum = 0;
        int minInd = Integer.MAX_VALUE;
        int maxInd = Integer.MIN_VALUE;
        int i = 0;
        while (i < nv.length) {
            sum += nv[i];
            if (nv[i] > 0) {
                if (i < minInd) {
                    minInd = i;
                }
                maxInd = i;
            }
            ++i;
        }
        entropy = PuCompress.logFactorial(maxInd - minInd + 1 + sum);
        entropy -= PuCompress.logFactorial(maxInd - minInd + 1);
        i = 0;
        while (i < nv.length) {
            if (nv[i] > 0) {
                entropy -= PuCompress.logFactorial(nv[i]);
            }
            ++i;
        }
        return entropy / Math.log(2.0);
    }

    public static double computeCompressedSize(PiVector a) {
        int min = a.min();
        int max = a.max();
        int[] nv = new int[max - min + 1];
        int i = 0;
        while (i < a.getSize()) {
            int n = a.m_data[i] - min;
            nv[n] = nv[n] + 1;
            ++i;
        }
        return PuCompress.computeCompressedSize(nv);
    }

    public static double computeEntropy(PiVector a) {
        int sum = 0;
        int min = a.min();
        int max = a.max();
        int[] nv = new int[max - min + 1];
        int i = 0;
        while (i < a.getSize()) {
            int n = a.m_data[i] - min;
            nv[n] = nv[n] + 1;
            ++i;
        }
        double entropy = 0.0;
        int i2 = min;
        while (i2 < max) {
            sum += nv[i2 - min];
            if (nv[i2 - min] > 0) {
                entropy -= (double)nv[i2 - min] * Math.log(nv[i2 - min]);
            }
            ++i2;
        }
        if (sum > 0) {
            entropy += (double)sum * Math.log(sum);
        }
        return entropy / 0.6931471805599453;
    }

    private static double logFactorial(int n) {
        if (n == 0 || n == 1) {
            return 0.0;
        }
        if (n == 2) {
            return 0.6931471805599453;
        }
        return ((double)n + 0.5) * Math.log(n) - (double)n + 0.08333333333333333 / (double)n + 0.9189385332046728;
    }
}

