/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import devCompress.PuCumulatedTree;
import jv.vecmath.PiVector;

public final class PuArithmeticCoder {
    private int m_low;
    private int m_high;
    private int m_code;
    protected int m_streamBytes = 0;
    private byte[] m_stream = new byte[100];
    private int m_underflowBits;
    private PuCumulatedTree m_codingModel = null;
    protected int m_streamBitsLeft;

    public void encodeBounds(int min, int max) {
        if (min > -128 && min < 128) {
            this.outputByte((byte)min);
        } else {
            this.outputByte((byte)-128);
            this.outputByte((byte)(min >> 24 & 0xFF));
            this.outputByte((byte)(min >> 16 & 0xFF));
            this.outputByte((byte)(min >> 8 & 0xFF));
            this.outputByte((byte)(min & 0xFF));
        }
        if (max > -128 && max < 128) {
            this.outputByte((byte)max);
        } else {
            this.outputByte((byte)-128);
            this.outputByte((byte)(max >> 24 & 0xFF));
            this.outputByte((byte)(max >> 16 & 0xFF));
            this.outputByte((byte)(max >> 8 & 0xFF));
            this.outputByte((byte)(max & 0xFF));
        }
    }

    public byte[] encode(int[] message, int length, boolean permutation, int min, int max) {
        int i;
        this.m_codingModel = new PuCumulatedTree(max + 2);
        this.m_codingModel.setConstant(1);
        this.m_low = 0;
        this.m_high = Integer.MAX_VALUE;
        this.m_underflowBits = 0;
        if (permutation) {
            i = 0;
            while (i < length) {
                int c = message[i] - min;
                this.encodeSymbol(c);
                this.m_codingModel.changeValue(c, -1);
                ++i;
            }
        } else {
            i = 0;
            while (i < length) {
                int c = message[i] - min;
                this.encodeSymbol(c);
                this.m_codingModel.changeValue(c, 1);
                ++i;
            }
        }
        this.encodeSymbol(max + 1);
        this.flushEncoder();
        byte[] shortStream = new byte[this.m_streamBytes];
        System.arraycopy(this.m_stream, 0, shortStream, 0, this.m_streamBytes);
        return shortStream;
    }

    public int[] decode(byte[] code, boolean bPermutation, boolean bDecodeArray, boolean bBooleans, boolean bCompactBitPacking) {
        if (code == null) {
            return null;
        }
        this.m_stream = code;
        PiVector message = new PiVector(2 * this.m_stream.length);
        if (!bDecodeArray) {
            this.m_streamBytes = 0;
        }
        if (!bCompactBitPacking) {
            this.m_streamBitsLeft = 0;
        }
        int min = 0;
        int max = 1;
        if (!bBooleans) {
            min = this.inputByte();
            if (min == -128) {
                min = (this.inputByte() & 0xFF) << 24 | (this.inputByte() & 0xFF) << 16 | (this.inputByte() & 0xFF) << 8 | this.inputByte() & 0xFF;
            }
            if ((max = (int)this.inputByte()) == -128) {
                max = (this.inputByte() & 0xFF) << 24 | (this.inputByte() & 0xFF) << 16 | (this.inputByte() & 0xFF) << 8 | this.inputByte() & 0xFF;
            }
        }
        this.m_codingModel = new PuCumulatedTree(max + 2);
        this.m_codingModel.setConstant(1);
        this.m_low = 0;
        this.m_high = Integer.MAX_VALUE;
        this.m_code = 0;
        int i = 0;
        while (i < 31) {
            this.m_code <<= 1;
            this.m_code |= this.inputBit();
            ++i;
        }
        if (this.m_code == 0 && (this.m_streamBytes > this.m_stream.length || this.m_streamBytes == this.m_stream.length && this.m_stream[this.m_streamBytes - 1] >> this.m_streamBitsLeft != 0)) {
            return null;
        }
        int symbols = 0;
        while (true) {
            int count = this.getCurrentCount();
            int c = this.m_codingModel.getIndex(count + 1);
            this.removeSymbolFromStream(c);
            if (c > max) break;
            if (message.getSize() == symbols) {
                message.setSize(2 * message.m_data.length);
            }
            message.setEntry(symbols, c);
            if (bPermutation) {
                this.m_codingModel.changeValue(c, -1);
            } else {
                this.m_codingModel.changeValue(c, 1);
            }
            ++symbols;
        }
        int[] shortMessage = new int[symbols];
        System.arraycopy(message.m_data, 0, shortMessage, 0, shortMessage.length);
        int i2 = 0;
        while (i2 < shortMessage.length) {
            int n = i2++;
            shortMessage[n] = shortMessage[n] + min;
        }
        return shortMessage;
    }

    public int[][] decodeArray(byte[] code, boolean bBooleans) {
        int i;
        if (code == null) {
            return null;
        }
        int count = 0;
        int[][] message = new int[20][];
        while (this.m_streamBytes < code.length) {
            if (count == message.length) {
                int[][] m2 = new int[2 * count][];
                i = 0;
                while (i < count) {
                    m2[i] = message[i];
                    ++i;
                }
                message = m2;
            }
            message[count] = this.decode(code, false, true, bBooleans, false);
            if (message[count] == null) {
                message[count] = new int[0];
            }
            this.m_streamBytes -= (29 + this.m_streamBitsLeft) / 8;
            ++count;
        }
        int[][] shortMessage = new int[count][];
        i = 0;
        while (i < count) {
            shortMessage[i] = message[i];
            ++i;
        }
        return shortMessage;
    }

    private void updateRange(int c) {
        long range = (long)(this.m_high - this.m_low) + 1L;
        int top = this.m_codingModel.getCumulatedValue(c);
        int bot = this.m_codingModel.getCumulatedValue(c - 1);
        long tot = this.m_codingModel.getTotalSum();
        this.m_high = this.m_low + (int)(range * (long)top / tot - 1L);
        this.m_low += (int)(range * (long)bot / tot);
    }

    private void encodeSymbol(int c) {
        this.updateRange(c);
        while (true) {
            if ((this.m_low & 0x40000000) == (this.m_high & 0x40000000)) {
                this.outputBit(this.m_high & 0x40000000);
                while (this.m_underflowBits > 0) {
                    --this.m_underflowBits;
                    this.outputBit(~this.m_high & 0x40000000);
                }
            } else if ((this.m_low & 0x20000000) != 0 && (this.m_high & 0x20000000) == 0) {
                ++this.m_underflowBits;
                this.m_low &= 0x1FFFFFFF;
                this.m_high |= 0x20000000;
            } else {
                return;
            }
            this.m_low = this.m_low << 1 & Integer.MAX_VALUE;
            this.m_high = this.m_high << 1 & Integer.MAX_VALUE;
            this.m_high |= 1;
        }
    }

    private int getCurrentCount() {
        long range = (long)(this.m_high - this.m_low) + 1L;
        long mid = (long)(this.m_code - this.m_low) + 1L;
        long tot = this.m_codingModel.getTotalSum();
        long freq = (mid * tot - 1L) / range;
        return (int)freq;
    }

    private void removeSymbolFromStream(int c) {
        this.updateRange(c);
        while (true) {
            if ((this.m_low & 0x40000000) != (this.m_high & 0x40000000)) {
                if ((this.m_low & 0x20000000) != 0 && (this.m_high & 0x20000000) == 0) {
                    this.m_code ^= 0x20000000;
                    this.m_low &= 0x1FFFFFFF;
                    this.m_high |= 0x20000000;
                } else {
                    return;
                }
            }
            this.m_low = this.m_low << 1 & Integer.MAX_VALUE;
            this.m_high = this.m_high << 1 & Integer.MAX_VALUE;
            this.m_high |= 1;
            this.m_code = this.m_code << 1 & Integer.MAX_VALUE;
            this.m_code += this.inputBit();
        }
    }

    private void flushEncoder() {
        this.outputBit(this.m_low & 0x20000000);
        while (this.m_underflowBits-- >= 0) {
            this.outputBit(~this.m_low & 0x20000000);
        }
    }

    private void outputByte(byte b) {
        int mask = 128;
        while (mask != 0) {
            this.outputBit(b & mask);
            mask >>= 1;
        }
    }

    private void outputBit(int bit) {
        if (this.m_streamBitsLeft == 0) {
            this.m_streamBitsLeft = 8;
            ++this.m_streamBytes;
            if (this.m_streamBytes == this.m_stream.length) {
                byte[] a = new byte[Math.max(2 * this.m_streamBytes, 256)];
                System.arraycopy(this.m_stream, 0, a, 0, this.m_stream.length);
                this.m_stream = a;
            }
        }
        --this.m_streamBitsLeft;
        if (bit != 0) {
            int n = this.m_streamBytes - 1;
            this.m_stream[n] = (byte)(this.m_stream[n] | 1 << this.m_streamBitsLeft);
        }
    }

    private byte inputByte() {
        byte b = 0;
        int i = 0;
        while (i < 8) {
            b = (byte)(b | this.inputBit() << 7 - i);
            ++i;
        }
        return b;
    }

    private int inputBit() {
        if (this.m_streamBitsLeft == 0) {
            this.m_streamBitsLeft = 8;
            ++this.m_streamBytes;
        }
        --this.m_streamBitsLeft;
        if (this.m_streamBytes > this.m_stream.length) {
            return 0;
        }
        return this.m_stream[this.m_streamBytes - 1] >> this.m_streamBitsLeft & 1;
    }

    public int getNumUsedBits() {
        return 8 * this.m_streamBytes - this.m_streamBitsLeft;
    }
}

