/*
 * Decompiled with CFR 0.152.
 */
package devCompress;

import jv.geom.PgVectorField;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;

public class PgJvzCode
extends PgJvxSrc {
    protected int m_numStoredVertices;
    protected int m_numStoredElements;
    protected PdVector[] m_quantBndBox;
    protected int m_doubleResolution;
    protected double m_resizeFactor;
    protected int m_numContexts;
    protected int[] m_contextThreshold;
    protected int[] m_axisResolution;
    protected byte[] m_vertexCode;
    protected byte[] m_elementCode;
    protected byte[] m_splitCode;
    protected byte[] m_vertexData;
    protected byte[] m_discrErrorData;
    protected byte[] m_vertexNormalData;
    protected byte[] m_elementNormalData;
    protected byte[] m_vertexColorData;
    protected byte[] m_elementColorData;
    protected byte[] m_elementBackColorData;
    protected byte[] m_vertexIndexCode;
    protected byte[] m_elementIndexCode;
    protected byte[] m_localIndexCode;
    protected byte[] m_vertexTextureCode;
    protected byte[] m_elementTextureCode;
    protected int m_numStoredVectorFields;
    protected byte[][] m_vectorFieldCode;

    public PgJvzCode() {
        if (((Object)((Object)this)).getClass() == PgJvzCode.class) {
            this.init();
        }
    }

    public void copy(PgJvzCode geomCode) {
        this.m_numStoredVertices = geomCode.getNumStoredVertices();
        this.m_numStoredElements = geomCode.getNumStoredElements();
        this.m_quantBndBox = geomCode.getBndBox();
        this.m_doubleResolution = geomCode.getDoubleResolution();
        this.m_resizeFactor = geomCode.getResizeFactor();
        this.m_numContexts = geomCode.getNumContexts();
        this.m_contextThreshold = geomCode.getContextThresholds();
        this.m_axisResolution = geomCode.getAxisResolution();
        this.m_vertexCode = geomCode.getVertexSymbolCode();
        this.m_elementCode = geomCode.getElementSymbolCode();
        this.m_splitCode = geomCode.getSplitSymbolCode();
        this.m_vertexData = geomCode.getVertexDataCode();
        this.m_discrErrorData = geomCode.getDiscrErrorCode();
        this.m_vertexNormalData = geomCode.getVertexNormalCode();
        this.m_elementNormalData = geomCode.getElementNormalCode();
        this.m_vertexColorData = geomCode.getVertexColorCode();
        this.m_elementColorData = geomCode.getElementColorCode();
        this.m_elementBackColorData = geomCode.getElementBackColorCode();
        this.m_vertexIndexCode = geomCode.getVertexIndexCode();
        this.m_elementIndexCode = geomCode.getElementIndexCode();
        this.m_localIndexCode = geomCode.getLocalIndexCode();
        this.m_vertexTextureCode = geomCode.getVertexTextureCode();
        this.m_elementTextureCode = geomCode.getElementTextureCode();
        this.m_numStoredVectorFields = geomCode.getNumStoredVectorFields();
        int i = 0;
        while (i < this.m_numStoredVectorFields) {
            this.m_vectorFieldCode[i] = geomCode.getVectorFieldCode(i);
            ++i;
        }
        super.copy((PgJvxSrc)geomCode);
    }

    public PdVector[] getBndBox() {
        return this.m_quantBndBox;
    }

    public double getResizeFactor() {
        return this.m_resizeFactor;
    }

    public int getNumContexts() {
        return this.m_numContexts;
    }

    public int[] getContextThresholds() {
        return this.m_contextThreshold;
    }

    public int[] getAxisResolution() {
        return this.m_axisResolution;
    }

    public int getDoubleResolution() {
        return this.m_doubleResolution;
    }

    public int getNumStoredVertices() {
        return this.m_numStoredVertices;
    }

    public int getNumStoredElements() {
        return this.m_numStoredElements;
    }

    public byte[] getVertexSymbolCode() {
        return this.m_vertexCode;
    }

    public byte[] getElementSymbolCode() {
        return this.m_elementCode;
    }

    public byte[] getSplitSymbolCode() {
        return this.m_splitCode;
    }

    public byte[] getVertexDataCode() {
        return this.m_vertexData;
    }

    public byte[] getDiscrErrorCode() {
        return this.m_discrErrorData;
    }

    public byte[] getVertexNormalCode() {
        return this.m_vertexNormalData;
    }

    public byte[] getElementNormalCode() {
        return this.m_elementNormalData;
    }

    public byte[] getVertexColorCode() {
        return this.m_vertexColorData;
    }

    public byte[] getElementColorCode() {
        return this.m_elementColorData;
    }

    public byte[] getElementBackColorCode() {
        return this.m_elementBackColorData;
    }

    public byte[] getVertexTextureCode() {
        return this.m_vertexTextureCode;
    }

    public byte[] getElementTextureCode() {
        return this.m_elementTextureCode;
    }

    public byte[] getVertexIndexCode() {
        return this.m_vertexIndexCode;
    }

    public byte[] getElementIndexCode() {
        return this.m_elementIndexCode;
    }

    public byte[] getLocalIndexCode() {
        return this.m_localIndexCode;
    }

    public byte[] getVectorCode(int index) {
        return this.m_vectorFieldCode[index];
    }

    public int getNumStoredVectorFields() {
        return this.m_numStoredVectorFields;
    }

    public byte[] getVectorFieldCode(int index) {
        if (index >= this.m_numStoredVectorFields) {
            return null;
        }
        if (this.m_vectorFieldCode == null || this.m_vectorFieldCode.length <= index || this.m_vectorFieldCode[index] == null) {
            PsDebug.error((String)"Not enough vectors allocated for vector field.");
            return null;
        }
        return this.m_vectorFieldCode[index];
    }

    public void setBndBox(PdVector[] box) {
        this.m_quantBndBox = box;
    }

    public void setResizeFactor(double rf) {
        this.m_resizeFactor = rf;
    }

    public void setNumStoredVertices(int numVertices) {
        this.m_numStoredVertices = numVertices;
    }

    public void setNumStoredElements(int numElements) {
        this.m_numStoredElements = numElements;
    }

    public void setDoubleResolution(int resolution) {
        this.m_doubleResolution = resolution;
    }

    public void setNumContexts(int noc) {
        this.m_numContexts = noc;
    }

    public void setContextThresholds(int[] ct) {
        this.m_contextThreshold = ct;
    }

    public void setAxisResolution(int[] ar) {
        this.m_axisResolution = ar;
    }

    public void setVertexSymbolCode(byte[] code) {
        this.m_vertexCode = code;
    }

    public void setElementSymbolCode(byte[] code) {
        this.m_elementCode = code;
    }

    public void setSplitSymbolCode(byte[] code) {
        this.m_splitCode = code;
    }

    public void setVertexDataCode(byte[] code) {
        this.m_vertexData = code;
    }

    public void setDiscrErrorCode(byte[] code) {
        this.m_discrErrorData = code;
    }

    public void setVertexNormalCode(byte[] code) {
        this.m_vertexNormalData = code;
    }

    public void setElementNormalCode(byte[] code) {
        this.m_elementNormalData = code;
    }

    public void setVertexColorCode(byte[] code) {
        this.m_vertexColorData = code;
    }

    public void setElementColorCode(byte[] code) {
        this.m_elementColorData = code;
    }

    public void setElementBackColorCode(byte[] code) {
        this.m_elementBackColorData = code;
    }

    public void setVertexTextureCode(byte[] code) {
        this.m_vertexTextureCode = code;
    }

    public void setElementTextureCode(byte[] code) {
        this.m_elementTextureCode = code;
    }

    public void setVertexIndexCode(byte[] code) {
        this.m_vertexIndexCode = code;
    }

    public void setElementIndexCode(byte[] code) {
        this.m_elementIndexCode = code;
    }

    public void setLocalIndexCode(byte[] code) {
        this.m_localIndexCode = code;
    }

    public void setNumStoredVectorFields(int numVF) {
        this.m_numStoredVectorFields = numVF;
        if (this.m_vectorFieldCode == null || numVF != this.m_vectorFieldCode.length) {
            byte[][] tmp = new byte[numVF][];
            if (this.m_vectorFieldCode != null) {
                int toCopy = Math.min(numVF, this.m_vectorFieldCode.length);
                int i = 0;
                while (i < toCopy) {
                    tmp[i] = this.m_vectorFieldCode[i];
                    ++i;
                }
            }
            this.m_vectorFieldCode = tmp;
        }
    }

    public void copyVectorFieldAttributes(int index, PgVectorField vf) {
        if (this.m_vectorFieldCode == null || index >= this.m_vectorFieldCode.length) {
            return;
        }
        this.setVectorFieldName(index, vf.getName());
        this.setVectorElementBased(index, vf.getBasedOn() == 1);
        this.showVectorField(index, vf.isVisible());
        this.showVectorFieldMaterials(index, vf.isShowingIndividualMaterial());
        this.showVectorArrows(index, vf.isShowingVectorArrows());
        this.showVectorColors(index, vf.isShowingVectorColors());
        this.setGlobalVectorColor(index, vf.getGlobalVectorColor());
        this.setGlobalVectorLength(index, vf.getGlobalVectorLength());
        this.setGlobalVectorSize(index, vf.getGlobalVectorSize());
        this.setVectorColors(index, vf.getVectorColors());
    }

    public void setVectorFieldCode(int index, byte[] vfCode) {
        if (this.m_vectorFieldCode == null || index >= this.m_vectorFieldCode.length) {
            PsDebug.warning((String)"index out of range or argument is null!");
            return;
        }
        this.m_vectorFieldCode[index] = vfCode;
    }

    public String getDetailInfo() {
        StringBuffer str = new StringBuffer();
        int numV = this.m_numStoredVertices;
        int vCode = this.m_vertexCode == null ? 0 : this.m_vertexCode.length;
        int eCode = this.m_elementCode == null ? 0 : this.m_elementCode.length;
        int sCode = this.m_splitCode == null ? 0 : this.m_splitCode.length;
        int vData = this.m_vertexData == null ? 0 : this.m_vertexData.length;
        int dData = this.m_discrErrorData == null ? 0 : this.m_discrErrorData.length;
        int vf = 0;
        int i = 0;
        while (i < this.m_numStoredVectorFields) {
            vf += this.m_vectorFieldCode[i] == null ? 0 : this.m_vectorFieldCode[i].length;
            ++i;
        }
        int vNormal = this.m_vertexNormalData == null ? 0 : this.m_vertexNormalData.length;
        int eNormal = this.m_elementNormalData == null ? 0 : this.m_elementNormalData.length;
        int vColor = this.m_vertexColorData == null ? 0 : this.m_vertexColorData.length;
        int eColor = this.m_elementColorData == null ? 0 : this.m_elementColorData.length;
        int ebColor = this.m_elementBackColorData == null ? 0 : this.m_elementBackColorData.length;
        int vIndex = this.m_vertexIndexCode == null ? 0 : this.m_vertexIndexCode.length;
        int eIndex = this.m_elementIndexCode == null ? 0 : this.m_elementIndexCode.length;
        int lIndex = this.m_localIndexCode == null ? 0 : this.m_localIndexCode.length;
        int vTex = this.m_vertexTextureCode == null ? 0 : this.m_vertexTextureCode.length;
        int eTex = this.m_elementTextureCode == null ? 0 : this.m_elementTextureCode.length;
        str.append("---------- PgJvzCode detail info ------------------\n");
        str.append("Model name:           " + this.getName() + "\n");
        str.append("Number of vertices:   " + this.m_numStoredVertices + "\n");
        str.append("Number of elements:   " + this.m_numStoredElements + "\n");
        int connData = vCode + eCode + sCode;
        str.append("Connectivity Data:    " + connData + " b   \t(" + PuString.toString((double)((double)connData / (double)numV * 8.0), (int)3) + "bpv)\n");
        str.append("   Vertex code:         " + vCode + " b   \t(" + PuString.toString((double)((double)vCode / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Element code:        " + eCode + " b   \t(" + PuString.toString((double)((double)eCode / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Split code:          " + sCode + " b   \t(" + PuString.toString((double)((double)sCode / (double)numV * 8.0), (int)3) + " bpv)\n");
        int geomData = vData + dData;
        str.append("Geometry Data:        " + geomData + " b   \t(" + PuString.toString((double)((double)geomData / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Geometry code:       " + vData + " b   \t(" + PuString.toString((double)((double)vData / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Hi-Res geometry:     " + dData + " b   \t(" + PuString.toString((double)((double)dData / (double)numV * 8.0), (int)3) + " bpv)\n");
        int attrData = vf + vNormal + eNormal + vColor + eColor + ebColor + vIndex + eIndex + lIndex + vTex + eTex;
        str.append("Attribute Data:       " + attrData + " b   \t(" + PuString.toString((double)((double)attrData / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Normals:             " + (vNormal + eNormal) + " b   \t(" + PuString.toString((double)((double)(vNormal + eNormal) / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Colors:              " + (vColor + eColor + ebColor) + " b   \t(" + PuString.toString((double)((double)(vColor + eColor + ebColor) / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Indices:             " + (vIndex + eIndex + lIndex) + " b   \t(" + PuString.toString((double)((double)(vIndex + eIndex + lIndex) / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("   Textures:            " + (vTex + eTex) + " b   \t(" + PuString.toString((double)((double)(vTex + eTex) / (double)numV * 8.0), (int)3) + " bpv)\n");
        str.append("---------------------------------------------------\n");
        int total = connData + geomData + attrData;
        str.append("Total Data:       " + total + " b   \t(" + PuString.toString((double)((double)total / (double)numV * 8.0), (int)3) + " bpv)\n");
        return str.toString();
    }
}

