/*
 * Decompiled with CFR 0.152.
 */
package devColor;

import devDomainColoring.colors.schemes.PuCSCustomColorBar1d;
import java.awt.Color;
import jv.geom.PgElementSet;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PiVector;
import jvx.project.PjWorkshop;

public class PwMapColor
extends PjWorkshop {
    protected PgElementSet m_elementSet;
    protected int m_numColors = 5;
    protected Color[] m_color;
    protected PuCSCustomColorBar1d m_ccb = new PuCSCustomColorBar1d();

    public PwMapColor() {
        super("Map Colors");
        this.m_ccb.addUpdateListener((PsUpdateIf)this);
        this.m_ccb.setNumTeeth(this.m_numColors);
        this.m_ccb.setToothSlope(0.0);
        this.getColorsFromScheme();
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_elementSet = (PgElementSet)geom;
    }

    public boolean update(Object event) {
        if (event == this.m_ccb) {
            this.getColorsFromScheme();
            this.computeElementColors();
            return this.m_elementSet.update((Object)this.m_elementSet);
        }
        return super.update(event);
    }

    public void getColorsFromScheme() {
        int num = this.m_ccb.getNumTeeth();
        if (num < 2) {
            return;
        }
        this.m_numColors = num;
        this.m_color = new Color[this.m_numColors];
        int i = 0;
        while (i < this.m_numColors) {
            this.m_color[i] = new Color(this.m_ccb.getColorImpl((double)i / ((double)this.m_numColors - 1.0)));
            ++i;
        }
    }

    public void setColors(Color[] col) {
        if (col.length < 1) {
            return;
        }
        this.m_numColors = col.length;
        this.m_color = col;
    }

    public void computeElementColors() {
        this.m_elementSet.setElementColors(PwMapColor.computeColorMap(this.m_elementSet.getNeighbours(), this.m_elementSet.getNumElements(), this.m_color));
        this.m_elementSet.showElementColors(true);
    }

    public static Color[] computeColorMap(PiVector[] neigh, int noe, Color[] col) {
        int[] ci = new int[noe];
        int nc = col.length;
        int[] nce = new int[nc];
        int i = 0;
        while (i < noe) {
            int rci;
            ci[i] = rci = (int)(Math.random() * (double)nc) % nc;
            int n = rci;
            nce[n] = nce[n] + 1;
            ++i;
        }
        boolean bChanged = true;
        boolean[] cu = new boolean[nc];
        while (bChanged) {
            bChanged = false;
            int i2 = 0;
            while (i2 < noe) {
                int neighSize = neigh[i2].getSize();
                int j = 0;
                while (j < nc) {
                    cu[j] = false;
                    ++j;
                }
                j = 0;
                while (j < neighSize) {
                    if (neigh[i2].m_data[j] >= 0) {
                        cu[ci[neigh[i2].m_data[j]]] = true;
                    }
                    ++j;
                }
                int bestIndex = -1;
                int smallestNum = noe + 1;
                j = 0;
                while (j < nc) {
                    if (!cu[j] && nce[j] < smallestNum) {
                        smallestNum = nce[j];
                        bestIndex = j;
                    }
                    ++j;
                }
                if (bestIndex != -1 && bestIndex != ci[i2] && (nce[ci[i2]] > nce[bestIndex] + 1 || cu[ci[i2]])) {
                    bChanged = true;
                    int n = ci[i2];
                    nce[n] = nce[n] - 1;
                    int n2 = bestIndex;
                    nce[n2] = nce[n2] + 1;
                    ci[i2] = bestIndex;
                }
                ++i2;
            }
        }
        Color[] ec = new Color[noe];
        int i3 = 0;
        while (i3 < noe) {
            ec[i3] = col[ci[i3]];
            ++i3;
        }
        return ec;
    }
}

