/*
 * Decompiled with CFR 0.152.
 */
package dev.vector;

import dev.numeric.PnTaucsSolver;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnBiconjugateGradient;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnMassMatrix;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnPreconditionerJacobi;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffDiriConforming;
import jvx.project.PjWorkshop;

public class PwSmoothField
extends PjWorkshop
implements Runnable {
    protected PgElementSet m_geom;
    protected int m_currLoop;
    protected int m_maxNumLoops;
    protected double m_stepwidth;
    private boolean m_bKeepBoundary;
    protected boolean m_bUpdateScalarField;
    protected boolean m_bUseTaucs = true;
    protected boolean m_bShowSolverLog = false;
    protected PnStiffDiriConforming m_stiff;
    private PdVector[] m_storeStiff;
    private PnMassMatrix m_mass;
    private PnConjugateGradientMatrix m_solver;
    protected PnPreconditionerJacobi m_preconditioner;
    public boolean m_bUseBiconjugateGradient = false;
    private PgVectorField m_field;
    private PdVector m_xi;
    private PdVector m_xii;
    private boolean m_bBackupField = true;
    private PdVector[] m_backupField;
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;

    public PwSmoothField() {
        super("Smooth Function");
        if (this.getClass() == PwSmoothField.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_maxNumLoops = 100000;
        this.m_currLoop = 0;
        this.m_stepwidth = 0.1;
    }

    public boolean update(Object event) {
        return super.update(event);
    }

    public void setGeometry(PgElementSet geom) {
        super.setGeometry((PgGeometry)geom);
        this.m_geom = geom;
        if (this.m_bKeepBoundary) {
            this.m_geom.markBoundary();
        }
        this.initMatrices();
    }

    public void setField(PgVectorField scalarField) {
        if (scalarField == null) {
            PsDebug.warning((String)"No scalar field available.");
            return;
        }
        this.m_field = scalarField;
        int nov = this.m_field.getNumVectors();
        int dim = this.m_field.getDimOfVertices();
        if (this.m_bBackupField) {
            this.m_backupField = PdVector.realloc(null, (int)dim, (int)nov);
            PdVector[] vecs = this.m_field.getVectors();
            int i = 0;
            while (i < nov) {
                int j = 0;
                while (j < dim) {
                    this.m_backupField[j].m_data[i] = vecs[i].m_data[j];
                    ++j;
                }
                ++i;
            }
        }
        this.initSolver();
        this.initVectors();
    }

    public void enableBiconjugateGradient(boolean flag) {
        this.m_bUseBiconjugateGradient = flag;
    }

    public void setStepWidth(double stw) {
        this.m_stepwidth = stw;
    }

    public PnStiffDiriConforming getStiffnessMatrix() {
        return this.m_stiff;
    }

    protected void initMatrices() {
        this.m_stiff = new PnStiffDiriConforming(this.m_geom);
        this.m_mass = new PnMassMatrix(this.m_geom, true);
        this.backupStiff();
    }

    private void initVectors() {
        int nov = this.m_field.getNumVectors();
        int dim = this.m_field.getDimOfVertices();
        this.m_xi = new PdVector(nov * dim);
        this.m_xii = new PdVector(nov * dim);
    }

    private void initSolver() {
        if (this.m_bUseTaucs) {
            PnTaucsSolver.logfile2StandardOut(this.m_bShowSolverLog);
        }
        if (this.m_solver == null || this.m_solver.getClass() == PnConjugateGradientMatrix.class == this.m_bUseBiconjugateGradient) {
            this.m_solver = this.m_bUseBiconjugateGradient ? new PnBiconjugateGradient() : new PnConjugateGradientMatrix();
            this.m_solver.setTolerance(1.0E-10);
            this.m_solver.setMaxNumIterations(10000);
            this.m_preconditioner = new PnPreconditionerJacobi((PnSparseMatrix)this.m_stiff);
            this.m_solver.setPreconditioner((PnPreconditioner)this.m_preconditioner);
        }
        this.m_solver.setDimension(this.m_field.getDimOfVectors());
    }

    protected void resetFunction() {
        int nov = this.m_geom.getNumVertices();
        PdVector[] vecs = this.m_field.getVectors();
        int dim = this.m_field.getDimOfVertices();
        if (this.m_bBackupField) {
            int i = 0;
            while (i < nov) {
                int j = 0;
                while (j < dim) {
                    vecs[i].m_data[j] = this.m_backupField[j].m_data[i];
                    ++j;
                }
                ++i;
            }
        } else {
            PsDebug.warning((String)"Cannot reset field, because no copy has been made.");
        }
    }

    protected void restoreStiffMatrix() {
        int nov = this.m_stiff.getNumRows();
        int i = 0;
        while (i < nov) {
            int size = this.m_storeStiff[i].m_data.length;
            int j = 0;
            while (j < size) {
                this.m_stiff.getEntries((int)i).m_data[j] = this.m_storeStiff[i].m_data[j];
                ++j;
            }
            ++i;
        }
    }

    public void backupStiff() {
        int nov = this.m_stiff.getNumRows();
        this.m_storeStiff = new PdVector[nov];
        int i = 0;
        while (i < nov) {
            this.m_storeStiff[i] = new PdVector(this.m_stiff.getEntries((int)i).m_data);
            ++i;
        }
    }

    public void setEnableKeepBoundary(boolean flag) {
        this.m_bKeepBoundary = true;
        if (this.m_geom != null) {
            this.m_geom.markBoundary();
        }
    }

    public void setEnabledUpdate(boolean flag) {
        this.m_bUpdateScalarField = flag;
    }

    public void smoothingStep() {
        int snoe;
        int j;
        int nov = this.m_geom.getNumVertices();
        PdVector[] vecs = this.m_field.getVectors();
        double l = this.m_stepwidth;
        l *= this.m_geom.getArea() / 3.0 / (double)this.m_geom.getNumVertices();
        int dim = this.m_field.getDimOfVertices();
        int i = 0;
        while (i < nov) {
            j = 0;
            while (j < dim) {
                this.m_xii.m_data[dim * i + j] = vecs[i].m_data[j];
                ++j;
            }
            ++i;
        }
        this.restoreStiffMatrix();
        PnSparseMatrix.rightMultVector((PnSparseMatrix)this.m_mass, (PdVector)this.m_xii, (PdVector)this.m_xi, (int)dim);
        int nop = this.m_stiff.getNumRows();
        i = 0;
        while (i < nop) {
            snoe = this.m_stiff.getNumEntries(i);
            j = 0;
            while (j < snoe) {
                int n = j++;
                this.m_stiff.getEntries((int)i).m_data[n] = this.m_stiff.getEntries((int)i).m_data[n] * l;
            }
            ++i;
        }
        nop = this.m_mass.getNumRows();
        i = 0;
        while (i < nop) {
            snoe = this.m_mass.getNumEntries(i);
            j = 0;
            while (j < snoe) {
                if (this.m_mass.getColIndex(i, j) >= 0) {
                    int n = this.m_stiff.getIndex(i, this.m_mass.getColIndex(i, j));
                    this.m_stiff.getEntries((int)i).m_data[n] = this.m_stiff.getEntries((int)i).m_data[n] + this.m_mass.getEntrySparse(i, j);
                }
                ++j;
            }
            ++i;
        }
        if (this.m_bUseTaucs) {
            PnTaucsSolver.solveCholeksy((PnSparseMatrix)this.m_stiff, this.m_xii, this.m_xi);
        } else {
            if (this.m_solver == null) {
                this.initSolver();
            }
            this.m_solver.updatePreconditioner((PnSparseMatrix)this.m_stiff);
            double d = this.m_solver.solve((PnSparseMatrix)this.m_stiff, this.m_xii, this.m_xi);
            if (this.m_bShowSolverLog) {
                PsDebug.warning((String)("Residual of linear system (PCG-solver): " + d));
            }
        }
        if (this.m_bKeepBoundary) {
            PdVector[] vert = this.m_geom.getVertices();
            i = 0;
            while (i < nov) {
                if (!vert[i].hasTag(14)) {
                    j = 0;
                    while (j < dim) {
                        vecs[i].m_data[j] = this.m_xii.m_data[dim * i + j];
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < nov) {
                j = 0;
                while (j < dim) {
                    vecs[i].m_data[j] = this.m_xii.m_data[dim * i + j];
                    ++j;
                }
                ++i;
            }
        }
    }

    public static void smoothTensor(PgElementSet geom, PdMatrix[] tensor, int numSteps, double stepWidth) {
        int nov = geom.getNumVertices();
        int dim = tensor[0].m_data.length;
        PwSmoothField smooth = new PwSmoothField();
        smooth.setGeometry(geom);
        smooth.m_stepwidth = stepWidth;
        PgVectorField vf = new PgVectorField(1);
        vf.setBasedOn(0);
        vf.setGeometry((PgPointSet)geom);
        smooth.m_bBackupField = false;
        smooth.setField(vf);
        PdVector[] vecs = vf.getVectors();
        int k = 0;
        while (k < dim) {
            int l = 0;
            while (l < dim) {
                int i = 0;
                while (i < nov) {
                    vecs[i].m_data[0] = tensor[i].m_data[k][l];
                    ++i;
                }
                i = 0;
                while (i < numSteps) {
                    smooth.smoothingStep();
                    ++i;
                }
                i = 0;
                while (i < nov) {
                    tensor[i].m_data[k][l] = vecs[i].m_data[0];
                    ++i;
                }
                ++l;
            }
            ++k;
        }
    }

    public static void smoothFunction(PgElementSet geom, PdVector func, int numSteps, double stepWidth) {
        int nov = geom.getNumVertices();
        PwSmoothField smooth = new PwSmoothField();
        smooth.setGeometry(geom);
        smooth.m_stepwidth = stepWidth;
        PgVectorField vf = new PgVectorField(1);
        vf.setBasedOn(0);
        vf.setGeometry((PgPointSet)geom);
        smooth.m_bBackupField = false;
        smooth.setField(vf);
        PdVector[] vecs = vf.getVectors();
        int i = 0;
        while (i < nov) {
            vecs[i].m_data[0] = func.m_data[i];
            ++i;
        }
        i = 0;
        while (i < numSteps) {
            smooth.smoothingStep();
            ++i;
        }
        i = 0;
        while (i < nov) {
            func.m_data[i] = vecs[i].m_data[0];
            ++i;
        }
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_currLoop = 1;
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Shape Approximation");
        this.m_thread.setPriority(5);
        this.m_thread.start();
        PsDebug.notify((String)"Thread started");
    }

    public void stop() {
        if (this.m_bRunning) {
            this.m_bRunning = false;
            this.m_thread = null;
            PsDebug.notify((String)"Thread stopped");
        }
    }

    @Override
    public void run() {
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            this.smoothingStep();
            if (this.m_bUpdateScalarField) {
                this.m_field.update((Object)this.m_field);
                this.m_geom.update((Object)this.m_geom);
            }
            this.update(this);
            if (this.m_currLoop >= this.m_maxNumLoops) {
                this.stop();
                continue;
            }
            ++this.m_currLoop;
        }
        this.m_bStopped = true;
        this.m_field.update((Object)this.m_field);
        this.m_geom.update((Object)this.m_geom);
        this.update(this);
    }

    public int getMaxNumLoops() {
        return this.m_maxNumLoops;
    }

    public void setMaxNumLoops(int maxNumLoops) {
        this.m_maxNumLoops = maxNumLoops;
    }
}

