/*
 * Decompiled with CFR 0.152.
 */
package dev.vector;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.geom.PwCurvature;
import jvx.geom.PwShapeOperator;
import jvx.numeric.PnMassMatrix;
import jvx.project.PjWorkshop;

public class PwScalarFieldTmp
extends PjWorkshop {
    public final String[] m_scalarFieldName = new String[]{PsConfig.getMessage((int)45070), PsConfig.getMessage((int)45071), PsConfig.getMessage((int)45072), PsConfig.getMessage((boolean)true, (int)45000, (String)"t-Height"), PsConfig.getMessage((int)45073), PsConfig.getMessage((int)45074), PsConfig.getMessage((int)45075), PsConfig.getMessage((int)45076), String.valueOf(PsConfig.getMessage((int)45075)) + " (" + PsConfig.getMessage((boolean)true, (int)45000, (String)"Absolute Value") + ")", String.valueOf(PsConfig.getMessage((int)45076)) + " (" + PsConfig.getMessage((boolean)true, (int)45000, (String)"Absolute Value") + ")", PsConfig.getMessage((boolean)true, (int)45000, (String)"Difference of Principal Curvatures"), PsConfig.getMessage((boolean)true, (int)45000, (String)"Sqrt(k1^2+k2^2)"), PsConfig.getMessage((boolean)true, (int)45000, (String)"k1*k2"), PsConfig.getMessage((int)45077)};
    public static final int SCALAR_X_HEIGHT = 0;
    public static final int SCALAR_Y_HEIGHT = 1;
    public static final int SCALAR_Z_HEIGHT = 2;
    public static final int SCALAR_T_HEIGHT = 3;
    public static final int SCALAR_GAUSS_CURVATURE = 4;
    public static final int SCALAR_MEAN_CURVATURE = 5;
    public static final int SCALAR_MAX_PRINCIPAL = 6;
    public static final int SCALAR_MIN_PRINCIPAL = 7;
    public static final int SCALAR_MAX_PRINCIPAL_ABS = 8;
    public static final int SCALAR_MIN_PRINCIPAL_ABS = 9;
    public static final int SCALAR_DIFF_PRINCIPAL = 10;
    public static final int SCALAR_TOTAL_CURVATURE = 11;
    public static final int SCALAR_GAUSS_VIA_PRINCIPAL = 12;
    public static final int SCALAR_IMPORTED_FUNCTION = 13;
    protected static final int m_numScalarTypes = 14;
    public static final int SCALAR_EXTREMALITY = 14;
    protected PgElementSet m_geom;
    protected PgVectorField m_scalar;
    protected int m_defScalarField = 0;
    protected int m_scalarType;
    protected int m_basisType;
    protected boolean m_bShowColor;
    protected boolean m_bShowGradient;
    protected boolean m_bInvertColor;
    protected boolean m_bShowVectorField;
    protected PgVectorField m_gradient;
    protected PgVectorField m_offsetVectorField;
    protected boolean m_bUseTotalCurv;
    protected boolean m_bChopField;
    protected PuDouble m_chopMin = new PuDouble(PsConfig.getMessage((int)54520), (PsUpdateIf)this);
    protected PuDouble m_chopMax = new PuDouble(PsConfig.getMessage((int)54521), (PsUpdateIf)this);
    protected PdVector m_backupField;
    protected PdVector m_backupOfImportedField;
    protected boolean m_hasImportedFunction = false;
    protected boolean m_bAdjustColoring;
    protected boolean m_bNonLinColoring;
    protected PuDouble m_colorMin;
    protected PuDouble m_colorMax = new PuDouble(PsConfig.getMessage((int)54522), (PsUpdateIf)this);
    protected boolean m_bUseGrayLevel;
    protected boolean m_bUseAbsValue;
    protected boolean m_bUseSymmetricInterval;
    protected boolean[] m_bFieldAvailable;
    protected boolean m_bIgnoreOutliersWhenColoring;
    protected PuDouble m_curvRadius;
    protected PdVector[] m_curvatures;
    private String m_backUpNameOfField = null;
    private static double[] m_ColorMapCurvatureIntervals = new double[]{0.05, 0.1, 0.2, 0.4, 0.45, 0.55, 0.85};
    private static double[] m_ColorMapLinearIntervals = new double[]{0.1, 0.2, 0.35, 0.5, 0.65, 0.8, 0.9};
    private static double[] m_ColorMapOldIntervals = new double[]{0.1, 0.15, 0.4, 0.5, 0.75, 0.82, 0.88};

    public PwScalarFieldTmp() {
        super(PsConfig.getMessage((int)54519));
        this.m_colorMin = new PuDouble(PsConfig.getMessage((int)54523), (PsUpdateIf)this);
        this.m_curvRadius = new PuDouble("Support Radius", (PsUpdateIf)this);
        this.m_bFieldAvailable = new boolean[14];
        if (((Object)((Object)this)).getClass() == PwScalarFieldTmp.class) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_scalarType = this.m_defScalarField;
        this.m_basisType = 0;
        this.m_bChopField = false;
        this.m_bUseTotalCurv = false;
        this.m_bShowGradient = false;
        this.m_bShowVectorField = false;
        this.m_bShowColor = true;
        this.m_bAdjustColoring = true;
        this.m_bUseGrayLevel = false;
        this.m_bUseAbsValue = false;
        this.m_bNonLinColoring = false;
        this.m_bIgnoreOutliersWhenColoring = false;
        this.m_bUseSymmetricInterval = false;
        this.m_bInvertColor = false;
        this.m_chopMax.init();
        this.m_chopMin.init();
        this.m_chopMax.setEnabled(this.m_bChopField);
        this.m_chopMin.setEnabled(this.m_bChopField);
        this.m_colorMax.init();
        this.m_colorMin.init();
        this.m_curvRadius.init();
        int i = 0;
        while (i < 14) {
            this.m_bFieldAvailable[i] = true;
            ++i;
        }
        if (this.m_scalar != null) {
            this.m_scalar.init();
            this.m_scalar.setType(this.m_basisType);
        }
    }

    public void reset() {
        super.reset();
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
        }
        this.setGeometry(this.m_geom);
    }

    public boolean update(Object event) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (event == this.m_geom) {
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            return true;
        }
        if (event == this) {
            this.computeScalar(this.m_geom, this.m_scalarType);
            this.adjustChopSliders();
            this.m_chopMin.update((Object)this.m_chopMin);
            this.m_chopMax.update((Object)this.m_chopMax);
            if (this.m_bAdjustColoring) {
                this.adjustColorSliders();
                this.m_colorMax.update((Object)this.m_colorMax);
                this.m_colorMin.update((Object)this.m_colorMin);
            }
            this.updateGradient();
            if (this.m_bShowColor) {
                this.updateColor();
            }
            if (this.m_bChopField) {
                this.chopField();
            }
            this.updateGeometry();
            return super.update((Object)this);
        }
        if (event == this.m_curvRadius) {
            this.m_curvatures = PdVector.realloc(null, (int)this.m_geom.getNumVertices(), (int)2);
            PwShapeOperator.makeVertexBasedPrincipalCurvatures((PgElementSet)this.m_geom, (PdVector[])this.m_curvatures, (double)this.m_curvRadius.getValue());
            this.computeScalar(this.m_geom, this.m_scalarType);
            if (this.m_bAdjustColoring) {
                this.adjustColorSliders();
                this.m_colorMax.update((Object)this.m_colorMax);
                this.m_colorMin.update((Object)this.m_colorMin);
            }
            this.updateGradient();
            if (this.m_bShowColor) {
                this.updateColor();
            }
            this.updateGeometry();
            return super.update((Object)this);
        }
        if (event == this.m_chopMin || event == this.m_chopMax) {
            if (!this.m_bChopField) {
                return true;
            }
            this.chopField();
            this.updateGradient();
            this.updateColor();
            this.m_bUpdateSender = true;
            this.m_scalar.update((Object)this.m_scalar);
            this.m_bUpdateSender = false;
            this.updateGeometry();
            return true;
        }
        if (event == this.m_colorMax || event == this.m_colorMin) {
            if (this.m_bUseSymmetricInterval) {
                if (event == this.m_colorMax) {
                    this.m_colorMin.setValue(-this.m_colorMax.getValue());
                    this.m_colorMin.updatePanels((Object)this.m_colorMin);
                } else {
                    this.m_colorMax.setValue(-this.m_colorMin.getValue());
                    this.m_colorMax.updatePanels((Object)this.m_colorMax);
                }
            }
            this.updateColor();
            this.updateGeometry();
            return true;
        }
        if (event == this.m_scalar && !this.m_bUpdateSender) {
            this.adjustChopSliders();
            this.m_chopMin.update((Object)this.m_chopMin);
            this.m_chopMax.update((Object)this.m_chopMax);
            if (this.m_bAdjustColoring) {
                this.adjustColorSliders();
                this.m_colorMax.update((Object)this.m_colorMax);
                this.m_colorMin.update((Object)this.m_colorMin);
            }
            this.updateGradient();
            if (this.m_bShowColor) {
                this.updateColor();
            }
            if (this.m_bChopField) {
                this.chopField();
            }
            this.updateGeometry();
            return true;
        }
        return super.update(event);
    }

    private void updateGeometry() {
        this.m_bUpdateSender = true;
        this.m_geom.update((Object)this.m_geom);
        this.m_bUpdateSender = false;
    }

    public void cancel() {
        this.resetColors();
        super.cancel();
    }

    public void showOnlyGrayLevels(boolean gl) {
        this.m_bUseGrayLevel = gl;
    }

    public boolean isShowingOnlyGrayLevels(boolean gl) {
        return this.m_bUseGrayLevel;
    }

    public void setColorMin(double value) {
        this.m_colorMin.setValue(value);
    }

    public double getColorMin() {
        return this.m_colorMin.getValue();
    }

    public void setColorMax(double value) {
        this.m_colorMax.setValue(value);
    }

    public double getColorMax() {
        return this.m_colorMax.getValue();
    }

    public void setGeometry(PgElementSet geom) {
        if (geom.getDimOfElements() != 3) {
            PgElementSet.triangulate((PgElementSet)geom);
            geom.update((Object)geom);
        }
        super.setGeometry((PgGeometry)geom);
        this.m_geom = geom;
        this.m_scalar = null;
        PgVectorField vf = this.m_geom.getSelectedVectorField();
        if (vf != null && vf.getDimOfVectors() == 1) {
            this.m_scalar = vf;
            this.m_scalarType = 13;
            this.m_hasImportedFunction = true;
            boolean bNameAlreadyUsed = false;
            String name = vf.getName();
            int i = 0;
            while (i < 14) {
                if (name.equals(this.m_scalarFieldName[i])) {
                    bNameAlreadyUsed = true;
                    this.m_backUpNameOfField = new String(name);
                    break;
                }
                ++i;
            }
            if (!bNameAlreadyUsed) {
                this.m_scalarFieldName[13] = name;
            }
            this.backupImportedField();
        } else {
            this.m_bFieldAvailable[13] = false;
            this.m_scalar = new PgVectorField(1);
            this.m_scalar.setType(this.m_basisType);
            this.m_scalar.setGeometry((PgPointSet)this.m_geom);
            this.m_scalar.setVisible(false);
            this.m_geom.addVectorField(this.m_scalar);
        }
        if (this.m_geom.getDimOfVertices() < 4) {
            this.m_bFieldAvailable[3] = false;
        }
        if (this.m_geom.getDimOfVertices() < 3) {
            this.m_bFieldAvailable[2] = false;
        }
        if (this.m_geom.getDimOfVertices() < 2) {
            this.m_bFieldAvailable[1] = false;
        }
        if (this.m_geom.getDimOfElements() != 3) {
            this.m_bFieldAvailable[5] = false;
        }
        double diameter = this.m_geom.getDiameter();
        this.m_curvRadius.setBounds(0.0, 0.5 * diameter, diameter / 100.0, diameter / 10.0);
        this.computeScalar(this.m_geom, this.m_scalarType);
        this.adjustChopSliders();
        this.adjustColorSliders();
        this.m_chopMin.update((Object)this.m_chopMin);
        this.m_chopMax.update((Object)this.m_chopMax);
        this.m_colorMax.update((Object)this.m_colorMax);
        this.m_colorMin.update((Object)this.m_colorMin);
        this.updateGeometry();
        this.m_scalar.addUpdateListener((PsUpdateIf)this);
    }

    public int getScalarType() {
        return this.m_scalarType;
    }

    public void setScalarType(int type) {
        this.m_scalarType = type;
    }

    public void setAdjustColoring(boolean flag) {
        this.m_bAdjustColoring = flag;
    }

    public boolean getAdjustColoring() {
        return this.m_bAdjustColoring;
    }

    public String getScalarName(int type) {
        return this.m_scalarFieldName[type];
    }

    public boolean computeScalar() {
        return this.computeScalar((PgElementSet)this.getGeometry(), this.getScalarType());
    }

    public boolean computeScalar(PgElementSet geom, int type) {
        if (type < 0 || type >= 14) {
            PsDebug.warning((String)("scalar type out of bounds, type = " + type));
            return false;
        }
        PdVector dir = null;
        if (type == 0 || type == 1 || type == 2 || type == 3) {
            dir = new PdVector(geom.getDimOfVertices());
        }
        switch (type) {
            case 0: {
                dir.setEntry(0, 1.0);
                break;
            }
            case 1: {
                dir.setEntry(1, 1.0);
                break;
            }
            case 2: {
                dir.setEntry(2, 1.0);
                break;
            }
            case 3: {
                dir.setEntry(3, 1.0);
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                return false;
            }
        }
        int nov = geom.getNumVertices();
        PdVector[] vec = this.m_scalar.getVectors();
        if (type == 0 || type == 1 || type == 2 || type == 3) {
            PdVector[] bndBox = geom.getBounds();
            if (bndBox == null) {
                PsDebug.warning((String)"missing bounding box");
                return false;
            }
            int i = 0;
            while (i < nov) {
                double height;
                vec[i].m_data[0] = height = PdVector.dot((PdVector)dir, (PdVector)geom.getVertex(i));
                ++i;
            }
        } else if (type == 4) {
            if (this.m_curvRadius.getValue() > 0.0) {
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = this.m_curvatures[i].m_data[0] * this.m_curvatures[i].m_data[1];
                    ++i;
                }
            } else {
                PdVector gauss = new PdVector(nov);
                PwCurvature.getGaussCurvature((PgElementSet)geom, (PdVector)gauss);
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = gauss.m_data[i];
                    ++i;
                }
                if (!this.m_bUseTotalCurv) {
                    PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
                }
            }
        } else if (type == 5) {
            if (this.m_curvRadius.getValue() > 0.0) {
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = (this.m_curvatures[i].m_data[0] + this.m_curvatures[i].m_data[1]) / 2.0;
                    ++i;
                }
            } else {
                PdVector mean = new PdVector(nov);
                PwCurvature.getMeanCurvature((PgElementSet)geom, (PdVector)mean);
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = mean.m_data[i] / 2.0;
                    ++i;
                }
                if (!this.m_bUseTotalCurv) {
                    PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
                }
            }
        } else if (type == 6) {
            if (this.m_curvRadius.getValue() > 0.0) {
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = this.m_curvatures[i].m_data[0];
                    ++i;
                }
            } else {
                PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
                PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = pc[0].m_data[i];
                    ++i;
                }
                if (!this.m_bUseTotalCurv) {
                    PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
                }
            }
        } else if (type == 7) {
            if (this.m_curvRadius.getValue() > 0.0) {
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = this.m_curvatures[i].m_data[1];
                    ++i;
                }
            } else {
                PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
                PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
                int i = 0;
                while (i < nov) {
                    vec[i].m_data[0] = pc[1].m_data[i];
                    ++i;
                }
                if (!this.m_bUseTotalCurv) {
                    PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
                }
            }
        } else if (type == 8) {
            PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
            PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
            int i = 0;
            while (i < nov) {
                vec[i].m_data[0] = Math.abs(pc[0].m_data[i]) >= Math.abs(pc[1].m_data[i]) ? pc[0].m_data[i] : pc[1].m_data[i];
                ++i;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
            }
        } else if (type == 9) {
            PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
            PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
            int i = 0;
            while (i < nov) {
                vec[i].m_data[0] = Math.abs(pc[0].m_data[i]) >= Math.abs(pc[1].m_data[i]) ? pc[1].m_data[i] : pc[0].m_data[i];
                ++i;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
            }
        } else if (type == 10) {
            PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
            PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
            int i = 0;
            while (i < nov) {
                vec[i].m_data[0] = Math.abs(Math.abs(pc[0].m_data[i]) - Math.abs(pc[1].m_data[i]));
                ++i;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector[])this.m_scalar.getVectors(), (boolean)true);
            }
        } else if (type == 11) {
            PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
            PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector)pc[0], (boolean)true);
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector)pc[1], (boolean)true);
            }
            int i = 0;
            while (i < nov) {
                vec[i].m_data[0] = Math.sqrt(pc[0].m_data[i] * pc[0].m_data[i] + pc[1].m_data[i] * pc[1].m_data[i]);
                ++i;
            }
        } else if (type == 12) {
            PdVector[] pc = PdVector.realloc(null, (int)2, (int)nov);
            PwCurvature.getPrincipalCurvatures((PgElementSet)geom, (PdVector[])pc, null);
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector)pc[0], (boolean)true);
                PnMassMatrix.multInvMassMatrix((PgElementSet)this.m_geom, (PdVector)pc[1], (boolean)true);
            }
            int i = 0;
            while (i < nov) {
                vec[i].m_data[0] = pc[0].m_data[i] * pc[1].m_data[i];
                ++i;
            }
        } else if (type == 13 && this.m_backupOfImportedField != null) {
            this.restoreField(this.m_backupOfImportedField);
        }
        if (type == 13 && this.m_backUpNameOfField != null) {
            this.m_scalar.setName(this.m_backUpNameOfField);
        } else {
            this.m_scalar.setName(this.m_scalarFieldName[type]);
        }
        this.backupField();
        if (this.m_bUseAbsValue) {
            this.computeAbsField();
        }
        return true;
    }

    protected void computeAbsField() {
        int nov = this.m_geom.getNumVertices();
        PdVector[] vecs = this.m_scalar.getVectors();
        int i = 0;
        while (i < nov) {
            if (vecs[i].m_data[0] < 0.0) {
                vecs[i].m_data[0] = -vecs[i].m_data[0];
            }
            ++i;
        }
    }

    protected void updateColor() {
        boolean vertexBased;
        int nov = this.m_scalar.getNumVectors();
        if (nov <= 0) {
            return;
        }
        PdVector[] values = this.m_scalar.getVectors();
        double max = this.m_colorMax.getValue();
        double min = this.m_colorMin.getValue();
        double diff = 0.0;
        if (max - min > 1.0E-10) {
            diff = 1.0 / (max - min);
        }
        boolean bl = vertexBased = this.m_scalar.getBasedOn() == 0;
        if (this.m_bNonLinColoring) {
            int i = 0;
            while (i < nov) {
                Color c;
                double d = (values[i].m_data[0] - min) * diff;
                if (d < 1.0 && d > 0.0) {
                    d = 1.0 - (Math.cos(Math.PI * d) + 1.0) / 2.0;
                }
                if (this.m_bInvertColor) {
                    d = 1.0 - d;
                }
                Color color = c = this.m_bUseGrayLevel ? PwScalarFieldTmp.colorMapGray(d) : PwScalarFieldTmp.colorMapCurvature(d);
                if (vertexBased) {
                    this.m_geom.setVertexColor(i, c);
                } else {
                    this.m_geom.setElementColor(i, c);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nov) {
                Color c;
                double d = (values[i].m_data[0] - min) * diff;
                if (this.m_bInvertColor) {
                    d = 1.0 - d;
                }
                Color color = c = this.m_bUseGrayLevel ? PwScalarFieldTmp.colorMapGray(d) : PwScalarFieldTmp.colorMap(d);
                if (vertexBased) {
                    this.m_geom.setVertexColor(i, c);
                } else {
                    this.m_geom.setElementColor(i, c);
                }
                ++i;
            }
        }
    }

    protected void resetColors() {
        if (this.m_geomSave != null && this.m_geomSave instanceof PgElementSet) {
            PgElementSet gs = (PgElementSet)this.m_geomSave;
            this.m_geom.showElementColors(gs.isShowingElementColors());
            this.m_geom.showElementColorFromVertices(gs.isShowingElementColorFromVertices());
            this.m_geom.showElementBackColor(gs.isShowingElementBackColor());
        }
    }

    protected void updateGradient() {
        if (this.m_bShowGradient) {
            this.m_gradient = this.computeGradient(this.m_gradient);
            this.m_geom.addVectorField(this.m_gradient);
        }
        if (this.m_gradient != null) {
            this.m_gradient.setVisible(this.m_bShowGradient);
        }
    }

    protected void update3dVectorField() {
        if (this.m_bShowVectorField) {
            this.m_offsetVectorField = this.computer3dVectorField(this.m_offsetVectorField);
            this.m_geom.addVectorField(this.m_offsetVectorField);
        }
        if (this.m_offsetVectorField != null) {
            this.m_offsetVectorField.setVisible(this.m_bShowVectorField);
        }
    }

    protected void adjustChopSliders() {
        int nov = this.m_scalar.getNumVectors();
        if (nov < 1) {
            return;
        }
        PdVector[] values = this.m_scalar.getVectors();
        int[] sort = new int[nov];
        PuMath.heapsort((int)nov, (double[])PwScalarFieldTmp.scalarField2Array(this.m_scalar, null), (int[])sort);
        double min = 0.0;
        double max = values[sort[nov - 1 - nov / 10]].m_data[0];
        if (!this.m_bUseAbsValue) {
            min = values[sort[nov / 10]].m_data[0];
        }
        double diff = max - min;
        double totalMax = values[sort[nov - 1]].m_data[0];
        double totalMin = 0.0;
        if (!this.m_bUseAbsValue) {
            totalMin = values[sort[0]].m_data[0];
        }
        this.m_chopMin.setBounds(totalMin, totalMax, diff / 100.0, diff / 10.0);
        this.m_chopMax.setBounds(totalMin, totalMax, diff / 100.0, diff / 10.0);
        if (!this.m_bChopField) {
            this.m_chopMax.setValue(max);
            this.m_chopMin.setValue(min);
        }
    }

    protected void adjustColorSliders() {
        double diff;
        double max;
        int nov = this.m_scalar.getNumVectors();
        if (nov < 1) {
            return;
        }
        PdVector[] values = this.m_scalar.getVectors();
        double min = 0.0;
        if (this.m_bIgnoreOutliersWhenColoring) {
            int[] sort = new int[nov];
            PuMath.heapsort((int)nov, (double[])PwScalarFieldTmp.scalarField2Array(this.m_scalar, null), (int[])sort);
            max = values[sort[nov - 1 - nov / 10]].m_data[0];
            if (!this.m_bUseAbsValue) {
                min = values[sort[nov / 10]].m_data[0];
            }
            if (this.m_bUseSymmetricInterval && !this.m_bUseAbsValue) {
                if (max < -min) {
                    max = -min;
                } else {
                    min = -max;
                }
            }
            diff = max - min;
        } else {
            max = min = values[0].m_data[0];
            int i = 1;
            while (i < nov) {
                if (values[i].m_data[0] < min) {
                    min = values[i].m_data[0];
                } else if (values[i].m_data[0] > max) {
                    max = values[i].m_data[0];
                }
                ++i;
            }
            if (this.m_bUseAbsValue) {
                min = 0.0;
            }
            if (this.m_bUseSymmetricInterval && !this.m_bUseAbsValue) {
                if (max < -min) {
                    max = -min;
                } else {
                    min = -max;
                }
            }
            diff = max - min;
        }
        this.m_colorMin.setBounds(min - diff, max + diff, diff / 33.0, diff / 3.0);
        this.m_colorMax.setBounds(min - diff, max + diff, diff / 33.0, diff / 3.0);
        this.m_colorMax.setValue(max);
        this.m_colorMin.setValue(min);
    }

    protected void symmetrizeColorSliders() {
        double min;
        if (this.m_bUseAbsValue) {
            return;
        }
        double max = this.m_colorMax.getMax();
        if (max < -(min = this.m_colorMax.getMin())) {
            this.m_colorMin.setBounds(min, -min);
            this.m_colorMax.setBounds(min, -min);
        } else {
            this.m_colorMin.setBounds(-max, max);
            this.m_colorMax.setBounds(-max, max);
        }
        max = this.m_colorMax.getValue();
        min = this.m_colorMin.getValue();
        if (max < -min) {
            this.m_colorMax.setValue(-min);
        } else {
            this.m_colorMin.setValue(-max);
        }
    }

    protected void backupField() {
        PdVector[] vec = this.m_scalar.getVectors();
        int nov = this.m_scalar.getNumVectors();
        if (this.m_backupField == null) {
            this.m_backupField = new PdVector(nov);
        } else if (this.m_backupField.m_data.length < nov) {
            this.m_backupField.setSize(nov);
        }
        int i = 0;
        while (i < nov) {
            this.m_backupField.m_data[i] = vec[i].m_data[0];
            ++i;
        }
    }

    protected void backupImportedField() {
        PdVector[] vec = this.m_scalar.getVectors();
        int nov = this.m_scalar.getNumVectors();
        if (this.m_backupOfImportedField == null) {
            this.m_backupOfImportedField = new PdVector(nov);
        } else if (this.m_backupOfImportedField.m_data.length < nov) {
            this.m_backupOfImportedField.setSize(nov);
        }
        int i = 0;
        while (i < nov) {
            this.m_backupOfImportedField.m_data[i] = vec[i].m_data[0];
            ++i;
        }
    }

    protected void restoreField(PdVector data) {
        PdVector[] vec = this.m_scalar.getVectors();
        int nov = this.m_scalar.getNumVectors();
        int i = 0;
        while (i < nov) {
            vec[i].m_data[0] = data.m_data[i];
            ++i;
        }
    }

    protected void chopField() {
        int nov = this.m_scalar.getNumVectors();
        PdVector[] vec = this.m_scalar.getVectors();
        double min = this.m_chopMin.getValue();
        double max = this.m_chopMax.getValue();
        int i = 0;
        while (i < nov) {
            vec[i].m_data[0] = this.m_backupField.m_data[i] < min ? min : (this.m_backupField.m_data[i] > max ? max : this.m_backupField.m_data[i]);
            ++i;
        }
    }

    public PgVectorField computeGradient(PgVectorField gradient) {
        int dim = this.m_geom.getDimOfVertices();
        if (gradient == null) {
            gradient = new PgVectorField(dim);
        }
        gradient.setName(String.valueOf(PsConfig.getMessage((int)45078)) + " " + this.m_scalarFieldName[this.m_scalarType]);
        gradient.computeGradient(this.m_geom, this.m_scalar.getVectors(), 0);
        this.m_geom.addVectorField(gradient);
        return gradient;
    }

    public static PgVectorField array2ScalarField(PgPointSet domain, double[] func, PgVectorField scalarField) {
        if (domain == null) {
            PsDebug.warning((String)"specified domain is null.");
            return scalarField;
        }
        int nov = domain.getNumVertices();
        if (func == null || func.length != nov) {
            PsDebug.warning((String)"length of array specifying a piecewise linear function, does not match with the number of vertices of the domain.");
            return scalarField;
        }
        if (scalarField == null) {
            scalarField = new PgVectorField(1);
        }
        scalarField.setBasedOn(0);
        if (domain != scalarField.getGeometry()) {
            scalarField.setGeometry(domain);
        }
        PdVector[] vec = scalarField.getVectors();
        int i = 0;
        while (i < nov) {
            vec[i].m_data[0] = func[i];
            ++i;
        }
        return scalarField;
    }

    public static double[] scalarField2Array(PgVectorField scalarField, double[] func) {
        if (scalarField == null) {
            PsDebug.warning((String)"given scalar field is null.");
            return func;
        }
        int nov = scalarField.getNumVectors();
        if (func == null || func.length != nov) {
            func = new double[nov];
        }
        PdVector[] vec = scalarField.getVectors();
        int i = 0;
        while (i < nov) {
            func[i] = vec[i].m_data[0];
            ++i;
        }
        return func;
    }

    public static Color colorMapGray(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        float f = (float)d;
        return new Color(f, f, f);
    }

    private static final Color colorMapCurvature(double d) {
        float f;
        float g;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapCurvatureIntervals[0]) {
            d /= m_ColorMapCurvatureIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int len = m_ColorMapOldIntervals.length;
            int i = 1;
            while (i < len) {
                if (d < m_ColorMapCurvatureIntervals[i]) {
                    d -= m_ColorMapCurvatureIntervals[i - 1];
                    d /= m_ColorMapCurvatureIntervals[i] - m_ColorMapCurvatureIntervals[i - 1];
                    d *= m_ColorMapOldIntervals[i] - m_ColorMapOldIntervals[i - 1];
                    d += m_ColorMapOldIntervals[i - 1];
                    break;
                }
                ++i;
            }
        }
        if (d > 0.2) {
            g = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            g = (float)d;
        }
        return Color.getHSBColor(f, g, 1.0f);
    }

    public static Color colorMap(double d) {
        float f;
        float g;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapLinearIntervals[0]) {
            d /= m_ColorMapLinearIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int len = m_ColorMapOldIntervals.length;
            int i = 1;
            while (i < len) {
                if (d < m_ColorMapLinearIntervals[i]) {
                    d -= m_ColorMapLinearIntervals[i - 1];
                    d /= m_ColorMapLinearIntervals[i] - m_ColorMapLinearIntervals[i - 1];
                    d *= m_ColorMapOldIntervals[i] - m_ColorMapOldIntervals[i - 1];
                    d += m_ColorMapOldIntervals[i - 1];
                    break;
                }
                ++i;
            }
        }
        if (d > 0.2) {
            g = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            g = (float)d;
        }
        return Color.getHSBColor(f, g, 1.0f);
    }

    protected PgVectorField computer3dVectorField(PgVectorField vf) {
        vf = this.get3dVectorField(vf);
        this.m_geom.addVectorField(vf);
        return vf;
    }

    protected PgVectorField get3dVectorField(PgVectorField vf) {
        if (vf == null) {
            vf = new PgVectorField(3);
        }
        vf.setBasedOn(0);
        vf.setGeometry((PgPointSet)this.m_geom);
        vf.setName("Normal offset of " + this.m_scalar.getName());
        int nov = this.m_geom.getNumVertices();
        this.m_geom.assureVertexNormals();
        PdVector[] vn = this.m_geom.getVertexNormals();
        PdVector[] scal = this.m_scalar.getVectors();
        PdVector[] vect = vf.getVectors();
        int i = 0;
        while (i < nov) {
            vect[i].multScalar(vn[i], scal[i].m_data[0]);
            ++i;
        }
        return vf;
    }

    protected void showFunctionAsVertexLabels(boolean tag) {
        int nov = this.m_geom.getNumVertices();
        PdVector[] vertex = this.m_geom.getVertices();
        PdVector[] vecs = this.m_scalar.getVectors();
        if (tag) {
            int i = 0;
            while (i < nov) {
                vertex[i].setName(Double.toString(vecs[i].m_data[0]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < nov) {
                vertex[i].setName(Integer.toString(i));
                ++i;
            }
        }
    }
}

