/*
 * Decompiled with CFR 0.152.
 */
package dev.vector;

import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jvx.project.PjWorkshop;

public class PwInterpolateVectorFields
extends PjWorkshop {
    protected PgPointSet m_pointSet;
    protected PuDouble[] m_dWeight = new PuDouble[0];
    protected int m_numVectorFields = 0;
    protected PgVectorField[] m_vf;
    protected PgVectorField m_vfInterpolatedVertex;
    protected PgVectorField m_vfInterpolatedElement;
    protected int[] m_basedOn;
    protected int m_nov = -1;
    protected int m_noe = -1;

    public PwInterpolateVectorFields() {
        super("Vector Field Interpolation");
    }

    public void setGeometry(PgGeometry geom) {
        super.setGeometry(geom);
        this.m_pointSet = (PgPointSet)geom;
        this.m_numVectorFields = this.m_pointSet.getNumVectorFields();
        this.m_dWeight = new PuDouble[this.m_numVectorFields];
        this.m_basedOn = new int[this.m_numVectorFields];
        int i = 0;
        while (i < this.m_numVectorFields) {
            this.m_basedOn[i] = -1;
            ++i;
        }
        int vfDimV = -1;
        int vfDimE = -1;
        this.m_vf = new PgVectorField[this.m_numVectorFields];
        int i2 = 0;
        while (i2 < this.m_numVectorFields) {
            PgVectorField vf = this.m_pointSet.getVectorField(i2);
            String name = "";
            int dim = vf.getDimOfVectors();
            if (vf.getBasedOn() == 1) {
                name = String.valueOf(name) + "E ";
                this.m_noe = vf.getNumVectors();
                this.m_basedOn[i2] = 1;
                if (vfDimE != -1 && vfDimE != dim) {
                    PsDebug.warning((String)"Found element-based vector fields with different dimensions.");
                }
                if (vfDimE < dim) {
                    vfDimE = dim;
                }
                this.m_vf[i2] = vf;
            } else if (vf.getBasedOn() == 0) {
                name = String.valueOf(name) + "V ";
                this.m_nov = vf.getNumVectors();
                this.m_basedOn[i2] = 0;
                if (vfDimV != -1 && vfDimV != dim) {
                    PsDebug.warning((String)"Found vertex-based vector fields with different dimensions.");
                }
                if (vfDimV < dim) {
                    vfDimV = dim;
                }
                this.m_vf[i2] = vf;
            }
            name = String.valueOf(name) + i2 + " " + vf.getName();
            this.m_dWeight[i2] = new PuDouble(name, (PsUpdateIf)this);
            this.m_dWeight[i2].setDefBounds(-1.0, 1.0, 0.01, 0.1);
            this.m_dWeight[i2].setBounds(-1.0, 1.0, 0.01, 0.1);
            this.m_dWeight[i2].setDefValue(0.0);
            ++i2;
        }
        if (this.m_nov > -1) {
            this.m_vfInterpolatedVertex = new PgVectorField(vfDimV);
            this.m_vfInterpolatedVertex.setBasedOn(0);
            this.m_vfInterpolatedVertex.setNumVectors(this.m_nov);
            this.m_vfInterpolatedVertex.setName("Interpolated vertex-based field");
            this.m_vfInterpolatedVertex.setGeometry(this.m_pointSet);
            this.m_pointSet.addVectorField(this.m_vfInterpolatedVertex);
        }
        if (this.m_noe > -1) {
            this.m_vfInterpolatedElement = new PgVectorField(vfDimE);
            this.m_vfInterpolatedElement.setBasedOn(1);
            this.m_vfInterpolatedElement.setNumVectors(this.m_noe);
            this.m_vfInterpolatedElement.setName("Interpolated element-based field");
            this.m_vfInterpolatedElement.setGeometry(this.m_pointSet);
            this.m_pointSet.addVectorField(this.m_vfInterpolatedElement);
        }
    }

    public boolean update(Object event) {
        int i = 0;
        while (i < this.m_numVectorFields) {
            if (event == this.m_dWeight[i]) {
                this.interpolate();
                this.m_pointSet.update((Object)this.m_pointSet);
                return true;
            }
            ++i;
        }
        return super.update(event);
    }

    public void interpolate() {
        int i;
        if (this.m_nov > -1) {
            i = 0;
            while (i < this.m_nov) {
                this.m_vfInterpolatedVertex.getVector(i).setConstant(0.0);
                ++i;
            }
        }
        if (this.m_noe > -1) {
            i = 0;
            while (i < this.m_noe) {
                this.m_vfInterpolatedElement.getVector(i).setConstant(0.0);
                ++i;
            }
        }
        i = 0;
        while (i < this.m_numVectorFields) {
            int j;
            double weight = this.m_dWeight[i].getValue();
            if (this.m_basedOn[i] == 0) {
                j = 0;
                while (j < this.m_nov) {
                    this.m_vfInterpolatedVertex.getVector(j).add(weight, this.m_vf[i].getVector(j));
                    ++j;
                }
            } else if (this.m_basedOn[i] == 1) {
                j = 0;
                while (j < this.m_noe) {
                    this.m_vfInterpolatedElement.getVector(j).add(weight, this.m_vf[i].getVector(j));
                    ++j;
                }
            }
            ++i;
        }
    }
}

