/*
 * Decompiled with CFR 0.152.
 */
package dev.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PdDynVector {
    protected static final int FIRST_PAGE_SIZE = 8;
    protected static final double PAGE_GROWTH_FACTOR = 1.5;
    protected static final int PAGE_GROWTH_MINIMUM = 8;
    protected boolean m_reduceSize = false;
    protected int m_size;
    protected int m_numPages;
    protected PiVector m_pages;
    protected double[][] m_data;

    public PdDynVector() {
        this(0, 0);
    }

    public PdDynVector(int initialSize) {
        this(initialSize, initialSize);
    }

    public PdDynVector(int initialSize, int initialBufferSize) {
        if (initialSize > initialBufferSize) {
            PsDebug.warning((String)"Buffer size too small, set to initialSize");
            initialBufferSize = initialSize;
        }
        if (initialBufferSize > 0) {
            this.assureBufferSize(initialBufferSize);
        }
        this.m_size = initialSize;
    }

    public PdDynVector(PdVector arr) {
        this(arr.getSize());
        int size = arr.getSize();
        int i = 0;
        while (i < size) {
            this.setEntry(i, arr.m_data[i]);
            ++i;
        }
    }

    private int getPageInd(int ind) {
        int i = this.m_pages.indexOfValueInOrdering(ind);
        return this.m_pages.m_data[i] == ind ? i : i - 1;
    }

    private int getIndex(int ind, int page) {
        return ind - this.m_pages.m_data[page];
    }

    protected void assureBufferSize(int size) {
        if (this.m_data == null) {
            if (size > 0) {
                if (size < 8) {
                    size = 8;
                }
                this.m_data = new double[1][size];
                this.m_pages = new PiVector(0, size);
                this.m_numPages = 1;
            }
            return;
        }
        if (size > this.m_pages.getLastEntry()) {
            int bufferSize = this.m_pages.getLastEntry();
            int newBufferSize = Math.max((int)((double)bufferSize * 1.5), bufferSize + 8);
            int newPageSize = newBufferSize - bufferSize;
            ++this.m_numPages;
            this.m_pages.setSize(this.m_numPages + 1);
            double[][] newData = new double[this.m_numPages][];
            System.arraycopy(this.m_data, 0, newData, 0, this.m_numPages - 1);
            this.m_data = newData;
            this.m_data[this.m_numPages - 1] = new double[newPageSize];
            this.m_pages.m_data[this.m_numPages] = newBufferSize;
            return;
        }
        if (this.m_reduceSize && size < this.m_pages.m_data[this.m_numPages - 1] - 8) {
            int p = size < 0 ? -1 : this.getPageInd(size - 1);
            this.m_numPages = p + 1;
            this.m_pages.setSize(this.m_numPages + 1);
            double[][] newData = new double[this.m_numPages][];
            System.arraycopy(this.m_data, 0, newData, 0, this.m_numPages);
            this.m_data = newData;
            return;
        }
    }

    public void setSize(int size) {
        this.assureBufferSize(size);
        this.m_size = size;
    }

    public int getSize() {
        return this.m_size;
    }

    public boolean reduceSize() {
        return this.m_reduceSize;
    }

    public void setReduceSize(boolean reduceSize) {
        this.m_reduceSize = reduceSize;
    }

    public double getEntry(int ind) {
        if (ind < 0 || ind >= this.m_size) {
            PsDebug.warning((String)"Index out of range");
            return 0.0;
        }
        int p = this.getPageInd(ind);
        int i = this.getIndex(ind, p);
        return this.m_data[p][i];
    }

    public void setEntry(int ind, double entry) {
        if (ind < 0 || ind >= this.m_pages.getLastEntry()) {
            PsDebug.warning((String)"Index out of range");
            return;
        }
        int p = this.getPageInd(ind);
        int i = this.getIndex(ind, p);
        this.m_data[p][i] = entry;
    }

    public void appendEntry(double entry) {
        this.setSize(this.m_size + 1);
        this.setEntry(this.m_size - 1, entry);
    }

    public PdVector toPdVector() {
        return this.toPdVector(new PdVector());
    }

    public PdVector toPdVector(PdVector pdVector) {
        pdVector.setSize(this.m_size);
        int p = 0;
        int locInd = 0;
        int i = 0;
        while (i < this.m_size) {
            if (i == this.m_pages.m_data[p + 1]) {
                ++p;
                locInd = 0;
            }
            pdVector.m_data[i] = this.m_data[p][locInd];
            ++locInd;
            ++i;
        }
        return pdVector;
    }

    public static PdVector[] toPdVector(PdDynVector[] in) {
        int num = in.length;
        PdVector[] out = new PdVector[num];
        int i = 0;
        while (i < num) {
            out[i] = in[i].toPdVector();
            ++i;
        }
        return out;
    }

    public static PdDynVector[] realloc(PdDynVector[] data, int arraySize, int vectorSize) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            int j = 0;
            while (j < data.length) {
                if (data[j] == null) {
                    data[j] = new PdDynVector(vectorSize);
                } else if (data[j].m_data == null || data[j].m_data.length != vectorSize) {
                    data[j].setSize(vectorSize);
                }
                ++j;
            }
            return data;
        }
        PdDynVector[] newData = new PdDynVector[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = 0;
        while (i < commonSize) {
            if (newData[i] == null) {
                newData[i] = new PdDynVector(vectorSize);
            } else if (newData[i].m_data == null || newData[i].m_data.length != vectorSize) {
                newData[i].setSize(vectorSize);
            }
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdDynVector(vectorSize);
            ++i;
        }
        return newData;
    }

    public static PdDynVector[] realloc(PdDynVector[] data, int arraySize) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            int j = 0;
            while (j < data.length) {
                if (data[j] == null) {
                    data[j] = new PdDynVector(0);
                }
                ++j;
            }
            return data;
        }
        PdDynVector[] newData = new PdDynVector[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = 0;
        while (i < commonSize) {
            if (newData[i] == null) {
                newData[i] = new PdDynVector(0);
            }
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdDynVector(0);
            ++i;
        }
        return newData;
    }

    public String toString() {
        return this.toShortString();
    }

    public String toShortString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < this.m_size) {
            sb.append(this.getEntry(i));
            if (i < this.m_size - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public int indexOf(double element) {
        int idx = 0;
        int page = 0;
        while (page < this.m_numPages) {
            int i = 0;
            while (idx < this.m_size && i < this.m_data[page].length) {
                if (this.m_data[page][i] == element) {
                    return idx;
                }
                ++idx;
                ++i;
            }
            ++page;
        }
        return -1;
    }
}

