/*
 * Decompiled with CFR 0.152.
 */
package dev.util.sortedList;

import dev.util.sortedList.PuListElement;
import java.util.Comparator;

public class PuSortedList<T> {
    protected int length;
    protected PuListElement<T> head;
    protected Comparator<T> comparator;

    public PuSortedList(Comparator<T> comparator) {
        this.comparator = comparator;
        this.length = 0;
    }

    public void add(T element) {
        ++this.length;
        if (this.head == null) {
            this.head = new PuListElement<T>(element, this.head);
        } else if (this.comparator.compare(element, this.head.getElement()) > 0) {
            this.head = new PuListElement<T>(element, this.head);
        } else {
            PuListElement<T> currentElement = this.head;
            PuListElement<T> successor = currentElement.getSuccessor();
            while (successor != null && this.comparator.compare(element, successor.getElement()) < 0) {
                currentElement = successor;
                successor = currentElement.getSuccessor();
            }
            currentElement.setSuccessor(new PuListElement<T>(element, successor));
        }
    }

    public T peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.getElement();
    }

    public T pop() {
        if (this.head == null) {
            return null;
        }
        --this.length;
        T result = this.head.getElement();
        this.head = this.head.getSuccessor();
        return result;
    }

    public int getLength() {
        return this.length;
    }

    public PuListElement<T> getHead() {
        return this.head;
    }
}

