/*
 * Decompiled with CFR 0.152.
 */
package dev.util.kdtree;

public class PuKdTreeNode {
    private PuKdTreeNode left;
    private PuKdTreeNode right;
    private double splitValue;
    public static double noHyperplaneValue = Double.NaN;
    private int splitDim;
    public static int noHyperplaneDim = -1;
    private int index;
    private boolean isLeaf;

    public PuKdTreeNode(PuKdTreeNode left, PuKdTreeNode right, double splitValue, int splitDim, int index, boolean isLeaf) {
        this.index = index;
        this.isLeaf = isLeaf;
        if (isLeaf) {
            this.left = null;
            this.right = null;
            this.splitValue = noHyperplaneValue;
            this.splitDim = noHyperplaneDim;
        } else {
            this.left = left;
            this.right = right;
            this.splitValue = splitValue;
            this.splitDim = splitDim;
        }
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
        if (isLeaf) {
            this.left = null;
            this.right = null;
            this.splitValue = noHyperplaneValue;
            this.splitDim = noHyperplaneDim;
        }
    }

    public PuKdTreeNode getLeft() {
        return this.left;
    }

    public void setLeft(PuKdTreeNode left) {
        if (!this.isLeaf) {
            this.left = left;
        }
    }

    public PuKdTreeNode getRight() {
        return this.right;
    }

    public void setRight(PuKdTreeNode right) {
        if (!this.isLeaf) {
            this.right = right;
        }
    }

    public double getSplitValue() {
        return this.splitValue;
    }

    public void setSplitValue(double splitValue) {
        if (!this.isLeaf) {
            this.splitValue = splitValue;
        }
    }

    public int getSplitDim() {
        return this.splitDim;
    }

    public void setSplitDim(int splitDim) {
        if (!this.isLeaf) {
            this.splitDim = splitDim;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

