/*
 * Decompiled with CFR 0.152.
 */
package dev.util.kdtree;

import java.security.InvalidParameterException;
import java.util.Comparator;
import jv.geom.PgPointSet;
import jv.vecmath.PdVector;

public class PuKdTreeLexComp
implements Comparator<Integer> {
    private int startDimension;
    private int dimension;
    private PgPointSet pointSet;

    public PuKdTreeLexComp(int startDimension, int dimension, PgPointSet pointSet) throws InvalidParameterException {
        if (startDimension < 0 || dimension <= 0) {
            throw new InvalidParameterException("Can only initialize a Lexicographical Comparator on startDimensiongreater equal to 0 and dimension greater than 0, but was given startDimension  " + startDimension + " and dimension " + dimension + ".");
        }
        if (startDimension >= dimension) {
            throw new InvalidParameterException("Can only initialize a Lexicographical Comparator on a startDimension less than dimension, but was given dimension " + dimension + " and startDimension " + startDimension + ".");
        }
        if (pointSet == null) {
            throw new InvalidParameterException("Cannot build a comparator on a NULL point set.");
        }
        this.startDimension = startDimension;
        this.dimension = dimension;
        this.pointSet = pointSet;
    }

    @Override
    public int compare(Integer indexA, Integer indexB) {
        if (indexA < 0 || indexB < 0 || indexA > this.pointSet.getNumVertices() || indexB > this.pointSet.getNumVertices()) {
            throw new InvalidParameterException("At least one of the given indices lies out of range.");
        }
        int d = this.startDimension;
        PdVector arg0 = this.pointSet.getVertex(indexA.intValue());
        PdVector arg1 = this.pointSet.getVertex(indexB.intValue());
        if (arg0.getEntry(d) < arg1.getEntry(d)) {
            return -1;
        }
        if (arg0.getEntry(d) > arg1.getEntry(d)) {
            return 1;
        }
        d = (d + 1) % this.dimension;
        while (d != this.startDimension) {
            if (arg0.getEntry(d) < arg1.getEntry(d)) {
                return -1;
            }
            if (arg0.getEntry(d) > arg1.getEntry(d)) {
                return 1;
            }
            d = (d + 1) % this.dimension;
        }
        if (arg0.hashCode() > arg1.hashCode()) {
            return 1;
        }
        if (arg0.hashCode() < arg1.hashCode()) {
            return -1;
        }
        return 0;
    }

    public int getStartDimension() {
        return this.startDimension;
    }

    public void setStartDimension(int startDimension) throws InvalidParameterException {
        if (startDimension < 0) {
            throw new InvalidParameterException("Can only set startDimension to a value greater equal than 0, but was given value " + startDimension + ".");
        }
        if (startDimension >= this.dimension) {
            throw new InvalidParameterException("Can only set a startDimension strictly less to the dimension, but was set dimension " + this.dimension + " and given startDimension " + startDimension + ".");
        }
        this.startDimension = startDimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) throws InvalidParameterException {
        if (dimension <= 0) {
            throw new InvalidParameterException("Can only set dimension to a value strictly greater than 0, but was given value " + dimension + ".");
        }
        if (this.startDimension >= dimension) {
            throw new InvalidParameterException("Can only set a dimension strictly greater to the startDimension, but was given dimension " + dimension + " and set startDimension " + this.startDimension + ".");
        }
        this.dimension = dimension;
    }
}

