/*
 * Decompiled with CFR 0.152.
 */
package dev.util.kdtree;

import dev.util.PuNearestNeighborList;
import dev.util.kdtree.PuKdTreeLexComp;
import dev.util.kdtree.PuKdTreeNode;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PuKdTree {
    private PuKdTreeNode root;
    private int dimension;
    private PgPointSet pointSet;
    private PuKdTreeLexComp[] dimComparator;

    public PuKdTree(PgPointSet points) throws InvalidParameterException {
        if (points == null) {
            throw new InvalidParameterException("Can not instantiate a KdTree on a NULL point set.");
        }
        this.pointSet = points;
        this.dimension = points.getDimOfVertices();
        this.buildTree();
    }

    private void buildTree() throws InvalidParameterException {
        if (this.dimension <= 0) {
            throw new InvalidParameterException("Can not build a KdTree on dimension < 1, but was given dimension " + this.dimension + ".");
        }
        this.dimComparator = new PuKdTreeLexComp[this.dimension];
        int i = 0;
        while (i < this.dimension) {
            this.dimComparator[i] = new PuKdTreeLexComp(i, this.dimension, this.pointSet);
            ++i;
        }
        PdVector minBound = new PdVector(this.dimension);
        minBound.setConstant(Double.MAX_VALUE);
        PdVector maxBound = new PdVector(this.dimension);
        maxBound.setConstant(Double.MIN_VALUE);
        int nov = this.pointSet.getNumVertices();
        int i2 = 0;
        while (i2 < nov) {
            PdVector vertex = this.pointSet.getVertex(i2);
            int j = 0;
            while (j < this.dimension) {
                if (vertex.m_data[j] < minBound.m_data[j]) {
                    minBound.m_data[j] = vertex.m_data[j];
                }
                if (vertex.m_data[j] > maxBound.m_data[j]) {
                    maxBound.m_data[j] = vertex.m_data[j];
                }
                ++j;
            }
            ++i2;
        }
        int[] indices = new int[nov];
        int i3 = 0;
        while (i3 < nov) {
            indices[i3] = i3;
            ++i3;
        }
        this.root = this.recursiveBuild(indices, minBound, maxBound, 0, nov - 1);
    }

    private PuKdTreeNode recursiveBuild(int[] indices, PdVector minBound, PdVector maxBound, int left, int right) {
        if (left > right) {
            return null;
        }
        if (left == right) {
            return new PuKdTreeNode(null, null, PuKdTreeNode.noHyperplaneValue, PuKdTreeNode.noHyperplaneDim, indices[left], true);
        }
        int splitDim = 0;
        int i = 1;
        while (i < minBound.getSize()) {
            if (Math.abs(maxBound.getEntry(i) - minBound.getEntry(i)) > Math.abs(maxBound.getEntry(splitDim) - minBound.getEntry(splitDim))) {
                splitDim = i;
            }
            ++i;
        }
        PuKdTreeLexComp comparator = this.dimComparator[splitDim];
        int medianIndexInPointSet = this.median(indices, left, right, splitDim);
        LinkedList<Integer> smaller = new LinkedList<Integer>();
        LinkedList<Integer> larger = new LinkedList<Integer>();
        int i2 = left;
        while (i2 <= right) {
            int comp = comparator.compare(indices[i2], medianIndexInPointSet);
            if (comp < 0) {
                smaller.add(indices[i2]);
            }
            if (comp > 0) {
                larger.add(indices[i2]);
            }
            ++i2;
        }
        int numSmaller = smaller.size();
        int numLarger = larger.size();
        int i3 = 0;
        while (i3 < numSmaller) {
            indices[i3 + left] = (Integer)smaller.poll();
            ++i3;
        }
        indices[left + numSmaller] = medianIndexInPointSet;
        int j = 0;
        while (j < numLarger) {
            indices[left + numSmaller + 1 + j] = (Integer)larger.poll();
            ++j;
        }
        PdVector rightMinBound = PdVector.copyNew((PdVector)minBound);
        PdVector rightMaxBound = PdVector.copyNew((PdVector)maxBound);
        maxBound.setEntry(splitDim, this.pointSet.getVertex(medianIndexInPointSet).getEntry(splitDim));
        rightMinBound.setEntry(splitDim, this.pointSet.getVertex(medianIndexInPointSet).getEntry(splitDim));
        return new PuKdTreeNode(this.recursiveBuild(indices, minBound, maxBound, left, left + numSmaller - 1), this.recursiveBuild(indices, rightMinBound, rightMaxBound, left + numSmaller + 1, right), this.pointSet.getVertex(medianIndexInPointSet).getEntry(splitDim), splitDim, medianIndexInPointSet, false);
    }

    public int median(int[] indices, int left, int right, int dim) {
        ArrayList<Integer> list = new ArrayList<Integer>(right - left + 1);
        int i = left;
        while (i <= right) {
            list.add(indices[i]);
            ++i;
        }
        try {
            Collections.sort(list, this.dimComparator[dim]);
        }
        catch (IllegalArgumentException e) {
            PsDebug.error((String)"Could not build a k-d tree on the given points. Apparently at least one point coordinate is not comparable, e.g. it is NaN.");
        }
        return (Integer)list.get((list.size() - 1) / 2);
    }

    public PiVector getNearestNeighbors(PdVector input, int maxValence, double influence) throws InvalidParameterException {
        if (input == null) {
            throw new InvalidParameterException("Cannot compute neighbors around a NULL input.");
        }
        if (maxValence <= 0) {
            maxValence = this.pointSet.getNumVertices();
        }
        if (influence <= 0.0) {
            influence = Double.POSITIVE_INFINITY;
        }
        PuNearestNeighborList results = new PuNearestNeighborList();
        this.getNNRecursive(input, -1, maxValence, influence, this.root, results);
        return results.giveResult(-1, false);
    }

    public PiVector getNearestNeighbors(int input, int maxValence, double influence, boolean includeInput) throws InvalidParameterException {
        if (input < 0 || input >= this.pointSet.getNumVertices()) {
            throw new InvalidParameterException("Cannot compute neighbors around a NULL input.");
        }
        if (maxValence <= 0) {
            maxValence = this.pointSet.getNumVertices();
        }
        if (influence <= 0.0) {
            influence = Double.POSITIVE_INFINITY;
        }
        PuNearestNeighborList results = new PuNearestNeighborList();
        this.getNNRecursive(this.pointSet.getVertex(input), input, ++maxValence, influence, this.root, results);
        return results.giveResult(input, includeInput);
    }

    public PiVector getNearestNeighborsRelaxed(int input, int maxValence, double influence, boolean includeInput, boolean deleteCloseNeighbors) throws InvalidParameterException {
        if (input < 0 || input >= this.pointSet.getNumVertices()) {
            throw new InvalidParameterException("Cannot compute neighbors around a NULL input.");
        }
        if (maxValence <= 0) {
            maxValence = this.pointSet.getNumVertices();
        }
        if (influence <= 0.0) {
            influence = Double.POSITIVE_INFINITY;
        }
        PuNearestNeighborList results = new PuNearestNeighborList();
        this.getNNRecursive(this.pointSet.getVertex(input), input, ++maxValence, influence, this.root, results);
        double largestDistance = results.getWorstDistance();
        results = new PuNearestNeighborList();
        this.getNNRecursive(this.pointSet.getVertex(input), input, this.pointSet.getNumVertices(), largestDistance + Double.MIN_VALUE, this.root, results);
        PiVector neighborhood = results.giveResult(input, includeInput);
        if (deleteCloseNeighbors) {
            PiVector neighborhoodResult = new PiVector(0);
            int i = 0;
            while (i < neighborhood.getSize()) {
                if (this.pointSet.getVertex(neighborhood.getEntry(i)).dist(this.pointSet.getVertex(input)) > Double.MIN_VALUE) {
                    neighborhoodResult.addEntry(neighborhood.getEntry(i));
                }
                ++i;
            }
            return neighborhoodResult;
        }
        return neighborhood;
    }

    protected void getNNRecursive(PdVector input, int inputIndex, int maxValence, double influence, PuKdTreeNode currentPosition, PuNearestNeighborList results) {
        PuKdTreeNode secondSide;
        PuKdTreeNode firstSide;
        double currentPositionSplitDimCoordinate;
        if (currentPosition == null) {
            return;
        }
        PdVector currentPoint = this.pointSet.getVertex(currentPosition.getIndex());
        if (input.dist(currentPoint) <= influence) {
            results.addPointToResult(currentPosition.getIndex(), input.dist(currentPoint));
        }
        if (results.getNumberOfNeighbors() > maxValence) {
            results.removeCurrentWorst(inputIndex);
        }
        if (currentPosition.isLeaf()) {
            return;
        }
        int splitDim = currentPosition.getSplitDim();
        double inputSPlitDimCoordinate = input.getEntry(splitDim);
        if (inputSPlitDimCoordinate <= (currentPositionSplitDimCoordinate = currentPoint.getEntry(splitDim))) {
            firstSide = currentPosition.getLeft();
            secondSide = currentPosition.getRight();
        } else {
            firstSide = currentPosition.getRight();
            secondSide = currentPosition.getLeft();
        }
        this.getNNRecursive(input, inputIndex, maxValence, influence, firstSide, results);
        double distancetoHyperplane = Math.abs(inputSPlitDimCoordinate - currentPositionSplitDimCoordinate);
        if (influence >= distancetoHyperplane && (results.getNumberOfNeighbors() < maxValence || results.getWorstDistance() >= distancetoHyperplane)) {
            this.getNNRecursive(input, inputIndex, maxValence, influence, secondSide, results);
        }
    }

    public PuKdTreeNode getRoot() {
        return this.root;
    }

    public int getDepth() {
        return this.recursiveDepth(this.root);
    }

    public PgPointSet getPointSet() {
        return this.pointSet;
    }

    private int recursiveDepth(PuKdTreeNode node) {
        if (node == null) {
            return Integer.MIN_VALUE;
        }
        if (node.isLeaf()) {
            return 0;
        }
        return Math.max(this.recursiveDepth(node.getLeft()), this.recursiveDepth(node.getRight())) + 1;
    }

    public PgPolygonSet displayAllNeighborhoods(int maxValence, double influence) {
        PiVector[] neighborhoods = new PiVector[this.pointSet.getNumVertices()];
        PgPolygonSet neighborhoodDisplay = new PgPolygonSet();
        neighborhoodDisplay.setName("Neighborhoods");
        int i = 0;
        while (i < this.pointSet.getNumVertices()) {
            neighborhoodDisplay.addVertex(this.pointSet.getVertex(i));
            ++i;
        }
        i = 0;
        while (i < this.pointSet.getNumVertices()) {
            neighborhoods[i] = this.getNearestNeighbors(i, maxValence, influence, false);
            ++i;
        }
        i = 0;
        while (i < this.pointSet.getNumVertices()) {
            int j = 0;
            while (j < neighborhoods[i].getSize()) {
                PiVector relation = new PiVector(i, neighborhoods[i].getEntry(j));
                int n = neighborhoodDisplay.addPolygon(relation);
                ++j;
            }
            ++i;
        }
        return neighborhoodDisplay;
    }
}

