/*
 * Decompiled with CFR 0.152.
 */
package dev.util;

import dev.util.PuNearestNeighborListElement;
import jv.vecmath.PiVector;

public class PuNearestNeighborList {
    private PuNearestNeighborListElement head = null;

    public void addPointToResult(int index, double distanceToQuery) {
        if (this.head == null) {
            this.head = new PuNearestNeighborListElement(index, null, distanceToQuery);
        } else if (distanceToQuery >= this.head.getDistanceToInput()) {
            PuNearestNeighborListElement newHead;
            this.head = newHead = new PuNearestNeighborListElement(index, this.head, distanceToQuery);
        } else {
            PuNearestNeighborListElement predecessor = this.head;
            while (predecessor.getSuccessor() != null && predecessor.getSuccessor().getDistanceToInput() > distanceToQuery) {
                predecessor = predecessor.getSuccessor();
            }
            PuNearestNeighborListElement newElement = new PuNearestNeighborListElement(index, predecessor.getSuccessor(), distanceToQuery);
            predecessor.setSuccessor(newElement);
        }
    }

    public int getNumberOfNeighbors() {
        PuNearestNeighborListElement currentElement = this.head;
        int length = 0;
        while (currentElement != null) {
            ++length;
            currentElement = currentElement.getSuccessor();
        }
        return length;
    }

    public double getWorstDistance() {
        return this.head.getDistanceToInput();
    }

    public void removeCurrentWorst(int inputIndex) {
        if (this.head.getIndex() == inputIndex) {
            this.head.setSuccessor(this.head.getSuccessor().getSuccessor());
        } else {
            this.head = this.head.getSuccessor();
        }
    }

    public PiVector giveResult(int input, boolean includeInput) {
        PiVector result = new PiVector(0);
        PuNearestNeighborListElement currentElement = this.head;
        while (currentElement != null) {
            int currentIndex = currentElement.getIndex();
            if (currentIndex != input || includeInput) {
                result.addEntry(currentElement.getIndex());
            }
            currentElement = currentElement.getSuccessor();
        }
        return result;
    }
}

