/*
 * Decompiled with CFR 0.152.
 */
package dev.objectGui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jv.object.PsDebug;
import jv.objectGui.PsDropListenerIf;

public class PsDropTargetListener
implements DropTargetListener {
    protected PsDropListenerIf m_dropListener;
    private boolean m_bLogging = true;
    private static String ZERO_CHAR_STRING = "\u0000";

    public PsDropTargetListener(PsDropListenerIf dropListener) {
        this.m_dropListener = dropListener;
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
        PsDropTargetListener.log("FileDrop: dragEnter event.");
        if (this.isDragOk(evt)) {
            evt.acceptDrag(1);
            PsDropTargetListener.log("FileDrop: event accepted.");
        } else {
            evt.rejectDrag();
            PsDropTargetListener.log("FileDrop: event rejected.");
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        PsDropTargetListener.log("FileDrop: drop event.");
        try {
            Transferable tr = evt.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                evt.acceptDrop(1);
                PsDropTargetListener.log("FileDrop: file list accepted.");
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                File[] filesTemp = new File[fileList.size()];
                fileList.toArray(filesTemp);
                File[] files = filesTemp;
                if (this.m_dropListener != null) {
                    this.m_dropListener.filesDropped(files);
                }
                evt.getDropTargetContext().dropComplete(true);
                PsDropTargetListener.log("FileDrop: drop complete.");
            } else {
                DataFlavor[] flavors = tr.getTransferDataFlavors();
                boolean handled = false;
                int zz = 0;
                while (zz < flavors.length) {
                    if (flavors[zz].isRepresentationClassReader()) {
                        evt.acceptDrop(1);
                        PsDropTargetListener.log("FileDrop: reader accepted.");
                        Reader reader = flavors[zz].getReaderForText(tr);
                        BufferedReader br = new BufferedReader(reader);
                        if (this.m_dropListener != null) {
                            this.m_dropListener.filesDropped(PsDropTargetListener.createFileArray(br));
                        }
                        evt.getDropTargetContext().dropComplete(true);
                        PsDropTargetListener.log("FileDrop: drop complete.");
                        handled = true;
                        break;
                    }
                    ++zz;
                }
                if (!handled) {
                    PsDropTargetListener.log("FileDrop: not a file list or reader - abort.");
                    evt.rejectDrop();
                }
            }
        }
        catch (IOException io) {
            PsDropTargetListener.log("FileDrop: IOException - abort");
            evt.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            PsDropTargetListener.log("FileDrop: UnsupportedFlavorException - abort:");
            evt.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
        PsDropTargetListener.log("FileDrop: dragExit event.");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
        PsDropTargetListener.log("FileDrop: dropActionChanged event.");
        if (this.isDragOk(evt)) {
            evt.acceptDrag(1);
            PsDropTargetListener.log("FileDrop: event accepted.");
        } else {
            evt.rejectDrag();
            PsDropTargetListener.log("FileDrop: event rejected.");
        }
    }

    private boolean isDragOk(DropTargetDragEvent evt) {
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        int i = 0;
        while (!ok && i < flavors.length) {
            DataFlavor curFlavor = flavors[i];
            if (curFlavor.equals(DataFlavor.javaFileListFlavor) || curFlavor.isRepresentationClassReader()) {
                ok = true;
            }
            ++i;
        }
        if (this.m_bLogging) {
            if (flavors.length == 0) {
                PsDropTargetListener.log("PsDropHandler: no data flavors.");
            }
            i = 0;
            while (i < flavors.length) {
                PsDropTargetListener.log(flavors[i].toString());
                ++i;
            }
        }
        return ok;
    }

    private static File[] createFileArray(BufferedReader bReader) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (Exception ex) {
                    PsDropTargetListener.log("Error with " + line + ": " + ex.getMessage());
                }
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException ex) {
            PsDropTargetListener.log("PsDropHandler: IOException");
            return new File[0];
        }
    }

    private static void log(String message) {
        PsDebug.notify((String)message);
    }
}

