/*
 * Decompiled with CFR 0.152.
 */
package dev.objectGui;

import dev.objectGui.PsDropTargetListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DropTarget;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.TooManyListenersException;
import jv.object.PsDebug;
import jv.objectGui.PsDropHandlerIf;
import jv.objectGui.PsDropListenerIf;

public class PsDropHandler
implements PsDropHandlerIf {
    private transient PsDropTargetListener m_dropTargetListener;
    private static Boolean m_supportsDnD;

    public boolean configure(Component comp, boolean bRecursive, PsDropListenerIf dropListener) {
        if (!PsDropHandler.supportsDnD()) {
            PsDropHandler.log("PsDropHandler: Drag and drop is not supported with this JVM");
            return false;
        }
        this.m_dropTargetListener = new PsDropTargetListener(dropListener);
        this.makeDropTarget(comp, bRecursive);
        return true;
    }

    private static boolean supportsDnD() {
        if (m_supportsDnD == null) {
            boolean support = false;
            try {
                Class<?> arbitraryDndClass = Class.forName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            m_supportsDnD = new Boolean(support);
        }
        return m_supportsDnD;
    }

    private void makeDropTarget(final Component comp, boolean bRecursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.m_dropTargetListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            PsDropHandler.log("PsDropHandler: Drop will not work due to previous error. Do you have another listener attached?");
        }
        comp.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                PsDropHandler.log("PsDropHandler: Hierarchy changed.");
                Container parent = comp.getParent();
                if (parent == null) {
                    comp.setDropTarget(null);
                    PsDropHandler.log("PsDropHandler: Drop target cleared from component.");
                } else {
                    new DropTarget(comp, PsDropHandler.this.m_dropTargetListener);
                    PsDropHandler.log("PsDropHandler: Drop target added to component.");
                }
            }
        });
        if (comp.getParent() != null) {
            new DropTarget(comp, this.m_dropTargetListener);
        }
        if (bRecursive && comp instanceof Container) {
            Container cont = (Container)comp;
            Component[] comps = cont.getComponents();
            int i = 0;
            while (i < comps.length) {
                this.makeDropTarget(comps[i], bRecursive);
                ++i;
            }
        }
    }

    public static boolean remove(Component comp) {
        return PsDropHandler.remove(comp, true);
    }

    public static boolean remove(Component comp, boolean bRecursive) {
        if (!PsDropHandler.supportsDnD()) {
            return false;
        }
        PsDropHandler.log("PsDropHandler: Removing drag-and-drop hooks.");
        comp.setDropTarget(null);
        if (bRecursive && comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            int i = 0;
            while (i < comps.length) {
                PsDropHandler.remove(comps[i], bRecursive);
                ++i;
            }
            return true;
        }
        return false;
    }

    private static void log(String message) {
        PsDebug.notify((String)message);
    }
}

