/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PuSparseMatrix {
    public static boolean test = false;

    public static void getReducedSystemMatrix(PnSparseMatrix in, PnSparseMatrix out, boolean[] fixed, PiVector tmpIntVector) {
        int numVars = in.getNumRows();
        int numFree = 0;
        int i = 0;
        while (i < numVars) {
            if (!fixed[i]) {
                ++numFree;
            }
            ++i;
        }
        if (out == null) {
            out = new PnSparseMatrix();
        }
        if (out.getNumRows() != numFree || out.getNumCols() != numFree) {
            out.setSize(numFree, numFree);
        }
        PiVector snoe = in.getNumEntries();
        PiVector[] sindx = in.getColIndices();
        PdVector[] stiff = in.getEntries();
        PiVector outsnoe = out.getNumEntries();
        PiVector[] outsindx = out.getColIndices();
        PdVector[] outstiff = out.getEntries();
        if (tmpIntVector == null) {
            tmpIntVector = new PiVector();
        }
        if (tmpIntVector.getSize() < numVars) {
            tmpIntVector.setSize(numVars);
        }
        int[] table = tmpIntVector.m_data;
        int cnti = 0;
        int i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                table[i2] = cnti++;
            }
            ++i2;
        }
        cnti = 0;
        int i3 = 0;
        while (i3 < numVars) {
            if (!fixed[i3]) {
                int cntj = 0;
                int j = 0;
                while (j < snoe.m_data[i3]) {
                    if (!fixed[sindx[i3].m_data[j]]) {
                        ++cntj;
                    }
                    ++j;
                }
                outsnoe.m_data[cnti] = cntj;
                if (outsindx[cnti].m_data.length < cntj) {
                    outsindx[cnti].setSize(cntj);
                    outstiff[cnti].setSize(cntj);
                }
                cntj = 0;
                j = 0;
                while (j < snoe.m_data[i3]) {
                    if (!fixed[sindx[i3].m_data[j]]) {
                        outsindx[cnti].m_data[cntj] = table[sindx[i3].m_data[j]];
                        outstiff[cnti].m_data[cntj] = stiff[i3].m_data[j];
                        ++cntj;
                    }
                    ++j;
                }
                ++cnti;
            }
            ++i3;
        }
    }

    public static void getReducedSystemRV(PnSparseMatrix in, PdVector xIn, PdVector bIn, PdVector bOut, boolean[] fixed, PiVector tmpIntVector) {
        PuSparseMatrix.getReducedSystemRV(in, xIn, bIn, bOut, fixed, 1, tmpIntVector);
    }

    public static void getReducedSystemRV(PnSparseMatrix in, PdVector xIn, PdVector bIn, PdVector bOut, boolean[] fixed, int dim, PiVector tmpIntVector) {
        int j;
        int b;
        int a;
        int numVars = in.getNumRows();
        int numFree = 0;
        int i = 0;
        while (i < numVars) {
            if (!fixed[i]) {
                ++numFree;
            }
            ++i;
        }
        if (bOut == null) {
            bOut = new PdVector();
        }
        if (bOut.getSize() != numFree) {
            bOut.setSize(numFree);
        }
        bOut.setSize(numFree);
        if (tmpIntVector == null) {
            tmpIntVector = new PiVector();
        }
        if (tmpIntVector.getSize() < numVars) {
            tmpIntVector.setSize(numVars);
        }
        int[] table = tmpIntVector.m_data;
        int cnti = 0;
        int i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                table[i2] = cnti++;
            }
            ++i2;
        }
        cnti = 0;
        i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                a = dim * cnti;
                b = dim * i2;
                j = 0;
                while (j < dim) {
                    bOut.m_data[a + j] = bIn.m_data[b + j];
                    ++j;
                }
                ++cnti;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                int b2 = dim * i2;
                int j2 = 0;
                while (j2 < dim) {
                    xIn.m_data[b2 + j2] = 0.0;
                    ++j2;
                }
            }
            ++i2;
        }
        PnSparseMatrix.rightMultVector((PnSparseMatrix)in, (PdVector)xIn, (PdVector)bIn, (int)dim);
        cnti = 0;
        i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                a = dim * cnti;
                b = dim * i2;
                j = 0;
                while (j < dim) {
                    int n = a + j;
                    bOut.m_data[n] = bOut.m_data[n] - bIn.m_data[b + j];
                    ++j;
                }
                ++cnti;
            }
            ++i2;
        }
    }

    public static PnSparseMatrix one2nD(PnSparseMatrix in, PnSparseMatrix out, int d) {
        int ni = in.getNumRows();
        int nj = in.getNumCols();
        if (out == null) {
            out = new PnSparseMatrix();
        }
        if (out.getNumRows() != d * ni || out.getNumCols() != d * nj) {
            out.setSize(d * ni, d * nj);
        }
        PiVector snoe = in.getNumEntries();
        PiVector[] sindx = in.getColIndices();
        PdVector[] stiff = in.getEntries();
        PiVector outsnoe = out.getNumEntries();
        PiVector[] outsindx = out.getColIndices();
        PdVector[] outstiff = out.getEntries();
        int i = 0;
        while (i < ni) {
            int j = i * d;
            int k = 0;
            while (k < d) {
                outsnoe.m_data[j + k] = snoe.m_data[i];
                outsindx[j + k].setSize(snoe.m_data[i]);
                outstiff[j + k].setSize(snoe.m_data[i]);
                int l = 0;
                while (l < snoe.m_data[i]) {
                    outsindx[j + k].m_data[l] = d * sindx[i].m_data[l] + k;
                    outstiff[j + k].m_data[l] = stiff[i].m_data[l];
                    ++l;
                }
                ++k;
            }
            ++i;
        }
        return out;
    }

    protected static void getReducedSystem(PnSparseMatrix in, PnSparseMatrix out, PdVector bIn, PdVector bOut, int dim, int numVars, boolean[] fixed, int[] store) {
        int ni = in.getNumRows();
        if (out == null) {
            out = new PnSparseMatrix();
        }
        if (out.getNumRows() != numVars || out.getNumCols() != numVars) {
            out.setSize(numVars, numVars);
        }
        PiVector snoe = in.getNumEntries();
        PiVector[] sindx = in.getColIndices();
        PdVector[] stiff = in.getEntries();
        PiVector outsnoe = out.getNumEntries();
        PiVector[] outsindx = out.getColIndices();
        PdVector[] outstiff = out.getEntries();
        bOut.setSize(numVars);
        int[] table = store;
        if (table == null) {
            table = new int[ni];
        }
        int cnti = 0;
        int i = 0;
        while (i < ni) {
            if (!fixed[i]) {
                table[i] = cnti++;
            }
            ++i;
        }
        cnti = 0;
        int i2 = 0;
        while (i2 < ni) {
            if (!fixed[i2]) {
                int j = 0;
                while (j < dim) {
                    int a = dim * cnti;
                    int b = dim * i2;
                    bOut.m_data[a + j] = bIn.m_data[b + j];
                    ++j;
                }
                int cntj = 0;
                j = 0;
                while (j < snoe.m_data[i2]) {
                    if (!fixed[sindx[i2].m_data[j]]) {
                        ++cntj;
                    }
                    ++j;
                }
                outsnoe.m_data[cnti] = cntj;
                if (outsindx[cnti].m_data.length < cntj) {
                    outsindx[cnti].setSize(cntj);
                    outstiff[cnti].setSize(cntj);
                }
                cntj = 0;
                j = 0;
                while (j < snoe.m_data[i2]) {
                    if (!fixed[sindx[i2].m_data[j]]) {
                        outsindx[cnti].m_data[cntj] = table[sindx[i2].m_data[j]];
                        outstiff[cnti].m_data[cntj] = stiff[i2].m_data[j];
                        ++cntj;
                    }
                    ++j;
                }
                ++cnti;
            }
            ++i2;
        }
    }

    public static void getReducedSystem(PnSparseMatrix in, PnSparseMatrix out, PdVector xIn, PdVector bIn, PdVector bOut, boolean[] fixed, PiVector tmpIntVector) {
        PuSparseMatrix.getReducedSystem(in, out, xIn, bIn, bOut, fixed, 1, tmpIntVector);
    }

    public static void enlargeReducedSolutionVector(PdVector x, boolean[] fixed, PdVector xSolution) {
        int fullDim = x.getSize();
        int freeVarInd = 0;
        int i = 0;
        while (i < fullDim) {
            if (!fixed[i]) {
                x.m_data[i] = xSolution.m_data[freeVarInd++];
            }
            ++i;
        }
    }

    public static void enlargeReducedSolutionVector(PdVector xIn, boolean[] fixed, PdVector xSolution, PdVector xOut) {
        int fullDim = xIn.getSize();
        xOut.setSize(fullDim);
        int freeVarInd = 0;
        int i = 0;
        while (i < fullDim) {
            xOut.m_data[i] = fixed[i] ? xIn.m_data[i] : xSolution.m_data[freeVarInd++];
            ++i;
        }
    }

    public static void getReducedSystem(PnSparseMatrix in, PnSparseMatrix out, PdVector xIn, PdVector bIn, PdVector bOut, boolean[] fixed, int dim, PiVector tmpIntVector) {
        int j;
        int j2;
        int b;
        int a;
        int numVars = in.getNumRows();
        int numFree = 0;
        int i = 0;
        while (i < numVars) {
            if (!fixed[i]) {
                ++numFree;
            }
            ++i;
        }
        if (out == null) {
            out = new PnSparseMatrix();
        }
        if (out.getNumRows() != numFree || out.getNumCols() != numFree) {
            out.setSize(numFree, numFree);
        }
        if (bOut == null) {
            bOut = new PdVector();
        }
        if (bOut.getSize() != numFree) {
            bOut.setSize(numFree);
        }
        PiVector snoe = in.getNumEntries();
        PiVector[] sindx = in.getColIndices();
        PdVector[] stiff = in.getEntries();
        PiVector outsnoe = out.getNumEntries();
        PiVector[] outsindx = out.getColIndices();
        PdVector[] outstiff = out.getEntries();
        bOut.setSize(numFree);
        if (tmpIntVector == null) {
            tmpIntVector = new PiVector();
        }
        if (tmpIntVector.getSize() < numVars) {
            tmpIntVector.setSize(numVars);
        }
        int[] table = tmpIntVector.m_data;
        int cnti = 0;
        int i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                table[i2] = cnti++;
            }
            ++i2;
        }
        cnti = 0;
        i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                a = dim * cnti;
                b = dim * i2;
                j2 = 0;
                while (j2 < dim) {
                    bOut.m_data[a + j2] = bIn.m_data[b + j2];
                    ++j2;
                }
                ++cnti;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                int b2 = dim * i2;
                j = 0;
                while (j < dim) {
                    xIn.m_data[b2 + j] = 0.0;
                    ++j;
                }
            }
            ++i2;
        }
        PnSparseMatrix.rightMultVector((PnSparseMatrix)in, (PdVector)xIn, (PdVector)bIn, (int)dim);
        cnti = 0;
        i2 = 0;
        while (i2 < numVars) {
            if (!fixed[i2]) {
                a = dim * cnti;
                b = dim * i2;
                j2 = 0;
                while (j2 < dim) {
                    int n = a + j2;
                    bOut.m_data[n] = bOut.m_data[n] - bIn.m_data[b + j2];
                    ++j2;
                }
                ++cnti;
            }
            ++i2;
        }
        cnti = 0;
        int i3 = 0;
        while (i3 < numVars) {
            if (!fixed[i3]) {
                int cntj = 0;
                j = 0;
                while (j < snoe.m_data[i3]) {
                    if (!fixed[sindx[i3].m_data[j]]) {
                        ++cntj;
                    }
                    ++j;
                }
                outsnoe.m_data[cnti] = cntj;
                if (outsindx[cnti].m_data.length < cntj) {
                    outsindx[cnti].setSize(cntj);
                    outstiff[cnti].setSize(cntj);
                }
                cntj = 0;
                j = 0;
                while (j < snoe.m_data[i3]) {
                    if (!fixed[sindx[i3].m_data[j]]) {
                        outsindx[cnti].m_data[cntj] = table[sindx[i3].m_data[j]];
                        outstiff[cnti].m_data[cntj] = stiff[i3].m_data[j];
                        ++cntj;
                    }
                    ++j;
                }
                ++cnti;
            }
            ++i3;
        }
    }

    public static final PdVector getDiagonal(PnSparseMatrix smat, PdVector diag) {
        int n = smat.getNumRows();
        if (diag == null) {
            diag = new PdVector(n);
        } else if (diag.m_data.length < n) {
            diag.setSize(n);
        }
        int i = 0;
        while (i < n) {
            diag.m_data[i] = smat.getEntry(i, i);
            ++i;
        }
        return diag;
    }

    public static final PdVector getfirstUpperOffDiagonal(PnSparseMatrix smat, PdVector firstUpperOffDiag, boolean cyclic) {
        int n = smat.getNumRows();
        if (firstUpperOffDiag == null) {
            firstUpperOffDiag = new PdVector(n);
        } else if (firstUpperOffDiag.m_data.length < n) {
            firstUpperOffDiag.setSize(n);
        }
        int i = 0;
        while (i < n - 1) {
            firstUpperOffDiag.m_data[i] = smat.getEntry(i, i + 1);
            ++i;
        }
        firstUpperOffDiag.m_data[n - 1] = cyclic ? smat.getEntry(n - 1, 0) : 0.0;
        return firstUpperOffDiag;
    }

    public static final PdVector getSecondUpperOffDiagonal(PnSparseMatrix smat, PdVector secondUpperOffDiag, boolean cyclic) {
        int n = smat.getNumRows();
        if (secondUpperOffDiag == null) {
            secondUpperOffDiag = new PdVector(n);
        } else if (secondUpperOffDiag.m_data.length < n) {
            secondUpperOffDiag.setSize(n);
        }
        int i = 0;
        while (i < n - 2) {
            secondUpperOffDiag.m_data[i] = smat.getEntry(i, i + 2);
            ++i;
        }
        if (cyclic) {
            secondUpperOffDiag.m_data[n - 2] = smat.getEntry(n - 2, 0);
            secondUpperOffDiag.m_data[n - 1] = smat.getEntry(n - 1, 1);
        } else {
            secondUpperOffDiag.m_data[n - 1] = 0.0;
            secondUpperOffDiag.m_data[n - 2] = 0.0;
        }
        return secondUpperOffDiag;
    }

    public static final PdVector getfirstLowerOffDiagonal(PnSparseMatrix smat, PdVector firstLowerOffDiag, boolean cyclic) {
        int n = smat.getNumRows();
        if (firstLowerOffDiag == null) {
            firstLowerOffDiag = new PdVector(n);
        } else if (firstLowerOffDiag.m_data.length < n) {
            firstLowerOffDiag.setSize(n);
        }
        int i = 1;
        while (i < n) {
            firstLowerOffDiag.m_data[i] = smat.getEntry(i, i - 1);
            ++i;
        }
        firstLowerOffDiag.m_data[0] = cyclic ? smat.getEntry(0, n - 1) : 0.0;
        return firstLowerOffDiag;
    }

    public static final PdVector getsecondLowerOffDiagonal(PnSparseMatrix smat, PdVector secondLowerOffDiag, boolean cyclic) {
        int n = smat.getNumRows();
        if (secondLowerOffDiag == null) {
            secondLowerOffDiag = new PdVector(n);
        } else if (secondLowerOffDiag.m_data.length < n) {
            secondLowerOffDiag.setSize(n);
        }
        int i = 2;
        while (i < n) {
            secondLowerOffDiag.m_data[i] = smat.getEntry(i, i - 2);
            ++i;
        }
        if (cyclic) {
            secondLowerOffDiag.m_data[0] = smat.getEntry(0, n - 2);
            secondLowerOffDiag.m_data[1] = smat.getEntry(1, n - 1);
        } else {
            secondLowerOffDiag.m_data[0] = 0.0;
            secondLowerOffDiag.m_data[1] = 0.0;
        }
        return secondLowerOffDiag;
    }

    public static final PdVector solvePentaDiagonalCyclic(PnSparseMatrix smat, PdVector s, PdVector[] band) {
        int n = smat.getNumRows();
        if (band == null || band.length != 5) {
            band = PdVector.realloc((PdVector[])band, (int)5, (int)n);
        } else {
            int i = 0;
            while (i < 5) {
                if (band[i] == null) {
                    band[i] = new PdVector(n);
                } else if (band[i].m_data.length < n) {
                    band[i].setSize(n);
                }
                ++i;
            }
        }
        band[0] = PuSparseMatrix.getsecondLowerOffDiagonal(smat, band[0], true);
        band[1] = PuSparseMatrix.getfirstLowerOffDiagonal(smat, band[1], true);
        band[2] = PuSparseMatrix.getDiagonal(smat, band[2]);
        band[3] = PuSparseMatrix.getfirstUpperOffDiagonal(smat, band[3], true);
        band[4] = PuSparseMatrix.getSecondUpperOffDiagonal(smat, band[4], true);
        PuSparseMatrix.pentacyclic(n, band[0].m_data, band[1].m_data, band[2].m_data, band[3].m_data, band[4].m_data, s.m_data);
        return s;
    }

    public static void main(String[] args) {
        double[][] entries = new double[][]{{2.0, 2.0, 3.0}, {2.0, 3.0, 1.0}, {3.0, 1.0, 4.0}};
        PdMatrix mat = new PdMatrix((double[][])entries);
        PnSparseMatrix smat = new PnSparseMatrix(mat);
        smat.getEntries();
    }

    protected static double[] pentacyclic(int n, double[] l2, double[] l1, double[] diag, double[] u1, double[] u2, double[] x) {
        double v;
        int n1 = --n - 1;
        int n2 = n - 2;
        int n3 = n - 3;
        int n4 = n - 4;
        double g = l2[1];
        l2[1] = 0.0;
        double h = 0.0;
        diag[0] = 1.0 / diag[0];
        int i = 1;
        while (i <= n - 4) {
            int i1 = i - 1;
            int i2 = i + 1;
            v = l1[i] * diag[i1];
            int n5 = i;
            diag[n5] = diag[n5] - v * u1[i1];
            int n6 = i;
            u1[n6] = u1[n6] - v * u2[i1];
            l1[i] = g - v * l1[i1];
            int n7 = i;
            l2[n7] = l2[n7] - v * l2[i1];
            int n8 = i;
            x[n8] = x[n8] - v * x[i1];
            v = l2[i2] * diag[i1];
            int n9 = i2;
            l1[n9] = l1[n9] - v * u1[i1];
            int n10 = i2;
            diag[n10] = diag[n10] - v * u2[i1];
            l2[i2] = -v * l2[i1];
            g = -v * l1[i1];
            int n11 = i2;
            x[n11] = x[n11] - v * x[i1];
            v = u2[n1] * diag[i1];
            int n12 = n1;
            diag[n12] = diag[n12] - v * l2[i1];
            int n13 = n1;
            u1[n13] = u1[n13] - v * l1[i1];
            u2[n1] = h - v * u1[i1];
            h = -v * u2[i1];
            int n14 = n1;
            x[n14] = x[n14] - v * x[i1];
            v = u1[n] * diag[i1];
            u1[n] = u2[n] - v * u1[i1];
            u2[n] = -v * u2[i1];
            int n15 = n;
            l1[n15] = l1[n15] - v * l2[i1];
            int n16 = n;
            diag[n16] = diag[n16] - v * l1[i1];
            int n17 = n;
            x[n17] = x[n17] - v * x[i1];
            diag[i] = 1.0 / diag[i];
            ++i;
        }
        int n18 = n3;
        u2[n18] = u2[n18] + l2[n3];
        l2[n3] = g;
        l2[n1] = l2[n1] + h;
        i = n - 3;
        v = l1[n3] * diag[n4];
        int n19 = n3;
        diag[n19] = diag[n19] - v * u1[n4];
        int n20 = n3;
        x[n20] = x[n20] - v * x[n4];
        int n21 = n3;
        u1[n21] = u1[n21] - v * u2[n4];
        int n22 = n3;
        u2[n22] = u2[n22] - v * l2[n4];
        int n23 = n3;
        l2[n23] = l2[n23] - v * l1[n4];
        v = l2[n2] * diag[n4];
        int n24 = n2;
        l1[n24] = l1[n24] - v * u1[n4];
        int n25 = n2;
        diag[n25] = diag[n25] - v * u2[n4];
        int n26 = n2;
        x[n26] = x[n26] - v * x[n4];
        int n27 = n2;
        u1[n27] = u1[n27] - v * l2[n4];
        int n28 = n2;
        u2[n28] = u2[n28] - v * l1[n4];
        v = u2[n1] * diag[n4];
        int n29 = n1;
        l2[n29] = l2[n29] - v * u1[n4];
        int n30 = n1;
        l1[n30] = l1[n30] - v * u2[n4];
        int n31 = n1;
        x[n31] = x[n31] - v * x[n4];
        int n32 = n1;
        diag[n32] = diag[n32] - v * l2[n4];
        int n33 = n1;
        u1[n33] = u1[n33] - v * l1[n4];
        v = u1[n] * diag[n4];
        int n34 = n;
        u2[n34] = u2[n34] - v * u1[n4];
        int n35 = n;
        l2[n35] = l2[n35] - v * u2[n4];
        int n36 = n;
        l1[n36] = l1[n36] - v * l2[n4];
        int n37 = n;
        diag[n37] = diag[n37] - v * l1[n4];
        int n38 = n;
        x[n38] = x[n38] - v * x[n4];
        diag[n3] = 1.0 / diag[n3];
        i = n - 2;
        v = l1[n2] * diag[n3];
        int n39 = n2;
        diag[n39] = diag[n39] - v * u1[n3];
        int n40 = n2;
        x[n40] = x[n40] - v * x[n3];
        int n41 = n2;
        u1[n41] = u1[n41] - v * u2[n3];
        int n42 = n2;
        u2[n42] = u2[n42] - v * l2[n3];
        v = l2[n1] * diag[n3];
        int n43 = n1;
        l1[n43] = l1[n43] - v * u1[n3];
        int n44 = n1;
        diag[n44] = diag[n44] - v * u2[n3];
        int n45 = n1;
        x[n45] = x[n45] - v * x[n3];
        int n46 = n1;
        u1[n46] = u1[n46] - v * l2[n3];
        v = u2[n] * diag[n3];
        int n47 = n;
        l2[n47] = l2[n47] - v * u1[n3];
        int n48 = n;
        l1[n48] = l1[n48] - v * u2[n3];
        int n49 = n;
        x[n49] = x[n49] - v * x[n3];
        int n50 = n;
        diag[n50] = diag[n50] - v * l2[n3];
        diag[n2] = 1.0 / diag[n2];
        i = n - 1;
        v = l1[n1] * diag[n2];
        int n51 = n1;
        diag[n51] = diag[n51] - v * u1[n2];
        int n52 = n1;
        x[n52] = x[n52] - v * x[n2];
        int n53 = n1;
        u1[n53] = u1[n53] - v * u2[n2];
        v = l2[n] * diag[n2];
        int n54 = n;
        l1[n54] = l1[n54] - v * u1[n2];
        int n55 = n;
        diag[n55] = diag[n55] - v * u2[n2];
        int n56 = n;
        x[n56] = x[n56] - v * x[n2];
        diag[n1] = 1.0 / diag[n1];
        i = n;
        v = l1[n] * diag[n1];
        int n57 = n;
        diag[n57] = diag[n57] - v * u1[n1];
        int n58 = n;
        x[n58] = x[n58] - v * x[n1];
        diag[n] = 1.0 / diag[n];
        int n59 = n;
        x[n59] = x[n59] * diag[n];
        x[n1] = (x[n1] - u1[n1] * x[n]) * diag[n1];
        x[n2] = (x[n2] - u1[n2] * x[n1] - u2[n2] * x[n]) * diag[n2];
        x[n3] = (x[n3] - u1[n3] * x[n2] - u2[n3] * x[n1] - l2[n3] * x[n]) * diag[n3];
        i = n - 4;
        while (i >= 0) {
            x[i] = (x[i] - u1[i] * x[i + 1] - u2[i] * x[i + 2] - l2[i] * x[n1] - l1[i] * x[n]) * diag[i];
            --i;
        }
        return x;
    }
}

