/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import java.security.InvalidParameterException;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnMatrix;

public class PnWLS {
    protected int[][] basis;

    public PnWLS(int dimension, int degree) {
        if (dimension < 1) {
            dimension = 1;
            PsDebug.message((String)"PnWLS: Given dimension was < 1, has been set to 1.");
        }
        if (degree < 0) {
            degree = 0;
            PsDebug.message((String)"PnWLS: Given degree was < 0, has been set to 0.");
        }
        this.basis = PnWLS.enumeratePolynomialBasis(dimension, degree);
    }

    public int[][] getBasis() {
        return this.basis;
    }

    public static double bumpFunction(double argument, double radius) {
        if (Math.abs(argument) >= Math.abs(radius)) {
            return 0.0;
        }
        return Math.exp(-1.0 * Math.pow(argument, 2.0) / Math.pow(argument - radius, 2.0));
    }

    public static int[][] enumeratePolynomialBasis(int dimension, int degree) {
        int[][] basis = new int[(int)((double)PnWLS.factorial(dimension + degree) / (double)(PnWLS.factorial(dimension) * PnWLS.factorial(degree)))][dimension];
        PnWLS.enumeratePolynomialBasisRecursive(basis, dimension - 1, degree, 0);
        return basis;
    }

    private static int enumeratePolynomialBasisRecursive(int[][] basis, int dimension, int degree, int currentRow) {
        if (dimension < 0 || degree < 0) {
            return currentRow;
        }
        int i = 0;
        while (i <= degree) {
            int lastRow = PnWLS.enumeratePolynomialBasisRecursive(basis, dimension - 1, degree - i, currentRow);
            int j = currentRow;
            while (j <= lastRow) {
                basis[j][dimension] = i;
                ++j;
            }
            if (i != degree) {
                currentRow = lastRow + 1;
            }
            ++i;
        }
        return currentRow;
    }

    public PdMatrix evaluatePolynomialBasis(PdVector point) throws InvalidParameterException {
        if (point.getSize() != this.basis[0].length) {
            throw new InvalidParameterException("PnWLS: Expected dimension " + this.basis[0].length + " but got " + point.getSize());
        }
        PdMatrix result = new PdMatrix(this.basis.length, 1);
        int i = 0;
        while (i < this.basis.length) {
            double evaluation = 1.0;
            int j = 0;
            while (j < this.basis[i].length) {
                evaluation *= Math.pow(point.getEntry(j), this.basis[i][j]);
                ++j;
            }
            result.setEntry(i, 0, evaluation);
            ++i;
        }
        return result;
    }

    public double evaluatePolynomial(PdVector point, double[] coefficients) throws InvalidParameterException {
        if (point.getSize() != this.basis[0].length) {
            throw new InvalidParameterException("PnWLS: Expected dimension " + this.basis[0].length + " but got " + point.getSize());
        }
        if (this.basis.length != coefficients.length) {
            throw new InvalidParameterException("PnWLS: Expected " + this.basis.length + " weights, but got " + coefficients.length);
        }
        double result = 0.0;
        int i = 0;
        while (i < this.basis.length) {
            double evaluation = 1.0;
            int j = 0;
            while (j < this.basis[i].length) {
                evaluation *= Math.pow(point.getEntry(j), this.basis[i][j]);
                ++j;
            }
            result += coefficients[i] * evaluation;
            ++i;
        }
        return result;
    }

    private static int factorial(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return n * PnWLS.factorial(n - 1);
    }

    public double[] weightedLeastSquares(PgPointSet projections, PdVector distances, PdVector weights) throws InvalidParameterException {
        if (projections.getDimOfVertices() != this.basis[0].length) {
            throw new InvalidParameterException("PnWLS: Expected dimension " + this.basis[0].length + " but got " + projections.getDimOfVertices());
        }
        if (projections.getNumVertices() != distances.getSize()) {
            throw new InvalidParameterException("PnWLS: Expected " + projections.getNumVertices() + " distances, but got " + distances.getSize());
        }
        if (projections.getNumVertices() != weights.getSize()) {
            throw new InvalidParameterException("PnWLS: Expected " + projections.getNumVertices() + " weights, but got " + weights.getSize());
        }
        PdMatrix Am = new PdMatrix(this.basis.length, this.basis.length);
        PdMatrix bm = new PdMatrix(this.basis.length, 1);
        int i = 0;
        while (i < projections.getNumVertices()) {
            PdMatrix bi = this.evaluatePolynomialBasis(projections.getVertex(i));
            PdMatrix bit = new PdMatrix(bi.getJSize(), bi.getISize());
            bit.transpose(bi);
            PdMatrix B = new PdMatrix(this.basis.length, this.basis.length);
            B.mult(bi, bit);
            bit.multScalar(weights.getEntry(i));
            Am.add(B);
            bi.multScalar(weights.getEntry(i) * distances.getEntry(i));
            bm.add(bi);
            ++i;
        }
        double[][] A = new double[this.basis.length][this.basis.length];
        int i2 = 0;
        while (i2 < this.basis.length) {
            int j = 0;
            while (j < this.basis.length) {
                A[i2][j] = Am.getEntry(i2, j);
                ++j;
            }
            ++i2;
        }
        int[] indx = new int[this.basis.length];
        PnMatrix.ludcmp((double[][])A, (int)this.basis.length, (int[])indx);
        double[] b = new double[this.basis.length];
        int i3 = 0;
        while (i3 < this.basis.length) {
            b[i3] = bm.getEntry(i3, 0);
            ++i3;
        }
        PnMatrix.lubksb((double[][])A, (int)this.basis.length, (int[])indx, (double[])b);
        return b;
    }
}

