/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnTaucsSolver;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnTaucsSparseLDLTFactorization {
    private long m_factorizationPointer = 0L;

    public PnTaucsSparseLDLTFactorization(PnSparseMatrix smat) throws Exception {
        this.m_factorizationPointer = PnTaucsSolver.factorLDLT(smat.getNumRows(), smat.getColIndices(), smat.getNumEntries(), smat.getEntries());
    }

    public void solveUseFactorization(PdVector x, PdVector b) throws Exception {
        if (this.m_factorizationPointer == 0L) {
            PsDebug.warning((String)"Cannot solve system. Compute factorization of the matrix first.");
            return;
        }
        PnTaucsSolver.solveLDLT(this.m_factorizationPointer, x.m_data, b.m_data);
    }

    public void freeFactorization() {
        if (this.m_factorizationPointer != 0L) {
            try {
                PnTaucsSolver.freeLDLT(this.m_factorizationPointer);
            }
            catch (Exception e) {
                PsDebug.error((String)"Unable to delete factorization in native code.", (Object)e);
            }
        }
        this.m_factorizationPointer = 0L;
    }
}

