/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnTaucsSolver;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnTaucsSparseCholeskyFactorization {
    private long m_factorizationPointer = 0L;

    public PnTaucsSparseCholeskyFactorization() {
    }

    public PnTaucsSparseCholeskyFactorization(PnSparseMatrix smat) {
        this.m_factorizationPointer = PnTaucsSolver.getCholeksyFactorization(smat);
        if (this.m_factorizationPointer == 0L) {
            throw new IllegalArgumentException("Unable to create Cholesky factorization of indefinite matrix!");
        }
    }

    public PnTaucsSparseCholeskyFactorization(PnSparseMatrix smat, boolean bUseMultifront, boolean bConvert2CCS) {
        this.m_factorizationPointer = PnTaucsSolver.getCholeksyFactorization(smat, bUseMultifront, bConvert2CCS);
        if (this.m_factorizationPointer == 0L) {
            throw new IllegalArgumentException("Unable to create Cholesky factorization of indefinite matrix!");
        }
    }

    public void computeFactorization(PnSparseMatrix smat) {
        this.freeFactorization();
        this.m_factorizationPointer = PnTaucsSolver.getCholeksyFactorization(smat);
    }

    public void computeFactorization(PnSparseMatrix smat, boolean bUseMultifront, boolean bConvert2CCS) {
        this.freeFactorization();
        this.m_factorizationPointer = PnTaucsSolver.getCholeksyFactorization(smat, bUseMultifront, bConvert2CCS);
    }

    public void solveUseFactorization(PdVector x, PdVector b) {
        PnTaucsSolver.solveUseFactorization(this.m_factorizationPointer, x.m_data, b.m_data);
    }

    public void solveUseFactorization(double[] x, double[] b) {
        if (!this.hasFactorization()) {
            PsDebug.warning((String)"Cannot solve system. Compute factorization of the matrix first.");
            return;
        }
        PnTaucsSolver.solveUseFactorization(this.m_factorizationPointer, x, b);
    }

    public void freeFactorization() {
        if (this.hasFactorization()) {
            PnTaucsSolver.freeFactorization(this.m_factorizationPointer);
        }
        this.m_factorizationPointer = 0L;
    }

    public boolean hasFactorization() {
        return this.m_factorizationPointer != 0L;
    }
}

