/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnTaucsSolver {
    public static final long NULL = 0L;
    private static boolean m_available = true;
    private static String[] METHOD_CHOLESKY;
    private static String[] METHOD_CG;

    static {
        try {
            if (System.getProperty("os.name").startsWith("Win") && System.getProperty("os.arch").endsWith("64")) {
                System.loadLibrary("w64gcc_s_sjlj-1");
                System.loadLibrary("libstdc++-6");
                System.loadLibrary("libgfortran-3");
            }
            System.loadLibrary("TaucsJNI");
        }
        catch (UnsatisfiedLinkError e) {
            m_available = false;
        }
        METHOD_CHOLESKY = new String[]{"taucs.factor.ordering=metis", "taucs.factor.LLT=true"};
        METHOD_CG = new String[]{"taucs.factor.ordering=metis", "taucs.factor.LLT=true", "taucs.solve.cg=true"};
    }

    public static boolean isAvailable() {
        return m_available;
    }

    public static native void logfile2StandardOut(boolean var0);

    private static native long solve(String[] var0, int var1, PiVector[] var2, PiVector var3, PdVector[] var4, double[] var5, double[] var6, long var7) throws Exception;

    private static native int solveCholeksy(int var0, PiVector[] var1, PiVector var2, PdVector[] var3, double[] var4, double[] var5);

    private static native long getCholeksyFactorization(int var0, PiVector[] var1, PiVector var2, PdVector[] var3, boolean var4, boolean var5);

    public static native int solveUseFactorization(long var0, double[] var2, double[] var3);

    public static native void freeFactorization(long var0);

    public static boolean solve(String[] linsolve, PnSparseMatrix smat, PdVector x, PdVector b) {
        if (smat == null || x == null || b == null) {
            PsDebug.warning((String)"One of the arguments is null.");
            return false;
        }
        if (linsolve == null) {
            linsolve = METHOD_CHOLESKY;
        }
        try {
            PnTaucsSolver.solve(linsolve, smat.getNumRows(), smat.getColIndices(), smat.getNumEntries(), smat.getEntries(), x.m_data, b.m_data, -1L);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean solveCholeksy(PnSparseMatrix smat, PdVector x, PdVector b) {
        if (smat == null || x == null || b == null) {
            PsDebug.warning((String)"One of the arguments is null.");
            return false;
        }
        return PnTaucsSolver.solveCholeksy(smat.getNumRows(), smat.getColIndices(), smat.getNumEntries(), smat.getEntries(), x.m_data, b.m_data) == 1;
    }

    public static boolean solveCG(PnSparseMatrix smat, PdVector x, PdVector b) {
        if (smat == null || x == null || b == null) {
            PsDebug.warning((String)"One of the arguments is null.");
            return false;
        }
        try {
            PnTaucsSolver.solve(METHOD_CG, smat.getNumRows(), smat.getColIndices(), smat.getNumEntries(), smat.getEntries(), x.m_data, b.m_data, 0L);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static long getCholeksyFactorization(PnSparseMatrix smat) {
        return PnTaucsSolver.getCholeksyFactorization(smat.getNumRows(), smat.getColIndices(), smat.getNumEntries(), smat.getEntries(), false, false);
    }

    public static long getCholeksyFactorization(PnSparseMatrix smat, boolean bUseMultifront, boolean bConvert2CCS) {
        return PnTaucsSolver.getCholeksyFactorization(smat.getNumRows(), smat.getColIndices(), smat.getNumEntries(), smat.getEntries(), bUseMultifront, bConvert2CCS);
    }

    public static native long factorLDLT(int var0, PiVector[] var1, PiVector var2, PdVector[] var3);

    public static native void solveLDLT(long var0, double[] var2, double[] var3);

    public static native void freeLDLT(long var0);

    public static void main(String[] args) {
        double[][] m = new double[][]{{33.0, 2.0, 9.0, 4.0}, {2.0, 31.0, 2.0, 2.0}, {9.0, 2.0, 35.0, 4.0}, {4.0, 2.0, 4.0, 35.0}};
        PdMatrix mat = new PdMatrix((double[][])m);
        PnSparseMatrix smat = new PnSparseMatrix(mat);
        double[] b1 = new double[]{0.0, 4.0, 5.0, 6.0};
        PdVector b = new PdVector(b1);
        PdVector x = new PdVector(4);
        PnTaucsSolver.logfile2StandardOut(true);
        PnTaucsSolver.solve(METHOD_CHOLESKY, smat, x, b);
        PdVector test = new PdVector(4);
        PnSparseMatrix.rightMultVector((PnSparseMatrix)smat, (PdVector)x, (PdVector)test);
        test.sub(b);
        System.out.println("Residual: " + test.length());
    }
}

