/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnSuperLUSolver {
    public static final long NULL = 0L;
    private static boolean m_available = true;

    static {
        try {
            System.loadLibrary("SuperLuJNI");
        }
        catch (UnsatisfiedLinkError e) {
            m_available = false;
            PsDebug.warning((String)("Cannot load SuperLU library: " + e.getMessage()));
        }
    }

    public static boolean isAvailable() {
        return m_available;
    }

    public static native void solveNative(int var0, PiVector[] var1, PiVector var2, PdVector[] var3, PdVector var4, PdVector var5);

    public static native long factor(int var0, PiVector[] var1, PiVector var2, PdVector[] var3) throws Exception;

    public static native void solveUsingLU(long var0, double[] var2, double[] var3) throws Exception;

    public static native void freeFactorization(long var0);

    public static double solve(PnSparseMatrix A, PdVector x, PdVector b) {
        if (A == null || x == null || b == null) {
            PsDebug.warning((String)"One of the arguments is null.");
            return -1.0;
        }
        PnSuperLUSolver.solveNative(A.getNumCols(), A.getColIndices(), A.getNumEntries(), A.getEntries(), x, b);
        return 0.0;
    }
}

