/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnFunctionWithSparseHessian;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnSumOfEnergies
extends PnFunctionWithSparseHessian {
    protected PnFunctionWithSparseHessian[] m_func;
    protected PdVector m_factor;
    protected PnSparseMatrix m_tmp_data_hessian;
    protected PdVector m_tmp_data_gradient;

    public PnSumOfEnergies(PnFunctionWithSparseHessian[] func, PdVector factor) {
        this.m_factor = factor;
        this.m_func = func;
    }

    public PnSumOfEnergies(int numberOfEnergies) {
        this.m_func = new PnFunctionWithSparseHessian[numberOfEnergies];
        this.m_factor = new PdVector(numberOfEnergies);
    }

    public PdVector getFactor() {
        return this.m_factor;
    }

    public void setFactor(int index, double value) {
        if (this.m_factor != null && this.m_factor.m_data.length > index) {
            this.m_factor.setEntry(index, value);
        }
    }

    public void setEnergy(int index, PnFunctionWithSparseHessian energy) {
        if (this.m_func != null && this.m_func.length > index) {
            this.m_func[index] = energy;
        }
    }

    public void setEnergy(int index, double factor, PnFunctionWithSparseHessian energy) {
        if (this.m_func != null && this.m_func.length > index) {
            this.m_func[index] = energy;
        }
        this.setFactor(index, factor);
    }

    public void setNumberOfEnergies(int numberOfEnergies) {
        this.m_func = new PnFunctionWithSparseHessian[numberOfEnergies];
        this.m_factor = new PdVector(numberOfEnergies);
    }

    public boolean isEvaluable() {
        return this.m_bEvaluable;
    }

    public void enableEvaluation(boolean flag) {
        this.m_bEvaluable = flag;
    }

    public int getNumOfVariables() {
        if (this.m_func != null) {
            int max = 0;
            int i = 0;
            while (i < this.m_func.length) {
                int tmp;
                if (this.m_func[i] != null && (tmp = this.m_func[i].getNumOfVariables()) > max) {
                    max = tmp;
                }
                ++i;
            }
            return max;
        }
        return 0;
    }

    public double eval(PdVector x) {
        return PnSumOfEnergies.evaluateEnergy(this.m_func, this.m_factor, x);
    }

    public PdVector evalGradient(PdVector x, PdVector aGradient) {
        return PnSumOfEnergies.evaluateGradient(this.m_func, this.m_factor, x, aGradient, this.m_tmp_data_gradient);
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return aHessian;
    }

    @Override
    public PnSparseMatrix evalSparseHessian(PdVector x, PnSparseMatrix hessian) {
        return PnSumOfEnergies.evalHessian(this.m_func, this.m_factor, x, hessian, this.m_tmp_data_hessian);
    }

    public static double evaluateEnergy(PnFunctionWithSparseHessian[] func, PdVector factor, PdVector vertPositions) {
        if (func != null) {
            double energy = 0.0;
            int i = 0;
            while (i < func.length) {
                if (func[i] != null) {
                    energy += func[i].eval(vertPositions) * factor.m_data[i];
                }
                ++i;
            }
            return energy;
        }
        return 0.0;
    }

    protected static PdVector evaluateGradient(PnFunctionWithSparseHessian[] func, PdVector factor, PdVector vertexPositions, PdVector gradient, PdVector tmp_data) {
        gradient.setConstant(0.0);
        if (func != null) {
            if (tmp_data == null) {
                tmp_data = new PdVector();
            }
            int i = 0;
            while (i < func.length) {
                if (func[i] != null) {
                    tmp_data.setSize(func[i].getNumOfVariables());
                    tmp_data = func[i].evalGradient(vertexPositions, tmp_data);
                    gradient.add(factor.m_data[i], tmp_data);
                }
                ++i;
            }
            return gradient;
        }
        return null;
    }

    protected static PnSparseMatrix evalHessian(PnFunctionWithSparseHessian[] func, PdVector factor, PdVector vertexPositions, PnSparseMatrix hessian, PnSparseMatrix tmp_data) {
        if (func != null) {
            if (tmp_data == null) {
                tmp_data = new PnSparseMatrix();
            }
            boolean first = true;
            int i = 0;
            while (i < func.length) {
                if (func[i] != null) {
                    if (first) {
                        if (hessian == null) {
                            hessian = new PnSparseMatrix();
                        }
                        hessian = func[i].evalSparseHessian(vertexPositions, hessian);
                        hessian.validate();
                        hessian.multScalar(factor.m_data[i]);
                        first = false;
                    } else {
                        tmp_data = func[i].evalSparseHessian(vertexPositions, tmp_data);
                        tmp_data.validate();
                        tmp_data.multScalar(factor.m_data[i]);
                        hessian.add(tmp_data);
                    }
                }
                ++i;
            }
            return hessian;
        }
        return null;
    }
}

