/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import java.security.InvalidParameterException;

public class PnSigmoidFunctions {
    public static double sigmoid_cos(double a, double b, double x) {
        if (x < 0.0 || x > 1.0) {
            throw new InvalidParameterException("Argument x has to be within [0,1].");
        }
        double c = b * Math.PI / (1.0 - a);
        double a_ = (1.0 - a + a * b) / b;
        if (x < a) {
            return 0.0;
        }
        if (x < a_) {
            return -0.5 * Math.cos(c * (x - a)) + 0.5;
        }
        return 1.0;
    }
}

