/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnTaucsSolver;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnSparseMatrix;

public class PnPreconditionerConstraint
extends PnPreconditioner {
    public boolean[] m_bUse;
    public PdVector m_in;
    public PdVector m_out;
    public long m_choleskyFactorization;

    public void setSparseMatrix(PnSparseMatrix pm) {
        if (!pm.isSquare()) {
            PsDebug.warning((String)"Matrix is not square.");
            return;
        }
        this.m_choleskyFactorization = PnTaucsSolver.getCholeksyFactorization(pm);
    }

    public PdVector apply(PdVector b, PdVector x, int dim) {
        if (b == null) {
            PsDebug.warning((String)"Vector b is null");
            return null;
        }
        if (x == null) {
            x = new PdVector(b.getSize());
        }
        if (this.m_bUse == null || this.m_bUse.length < b.getSize()) {
            return b;
        }
        int n = this.m_bUse.length / 3;
        if (this.m_in == null) {
            this.m_in = new PdVector(n * dim);
        } else if (this.m_in.getSize() != n * dim) {
            this.m_in.setSize(n * dim);
        }
        if (this.m_out == null) {
            this.m_out = new PdVector(n * dim);
        } else if (this.m_out.getSize() != n * dim) {
            this.m_out.setSize(n * dim);
        }
        int cnt = 0;
        int i = 0;
        while (i < n) {
            this.m_in.m_data[i] = !this.m_bUse[i] ? b.m_data[cnt++] : 0.0;
            ++i;
        }
        PnTaucsSolver.solveUseFactorization(this.m_choleskyFactorization, this.m_out.m_data, this.m_in.m_data);
        cnt = 0;
        i = 0;
        while (i < n) {
            if (!this.m_bUse[i]) {
                x.m_data[cnt++] = this.m_out.m_data[i];
            }
            ++i;
        }
        return x;
    }

    public PdVector apply(PdVector b, PdVector x) {
        return this.apply(b, x, 1);
    }

    public PdVector applyTransposed(PdVector b, PdVector x) {
        return this.applyTransposed(b, x, 1);
    }

    public PdVector applyTransposed(PdVector b, PdVector x, int dim) {
        return this.apply(b, x, dim);
    }
}

