/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import java.util.LinkedList;
import jv.geom.PgPointSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnJacobi;

public class PnPCA {
    public static PdMatrix getCovarianceMatrix(PgPointSet geom, PiVector indices) {
        PdVector weights = new PdVector(indices.getSize());
        int i = 0;
        while (i < weights.getSize()) {
            weights.setEntry(i, 1.0);
            ++i;
        }
        return PnPCA.getCovarianceMatrix(geom, indices, weights);
    }

    public static PdMatrix getCovarianceMatrix(PgPointSet geom, PiVector indices, PdVector weights) {
        int dim = geom.getDimOfVertices();
        PdMatrix covMat = new PdMatrix(dim);
        int nov = geom.getNumVertices();
        if (indices != null) {
            nov = indices.getSize();
        }
        PdVector bary = new PdVector(dim);
        PdVector vec = new PdVector(dim);
        double weightSum = 0.0;
        int i = 0;
        while (i < nov) {
            if (indices != null) {
                vec.multScalar(geom.getVertex(indices.getEntry(i)), weights.getEntry(i));
                weightSum += weights.getEntry(i);
                bary.add(vec);
            } else {
                vec.multScalar(geom.getVertex(i), weights.getEntry(i));
                weightSum += weights.getEntry(i);
                bary.add(vec);
            }
            ++i;
        }
        bary.multScalar(1.0 / weightSum);
        PdMatrix covTmp = new PdMatrix(dim);
        vec = new PdVector(dim);
        int i2 = 0;
        while (i2 < nov) {
            if (indices != null) {
                vec.sub(bary, geom.getVertex(indices.getEntry(i2)));
            } else {
                vec.sub(bary, geom.getVertex(i2));
            }
            vec.multScalar(Math.sqrt(weights.getEntry(i2)));
            covTmp.adjoint(vec);
            covMat.add(covTmp);
            ++i2;
        }
        return covMat;
    }

    public static PdMatrix getCovarianceMatrix(PgPointSet geom) {
        return PnPCA.getCovarianceMatrix(geom, null);
    }

    public static PdVector[] getPrincipalComponents(PgPointSet geom) {
        PiVector indices = null;
        return PnPCA.getPrincipalComponents(geom, indices);
    }

    public static PdVector[] getPrincipalComponents(PgPointSet geom, PiVector indices) {
        PdVector weights = new PdVector(geom.getNumVertices());
        if (indices != null) {
            weights = new PdVector(indices.getSize());
        }
        int i = 0;
        while (i < weights.getSize()) {
            weights.setEntry(i, 1.0);
            ++i;
        }
        return PnPCA.getPrincipalComponents(geom, indices, weights);
    }

    public static PdVector[] getPrincipalComponents(PgPointSet geom, PiVector indices, PdVector weights) {
        PdMatrix covariance = PnPCA.getCovarianceMatrix(geom, indices, weights);
        int dim = geom.getDimOfVertices();
        PdVector eigenVal = new PdVector(dim);
        PdVector[] eigenVec = new PdVector[dim];
        int i = 0;
        while (i < dim) {
            eigenVec[i] = new PdVector(dim);
            ++i;
        }
        PnJacobi.computeEigenvectors((PdMatrix)covariance, (int)dim, (PdVector)eigenVal, (PdVector[])eigenVec);
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < dim - 1) {
                if (eigenVal.getEntry(j) < eigenVal.getEntry(j + 1)) {
                    PdVector temp = eigenVec[j];
                    eigenVec[j] = eigenVec[j + 1];
                    eigenVec[j + 1] = temp;
                    double t = eigenVal.m_data[j];
                    eigenVal.m_data[j] = eigenVal.m_data[j + 1];
                    eigenVal.m_data[j + 1] = t;
                }
                ++j;
            }
            ++i2;
        }
        return eigenVec;
    }

    public static PdVector[] getPrincipalComponents(PgPointSet geom, int numberOfComponent) {
        PdVector[] components = PnPCA.getPrincipalComponents(geom);
        PdVector[] result = new PdVector[numberOfComponent];
        int i = 0;
        while (i < numberOfComponent) {
            result[i] = components[i];
            ++i;
        }
        return result;
    }

    public static PdVector getPrincipalComponent(PgPointSet geom) {
        PdVector[] result = PnPCA.getPrincipalComponents(geom);
        return result[0];
    }

    public static PdVector[] getPrincipalComponents(LinkedList<PdVector> points) {
        PgPointSet geom = null;
        if (points != null && points.size() > 0) {
            geom = new PgPointSet(points.get(0).getSize());
        }
        int i = 0;
        while (i < points.size()) {
            geom.addVertex(points.get(i));
            ++i;
        }
        return PnPCA.getPrincipalComponents(geom);
    }

    public static PdVector getPrincipalComponent(PgPointSet pointCloud, LinkedList<Integer> indices) {
        PdVector[] result = PnPCA.getPrincipalComponents(pointCloud, indices);
        return result[0];
    }

    public static PdVector[] getPrincipalComponents(PgPointSet pc, LinkedList<Integer> points) {
        PgPointSet geom = new PgPointSet(3);
        int i = 0;
        while (i < points.size()) {
            geom.addVertex(pc.getVertex(points.get(i).intValue()));
            ++i;
        }
        return PnPCA.getPrincipalComponents(geom);
    }

    public static PdVector getPrincipalValues(PgPointSet geom, PiVector indices) {
        PdVector weights = new PdVector(0);
        int i = 0;
        while (i < indices.getSize()) {
            weights.addEntry(1.0);
            ++i;
        }
        return PnPCA.getPrincipalValues(geom, indices, weights);
    }

    public static PdVector getPrincipalValues(PgPointSet geom, PiVector indices, PdVector weights) {
        PdMatrix covariance = PnPCA.getCovarianceMatrix(geom, indices, weights);
        int dim = geom.getDimOfVertices();
        PdVector eigenVal = new PdVector(dim);
        PdVector[] eigenVec = new PdVector[dim];
        int i = 0;
        while (i < dim) {
            eigenVec[i] = new PdVector(dim);
            ++i;
        }
        PnJacobi.computeEigenvectors((PdMatrix)covariance, (int)dim, (PdVector)eigenVal, (PdVector[])eigenVec);
        int i2 = 0;
        while (i2 < dim) {
            int j = 0;
            while (j < dim - 1) {
                if (eigenVal.getEntry(j) < eigenVal.getEntry(j + 1)) {
                    PdVector temp = eigenVec[j];
                    eigenVec[j] = eigenVec[j + 1];
                    eigenVec[j + 1] = temp;
                    double t = eigenVal.m_data[j];
                    eigenVal.m_data[j] = eigenVal.m_data[j + 1];
                    eigenVal.m_data[j + 1] = t;
                }
                ++j;
            }
            ++i2;
        }
        return eigenVal;
    }

    public static void transformCoordinateSystem(PgPointSet geom, PdVector origin, PdVector[] basis) {
        int dim = geom.getDimOfVertices();
        int nov = geom.getNumVertices();
        int i = 0;
        while (i < nov) {
            geom.getVertex(i).sub(origin);
            ++i;
        }
        PdMatrix m = new PdMatrix(dim);
        int i2 = 0;
        while (i2 < dim) {
            System.arraycopy(basis[i2].m_data, 0, m.m_data[i2], 0, dim);
            ++i2;
        }
        m.transpose();
        m.invert();
        i2 = 0;
        while (i2 < nov) {
            geom.getVertex(i2).leftMultMatrix(m);
            ++i2;
        }
    }

    public static void transformToNormalPosition(PgPointSet geom) {
        int dim = geom.getDimOfVertices();
        PdVector[] eVector = PnPCA.getPrincipalComponents(geom);
        int i = 0;
        while (i < dim) {
            eVector[i].normalize();
            ++i;
        }
        PnPCA.transformCoordinateSystem(geom, PnPCA.getBarycenter(geom), eVector);
    }

    public static PdVector getBarycenter(PgPointSet geom) {
        int dim = geom.getDimOfVertices();
        int nov = geom.getNumVertices();
        PdVector bary = new PdVector(dim);
        int i = 0;
        while (i < nov) {
            bary.add(geom.getVertex(i));
            ++i;
        }
        bary.multScalar(1.0 / (double)nov);
        return bary;
    }

    public static PdVector getBarycenter(PgPointSet geom, PiVector indices) {
        int dim = geom.getDimOfVertices();
        int nov = indices.getSize();
        PdVector bary = new PdVector(dim);
        int i = 0;
        while (i < nov) {
            bary.add(geom.getVertex(indices.getEntry(i)));
            ++i;
        }
        bary.multScalar(1.0 / (double)nov);
        return bary;
    }
}

