/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnBendingCurve;
import dev.numeric.PnDirichletCurve;
import dev.numeric.PnFunctionWithSparseHessian;
import dev.numeric.PnMassCurve;
import dev.numeric.PuSparseMatrix;
import jv.geom.PgPolygon;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnMinimumVariationCurve
extends PnFunctionWithSparseHessian {
    protected boolean m_bEvaluable = true;
    protected boolean m_bscaleInvariant = true;
    protected PgPolygon m_geom;
    protected PnDirichletCurve m_stiff;
    protected PnSparseMatrix m_laplace;
    protected PnSparseMatrix m_biLaplace;
    protected PnSparseMatrix m_hessian_1d;
    protected PdVector m_invMass;
    private static PdVector[] m_store;

    public PnMinimumVariationCurve(PgPolygon geom) {
        this.m_geom = geom;
    }

    public boolean isEvaluable() {
        return this.m_bEvaluable;
    }

    public void enableEvaluation(boolean flag) {
        this.m_bEvaluable = flag;
    }

    public int getNumOfVariables() {
        return this.m_geom.getNumVertices();
    }

    public double eval(PdVector x) {
        return PnMinimumVariationCurve.evaluateEnergy(this.m_geom, x, this.m_bscaleInvariant);
    }

    public PdVector evalGradient(PdVector x, PdVector aGradient) {
        return PnMinimumVariationCurve.evaluateGradient(this.m_geom, x, aGradient, this.m_bscaleInvariant);
    }

    @Override
    public PnSparseMatrix evalSparseHessian(PdVector x, PnSparseMatrix hessian) {
        int n = this.m_geom.getNumVertices();
        if (hessian == null) {
            hessian = new PnSparseMatrix(n, n, 7);
        }
        if (this.m_biLaplace == null) {
            this.m_biLaplace = new PnSparseMatrix(n, n, 5);
        }
        if (this.m_stiff == null) {
            this.m_stiff = new PnDirichletCurve(this.m_geom);
        } else {
            this.m_stiff.init();
        }
        this.m_invMass = PnMassCurve.getInverseOfLumpedMassMatrix(this.m_geom, this.m_invMass);
        if (this.m_laplace == null) {
            this.m_laplace = new PnDirichletCurve(this.m_geom);
        } else {
            this.m_laplace.copy((PnSparseMatrix)this.m_stiff);
        }
        PdVector[] l_values = this.m_laplace.getEntries();
        int i = 0;
        while (i < n) {
            l_values[i].multScalar(this.m_invMass.m_data[i]);
            ++i;
        }
        this.m_biLaplace = PnSparseMatrix.multMatrices((PnSparseMatrix)this.m_laplace, (PnSparseMatrix)this.m_laplace, (PnSparseMatrix)this.m_biLaplace);
        this.m_hessian_1d = PnSparseMatrix.multMatrices((PnSparseMatrix)this.m_stiff, (PnSparseMatrix)this.m_biLaplace, (PnSparseMatrix)this.m_hessian_1d);
        if (this.m_bscaleInvariant) {
            double l = this.m_geom.getLength();
            this.m_hessian_1d.multScalar(l * l * l);
        }
        i = 0;
        while (i < n) {
            this.m_hessian_1d.addEntry(i, i, 0.001);
            ++i;
        }
        return this.m_hessian_1d;
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return aHessian;
    }

    public void setScaleInvariant(boolean flag) {
        this.m_bscaleInvariant = flag;
    }

    public boolean isScalaInvariant() {
        return this.m_bscaleInvariant;
    }

    public static double evaluateEnergy(PgPolygon poly, PdVector vertPositions, boolean scaleInvariant) {
        double energy = 0.0;
        int nov = poly.getNumVertices();
        int d = poly.getDimOfVertices();
        if (m_store == null) {
            m_store = PdVector.realloc((PdVector[])m_store, (int)6, (int)d);
        }
        PdVector em = m_store[0];
        PdVector e = m_store[1];
        PdVector ep = m_store[2];
        double len = 0.0;
        boolean closed = poly.isClosed();
        int end = closed ? nov : nov - 1;
        int nov_3 = nov - 3;
        int i = 0;
        while (i < end) {
            int ipp;
            int ip;
            int im = i == 0 ? (i + nov - 1) % nov : i - 1;
            if (i >= nov_3) {
                ip = (i + 1) % nov;
                ipp = (i + 2) % nov;
            } else {
                ip = i + 1;
                ipp = i + 2;
            }
            int j = 0;
            while (j < d) {
                em.m_data[j] = vertPositions.m_data[d * i + j] - vertPositions.m_data[d * im + j];
                e.m_data[j] = vertPositions.m_data[d * ip + j] - vertPositions.m_data[d * i + j];
                ep.m_data[j] = vertPositions.m_data[d * ipp + j] - vertPositions.m_data[d * ip + j];
                ++j;
            }
            double lm = em.length();
            double l = e.length();
            double lp = ep.length();
            e.multScalar(1.0 / l);
            em.multScalar(1.0 / lm);
            double dot = -PdVector.dot((PdVector)em, (PdVector)e);
            em.blendBase(em, dot, e);
            em.multScalar(1.0 / (lm + l));
            ep.multScalar(1.0 / lp);
            dot = -PdVector.dot((PdVector)ep, (PdVector)e);
            ep.blendBase(ep, dot, e);
            ep.multScalar(1.0 / (lp + l));
            if (!closed) {
                if (i == 0) {
                    em.setConstant(0.0);
                    lm = 0.0;
                }
                if (i == nov - 1) {
                    ep.setConstant(0.0);
                    lp = 0.0;
                }
            }
            em.add(ep);
            energy += 2.0 / l * em.sqrLength();
            len += l;
            ++i;
        }
        if (scaleInvariant) {
            return energy * len * len * len;
        }
        return energy;
    }

    public static double evaluateEnergy(PgPolygon poly, boolean scaleInvariant) {
        double energy = 0.0;
        int nov = poly.getNumVertices();
        PdVector[] vertices = poly.getVertices();
        int d = poly.getDimOfVertices();
        if (m_store == null || PnMinimumVariationCurve.m_store[0].m_data.length != d) {
            m_store = PdVector.realloc((PdVector[])m_store, (int)6, (int)d);
        }
        PdVector em = m_store[0];
        PdVector e = m_store[1];
        PdVector ep = m_store[2];
        double len = 0.0;
        boolean closed = poly.isClosed();
        int end = closed ? nov : nov - 1;
        int nov_3 = nov - 3;
        int i = 0;
        while (i < end) {
            int ipp;
            int ip;
            int im = i == 0 ? (i + nov - 1) % nov : i - 1;
            if (i >= nov_3) {
                ip = (i + 1) % nov;
                ipp = (i + 2) % nov;
            } else {
                ip = i + 1;
                ipp = i + 2;
            }
            em.sub(vertices[i], vertices[im]);
            e.sub(vertices[ip], vertices[i]);
            ep.sub(vertices[ipp], vertices[ip]);
            double lm = em.length();
            double l = e.length();
            double lp = ep.length();
            e.multScalar(1.0 / l);
            em.multScalar(1.0 / lm);
            double dot = -PdVector.dot((PdVector)em, (PdVector)e);
            em.blendBase(em, dot, e);
            em.multScalar(1.0 / (lm + l));
            ep.multScalar(1.0 / lp);
            dot = -PdVector.dot((PdVector)ep, (PdVector)e);
            ep.blendBase(ep, dot, e);
            ep.multScalar(1.0 / (lp + l));
            if (!closed) {
                if (i == 0) {
                    em.setConstant(0.0);
                    lm = 0.0;
                }
                if (i == nov - 1) {
                    ep.setConstant(0.0);
                    lp = 0.0;
                }
            }
            em.add(ep);
            energy += 2.0 / l * em.sqrLength();
            len += l;
            ++i;
        }
        if (scaleInvariant) {
            return energy * len * len * len;
        }
        return energy;
    }

    public static PdVector evaluateGradient(PgPolygon poly, PdVector x, PdVector gradient, boolean scaleInvariant) {
        int nov = poly.getNumVertices();
        int d = poly.getDimOfVertices();
        gradient.setConstant(0.0);
        if (m_store == null) {
            m_store = PdVector.realloc((PdVector[])m_store, (int)6, (int)d);
        }
        PdVector em = m_store[0];
        PdVector e = m_store[1];
        PdVector ep = m_store[2];
        PdVector grad = m_store[3];
        PdVector store = m_store[4];
        PdVector store2 = m_store[5];
        boolean closed = poly.isClosed();
        int end = closed ? nov : nov - 1;
        int nov_3 = nov - 3;
        double len = 0.0;
        int i = 0;
        while (i < end) {
            int ipp;
            int ip;
            int im = i == 0 ? (i + nov - 1) % nov : i - 1;
            if (i >= nov_3) {
                ip = (i + 1) % nov;
                ipp = (i + 2) % nov;
            } else {
                ip = i + 1;
                ipp = i + 2;
            }
            int j = 0;
            while (j < d) {
                em.m_data[j] = x.m_data[i * d + j] - x.m_data[im * d + j];
                e.m_data[j] = x.m_data[ip * d + j] - x.m_data[i * d + j];
                ep.m_data[j] = x.m_data[ipp * d + j] - x.m_data[ip * d + j];
                ++j;
            }
            double lm = em.length();
            double l = e.length();
            double lp = ep.length();
            len += l;
            PnMinimumVariationCurve.grad_O_Ei(em, e, ep, lm, l, lp, grad, store);
            int id = im * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] + grad.m_data[j];
                ++j;
            }
            PnMinimumVariationCurve.grad_O_Ei(ep, e, em, lp, l, lm, grad, store);
            id = ipp * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] - grad.m_data[j];
                ++j;
            }
            PnMinimumVariationCurve.grad_P_Ei(em, e, ep, lm, l, lp, grad, store, store2);
            id = i * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] + grad.m_data[j];
                ++j;
            }
            PnMinimumVariationCurve.grad_P_Ei(ep, e, em, lp, l, lm, grad, store, store2);
            id = ip * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] - grad.m_data[j];
                ++j;
            }
            ++i;
        }
        if (scaleInvariant) {
            double en = PnMinimumVariationCurve.evaluateEnergy(poly, x, false);
            gradient.blend(len * len * len, gradient, 3.0 * en * len * len, PnBendingCurve.getCurvatureVector(poly, x, null, false));
        }
        return gradient;
    }

    public static PdVector evaluateGradient(PgPolygon poly, PdVector gradient, boolean scaleInvariant) {
        int nov = poly.getNumVertices();
        PdVector[] vertices = poly.getVertices();
        int d = poly.getDimOfVertices();
        gradient.setConstant(0.0);
        if (m_store == null) {
            m_store = PdVector.realloc((PdVector[])m_store, (int)6, (int)d);
        }
        PdVector em = m_store[0];
        PdVector e = m_store[1];
        PdVector ep = m_store[2];
        PdVector grad = m_store[3];
        PdVector store = m_store[4];
        PdVector store2 = m_store[5];
        boolean closed = poly.isClosed();
        int end = closed ? nov : nov - 1;
        int nov_3 = nov - 3;
        double len = 0.0;
        int i = 0;
        while (i < end) {
            int ipp;
            int ip;
            int im = i == 0 ? (i + nov - 1) % nov : i - 1;
            if (i >= nov_3) {
                ip = (i + 1) % nov;
                ipp = (i + 2) % nov;
            } else {
                ip = i + 1;
                ipp = i + 2;
            }
            em.sub(vertices[i], vertices[im]);
            e.sub(vertices[ip], vertices[i]);
            ep.sub(vertices[ipp], vertices[ip]);
            double lm = em.length();
            double l = e.length();
            double lp = ep.length();
            len += l;
            PnMinimumVariationCurve.grad_O_Ei(em, e, ep, lm, l, lp, grad, store);
            int id = im * d;
            int j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] + grad.m_data[j];
                ++j;
            }
            PnMinimumVariationCurve.grad_O_Ei(ep, e, em, lp, l, lm, grad, store);
            id = ipp * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] - grad.m_data[j];
                ++j;
            }
            PnMinimumVariationCurve.grad_P_Ei(em, e, ep, lm, l, lp, grad, store, store2);
            id = i * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] + grad.m_data[j];
                ++j;
            }
            PnMinimumVariationCurve.grad_P_Ei(ep, e, em, lp, l, lm, grad, store, store2);
            id = ip * d;
            j = 0;
            while (j < d) {
                int n = id + j;
                gradient.m_data[n] = gradient.m_data[n] - grad.m_data[j];
                ++j;
            }
            ++i;
        }
        if (scaleInvariant) {
            double en = PnMinimumVariationCurve.evaluateEnergy(poly, false);
            gradient.blend(len * len * len, gradient, 3.0 * en * len * len, PnBendingCurve.getCurvatureVector(poly, null, false));
        }
        return gradient;
    }

    protected static final PdVector grad_O_Ei(PdVector em, PdVector e, PdVector ep, double lm, double l, double lp, PdVector grad, PdVector store) {
        PdVector a = store;
        a.blend(2.0 / ((lm + l) * lm), em, 2.0 / ((l + lp) * lp), ep);
        a.blendBase(a, -PdVector.dot((PdVector)e, (PdVector)a) / (l * l), e);
        grad.multScalar(em, 4.0 * PdVector.dot((PdVector)a, (PdVector)em) / (l * lm * lm * (lm + l) * (lm + l)));
        a.blendBase(a, -PdVector.dot((PdVector)em, (PdVector)a) / (lm * lm), em);
        grad.blendBase(grad, -4.0 / (l * lm * (lm + l)), a);
        return grad;
    }

    protected static final PdVector grad_P_Ei(PdVector em, PdVector e, PdVector ep, double lm, double l, double lp, PdVector grad, PdVector store1, PdVector store2) {
        PdVector a = store1;
        PdVector h = store2;
        a.blend(2.0 / ((lm + l) * lm), em, 2.0 / ((l + lp) * lp), ep);
        double aDote0 = PdVector.dot((PdVector)e, (PdVector)a) / l;
        a.blendBase(a, -aDote0 / l, e);
        h.blend(1.0 / l, e, -1.0 / lm, em);
        grad.multScalar(h, 4.0 * PdVector.dot((PdVector)a, (PdVector)em) / (l * lm * (lm + l) * (lm + l)));
        grad.blendBase(grad, 4.0 * PdVector.dot((PdVector)a, (PdVector)ep) / (lp * l * l * (l + lp) * (l + lp)), e);
        h.blendBase(a, -PdVector.dot((PdVector)a, (PdVector)em) / (lm * lm), em);
        grad.blendBase(grad, 4.0 / (lm * l * (lm + l)), h);
        grad.blendBase(grad, a.sqrLength() / (l * l * l), e);
        grad.blendBase(grad, 2.0 * aDote0 / (l * l), a);
        return grad;
    }

    protected static double dirichletEnergyOfCurvatureVector(PgPolygon poly) {
        PdVector cv = PnBendingCurve.getCurvatureVector(poly, null, true);
        PnDirichletCurve stiff = new PnDirichletCurve(poly);
        PnSparseMatrix stiff3d = PuSparseMatrix.one2nD(stiff, null, poly.getDimOfVertices());
        PdVector store = new PdVector(cv.getSize());
        PnSparseMatrix.rightMultVector((PnSparseMatrix)stiff3d, (PdVector)cv, (PdVector)store);
        return PdVector.dot((PdVector)store, (PdVector)cv);
    }

    protected static double dirichletEnergyOfCurvature(PgPolygon poly) {
        PdVector cv = PnBendingCurve.getCurvatureVector(poly, null, true);
        int n = poly.getNumVertices();
        int d = poly.getDimOfVertices();
        PdVector store = new PdVector(n);
        PdVector k = new PdVector(n);
        poly.makeVertexNormals();
        PdVector[] normals = poly.getVertexNormals();
        int i = 0;
        while (i < n) {
            int j = d * i;
            k.m_data[i] = 0.0;
            int l = 0;
            while (l < d) {
                int n2 = i;
                k.m_data[n2] = k.m_data[n2] + cv.m_data[j + l] * cv.m_data[j + l];
                ++l;
            }
            k.m_data[i] = Math.sqrt(k.m_data[i]);
            double dot = 0.0;
            int l2 = 0;
            while (l2 < d) {
                dot += normals[i].m_data[l2] * cv.m_data[j + l2];
                ++l2;
            }
            if (dot < 0.0) {
                int n3 = i;
                k.m_data[n3] = k.m_data[n3] * -1.0;
            }
            ++i;
        }
        PnDirichletCurve stiff = new PnDirichletCurve(poly);
        PnSparseMatrix.rightMultVector((PnSparseMatrix)stiff, (PdVector)k, (PdVector)store);
        return PdVector.dot((PdVector)store, (PdVector)k);
    }
}

