/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.util.kdtree.PuKdTree;
import jv.geom.PgPointSet;
import jv.vecmath.PiVector;

public class PnMeanSquaredError {
    public static double[][] meanSquaredError(PgPointSet[] geometries) {
        PuKdTree[] trees = new PuKdTree[geometries.length];
        double[][] errors = new double[geometries.length][geometries.length];
        int i = 0;
        while (i < geometries.length) {
            trees[i] = new PuKdTree(geometries[i]);
            int j = 0;
            while (j < geometries.length) {
                if (i == j) {
                    errors[j][i] = 0.0;
                } else {
                    errors[j][i] = 0.0;
                    int v = 0;
                    while (v < geometries[j].getNumVertices()) {
                        PiVector neighbor = trees[i].getNearestNeighbors(geometries[j].getVertex(v), 1, -1.0);
                        double[] dArray = errors[j];
                        int n = i;
                        dArray[n] = dArray[n] + Math.pow(geometries[j].getVertex(v).dist(geometries[i].getVertex(neighbor.getEntry(0))), 2.0);
                        ++v;
                    }
                    double[] dArray = errors[j];
                    int n = i;
                    dArray[n] = dArray[n] / (double)geometries[j].getNumVertices();
                }
                ++j;
            }
            ++i;
        }
        return errors;
    }
}

