/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.geom.PgPolygon;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnMassCurve
extends PnSparseMatrix {
    public PnMassCurve(PgPolygon curve) {
        this.allocateArrays(curve);
        if (((Object)((Object)this)).getClass() == PnMassCurve.class) {
            this.init(curve);
        }
    }

    public void allocateArrays(PgPolygon curve) {
        this.setSize(curve.getNumVertices());
        this.m_snoe.setConstant(3);
        this.m_sindx = PiVector.realloc((PiVector[])this.m_sindx, (int)this.m_iSize, (int)3);
        this.m_stiff = PdVector.realloc((PdVector[])this.m_stiff, (int)this.m_iSize, (int)3);
        int i = 1;
        while (i < this.m_iSize - 1) {
            this.m_sindx[i].m_data[0] = i - 1;
            this.m_sindx[i].m_data[1] = i;
            this.m_sindx[i].m_data[2] = i + 1;
            ++i;
        }
        this.m_sindx[0].m_data[0] = 1;
        this.m_sindx[0].m_data[1] = 0;
        this.m_sindx[this.m_iSize - 1].m_data[0] = this.m_iSize - 2;
        this.m_sindx[this.m_iSize - 1].m_data[1] = this.m_iSize - 1;
        if (curve.isClosed()) {
            this.m_sindx[0].m_data[2] = this.m_iSize - 1;
            this.m_sindx[this.m_iSize - 1].m_data[2] = 0;
        } else {
            this.m_snoe.m_data[0] = 2;
            this.m_snoe.m_data[this.m_iSize - 1] = 2;
            this.m_sindx[0].setSize(2);
            this.m_sindx[this.m_iSize - 1].setSize(2);
            this.m_stiff[0].setSize(2);
            this.m_stiff[this.m_iSize - 1].setSize(2);
        }
    }

    public void init(PgPolygon curve) {
        PdVector[] vertices = curve.getVertices();
        PdVector edge = new PdVector(curve.getDimOfVertices());
        double e0 = 0.0;
        double e1 = 0.0;
        edge.sub(vertices[1], vertices[0]);
        this.m_stiff[0].m_data[this.getIndex((int)0, (int)1)] = e0 = edge.length() / 6.0;
        this.m_stiff[0].m_data[this.getIndex((int)0, (int)0)] = 2.0 * e0;
        if (curve.isClosed()) {
            this.m_stiff[this.m_iSize - 1].m_data[this.getIndex((int)(this.m_iSize - 1), (int)(this.m_iSize - 1))] = 2.0 * e0;
            this.m_stiff[this.m_iSize - 1].m_data[this.getIndex((int)(this.m_iSize - 1), (int)0)] = e0;
        }
        int i = 1;
        while (i < this.m_iSize - 1) {
            edge.sub(vertices[i + 1], vertices[i]);
            e1 = edge.length() / 6.0;
            this.m_stiff[i].m_data[this.getIndex((int)i, (int)(i - 1))] = e0;
            this.m_stiff[i].m_data[this.getIndex((int)i, (int)i)] = 2.0 * (e0 + e1);
            this.m_stiff[i].m_data[this.getIndex((int)i, (int)(i + 1))] = e1;
            e0 = e1;
            ++i;
        }
        this.m_stiff[this.m_iSize - 1].m_data[this.getIndex((int)(this.m_iSize - 1), (int)(this.m_iSize - 2))] = e1;
        int n = this.getIndex(this.m_iSize - 1, this.m_iSize - 1);
        this.m_stiff[this.m_iSize - 1].m_data[n] = this.m_stiff[this.m_iSize - 1].m_data[n] + 2.0 * e1;
        if (curve.isClosed()) {
            int n2 = this.getIndex(0, 0);
            this.m_stiff[0].m_data[n2] = this.m_stiff[0].m_data[n2] + 2.0 * e1;
            this.m_stiff[0].m_data[this.getIndex((int)0, (int)(this.m_iSize - 1))] = e1;
        }
    }

    public static PdVector getLumpedMassMatrix(PgPolygon poly, PdVector mass) {
        double l1;
        double l2;
        int nov = poly.getNumVertices();
        if (mass == null) {
            mass = new PdVector(nov);
        } else if (mass.m_data.length != nov) {
            mass.setSize(nov);
        }
        mass.m_data[0] = l2 = 0.5 * poly.getLengthOfEdge(0);
        int i = 1;
        while (i < nov - 1) {
            l1 = l2;
            l2 = 0.5 * poly.getLengthOfEdge(i);
            mass.m_data[i] = l1 + l2;
            ++i;
        }
        mass.m_data[nov - 1] = l2;
        if (poly.isClosed()) {
            l1 = 0.5 * poly.getLengthOfEdge(nov - 1);
            mass.m_data[0] = mass.m_data[0] + l1;
            int n = nov - 1;
            mass.m_data[n] = mass.m_data[n] + l1;
        }
        return mass;
    }

    public static PdVector getInverseOfLumpedMassMatrix(PgPolygon poly, PdVector mass) {
        int nov = poly.getNumVertices();
        mass = PnMassCurve.getLumpedMassMatrix(poly, mass);
        int i = 0;
        while (i < nov) {
            mass.m_data[i] = mass.m_data[i] > 1.0E-10 ? 1.0 / mass.m_data[i] : 1.0;
            ++i;
        }
        return mass;
    }
}

