/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnPCA;
import dev.numeric.PnSigmoidFunctions;
import dev.numeric.PnWLS;
import java.security.InvalidParameterException;
import jv.geom.PgPointSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnMLS3D {
    public static double evaluateMLSFunctional(PiVector indices, PgPointSet points, PdVector normal, PdVector origin, double radius) {
        if (points.getDimOfVertices() != 3) {
            throw new InvalidParameterException("Expected point of dimension 3, was given " + points.getDimOfVertices());
        }
        if (normal.getSize() != 3) {
            throw new InvalidParameterException("Expected normal of dimension 3, was given " + normal.getSize());
        }
        if (origin.getSize() != 3) {
            throw new InvalidParameterException("Expected origin of dimension 3, was given " + origin.getSize());
        }
        double result = 0.0;
        int i = 0;
        while (i < indices.getSize()) {
            PdVector currentVertex = points.getVertex(indices.getEntry(i));
            double distance = currentVertex.dist(PnMLS3D.project3DtoHyperplane(currentVertex, normal, origin));
            result += Math.pow(distance, 2.0) * PnWLS.bumpFunction(origin.dist(currentVertex), radius);
            ++i;
        }
        return result;
    }

    public static PdVector mlsApproximation(double threshold, int maxIterations, PiVector neighborhood, PgPointSet points, double radius, PdVector point, int degree, boolean distanceBasedWeights, double normalWeight_a, double normalWeight_b) {
        PdVector[] linearResults = PnMLS3D.findProjectionHyperplane(threshold, maxIterations, neighborhood, points, radius, point, distanceBasedWeights, normalWeight_a, normalWeight_b);
        return PnMLS3D.polynomialApproximation(degree, neighborhood, points, linearResults[0], linearResults[1], linearResults[2], linearResults[3], radius, point, distanceBasedWeights, normalWeight_a, normalWeight_b);
    }

    public static PdVector polynomialApproximation(int degree, PiVector neighborhood, PgPointSet points, PdVector normal, PdVector basis1, PdVector basis2, PdVector projectedCenter, double radius, PdVector projectionPoint, boolean distanceBasedWeights, double normalWeight_a, double normalWeight_b) {
        if (points.getDimOfVertices() != 3) {
            throw new InvalidParameterException("Expected point of dimension 3, was given " + points.getDimOfVertices());
        }
        if (normal.getSize() != 3) {
            throw new InvalidParameterException("Expected normal of dimension 3, was given " + normal.getSize());
        }
        if (projectedCenter.getSize() != 3) {
            throw new InvalidParameterException("Expected projectedCenter of dimension 3, was given " + projectedCenter.getSize());
        }
        if (basis1.getSize() != 3) {
            throw new InvalidParameterException("Expected basis1 of dimension 3, was given " + basis1.getSize());
        }
        if (basis2.getSize() != 3) {
            throw new InvalidParameterException("Expected basis2 of dimension 3, was given " + basis2.getSize());
        }
        PnWLS wls = new PnWLS(2, degree);
        PdVector localDistances = new PdVector(neighborhood.getSize());
        PdVector weights = new PdVector(neighborhood.getSize());
        PgPointSet projections = new PgPointSet(2);
        projections.setNumVertices(neighborhood.getSize());
        int i = 0;
        while (i < neighborhood.getSize()) {
            localDistances.setEntry(i, -1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)points.getVertex(neighborhood.getEntry(i)), (PdVector)projectedCenter), (PdVector)normal));
            projections.setVertex(i, PnMLS3D.project3Dto2D(points.getVertex(neighborhood.getEntry(i)), normal, projectedCenter, basis1, basis2));
            if (distanceBasedWeights) {
                weights.setEntry(i, Math.sqrt(PnWLS.bumpFunction(PdVector.subNew((PdVector)points.getVertex(neighborhood.getEntry(i)), (PdVector)projectedCenter).length(), radius)));
            } else {
                double x = (PdVector.dot((PdVector)normal, (PdVector)points.getVertexNormal(neighborhood.getEntry(i))) + 1.0) / 2.0;
                if (x > 1.0) {
                    x = 1.0;
                }
                if (x < 0.0) {
                    x = 0.0;
                }
                weights.setEntry(i, PnSigmoidFunctions.sigmoid_cos(normalWeight_a, normalWeight_b, x) * PnWLS.bumpFunction(normal.dist(points.getVertex(neighborhood.getEntry(i))), radius));
            }
            ++i;
        }
        double[] wlsWeights = wls.weightedLeastSquares(projections, localDistances, weights);
        double height = wls.evaluatePolynomial(PnMLS3D.project3Dto2D(projectionPoint, normal, projectedCenter, basis1, basis2), wlsWeights);
        projectedCenter.add(-1.0 * height, normal);
        return projectedCenter;
    }

    public static PdVector[] findProjectionHyperplane(double threshold, int maxIterations, PiVector neighborhood, PgPointSet points, double radius, PdVector point, boolean distanceBasedWeights, double normalWeight_a, double normalWeight_b) {
        if (points.getDimOfVertices() != 3) {
            throw new InvalidParameterException("Expected points of dimension 3, was given " + points.getDimOfVertices());
        }
        PnWLS wls = new PnWLS(2, 1);
        PdVector baryCenter = PnPCA.getBarycenter(points, neighborhood);
        PdVector baryCenterNormal = new PdVector(3);
        int i = 0;
        while (i < neighborhood.getSize()) {
            baryCenterNormal.add(points.getVertexNormal(neighborhood.getEntry(i)));
            ++i;
        }
        baryCenterNormal.multScalar(1.0 / (double)neighborhood.getSize());
        PdVector weights = new PdVector(neighborhood.getSize());
        int i2 = 0;
        while (i2 < neighborhood.getSize()) {
            if (distanceBasedWeights) {
                weights.setEntry(i2, PnWLS.bumpFunction(baryCenter.dist(points.getVertex(neighborhood.getEntry(i2))), radius));
            } else {
                double x = (PdVector.dot((PdVector)baryCenterNormal, (PdVector)points.getVertexNormal(neighborhood.getEntry(i2))) + 1.0) / 2.0;
                if (x > 1.0) {
                    x = 1.0;
                }
                if (x < 0.0) {
                    x = 0.0;
                }
                weights.setEntry(i2, PnSigmoidFunctions.sigmoid_cos(normalWeight_a, normalWeight_b, x) * PnWLS.bumpFunction(baryCenter.dist(points.getVertex(neighborhood.getEntry(i2))), radius));
            }
            ++i2;
        }
        PdVector[] principalComponents = PnPCA.getPrincipalComponents(points, neighborhood, weights);
        PdVector basis1 = principalComponents[0];
        PdVector basis2 = principalComponents[1];
        PdVector normal = principalComponents[2];
        PdVector projectedCenter = PdVector.blendNew((double)1.0, (PdVector)point, (double)(-1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)point, (PdVector)baryCenter), (PdVector)normal)), (PdVector)normal);
        double distanceImprovement = Double.POSITIVE_INFINITY;
        int iteration = 0;
        while (distanceImprovement > threshold && iteration < maxIterations) {
            ++iteration;
            PdVector localDistances = new PdVector(neighborhood.getSize());
            weights = new PdVector(neighborhood.getSize());
            PgPointSet projections = new PgPointSet(2);
            int i3 = 0;
            while (i3 < neighborhood.getSize()) {
                localDistances.setEntry(i3, -1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)points.getVertex(neighborhood.getEntry(i3)), (PdVector)projectedCenter), (PdVector)normal));
                projections.setVertex(i3, PnMLS3D.project3Dto2D(points.getVertex(neighborhood.getEntry(i3)), normal, projectedCenter, basis1, basis2));
                if (distanceBasedWeights) {
                    weights.setEntry(i3, Math.sqrt(PnWLS.bumpFunction(PdVector.subNew((PdVector)points.getVertex(neighborhood.getEntry(i3)), (PdVector)projectedCenter).length(), radius)));
                } else {
                    double x;
                    if (normal.dot(PdVector.subNew((PdVector)point, (PdVector)projectedCenter)) < 0.0) {
                        normal.multScalar(-1.0);
                    }
                    if ((x = (PdVector.dot((PdVector)normal, (PdVector)points.getVertexNormal(neighborhood.getEntry(i3))) + 1.0) / 2.0) > 1.0) {
                        x = 1.0;
                    }
                    if (x < 0.0) {
                        x = 0.0;
                    }
                    weights.setEntry(i3, PnSigmoidFunctions.sigmoid_cos(normalWeight_a, normalWeight_b, x) * PnWLS.bumpFunction(baryCenter.dist(points.getVertex(neighborhood.getEntry(i3))), radius));
                }
                ++i3;
            }
            double[] wlsWeights = wls.weightedLeastSquares(projections, localDistances, weights);
            double newHeight = wls.evaluatePolynomial(new PdVector(0.0, 0.0), wlsWeights);
            PdVector tempOrigin = PdVector.blendNew((double)1.0, (PdVector)projectedCenter, (double)(-1.0 * newHeight), (PdVector)normal);
            basis1 = PdVector.addNew((PdVector)projectedCenter, (PdVector)basis1);
            newHeight = wls.evaluatePolynomial(new PdVector(1.0, 0.0), wlsWeights);
            basis1 = PdVector.blendNew((double)1.0, (PdVector)basis1, (double)(-1.0 * newHeight), (PdVector)normal);
            basis1 = PdVector.subNew((PdVector)basis1, (PdVector)tempOrigin);
            basis1.normalize();
            basis2 = PdVector.addNew((PdVector)projectedCenter, (PdVector)basis2);
            newHeight = wls.evaluatePolynomial(new PdVector(0.0, 1.0), wlsWeights);
            basis2 = PdVector.blendNew((double)1.0, (PdVector)basis2, (double)(-1.0 * newHeight), (PdVector)normal);
            basis2 = PdVector.subNew((PdVector)basis2, (PdVector)tempOrigin);
            basis2.blendBase(basis2, -1.0 * PdVector.dot((PdVector)basis1, (PdVector)basis2), basis1);
            basis2.normalize();
            PdVector newNormal = PdVector.crossNew((PdVector)basis1, (PdVector)basis2);
            newNormal.normalize();
            normal = newNormal;
            PdVector newProjectedCenter = PdVector.blendNew((double)PdVector.dot((PdVector)PdVector.subNew((PdVector)point, (PdVector)tempOrigin), (PdVector)basis1), (PdVector)basis1, (double)PdVector.dot((PdVector)PdVector.subNew((PdVector)point, (PdVector)tempOrigin), (PdVector)basis2), (PdVector)basis2, (double)1.0, (PdVector)tempOrigin);
            distanceImprovement = newProjectedCenter.dist(projectedCenter);
            projectedCenter = newProjectedCenter;
        }
        PdVector[] results = new PdVector[]{normal, basis1, basis2, projectedCenter, new PdVector((double)iteration)};
        return results;
    }

    public static PdVector project3Dto2D(PdVector point, PdVector normal, PdVector origin, PdVector basis1, PdVector basis2) throws InvalidParameterException {
        if (point.getSize() != 3) {
            throw new InvalidParameterException("Expected point of dimension 3, was given " + point.getSize());
        }
        if (normal.getSize() != 3) {
            throw new InvalidParameterException("Expected normal of dimension 3, was given " + normal.getSize());
        }
        if (origin.getSize() != 3) {
            throw new InvalidParameterException("Expected origin of dimension 3, was given " + origin.getSize());
        }
        if (basis1.getSize() != 3) {
            throw new InvalidParameterException("Expected basis1 of dimension 3, was given " + basis1.getSize());
        }
        if (basis2.getSize() != 3) {
            throw new InvalidParameterException("Expected basis2 of dimension 3, was given " + basis2.getSize());
        }
        PdVector projection = PdVector.blendNew((double)1.0, (PdVector)point, (double)(-1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)point, (PdVector)origin), (PdVector)normal)), (PdVector)normal);
        return new PdVector(-1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)origin, (PdVector)projection), (PdVector)basis1), -1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)origin, (PdVector)projection), (PdVector)basis2));
    }

    public static PdVector project3DtoHyperplane(PdVector point, PdVector normal, PdVector origin) {
        if (point.getSize() != 3) {
            throw new InvalidParameterException("Expected point of dimension 3, was given " + point.getSize());
        }
        if (normal.getSize() != 3) {
            throw new InvalidParameterException("Expected normal of dimension 3, was given " + normal.getSize());
        }
        if (origin.getSize() != 3) {
            throw new InvalidParameterException("Expected origin of dimension 3, was given " + origin.getSize());
        }
        return PdVector.blendNew((double)1.0, (PdVector)point, (double)(-1.0 * PdVector.dot((PdVector)PdVector.subNew((PdVector)point, (PdVector)origin), (PdVector)normal)), (PdVector)normal);
    }
}

