/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnDirichletCurve;
import dev.numeric.PnFunctionWithSparseHessian;
import jv.geom.PgPolygon;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnLengthCurve
extends PnFunctionWithSparseHessian {
    protected boolean m_bEvaluable = true;
    protected PgPolygon m_geom;
    protected boolean m_bUseInexactHessian = true;
    protected PnDirichletCurve m_stiffCurve;
    protected double diagAdd = 0.001;
    public static double m_lengthFactor = 0.0;

    public PnLengthCurve(PgPolygon geom) {
        this.m_geom = geom;
    }

    public boolean isEvaluable() {
        return this.m_bEvaluable;
    }

    public void enableEvaluation(boolean flag) {
        this.m_bEvaluable = flag;
    }

    public int getNumOfVariables() {
        return this.m_geom.getNumVertices();
    }

    public double eval(PdVector x) {
        return PnLengthCurve.evaluateEnergy(this.m_geom, x);
    }

    public PdVector evalGradient(PdVector x, PdVector aGradient) {
        return PnLengthCurve.evaluateGradient(this.m_geom, x, aGradient);
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return aHessian;
    }

    @Override
    public PnSparseMatrix evalSparseHessian(PdVector x, PnSparseMatrix hessian) {
        if (this.m_bUseInexactHessian) {
            if (this.m_stiffCurve == null) {
                this.m_stiffCurve = new PnDirichletCurve(this.m_geom);
            } else {
                this.m_stiffCurve.init(this.m_geom);
            }
            int n = this.m_stiffCurve.getNumRows();
            int i = 0;
            while (i < n) {
                this.m_stiffCurve.addEntry(i, i, this.diagAdd);
                ++i;
            }
            return this.m_stiffCurve;
        }
        return null;
    }

    public static double evaluateEnergy(PgPolygon poly, PdVector vertPositions) {
        boolean closed;
        double energy = 0.0;
        int nov = poly.getNumVertices();
        double len = 0.0;
        int d = poly.getDimOfVertices();
        boolean bUseVertPosVector = vertPositions != null;
        PdVector[] vertices = null;
        if (!bUseVertPosVector) {
            vertices = poly.getVertices();
        }
        int end = (closed = poly.isClosed()) ? nov : nov - 1;
        int i = 0;
        while (i < end) {
            int ip = (i + 1) % nov;
            len = 0.0;
            if (bUseVertPosVector) {
                int j = 0;
                while (j < d) {
                    len += (vertPositions.m_data[d * i + j] - vertPositions.m_data[d * ip + j]) * (vertPositions.m_data[d * i + j] - vertPositions.m_data[d * ip + j]);
                    ++j;
                }
                len = Math.sqrt(len);
            } else {
                len = PdVector.dist((PdVector)vertices[i], (PdVector)vertices[ip]);
            }
            energy += len;
            ++i;
        }
        return energy;
    }

    public static double evaluateEnergy(PgPolygon poly) {
        return PnLengthCurve.evaluateEnergy(poly, null);
    }

    public static PdVector getCurvatureVector(PgPolygon poly, PdVector curvatureVector) {
        return PnLengthCurve.getCurvatureVector(poly, null, curvatureVector, true);
    }

    public static PdVector getCurvatureVector(PgPolygon poly, PdVector curvatureVector, boolean multWithInverseMass) {
        return PnLengthCurve.getCurvatureVector(poly, null, curvatureVector, multWithInverseMass);
    }

    public static PdVector getCurvatureVector(PgPolygon poly, PdVector vertexPositions, PdVector curvatureVector, boolean multWithInverseMass) {
        int nov = poly.getNumVertices();
        int d = poly.getDimOfVertices();
        if (curvatureVector == null) {
            curvatureVector = new PdVector(nov * d);
        } else if (curvatureVector.m_data.length != nov * d) {
            curvatureVector.setSize(nov * d);
        }
        PdVector e1 = new PdVector(d);
        PdVector e2 = new PdVector(d);
        boolean bUseVertPosVector = vertexPositions != null;
        PdVector[] vertices = null;
        double[] x = null;
        if (!bUseVertPosVector) {
            vertices = poly.getVertices();
        } else {
            x = vertexPositions.m_data;
        }
        boolean closed = poly.isClosed();
        int start = closed ? 0 : 1;
        int end = closed ? nov : nov - 1;
        int i = start;
        while (i < end) {
            int j;
            int im = (i + nov - 1) % nov;
            int ip = (i + 1) % nov;
            if (bUseVertPosVector) {
                j = 0;
                while (j < d) {
                    e1.m_data[j] = x[d * i + j] - x[d * im + j];
                    e2.m_data[j] = x[d * i + j] - x[d * ip + j];
                    ++j;
                }
            } else {
                e1.sub(vertices[i], vertices[im]);
                e2.sub(vertices[i], vertices[ip]);
            }
            double l1 = e1.length();
            double l2 = e2.length();
            e1.multScalar(1.0 / l1);
            e2.multScalar(1.0 / l2);
            int id = i * d;
            double mInv = 2.0 / (l1 + l2);
            if (multWithInverseMass) {
                j = 0;
                while (j < d) {
                    curvatureVector.m_data[id + j] = mInv * (e1.m_data[j] + e2.m_data[j]);
                    ++j;
                }
            } else {
                j = 0;
                while (j < d) {
                    curvatureVector.m_data[id + j] = e1.m_data[j] + e2.m_data[j];
                    ++j;
                }
            }
            ++i;
        }
        return curvatureVector;
    }

    public static PdVector evaluateGradient(PgPolygon poly, PdVector vertexPositions, PdVector gradient) {
        return PnLengthCurve.getCurvatureVector(poly, vertexPositions, gradient, true);
    }

    public static PnSparseMatrix evalHessian(PgPolygon poly, PnSparseMatrix hessian) {
        return hessian;
    }
}

