/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PnLUFactorization {
    protected PdMatrix m_factors;
    protected int[] m_pivots;
    private PdVector m_z;
    private PdVector m_py;

    public PnLUFactorization(PdMatrix matrix) {
        this.m_factors = matrix;
        this.m_pivots = new int[matrix.getSize()];
        this.factorize();
    }

    private void factorize() {
        double[][] LU = this.m_factors.m_data;
        int i = 0;
        while (i < LU.length) {
            this.m_pivots[i] = PnLUFactorization.pivot(i, this.m_factors);
            if (LU[i][this.m_pivots[i]] == 0.0) {
                throw new IllegalArgumentException("matrix is singular");
            }
            if (i != this.m_pivots[i]) {
                PnLUFactorization.swapRows(this.m_factors, i, this.m_pivots[i]);
            }
            double s = 1.0 / LU[i][i];
            int k = i + 1;
            while (k < LU.length) {
                double[] dArray = LU[k];
                int n = i;
                dArray[n] = dArray[n] * s;
                int l = i + 1;
                while (l < LU.length) {
                    LU[k][l] = LU[k][l] - LU[k][i] * LU[i][l];
                    ++l;
                }
                ++k;
            }
            ++i;
        }
    }

    private static void swapRows(PdMatrix matrix, int i, int p) {
        double[] tmp = matrix.m_data[i];
        matrix.m_data[i] = matrix.m_data[p];
        matrix.m_data[p] = tmp;
    }

    private static int pivot(int i, PdMatrix matrix) {
        int pivot = i;
        double max = 0.0;
        int j = i;
        while (j < matrix.m_data.length) {
            double cur = Math.abs(matrix.m_data[j][i]);
            if (cur > max) {
                max = cur;
                pivot = j;
            }
            ++j;
        }
        return pivot;
    }

    public void solve(PdVector x, PdVector y) {
        if (this.m_z == null) {
            this.m_z = new PdVector(y.getSize());
            this.m_py = new PdVector(y.getSize());
        }
        this.m_py.copy(y);
        int i = 0;
        while (i < this.m_pivots.length) {
            double tmp = this.m_py.m_data[i];
            this.m_py.m_data[i] = this.m_py.m_data[this.m_pivots[i]];
            this.m_py.m_data[this.m_pivots[i]] = tmp;
            ++i;
        }
        i = 0;
        while (i < this.m_z.getSize()) {
            this.m_z.m_data[i] = this.m_py.m_data[i];
            int j = 0;
            while (j < i) {
                int n = i;
                this.m_z.m_data[n] = this.m_z.m_data[n] - this.m_z.m_data[j] * this.m_factors.m_data[i][j];
                ++j;
            }
            ++i;
        }
        i = x.getSize() - 1;
        while (i >= 0) {
            x.m_data[i] = this.m_z.m_data[i];
            int j = i + 1;
            while (j < x.getSize()) {
                int n = i;
                x.m_data[n] = x.m_data[n] - x.m_data[j] * this.m_factors.m_data[i][j];
                ++j;
            }
            int n = i;
            x.m_data[n] = x.m_data[n] / this.m_factors.m_data[i][i];
            --i;
        }
    }

    public PdMatrix getFactors() {
        return this.m_factors;
    }

    public void setFactors(PdMatrix LU) {
        this.m_factors = LU;
    }

    public int[] getPivots() {
        return this.m_pivots;
    }

    public void setPivots(int[] pivots) {
        this.m_pivots = pivots;
    }
}

