/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.object.PsDebug;
import jv.vecmath.PbVector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PnGaussMethod {
    private PdMatrix m_matrix;
    private PdVector m_rhs;
    private PbVector m_freeVars;
    private int m_numNonzeroRows;

    public void makeTriagonal(PdMatrix matrix) {
        this.makeTriangular(matrix, 0.0);
    }

    public void makeTriangular(PdMatrix matrix) {
        this.makeTriangular(matrix, 0.0);
    }

    public void makeTriangular(PdMatrix matrix, PdVector rhs) {
        this.makeTriangular(matrix, rhs, 0.0);
    }

    public void makeTriagonal(PdMatrix matrix, double eps) {
        this.makeTriangular(matrix, null, eps);
    }

    public void makeTriangular(PdMatrix matrix, double eps) {
        this.makeTriangular(matrix, null, eps);
    }

    public void makeTriangular(PdMatrix matrix, PdVector rhs, double eps) {
        int numRows = matrix.getNumRows();
        int numCols = matrix.getNumCols();
        this.m_matrix = new PdMatrix(numRows, numCols);
        this.m_matrix.copy(matrix);
        this.m_freeVars = new PbVector(numCols);
        this.m_rhs = rhs != null && numRows == rhs.getSize() ? PdVector.copyNew((PdVector)rhs) : new PdVector(numRows);
        int i = 0;
        int actVar = 0;
        while (actVar < numCols) {
            int pivot = -1;
            double maxVal = eps;
            int i2 = i;
            while (i2 < numRows) {
                double val = Math.abs(this.m_matrix.m_data[i2][actVar]);
                if (val > eps && val > maxVal) {
                    pivot = i2;
                    maxVal = val;
                }
                ++i2;
            }
            if (maxVal <= eps) {
                this.m_freeVars.m_data[actVar] = true;
            } else {
                if (i != pivot) {
                    double tmpVal = this.m_rhs.m_data[i];
                    this.m_rhs.m_data[i] = this.m_rhs.m_data[pivot];
                    this.m_rhs.m_data[pivot] = tmpVal;
                    int j = actVar;
                    while (j < numCols) {
                        tmpVal = this.m_matrix.m_data[i][j];
                        this.m_matrix.m_data[i][j] = this.m_matrix.m_data[pivot][j];
                        this.m_matrix.m_data[pivot][j] = tmpVal;
                        ++j;
                    }
                }
                i2 = i + 1;
                while (i2 < numRows) {
                    double value = this.m_matrix.m_data[i2][actVar];
                    this.m_matrix.m_data[i2][actVar] = 0.0;
                    if (!(Math.abs(value) <= eps)) {
                        int j = actVar + 1;
                        while (j < numCols) {
                            this.m_matrix.m_data[i2][j] = this.m_matrix.m_data[i2][j] * this.m_matrix.m_data[i][actVar] - this.m_matrix.m_data[i][j] * value;
                            ++j;
                        }
                        this.m_rhs.m_data[i2] = this.m_rhs.m_data[i2] * this.m_matrix.m_data[i][actVar] - this.m_rhs.m_data[i] * value;
                    }
                    ++i2;
                }
                if (++i >= numRows) {
                    int j = actVar + 1;
                    while (j < numCols) {
                        this.m_freeVars.m_data[j] = true;
                        ++j;
                    }
                    break;
                }
            }
            ++actVar;
        }
        this.m_numNonzeroRows = i;
    }

    public PdMatrix getTrigonalMatrix() {
        return this.m_matrix;
    }

    public PdMatrix getTriangularMatrix() {
        return this.m_matrix;
    }

    public PbVector getFreeVariables() {
        return this.m_freeVars;
    }

    public void solveForVector(PdVector vec) {
        if (this.m_matrix == null) {
            PsDebug.warning((String)"Gauss method not initialized. Call makeTriangular() first.");
            return;
        }
        if (vec.getSize() != this.m_matrix.getNumCols()) {
            PsDebug.warning((String)"Dimension of vector does not match");
            return;
        }
        int numCols = this.m_matrix.getNumCols();
        int i = this.m_numNonzeroRows - 1;
        int j = numCols - 1;
        while (j >= 0) {
            if (!this.m_freeVars.m_data[j]) {
                double val = 0.0;
                val = this.m_rhs.m_data[i];
                int j2 = j + 1;
                while (j2 < numCols) {
                    val += this.m_matrix.m_data[i][j2] * vec.m_data[j2];
                    ++j2;
                }
                vec.m_data[j] = -val / this.m_matrix.m_data[i][j];
                --i;
            }
            --j;
        }
    }
}

