/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jvx.numeric.PnMatrix;

public class PnFunctionSmoother {
    public static PdVector smooth(int nv, PdVector function, PdVector gaps, boolean bPeriodic, double stepsize, int num, boolean bUseMass) {
        if (nv < 3) {
            return function;
        }
        if (stepsize < 0.0) {
            stepsize = PnFunctionSmoother.guessStepSize(nv, gaps, bPeriodic, bUseMass);
        }
        int k = 0;
        while (k < num) {
            int lastind;
            int firstind;
            int next;
            int previous;
            if (bPeriodic) {
                previous = nv - 1;
                next = 1;
                firstind = 0;
                lastind = nv - 1;
            } else {
                previous = 0;
                next = 2;
                firstind = 1;
                lastind = nv - 2;
            }
            double prevval = function.m_data[previous];
            double val = function.m_data[firstind];
            double firstval = function.m_data[firstind];
            int i = firstind;
            while (i <= lastind) {
                double nextval = i < nv - 1 ? function.m_data[next] : firstval;
                double laplacian = (nextval - val) / gaps.m_data[i] + (prevval - val) / gaps.m_data[previous];
                if (bUseMass) {
                    laplacian *= 2.0 / (gaps.m_data[i] + gaps.m_data[previous]);
                }
                int n = i;
                function.m_data[n] = function.m_data[n] + stepsize * laplacian;
                prevval = val;
                val = nextval;
                ++next;
                if (++previous >= nv) {
                    previous %= nv;
                }
                if (next >= nv) {
                    next %= nv;
                }
                ++i;
            }
            ++k;
        }
        return function;
    }

    public static double guessStepSize(int nv, PdVector gaps, boolean bPeriodic, boolean bMass) {
        return PnFunctionSmoother.guessStepSize(nv, gaps, bPeriodic, bMass, null);
    }

    public static double guessStepSize(int nv, PdVector gaps, boolean bPeriodic, boolean bMass, boolean[] bFixed) {
        int pi;
        int last;
        int first;
        double mrow = 0.0;
        double mcol = 0.0;
        double ep = 0.0;
        int ppi = 0;
        if (bPeriodic) {
            first = 0;
            last = nv - 1;
            pi = nv - 1;
            ppi = nv - 2;
        } else {
            first = 1;
            last = nv - 2;
            pi = 0;
            mrow = 1.0;
            mcol = 1.0;
        }
        if (gaps.m_data[pi] < 1.0E-10 || gaps.m_data[first] < 1.0E-10) {
            PsDebug.warning((String)"degenerated edges");
            return Double.NaN;
        }
        if (pi >= 0 && pi < nv) {
            ep = 1.0 / gaps.m_data[pi];
        }
        int i = first;
        while (i <= last) {
            double single;
            int ni = (i + 1) % nv;
            if (bPeriodic && gaps.m_data[ni] < 1.0E-10) {
                PsDebug.warning((String)"degenerated edges");
                return Double.NaN;
            }
            double en = 1.0 / gaps.m_data[i];
            if (bFixed != null && bFixed[i]) {
                single = 1.0;
            } else {
                single = 2.0 * (ep + en);
                if (bMass) {
                    single *= 2.0 / (gaps.m_data[pi] + gaps.m_data[i]);
                }
            }
            if (mrow < single) {
                mrow = single;
            }
            if (bPeriodic) {
                single = ep + en;
                if (bMass) {
                    single /= gaps.m_data[pi] + gaps.m_data[i];
                    if (bFixed == null || !bFixed[pi]) {
                        single += ep / (gaps.m_data[ppi] + gaps.m_data[pi]);
                    }
                    if (bFixed == null || !bFixed[ni]) {
                        single += en / (gaps.m_data[i] + gaps.m_data[ni]);
                    }
                    single *= 2.0;
                } else {
                    if (bFixed == null || !bFixed[pi]) {
                        single += ep;
                    }
                    if (bFixed == null || !bFixed[ni]) {
                        single += en;
                    }
                }
            } else {
                single = ep + en;
                if (bMass) {
                    single *= 2.0 / (gaps.m_data[pi] + gaps.m_data[i]);
                }
                if (!(i <= first || bFixed != null && bFixed[pi])) {
                    single = bMass ? (single += 2.0 * ep / (gaps.m_data[ppi] + gaps.m_data[pi])) : (single += ep);
                }
                if (!(i >= last || bFixed != null && bFixed[ni])) {
                    single = bMass ? (single += 2.0 * en / (gaps.m_data[i] + gaps.m_data[ni])) : (single += en);
                }
            }
            if (mcol < single) {
                mcol = single;
            }
            ep = en;
            pi = i++;
        }
        mrow *= mcol;
        if ((mrow = Math.sqrt(mrow)) > 1.0E-10) {
            return 1.99 / mrow;
        }
        return Double.NaN;
    }

    public static double guessStepSize(int nv, PdVector gaps, boolean bPeriodic, PdVector curvature, PdVector preCurvature, boolean[] bFixed) {
        int prevIndex;
        int last;
        int first;
        double mrow = 0.0;
        double mcol = 0.0;
        double prevEdgeReciproce = 0.0;
        int maxind = 0;
        int prevPrevIndex = 0;
        if (bPeriodic) {
            first = 0;
            last = nv - 1;
            prevIndex = nv - 1;
            prevPrevIndex = nv - 2;
        } else {
            first = 1;
            last = nv - 2;
            prevIndex = 0;
            mrow = 1.0;
            mcol = 1.0;
        }
        if (prevIndex >= 0 && prevIndex < nv) {
            prevEdgeReciproce = 1.0 / gaps.m_data[prevIndex];
        }
        int i = first;
        while (i <= last) {
            int nextIndex = (i + 1) % nv;
            double nextEdgeReciproce = 1.0 / gaps.m_data[i];
            double single = bFixed != null && bFixed[i] ? 1.0 : (Math.abs(curvature.m_data[i]) > 1.0E-10 ? Math.abs((curvature.m_data[i] - preCurvature.m_data[i]) / curvature.m_data[i]) * 4.0 * (prevEdgeReciproce + nextEdgeReciproce) / (gaps.m_data[prevIndex] + gaps.m_data[i]) : 4.0 * (prevEdgeReciproce + nextEdgeReciproce) / (gaps.m_data[prevIndex] + gaps.m_data[i]));
            if (mrow < single) {
                mrow = single;
                maxind = i;
            }
            if (bPeriodic) {
                single = prevEdgeReciproce + nextEdgeReciproce / (gaps.m_data[prevIndex] + gaps.m_data[i]);
                if (bFixed == null || !bFixed[prevIndex]) {
                    single += prevEdgeReciproce / (gaps.m_data[prevPrevIndex] + gaps.m_data[prevIndex]);
                }
                if (bFixed == null || !bFixed[nextIndex]) {
                    single += nextEdgeReciproce / (gaps.m_data[i] + gaps.m_data[nextIndex]);
                }
                single *= 2.0;
            } else {
                single = 2.0 * (prevEdgeReciproce + nextEdgeReciproce) / (gaps.m_data[prevIndex] + gaps.m_data[i]);
                if (!(i <= first || bFixed != null && bFixed[prevIndex])) {
                    single += 2.0 * prevEdgeReciproce / (gaps.m_data[prevPrevIndex] + gaps.m_data[prevIndex]);
                }
                if (!(i >= last || bFixed != null && bFixed[nextIndex])) {
                    single += 2.0 * nextEdgeReciproce / (gaps.m_data[i] + gaps.m_data[nextIndex]);
                }
            }
            if (mcol < single) {
                mcol = single;
                maxind = -2;
            }
            prevEdgeReciproce = nextEdgeReciproce;
            prevIndex = i++;
        }
        mrow *= mcol;
        mrow = Math.sqrt(mrow);
        if (maxind >= 0) {
            System.err.println("index=" + maxind + " curv=" + curvature.m_data[maxind] + " prec=" + preCurvature.m_data[maxind]);
        }
        if (mrow > 1.0E-10) {
            return 1.99 / mrow;
        }
        return Double.NaN;
    }

    public static PdVector smoothImplicit(int nv, PdVector function, PdVector gaps, boolean bPeriodic, double stepsize, int num, boolean bUseMass) {
        return PnFunctionSmoother.smoothImplicit(nv, function, gaps, bPeriodic, stepsize, num, bUseMass, null, null, null, null, null, null, null, null);
    }

    public static PdVector smoothImplicit(int nv, PdVector function, PdVector gaps, boolean bPeriodic, double stepsize, int num, boolean bUseMass, double[] a, double[] b, double[] c, double[] u, double[] t1, double[] t2, double[] t3, double[] t4) {
        int ne;
        int start;
        if (nv < 3) {
            return function;
        }
        if (a == null) {
            a = new double[nv];
        }
        if (b == null) {
            b = new double[nv];
        }
        if (c == null) {
            c = new double[nv];
        }
        if (u == null) {
            u = new double[nv];
        }
        if (t1 == null) {
            t1 = new double[nv];
        }
        if (t2 == null && bPeriodic) {
            t2 = new double[nv];
        }
        if (t3 == null && bPeriodic) {
            t3 = new double[nv];
        }
        if (t4 == null && bPeriodic) {
            t4 = new double[nv];
        }
        if (bPeriodic) {
            start = 0;
            ne = nv;
        } else {
            start = 1;
            ne = nv - 1;
        }
        double prev = stepsize / gaps.m_data[(start - 1 + nv) % nv];
        int i = start;
        while (i < ne) {
            double next = stepsize / gaps.m_data[i];
            a[i] = -prev;
            c[i] = -next;
            if (bUseMass) {
                prev = 1.0 / (gaps.m_data[(i - 1 + nv) % nv] + gaps.m_data[i]);
                int n = i;
                a[n] = a[n] * prev;
                int n2 = i;
                c[n2] = c[n2] * prev;
            }
            b[i] = 1.0 - a[i] - c[i];
            prev = next;
            ++i;
        }
        if (!bPeriodic) {
            a[0] = 0.0;
            b[0] = 1.0;
            c[0] = 0.0;
            a[nv - 1] = 0.0;
            b[nv - 1] = 1.0;
            c[nv - 1] = 0.0;
        }
        int k = 0;
        while (k < num) {
            boolean suc = bPeriodic ? PnMatrix.cyclic((double[])a, (double[])b, (double[])c, (double[])function.m_data, (double[])u, (double[])t1, (double[])t2, (double[])t3, (double[])t4, (int)nv, (double)1.0E-10) : PnMatrix.tridag((double[])a, (double[])b, (double[])c, (double[])function.m_data, (double[])u, (double[])t1, (int)nv, (double)1.0E-10);
            if (!suc) {
                PsDebug.warning((String)"error solving implicit equation");
                return null;
            }
            System.arraycopy(u, 0, function.m_data, 0, nv);
            ++k;
        }
        return function;
    }

    public static PdVector smoothEqual(int nv, PdVector function, boolean bPeriodic, int num) {
        return PnFunctionSmoother.smoothEqual(nv, function, bPeriodic, num, null);
    }

    public static PdVector smoothEqual(int nv, PdVector function, boolean bPeriodic, int num, boolean[] bFixed) {
        if (function == null || num <= 0) {
            return function;
        }
        if (nv < 3) {
            return function;
        }
        int k = 0;
        while (k < num) {
            int lastind;
            int firstind;
            int next;
            int previous;
            if (bPeriodic) {
                previous = nv - 1;
                next = 1;
                firstind = 0;
                lastind = nv - 1;
            } else {
                previous = 0;
                next = 2;
                firstind = 1;
                lastind = nv - 2;
            }
            double prevval = function.m_data[previous];
            double val = function.m_data[firstind];
            double firstval = function.m_data[firstind];
            int i = firstind;
            while (i <= lastind) {
                double nextval = i < nv - 1 ? function.m_data[next] : firstval;
                if (bFixed == null || bFixed.length <= i || !bFixed[i]) {
                    function.m_data[i] = 0.25 * prevval + 0.5 * val + 0.25 * nextval;
                }
                prevval = val;
                val = nextval;
                ++next;
                if (++previous >= nv) {
                    previous %= nv;
                }
                if (next >= nv) {
                    next %= nv;
                }
                ++i;
            }
            ++k;
        }
        return function;
    }

    public static PdVector smoothPrescribed(int nv, PdVector function, PdVector gaps, boolean bPeriodic, int curvatureSmoothSteps, boolean bEqual, boolean bMass, double curvStepSize, int num, double stepsize) {
        if (nv < 3) {
            return function;
        }
        PdVector laplacian = new PdVector(nv);
        int pass = 0;
        int k = 0;
        while (k < num) {
            int lastind;
            int firstind;
            int next;
            int previous;
            if (bPeriodic) {
                previous = nv - 1;
                next = 1;
                firstind = 0;
                lastind = nv - 1;
            } else {
                previous = 0;
                next = 2;
                firstind = 1;
                lastind = nv - 2;
            }
            double prevval = function.m_data[previous];
            double val = function.m_data[firstind];
            double firstval = function.m_data[firstind];
            int i = firstind;
            while (i <= lastind) {
                double nextval = i < nv - 1 ? function.m_data[next] : firstval;
                switch (pass) {
                    case 0: {
                        laplacian.m_data[i] = (nextval - val) / gaps.m_data[i] + (prevval - val) / gaps.m_data[previous];
                        int n = i;
                        laplacian.m_data[n] = laplacian.m_data[n] * (2.0 / (gaps.m_data[i] + gaps.m_data[previous]));
                        int n2 = i;
                        function.m_data[n2] = function.m_data[n2] + stepsize * laplacian.m_data[i];
                        break;
                    }
                    case 1: {
                        int n = i;
                        function.m_data[n] = function.m_data[n] - stepsize * laplacian.m_data[i];
                    }
                }
                prevval = val;
                val = nextval;
                ++next;
                if (++previous >= nv) {
                    previous %= nv;
                }
                if (next >= nv) {
                    next %= nv;
                }
                ++i;
            }
            if (pass == 0) {
                if (bEqual) {
                    PnFunctionSmoother.smoothEqual(nv, laplacian, bPeriodic, curvatureSmoothSteps);
                } else {
                    PnFunctionSmoother.smooth(nv, laplacian, gaps, bPeriodic, curvStepSize, curvatureSmoothSteps, bMass);
                }
                --k;
                ++pass;
            } else {
                pass = 0;
            }
            ++k;
        }
        return function;
    }

    public static PdVector smoothLambdaMu(int nv, PdVector function, PdVector gaps, boolean bPeriodic, boolean bMass, double backforceStepsize, int num, double stepsize) {
        if (nv < 3) {
            return function;
        }
        PdVector laplacian = new PdVector(nv);
        int pass = 0;
        int k = 0;
        while (k < num) {
            int lastind;
            int firstind;
            int next;
            int previous;
            if (bPeriodic) {
                previous = nv - 1;
                next = 1;
                firstind = 0;
                lastind = nv - 1;
            } else {
                previous = 0;
                next = 2;
                firstind = 1;
                lastind = nv - 2;
            }
            double prevval = function.m_data[previous];
            double val = function.m_data[firstind];
            double firstval = function.m_data[firstind];
            int i = firstind;
            while (i <= lastind) {
                double nextval = i < nv - 1 ? function.m_data[next] : firstval;
                laplacian.m_data[i] = (nextval - val) / gaps.m_data[i] + (prevval - val) / gaps.m_data[previous];
                int n = i;
                laplacian.m_data[n] = laplacian.m_data[n] / (1.0 / gaps.m_data[i] + 1.0 / gaps.m_data[previous]);
                if (pass == 0) {
                    int n2 = i;
                    function.m_data[n2] = function.m_data[n2] + stepsize * laplacian.m_data[i];
                } else {
                    int n3 = i;
                    function.m_data[n3] = function.m_data[n3] - backforceStepsize * laplacian.m_data[i];
                }
                prevval = val;
                val = nextval;
                ++next;
                if (++previous >= nv) {
                    previous %= nv;
                }
                if (next >= nv) {
                    next %= nv;
                }
                ++i;
            }
            if (pass == 0) {
                --k;
                ++pass;
            } else {
                pass = 0;
            }
            ++k;
        }
        return function;
    }

    public static PdVector minimizeKSquare(int nv, PdVector function, PdVector gaps, boolean bPeriodic, int num, double stepsize) {
        if (nv < 3) {
            return function;
        }
        PdVector flow = new PdVector(nv);
        int k = 0;
        while (k < num) {
            int lastind;
            int firstind;
            int next;
            int previous;
            flow.setConstant(0.0);
            if (bPeriodic) {
                previous = nv - 1;
                next = 1;
                firstind = 0;
                lastind = nv - 1;
            } else {
                previous = 0;
                next = 2;
                firstind = 1;
                lastind = nv - 2;
            }
            double prevval = function.m_data[previous];
            double val = function.m_data[firstind];
            double prevdf = val - prevval;
            double firstval = function.m_data[firstind];
            double prevlen = gaps.m_data[previous] * gaps.m_data[previous] + prevdf * prevdf;
            prevlen = prevlen < 0.0 ? 0.0 : Math.sqrt(prevlen);
            int i = firstind;
            while (i <= lastind) {
                double nextval = i < nv - 1 ? function.m_data[next] : firstval;
                double nextdf = nextval - val;
                double nextlen = gaps.m_data[i] * gaps.m_data[i] + nextdf * nextdf;
                nextlen = nextlen < 0.0 ? 0.0 : Math.sqrt(nextlen);
                double denom = 1.0 / (prevlen * nextlen);
                double temp = -gaps.m_data[previous] * gaps.m_data[i] - prevdf * nextdf;
                double vec = (temp / (prevlen * prevlen) * prevdf + nextdf) / denom;
                flow.m_data[i] = flow.m_data[i] + vec;
                flow.m_data[previous] = flow.m_data[previous] - vec;
                vec = (-temp / (nextlen * nextlen) * nextdf - prevdf) / denom;
                flow.m_data[i] = flow.m_data[i] + vec;
                flow.m_data[next] = flow.m_data[next] - vec;
                prevval = val;
                val = nextval;
                prevlen = nextlen;
                prevdf = nextdf;
                ++next;
                if (++previous >= nv) {
                    previous %= nv;
                }
                if (next >= nv) {
                    next %= nv;
                }
                ++i;
            }
            i = 0;
            while (i < nv) {
                function.m_data[i] = function.m_data[i] + stepsize * flow.m_data[i];
                ++i;
            }
            ++k;
        }
        return function;
    }

    public static PdVector smoothEqualBiLaplace(int nv, PdVector function, boolean bPeriodic, int num, boolean[] bFixed) {
        if (function == null || num <= 0) {
            return function;
        }
        if (nv < 3) {
            return function;
        }
        int k = 0;
        while (k < num) {
            int lastind;
            int firstind;
            int nextnext;
            int prevprev;
            int next;
            int previous;
            if (bPeriodic) {
                previous = nv - 1;
                next = 1;
                prevprev = nv - 2;
                nextnext = 2;
                firstind = 0;
                lastind = nv - 1;
            } else {
                previous = 0;
                next = 2;
                prevprev = -1;
                nextnext = 3;
                firstind = 1;
                lastind = nv - 2;
            }
            double prevprevval = prevprev >= 0 ? function.m_data[prevprev] : 0.0;
            double prevval = function.m_data[previous];
            double val = function.m_data[firstind];
            double nextval = function.m_data[next];
            double firstval = function.m_data[firstind];
            double secondval = function.m_data[next];
            int i = firstind;
            while (i <= lastind) {
                double nextnextval = nextnext >= 0 && nextnext < nv ? function.m_data[nextnext] : (nextnext <= nv ? firstval : secondval);
                if (bFixed == null || bFixed.length <= i || !bFixed[i]) {
                    double temp = -0.25 * prevval + val * 3.0 / 8.0 - 0.25 * nextval;
                    if (prevprev >= 0) {
                        temp += prevprevval / 16.0;
                    }
                    if (nextnext >= 0) {
                        temp += nextnextval / 16.0;
                    }
                    function.m_data[i] = val - temp;
                }
                prevprevval = prevval;
                prevval = val;
                val = nextval;
                nextval = nextnextval;
                ++previous;
                ++next;
                ++nextnext;
                if (++prevprev >= nv) {
                    prevprev %= nv;
                }
                if (previous >= nv) {
                    previous %= nv;
                }
                if (next >= nv) {
                    next %= nv;
                }
                if (nextnext >= nv && !bPeriodic) {
                    nextnext = -1;
                }
                ++i;
            }
            ++k;
        }
        return function;
    }

    public static PdVector approxCubicSpline(int nv, PdVector function, PdVector gaps, boolean bPeriodic, double interpolate, boolean[] bFixed, PdVector a, PdVector b, PdVector c, PdVector d, PdVector e, PdVector f, PdVector p, PdVector y2) {
        interpolate = 1.0 - interpolate;
        interpolate += 1.0E-10;
        interpolate = 12.0 * interpolate * interpolate;
        interpolate = interpolate * interpolate * interpolate;
        if (p == null) {
            p = new PdVector(nv);
        } else if (p.getSize() != nv) {
            p.setSize(nv);
        }
        double HIGH = 1.0E10;
        p.setConstant(interpolate);
        if (bFixed != null) {
            int i = 0;
            while (i < nv) {
                if (bFixed[i]) {
                    p.m_data[i] = HIGH;
                }
                ++i;
            }
        }
        return PnFunctionSmoother.approxCubicSpline(nv, function, gaps, bPeriodic, p, a, b, c, d, e, f, y2);
    }

    public static PdVector approxCubicSpline(int nv, PdVector function, PdVector gaps, boolean bPeriodic, PdVector p, PdVector a, PdVector b, PdVector c, PdVector d, PdVector e, PdVector f, PdVector y2) {
        if (nv < 5) {
            PsDebug.warning((String)("too few function values " + nv + "<5"));
            return function;
        }
        if (nv < 6 && bPeriodic) {
            PsDebug.warning((String)("too few function values for periodic case " + nv + "<6"));
            return function;
        }
        if (a == null) {
            a = new PdVector(nv);
        } else if (a.getSize() != nv) {
            a.setSize(nv);
        }
        if (b == null) {
            b = new PdVector(nv);
        } else if (b.getSize() != nv) {
            b.setSize(nv);
        }
        if (c == null) {
            c = new PdVector(nv);
        } else if (c.getSize() != nv) {
            c.setSize(nv);
        }
        if (d == null) {
            d = new PdVector(nv);
        } else if (d.getSize() != nv) {
            d.setSize(nv);
        }
        if (bPeriodic) {
            if (e == null) {
                e = new PdVector(nv);
            } else if (e.getSize() != nv) {
                e.setSize(nv);
            }
            if (f == null) {
                f = new PdVector(nv);
            } else if (f.getSize() != nv) {
                f.setSize(nv);
            }
        }
        if (p == null) {
            p = new PdVector(nv);
        } else if (p.getSize() != nv) {
            p.setSize(nv);
        }
        if (y2 == null) {
            y2 = new PdVector(nv);
        } else if (y2.getSize() != nv) {
            y2.setSize(nv);
        }
        if (!bPeriodic) {
            double HIGH;
            p.m_data[0] = HIGH = 1.0E10;
            p.m_data[nv - 1] = HIGH;
            if (!PnFunctionSmoother.cubsm1(nv, function.m_data, gaps.m_data, p.m_data, 1.0E-10, y2.m_data, a.m_data, b.m_data, c.m_data, d.m_data)) {
                PsDebug.warning((String)"failed to compute approximating cubic spline - fatal");
                return null;
            }
        } else if (!PnFunctionSmoother.cubsm2(nv, function.m_data, gaps.m_data, p.m_data, 1.0E-10, y2.m_data, a.m_data, b.m_data, c.m_data, d.m_data, e.m_data, f.m_data)) {
            PsDebug.warning((String)"failed to compute approximating cubic spline - fatal");
            return null;
        }
        System.arraycopy(a.m_data, 0, function.m_data, 0, nv);
        return function;
    }

    public static boolean cubsm1(int n, double[] y, double[] gaps, double[] p, double eps, double[] y2, double[] a, double[] b, double[] c, double[] d) {
        int k1;
        int n1 = n - 1;
        int n2 = n - 2;
        int k = 0;
        while (k < n1) {
            d[k] = 1.0 / gaps[k];
            ++k;
        }
        d[n1] = 0.0;
        double p1 = 1.0 / p[0];
        double p2 = 1.0 / p[1];
        double h1 = d[0];
        double h2 = d[1];
        double r1 = (y[1] - y[0]) * h1;
        k = 0;
        while (k < n2) {
            k1 = k + 1;
            int k2 = k + 2;
            double h3 = d[k2];
            double p3 = 1.0 / p[k2];
            double s = h1 + h2;
            a[k] = 2.0 / h1 + 2.0 / h2 + 6.0 * (h1 * h1 * p1 + s * s * p2 + h2 * h2 * p3);
            b[k] = 1.0 / h2 - 6.0 * h2 * (p2 * s + p3 * (h2 + h3));
            c[k] = 6.0 * p3 * h2 * h3;
            double r2 = (y[k2] - y[k1]) * h2;
            y2[k] = 6.0 * (r2 - r1);
            h1 = h2;
            h2 = h3;
            p1 = p2;
            p2 = p3;
            r1 = r2;
            ++k;
        }
        if (!PnMatrix.pentas((int)n2, (double[])a, (double[])b, (double[])c, (double[])y2, (double)eps)) {
            return false;
        }
        k = n2 - 1;
        while (k >= 0) {
            y2[k + 1] = y2[k];
            --k;
        }
        y2[0] = 0.0;
        y2[n - 1] = 0.0;
        h1 = 0.0;
        k = 0;
        while (k < n1) {
            k1 = k + 1;
            b[k] = d[k];
            h2 = d[k] * (y2[k1] - y2[k]);
            d[k] = h2 / 6.0;
            a[k] = y[k] - (h2 - h1) / p[k];
            c[k] = y2[k] / 2.0;
            h1 = h2;
            ++k;
        }
        a[n - 1] = y[n - 1] + h1 / p[n - 1];
        k = 0;
        while (k < n1) {
            k1 = k + 1;
            h1 = b[k];
            b[k] = (a[k1] - a[k]) * h1 - (y2[k1] + 2.0 * y2[k]) / (6.0 * h1);
            ++k;
        }
        return true;
    }

    public static boolean cubsm2(int n, double[] y, double[] gaps, double[] p, double eps, double[] y2, double[] a, double[] b, double[] c, double[] d, double[] e, double[] f) {
        double h;
        int k1;
        int n1ind = ++n - 2;
        int n2ind = n - 3;
        double p1 = 1.0 / p[n1ind];
        double p2 = 1.0 / p[0];
        double h1 = 1.0 / gaps[n1ind];
        double h2 = 1.0 / gaps[0];
        double r1 = (y[0] - y[n1ind]) * h1;
        int k = 0;
        while (k <= n1ind) {
            double r2;
            double p3;
            double h3;
            k1 = k + 1;
            double s = h1 + h2;
            if (k < n1ind) {
                h3 = 1.0 / gaps[k1];
                p3 = 1.0 / p[k1];
                r2 = (y[k1] - y[k]) * h2;
            } else {
                h3 = 1.0 / gaps[0];
                p3 = 1.0 / p[0];
                r2 = (y[0] - y[n1ind]) * h2;
            }
            a[k] = 2.0 / h1 + 2.0 / h2 + 6.0 * (h1 * h1 * p1 + s * s * p2 + h2 * h2 * p3);
            if (k < n1ind) {
                b[k] = 1.0 / h2 - 6.0 * h2 * (p2 * s + p3 * (h2 + h3));
            }
            if (k < n2ind) {
                c[k] = 6.0 * p3 * h2 * h3;
            }
            y2[k] = 6.0 * (r2 - r1);
            if (k == 0) {
                double h4 = 1.0 / gaps[n2ind];
                b[n1ind] = 1.0 / h1 - 6.0 * h1 * (p1 * (h1 + h4) + p2 * (h1 + h2));
                c[n2ind] = 6.0 * p1 * h4 * h1;
            }
            if (k == 1) {
                c[n1ind] = 6.0 * p1 * h1 / gaps[n1ind];
            }
            h1 = h2;
            h2 = h3;
            p1 = p2;
            p2 = p3;
            r1 = r2;
            ++k;
        }
        if (!PnMatrix.penpes((int)(n1ind + 1), (double[])a, (double[])b, (double[])c, (double[])y2, (double[])d, (double[])e, (double[])f, (double)eps)) {
            return false;
        }
        h1 = (y2[0] - y2[n1ind]) / gaps[n1ind];
        k = 0;
        while (k < n1ind) {
            k1 = k + 1;
            b[k] = h = 1.0 / gaps[k];
            h2 = h * (y2[k1] - y2[k]);
            d[k] = h2 / 6.0;
            a[k] = y[k] - (h2 - h1) / p[k];
            c[k] = y2[k] / 2.0;
            h1 = h2;
            ++k;
        }
        b[n1ind] = h = 1.0 / gaps[n1ind];
        h2 = h * (y2[0] - y2[n1ind]);
        d[n1ind] = h2 / 6.0;
        a[n1ind] = y[n1ind] - (h2 - h1) / p[n1ind];
        c[n1ind] = y2[n1ind] / 2.0;
        k = 0;
        while (k < n1ind) {
            k1 = k + 1;
            h = b[k];
            b[k] = (a[k1] - a[k]) * h - (y2[k1] + 2.0 * y2[k]) / (6.0 * h);
            ++k;
        }
        h = b[n1ind];
        b[n1ind] = (a[0] - a[n1ind]) * h - (y2[0] + 2.0 * y2[n1ind]) / (6.0 * h);
        return true;
    }

    public static double getMean(int n, PdVector function, PdVector gaps) {
        if (n < 2) {
            return 0.0;
        }
        double len = 0.0;
        double mean = 0.0;
        int i = 0;
        while (i < n - 1) {
            len += gaps.m_data[i];
            mean += (function.m_data[i] + function.m_data[i + 1]) / 2.0 * gaps.m_data[i];
            ++i;
        }
        return mean /= len;
    }

    protected static double getVariance(int n, PdVector function, PdVector gaps) {
        if (n < 2) {
            return 0.0;
        }
        double variance = 0.0;
        double len = 0.0;
        double mean = PnFunctionSmoother.getMean(n, function, gaps);
        int i = 0;
        while (i < n - 1) {
            len += gaps.m_data[i];
            double t = (function.m_data[i] + function.m_data[i + 1]) / 2.0 - mean;
            variance += t * t * gaps.m_data[i];
            ++i;
        }
        return variance /= len;
    }

    protected static double getThirdMoment(int n, PdVector function, PdVector gaps) {
        if (n < 2) {
            return 0.0;
        }
        double power = 0.0;
        double len = 0.0;
        int i = 0;
        while (i < n - 1) {
            len += gaps.m_data[i];
            double t = (function.m_data[i] + function.m_data[i + 1]) / 2.0 * gaps.m_data[i];
            power += t * t;
            ++i;
        }
        return power /= len;
    }
}

