/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnDunnValidityIndex {
    public static double computeIndex(PgPointSet pointSet, PiVector[] segmentation) {
        double maximumDiameter = Double.NEGATIVE_INFINITY;
        PiVector[] piVectorArray = segmentation;
        int n = segmentation.length;
        int n2 = 0;
        while (n2 < n) {
            PiVector segment = piVectorArray[n2];
            int i = 0;
            while (i < segment.getSize()) {
                int j = i + 1;
                while (j < segment.getSize()) {
                    double localDiameter = pointSet.getVertex(segment.getEntry(i)).dist(pointSet.getVertex(segment.getEntry(j)));
                    if (localDiameter > maximumDiameter) {
                        maximumDiameter = localDiameter;
                    }
                    ++j;
                }
                ++i;
            }
            ++n2;
        }
        double minimumDistance = Double.POSITIVE_INFINITY;
        int segmentIndex1 = 0;
        while (segmentIndex1 < segmentation.length) {
            PiVector segment1 = segmentation[segmentIndex1];
            int segmentIndex2 = segmentIndex1 + 1;
            while (segmentIndex2 < segmentation.length) {
                PiVector segment2 = segmentation[segmentIndex2];
                int i = 0;
                while (i < segment1.getSize()) {
                    int j = 0;
                    while (j < segment2.getSize()) {
                        double localDistance = pointSet.getVertex(segment1.getEntry(i)).dist(pointSet.getVertex(segment2.getEntry(j)));
                        if (localDistance < minimumDistance) {
                            minimumDistance = localDistance;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++segmentIndex2;
            }
            ++segmentIndex1;
        }
        return minimumDistance / maximumDiameter;
    }

    public static double computeIndex(PgElementSet elementSet, PiVector[] segmentation) {
        double maximumDiameter = Double.NEGATIVE_INFINITY;
        PiVector[] piVectorArray = segmentation;
        int n = segmentation.length;
        int n2 = 0;
        while (n2 < n) {
            PiVector segment = piVectorArray[n2];
            int i = 0;
            while (i < segment.getSize()) {
                int j = i + 1;
                while (j < segment.getSize()) {
                    PdVector barycenter1 = new PdVector();
                    elementSet.getCenterOfElement(barycenter1, segment.getEntry(i));
                    PdVector barycenter2 = new PdVector();
                    elementSet.getCenterOfElement(barycenter2, segment.getEntry(j));
                    double localDiameter = barycenter1.dist(barycenter2);
                    if (localDiameter > maximumDiameter) {
                        maximumDiameter = localDiameter;
                    }
                    ++j;
                }
                ++i;
            }
            ++n2;
        }
        double minimumDistance = Double.POSITIVE_INFINITY;
        int segmentIndex1 = 0;
        while (segmentIndex1 < segmentation.length) {
            PiVector segment1 = segmentation[segmentIndex1];
            int segmentIndex2 = segmentIndex1 + 1;
            while (segmentIndex2 < segmentation.length) {
                PiVector segment2 = segmentation[segmentIndex2];
                int i = 0;
                while (i < segment1.getSize()) {
                    int j = 0;
                    while (j < segment2.getSize()) {
                        PdVector barycenter1 = new PdVector();
                        elementSet.getCenterOfElement(barycenter1, segment1.getEntry(i));
                        PdVector barycenter2 = new PdVector();
                        elementSet.getCenterOfElement(barycenter2, segment2.getEntry(j));
                        double localDistance = barycenter1.dist(barycenter2);
                        if (localDistance < minimumDistance) {
                            minimumDistance = localDistance;
                        }
                        ++j;
                    }
                    ++i;
                }
                ++segmentIndex2;
            }
            ++segmentIndex1;
        }
        return minimumDistance / maximumDiameter;
    }
}

