/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import jv.geom.PgPolygon;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnSparseMatrix;

public class PnDirichletCurve
extends PnSparseMatrix {
    public PnDirichletCurve(PgPolygon curve) {
        this.setSize(curve.getNumVertices());
        if (this.m_snoe == null) {
            this.m_snoe = new PiVector(this.m_iSize);
        } else {
            this.m_snoe.setSize(this.m_iSize);
        }
        this.m_sindx = PiVector.realloc((PiVector[])this.m_sindx, (int)this.m_iSize, (int)3);
        this.m_stiff = PdVector.realloc((PdVector[])this.m_stiff, (int)this.m_iSize, (int)3);
        this.m_snoe.setConstant(3);
        int i = 1;
        while (i < this.m_iSize - 1) {
            this.m_sindx[i].m_data[0] = i - 1;
            this.m_sindx[i].m_data[1] = i;
            this.m_sindx[i].m_data[2] = i + 1;
            ++i;
        }
        this.m_sindx[0].m_data[0] = 1;
        this.m_sindx[0].m_data[1] = 0;
        this.m_sindx[this.m_iSize - 1].m_data[0] = this.m_iSize - 2;
        this.m_sindx[this.m_iSize - 1].m_data[1] = this.m_iSize - 1;
        if (curve.isClosed()) {
            this.m_sindx[0].m_data[2] = this.m_iSize - 1;
            this.m_sindx[this.m_iSize - 1].m_data[2] = 0;
        } else {
            this.m_snoe.m_data[0] = 2;
            this.m_snoe.m_data[this.m_iSize - 1] = 2;
            this.m_sindx[0].setSize(2);
            this.m_sindx[this.m_iSize - 1].setSize(2);
            this.m_stiff[0].setSize(2);
            this.m_stiff[this.m_iSize - 1].setSize(2);
        }
        if (((Object)((Object)this)).getClass() == PnDirichletCurve.class) {
            this.init(curve);
        }
    }

    public void init(PgPolygon curve) {
        PdVector[] vertices = curve.getVertices();
        PdVector edge = new PdVector(curve.getDimOfVertices());
        double e0 = 0.0;
        double e1 = 0.0;
        edge.sub(vertices[1], vertices[0]);
        e0 = 1.0 / edge.length();
        this.m_stiff[0].m_data[this.getIndex((int)0, (int)1)] = -e0;
        this.m_stiff[0].m_data[this.getIndex((int)0, (int)0)] = e0;
        int i = 1;
        while (i < this.m_iSize - 1) {
            edge.sub(vertices[i + 1], vertices[i]);
            e1 = 1.0 / edge.length();
            this.m_stiff[i].m_data[this.getIndex((int)i, (int)(i - 1))] = -e0;
            this.m_stiff[i].m_data[this.getIndex((int)i, (int)i)] = e0 + e1;
            this.m_stiff[i].m_data[this.getIndex((int)i, (int)(i + 1))] = -e1;
            e0 = e1;
            ++i;
        }
        this.m_stiff[this.m_iSize - 1].m_data[this.getIndex((int)(this.m_iSize - 1), (int)(this.m_iSize - 2))] = -e1;
        this.m_stiff[this.m_iSize - 1].m_data[this.getIndex((int)(this.m_iSize - 1), (int)(this.m_iSize - 1))] = e1;
        if (curve.isClosed()) {
            edge.sub(vertices[0], vertices[this.m_iSize - 1]);
            e1 = 1.0 / edge.length();
            int n = this.getIndex(this.m_iSize - 1, this.m_iSize - 1);
            this.m_stiff[this.m_iSize - 1].m_data[n] = this.m_stiff[this.m_iSize - 1].m_data[n] + e1;
            this.m_stiff[this.m_iSize - 1].m_data[this.getIndex((int)(this.m_iSize - 1), (int)0)] = -e1;
            int n2 = this.getIndex(0, 0);
            this.m_stiff[0].m_data[n2] = this.m_stiff[0].m_data[n2] + e1;
            this.m_stiff[0].m_data[this.getIndex((int)0, (int)(this.m_iSize - 1))] = -e1;
        }
    }
}

