/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnPCA;
import jv.geom.PgPointSet;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PnDirectionalDensity {
    public static PdVector getCovarianceDensity(PgPointSet geom, int point, PiVector neighborhood, boolean normalizeInput, boolean normalizeOutput) {
        PiVector covarianceNeighborhood = PiVector.copyNew((PiVector)neighborhood);
        covarianceNeighborhood.addEntry(point);
        PdVector principalValues = PnPCA.getPrincipalValues(geom, covarianceNeighborhood);
        double c1 = principalValues.getEntry(0);
        double c2 = principalValues.getEntry(1);
        PdVector[] principalComponents = PnPCA.getPrincipalComponents(geom, covarianceNeighborhood);
        PdVector normal = principalComponents[2];
        PdVector v2 = principalComponents[1];
        PdVector v1 = principalComponents[0];
        PdVector results = new PdVector(neighborhood.getSize());
        double minimum = 0.0;
        int i = 0;
        while (i < neighborhood.getSize()) {
            PdVector tangentialComponent = PdVector.subNew((PdVector)geom.getVertex(neighborhood.getEntry(i)), (PdVector)geom.getVertex(point));
            double normalHeight = normal.dot(tangentialComponent);
            PdVector normalPart = PdVector.copyNew((PdVector)normal);
            normalPart.multScalar(normalHeight);
            tangentialComponent.sub(normalPart);
            if (normalizeInput) {
                tangentialComponent.normalize();
            }
            double directionalDensity = (3.0 * c1 - c2) * Math.pow(tangentialComponent.dot(v1), 2.0) + (3.0 * c2 - c1) * Math.pow(tangentialComponent.dot(v2), 2.0);
            results.setEntry(i, directionalDensity);
            if (directionalDensity < minimum) {
                minimum = directionalDensity;
            }
            ++i;
        }
        if (minimum < 0.0) {
            i = 0;
            while (i < neighborhood.getSize()) {
                results.setEntry(i, results.getEntry(i) - minimum);
                ++i;
            }
        }
        if (normalizeOutput) {
            double weightSum = 0.0;
            int i2 = 0;
            while (i2 < neighborhood.getSize()) {
                weightSum += results.getEntry(i2);
                ++i2;
            }
            double mean = weightSum / (double)neighborhood.getSize();
            int i3 = 0;
            while (i3 < neighborhood.getSize()) {
                results.setEntry(i3, 2.0 - results.getEntry(i3) / mean);
                ++i3;
            }
        }
        return results;
    }

    public static PdVector getCovarianceDensityLP(PgPointSet geom, int point, PiVector neighborhood, boolean normalizeInput, boolean normalizeOutput) {
        PiVector covarianceNeighborhood = PiVector.copyNew((PiVector)neighborhood);
        covarianceNeighborhood.addEntry(point);
        PdVector principalValues = PnPCA.getPrincipalValues(geom, covarianceNeighborhood);
        double c1 = principalValues.getEntry(0);
        double c2 = principalValues.getEntry(1);
        PdVector[] principalComponents = PnPCA.getPrincipalComponents(geom, covarianceNeighborhood);
        PdVector normal = principalComponents[2];
        PdVector v2 = principalComponents[1];
        PdVector v1 = principalComponents[0];
        PdVector results = new PdVector(neighborhood.getSize());
        double minimum = 0.0;
        int i = 0;
        while (i < neighborhood.getSize()) {
            PdVector tangentialComponent = PdVector.subNew((PdVector)geom.getVertex(neighborhood.getEntry(i)), (PdVector)geom.getVertex(point));
            double normalHeight = normal.dot(tangentialComponent);
            PdVector normalPart = PdVector.copyNew((PdVector)normal);
            normalPart.multScalar(normalHeight);
            tangentialComponent.sub(normalPart);
            if (normalizeInput) {
                tangentialComponent.normalize();
            }
            double directionalDensity = (3.0 * c1 - c2) * 0.5 * tangentialComponent.dot(v1) + (3.0 * c2 - c1) * 0.5 * tangentialComponent.dot(v2);
            results.setEntry(i, directionalDensity);
            if (directionalDensity < minimum) {
                minimum = directionalDensity;
            }
            ++i;
        }
        if (minimum < 0.0) {
            i = 0;
            while (i < neighborhood.getSize()) {
                results.setEntry(i, results.getEntry(i) - minimum);
                ++i;
            }
        }
        if (normalizeOutput) {
            double weightSum = 0.0;
            int i2 = 0;
            while (i2 < neighborhood.getSize()) {
                weightSum += results.getEntry(i2);
                ++i2;
            }
            double mean = weightSum / (double)neighborhood.getSize();
            int i3 = 0;
            while (i3 < neighborhood.getSize()) {
                results.setEntry(i3, 2.0 - results.getEntry(i3) / mean);
                ++i3;
            }
        }
        return results;
    }

    public static PdVector getArcLengthDensity(PgPointSet geom, int point, PiVector neighborhood, boolean normalizeOutput) {
        int size = neighborhood.getSize();
        PiVector covarianceNeighborhood = PiVector.copyNew((PiVector)neighborhood);
        covarianceNeighborhood.addEntry(point);
        PdVector[] principalComponents = PnPCA.getPrincipalComponents(geom, covarianceNeighborhood);
        PdVector normal = principalComponents[2];
        PdVector v1 = principalComponents[0];
        PdVector[] tangentialProjection = new PdVector[size];
        int i = 0;
        while (i < size) {
            PdVector tangentialComponent = PdVector.subNew((PdVector)geom.getVertex(neighborhood.getEntry(i)), (PdVector)geom.getVertex(point));
            double normalHeight = normal.dot(tangentialComponent);
            PdVector normalPart = PdVector.copyNew((PdVector)normal);
            normalPart.multScalar(normalHeight);
            tangentialComponent.sub(normalPart);
            tangentialComponent.normalize();
            tangentialProjection[i] = tangentialComponent;
            ++i;
        }
        double[] angles = new double[size];
        int i2 = 0;
        while (i2 < size) {
            angles[i2] = PdVector.angleWithOrientation((PdVector)v1, (PdVector)tangentialProjection[i2], (PdVector)normal);
            if (angles[i2] < 0.0) {
                angles[i2] = Math.PI * 2 + angles[i2];
            }
            ++i2;
        }
        int[] angleOrder = new int[size];
        int i3 = 0;
        while (i3 < size) {
            angleOrder[i3] = i3;
            ++i3;
        }
        int i4 = 1;
        while (i4 < angleOrder.length) {
            int j = 0;
            while (j < angleOrder.length - i4) {
                if (angles[angleOrder[j]] > angles[angleOrder[j + 1]]) {
                    int temp = angleOrder[j];
                    angleOrder[j] = angleOrder[j + 1];
                    angleOrder[j + 1] = temp;
                }
                ++j;
            }
            ++i4;
        }
        PdVector results = new PdVector(size);
        double leftarc = PdVector.angleWithOrientation((PdVector)tangentialProjection[angleOrder[size - 1]], (PdVector)tangentialProjection[angleOrder[0]], (PdVector)normal) / 2.0;
        double rightarc = PdVector.angleWithOrientation((PdVector)tangentialProjection[angleOrder[0]], (PdVector)tangentialProjection[angleOrder[1]], (PdVector)normal) / 2.0;
        results.setEntry(angleOrder[0], leftarc + rightarc);
        leftarc = PdVector.angleWithOrientation((PdVector)tangentialProjection[angleOrder[size - 2]], (PdVector)tangentialProjection[angleOrder[size - 1]], (PdVector)normal) / 2.0;
        rightarc = PdVector.angleWithOrientation((PdVector)tangentialProjection[angleOrder[size - 1]], (PdVector)tangentialProjection[angleOrder[0]], (PdVector)normal) / 2.0;
        results.setEntry(angleOrder[size - 1], leftarc + rightarc);
        int j = 1;
        while (j < size - 1) {
            leftarc = PdVector.angleWithOrientation((PdVector)tangentialProjection[angleOrder[j - 1]], (PdVector)tangentialProjection[angleOrder[j]], (PdVector)normal) / 2.0;
            rightarc = PdVector.angleWithOrientation((PdVector)tangentialProjection[angleOrder[j]], (PdVector)tangentialProjection[angleOrder[j + 1]], (PdVector)normal) / 2.0;
            results.setEntry(angleOrder[j], leftarc + rightarc);
            ++j;
        }
        if (normalizeOutput) {
            double weightSum = 0.0;
            int i5 = 0;
            while (i5 < neighborhood.getSize()) {
                weightSum += results.getEntry(i5);
                ++i5;
            }
            i5 = 0;
            while (i5 < neighborhood.getSize()) {
                results.setEntry(i5, results.getEntry(i5) * (double)neighborhood.getSize() / weightSum);
                ++i5;
            }
        }
        return results;
    }

    public static PdVector getSmoothDensity(PgPointSet geom, int point, PiVector neighborhood, boolean normalizeOutput) {
        int size = neighborhood.getSize();
        PiVector covarianceNeighborhood = PiVector.copyNew((PiVector)neighborhood);
        covarianceNeighborhood.addEntry(point);
        PdVector[] principalComponents = PnPCA.getPrincipalComponents(geom, covarianceNeighborhood);
        PdVector normal = principalComponents[2];
        PdVector v1 = principalComponents[0];
        PdVector[] tangentialProjection = new PdVector[size];
        int i = 0;
        while (i < size) {
            PdVector tangentialComponent = PdVector.subNew((PdVector)geom.getVertex(neighborhood.getEntry(i)), (PdVector)geom.getVertex(point));
            double normalHeight = normal.dot(tangentialComponent);
            PdVector normalPart = PdVector.copyNew((PdVector)normal);
            normalPart.multScalar(normalHeight);
            tangentialComponent.sub(normalPart);
            tangentialComponent.normalize();
            tangentialProjection[i] = tangentialComponent;
            ++i;
        }
        double[] angles = new double[size];
        int i2 = 0;
        while (i2 < size) {
            angles[i2] = PdVector.angleWithOrientation((PdVector)v1, (PdVector)tangentialProjection[i2], (PdVector)normal);
            if (angles[i2] < 0.0) {
                angles[i2] = Math.PI * 2 + angles[i2];
            }
            ++i2;
        }
        PdVector results = new PdVector(size);
        int i3 = 0;
        while (i3 < size) {
            double density = 0.0;
            double argument = angles[i3];
            int j = 0;
            while (j < size) {
                density += PnDirectionalDensity.bumpFunction(argument, angles[j], Math.PI * 2 / (double)size);
                ++j;
            }
            results.setEntry(i3, density / (double)size);
            ++i3;
        }
        if (normalizeOutput) {
            double weightSum = 0.0;
            int i4 = 0;
            while (i4 < neighborhood.getSize()) {
                weightSum += results.getEntry(i4);
                ++i4;
            }
            double mean = weightSum / (double)neighborhood.getSize();
            int i5 = 0;
            while (i5 < neighborhood.getSize()) {
                results.setEntry(i5, 2.0 - results.getEntry(i5) / mean);
                ++i5;
            }
        }
        return results;
    }

    protected static double bumpFunction(double argument, double center, double radius) {
        argument %= Math.PI * 2;
        double left = (center %= Math.PI * 2) - (radius %= Math.PI);
        double right = center + radius;
        if (left < 0.0) {
            left += Math.PI * 2;
        }
        if (right > Math.PI * 2) {
            right -= Math.PI * 2;
        }
        if (left <= right) {
            if (argument <= left || argument >= right) {
                return 0.0;
            }
            return Math.exp(1.0 / (Math.pow(radius, -2.0) * Math.pow(argument - center, 2.0) - 1.0));
        }
        if (argument <= left && argument >= right) {
            return 0.0;
        }
        if (center <= right) {
            if (argument <= right) {
                return Math.exp(1.0 / (Math.pow(radius, -2.0) * Math.pow(argument - center, 2.0) - 1.0));
            }
            return Math.exp(1.0 / (Math.pow(radius, -2.0) * Math.pow(argument - center - Math.PI * 2, 2.0) - 1.0));
        }
        if (argument >= left) {
            return Math.exp(1.0 / (Math.pow(radius, -2.0) * Math.pow(argument - center, 2.0) - 1.0));
        }
        return Math.exp(1.0 / (Math.pow(radius, -2.0) * Math.pow(argument - center + Math.PI * 2, 2.0) - 1.0));
    }
}

