/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnFunctionWithSparseHessian;
import dev.numeric.PnPreconditionerConstraint;
import dev.numeric.PnTaucsSolver;
import dev.numeric.PuSparseMatrix;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnConjugateGradientMatrix;
import jvx.numeric.PnFunction;
import jvx.numeric.PnPreconditioner;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffMatrix;

public class PnConstrainedNewton {
    protected PdVector m_help = new PdVector();
    protected PiVector m_sort = new PiVector();
    protected PdVector m_gradient;
    protected PdVector m_t;
    protected PdVector m_subB;
    protected PdVector m_subX;
    protected PdVector m_subXmin;
    protected PdVector m_subXmax;
    protected PnSparseMatrix m_subMat;
    protected boolean[] m_boolArray;
    protected PiVector m_table = new PiVector();
    protected PiVector m_store = new PiVector();
    protected int m_subSolverType = 1;
    public static final int SOLVER_CG = 0;
    public static final int SOLVER_DIRECT_TAUCS = 1;
    public static final int SOLVER_BAND_PENTA = 2;
    protected PnConjugateGradientMatrix m_subSolver;
    protected PnPreconditionerConstraint m_subPrec;
    private PdVector[] m_band;
    protected int m_size;
    protected boolean m_bUpdateHessian = false;
    protected int m_iter;
    protected double m_err;
    protected int m_itmax = 1000;
    protected double m_tol = 1.0E-10;
    protected int m_dim = 3;
    protected double m_eps = 1.0E-14;
    protected PnPreconditionerConstraint m_prec;
    protected int m_constraintType = 0;
    public static final int CONSTRAINT_UNCONSTRAINED = 0;
    public static final int CONSTRAINT_BOX = 1;
    public static final int CONSTRAINT_SPHERE_GLOBAL_RADIUS = 2;
    public static final int CONSTRAINT_SPHERE_INDIVIDUAL_RADII = 3;
    protected PdVector m_boxConstraint_lower;
    protected PdVector m_boxConstraint_upper;
    protected PdVector[] m_sphereConstraints_centers;
    protected double m_sphereConstraints_globalRadius;
    protected PdVector m_sphereConstraints_radii;
    public boolean m_bprojectedNewton = false;
    public boolean m_bUseActiveSet = true;
    public long m_choleskyFactorization = -1L;
    public boolean m_bDecomposeHessian = false;
    public PdVector diagonalMass;
    private boolean m_bDebugmessages = false;

    public PnConstrainedNewton() {
        this.m_gradient = new PdVector();
        this.m_t = new PdVector();
        this.m_boolArray = new boolean[0];
        this.m_subB = new PdVector();
        this.m_subX = new PdVector();
        this.m_subXmin = new PdVector();
        this.m_subXmax = new PdVector();
        this.m_subMat = new PnSparseMatrix();
    }

    public boolean converged() {
        return false;
    }

    public PnConjugateGradientMatrix getSubsolver() {
        return this.m_subSolver;
    }

    public void setPreconditioner(PnPreconditionerConstraint prec) {
        this.m_prec = prec;
    }

    public PnPreconditionerConstraint getPreconditioner() {
        return this.m_prec;
    }

    public int getActualNumOfTakenIterations() {
        return this.m_iter;
    }

    public boolean getUpdateHessian() {
        return this.m_bUpdateHessian;
    }

    public void setUpdateHessian(boolean flag) {
        this.m_bUpdateHessian = flag;
    }

    public void setMaxNumIterations(int itmax) {
        this.m_itmax = itmax;
    }

    public int getMaxNumIterations() {
        return this.m_itmax;
    }

    public void setTolerance(double tol) {
        this.m_tol = tol;
    }

    public double getTolerance() {
        return this.m_tol;
    }

    public void setDimension(int dim) {
        this.m_dim = dim;
    }

    public int getDimension() {
        return this.m_dim;
    }

    public void setEPS(double eps) {
        this.m_eps = eps;
    }

    public double getEPS() {
        return this.m_eps;
    }

    public void setSubSpaceSolver(int i) {
        this.m_subSolverType = i;
    }

    public int getSubSpaceSolver() {
        return this.m_subSolverType;
    }

    protected void setSize(int aSize) {
        this.m_size = aSize;
        int n = aSize;
        this.m_help.setSize(n);
        this.m_sort.setSize(n);
        this.m_table.setSize(n);
        this.m_store.setSize(n);
        this.m_gradient.setSize(n);
        this.m_t.setSize(n);
        if (this.m_boolArray.length != n) {
            this.m_boolArray = new boolean[n];
        }
    }

    protected void initSolver() {
        if (this.m_subSolverType == 0) {
            if (this.m_subPrec == null) {
                this.m_subPrec = new PnPreconditionerConstraint();
                this.m_subPrec.m_in = new PdVector(this.m_size / this.m_dim);
                this.m_subPrec.m_out = new PdVector(this.m_size / this.m_dim);
                this.m_subPrec.m_bUse = this.m_boolArray;
            }
            if (this.m_subSolver == null) {
                this.m_subSolver = new PnConjugateGradientMatrix();
            }
            this.m_subSolver.setMaxNumIterations(2);
            this.m_subSolver.setTolerance(1.0E-6);
            this.m_subSolver.setPreconditioner((PnPreconditioner)this.m_subPrec);
        }
    }

    public void updatePreconditioner(PnSparseMatrix smat) {
        if (smat == null) {
            PsDebug.warning((String)"Sparse matrix is null");
            return;
        }
        if (this.m_prec != null) {
            this.m_prec.setSparseMatrix(smat);
        } else {
            this.m_prec = new PnPreconditionerConstraint();
        }
    }

    public void minimize(PnFunctionWithSparseHessian f, PdVector x, PnSparseMatrix hessian) {
        double eps = 1.0E-14;
        if (this.m_bDebugmessages) {
            PsDebug.message((String)("En: " + f.eval(x)));
        }
        int n = x.m_data.length;
        int dim = this.m_dim;
        int m = n / dim;
        this.setSize(n);
        this.initSolver();
        double alphaFactor = 4.0;
        double alphaPrev = 1.0;
        double alphaPrevNewton = 1.0;
        double betaPrev = 1.0;
        PdVector y = this.m_help;
        boolean bStop = false;
        if (!this.m_bUpdateHessian) {
            if (hessian == null) {
                hessian = f.evalSparseHessian(x, hessian);
            }
            if (this.m_subSolverType != 2 && (this.m_bprojectedNewton || this.m_bUseActiveSet)) {
                long t1 = System.currentTimeMillis();
                this.m_choleskyFactorization = PnTaucsSolver.getCholeksyFactorization(hessian);
                long t2 = System.currentTimeMillis();
                PsDebug.message((String)("Factorization (ms): " + (t2 - t1)));
                if (this.m_subSolverType == 0) {
                    this.m_subPrec.m_choleskyFactorization = this.m_choleskyFactorization;
                }
            }
        }
        this.m_iter = 0;
        while (!bStop && this.m_iter < this.m_itmax) {
            int i;
            double fyPrev;
            boolean satisfied;
            this.m_gradient = f.evalGradient(x, this.m_gradient);
            this.m_gradient.multScalar(-1.0);
            this.getPLPath(x, this.m_gradient, this.m_t);
            double alpha = Math.max(alphaPrev, 1.0E-8);
            this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha);
            double fx = f.eval(x);
            double fy = f.eval(y);
            boolean bl = satisfied = fy < fx;
            if (satisfied) {
                do {
                    fyPrev = fy;
                    this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= alphaFactor);
                } while ((fy = f.eval(y)) < fyPrev);
                this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= 1.0 / alphaFactor);
            } else {
                double fac = 1.0 / alphaFactor;
                do {
                    this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= fac);
                } while ((fy = f.eval(y)) > fx && alpha > eps);
            }
            if (alpha > eps) {
                alphaPrev = alpha;
                x.copyArray(y);
            }
            if (this.m_bDebugmessages) {
                PsDebug.message((String)("Gradient Step decrease: " + (f.eval(x) - fx) + " factor: " + (alpha > eps ? alpha : 0.0)));
            }
            if (this.m_bprojectedNewton) {
                if (this.m_bUpdateHessian) {
                    hessian = f.evalSparseHessian(x, hessian);
                    if (this.m_subSolverType != 2) {
                        if (this.m_choleskyFactorization >= 0L) {
                            PnTaucsSolver.freeFactorization(this.m_choleskyFactorization);
                            this.m_choleskyFactorization = -1L;
                        }
                        this.m_choleskyFactorization = PnTaucsSolver.getCholeksyFactorization(hessian);
                    }
                }
                this.m_gradient = f.evalGradient(x, this.m_gradient);
                this.m_gradient.multScalar(-1.0);
                PdVector tGrad = this.m_subX;
                PdVector tDir = this.m_subB;
                if (tGrad == null || tGrad.m_data.length != m) {
                    tGrad = new PdVector(m);
                }
                if (tDir == null || tDir.m_data.length != m) {
                    tDir = new PdVector(m);
                }
                int d = 0;
                while (d < dim) {
                    i = 0;
                    while (i < m) {
                        tGrad.m_data[i] = this.m_gradient.m_data[dim * i + d];
                        ++i;
                    }
                    if (this.m_subSolverType == 2) {
                        this.m_band = PdVector.realloc((PdVector[])this.m_band, (int)5, (int)m);
                        PuSparseMatrix.solvePentaDiagonalCyclic(hessian, tGrad, this.m_band);
                        tDir.copyArray(tGrad);
                    } else {
                        PnTaucsSolver.solveUseFactorization(this.m_choleskyFactorization, tDir.m_data, tGrad.m_data);
                    }
                    if (this.m_bDecomposeHessian) {
                        i = 0;
                        while (i < m) {
                            tGrad.m_data[i] = this.diagonalMass.m_data[i] * tDir.m_data[i];
                            ++i;
                        }
                        if (this.m_subSolverType == 2) {
                            this.m_band = PdVector.realloc((PdVector[])this.m_band, (int)5, (int)m);
                            PuSparseMatrix.solvePentaDiagonalCyclic(hessian, tGrad, this.m_band);
                            tDir.copyArray(tGrad);
                        } else {
                            PnTaucsSolver.solveUseFactorization(this.m_choleskyFactorization, tDir.m_data, tGrad.m_data);
                        }
                    }
                    i = 0;
                    while (i < m) {
                        this.m_gradient.m_data[dim * i + d] = tDir.m_data[i];
                        ++i;
                    }
                    ++d;
                }
                this.getPLPath(x, this.m_gradient, this.m_t);
                alpha = Math.max(alphaPrevNewton, 1.0E-8);
                this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha);
                fx = f.eval(x);
                fy = f.eval(y);
                boolean bl2 = satisfied = fy < fx;
                if (satisfied) {
                    do {
                        fyPrev = fy;
                        this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= alphaFactor);
                    } while ((fy = f.eval(y)) < fyPrev);
                    this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= 1.0 / alphaFactor);
                } else {
                    double fac = 1.0 / alphaFactor;
                    do {
                        this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= fac);
                    } while ((fy = f.eval(y)) > fx && alpha > eps);
                }
                if (alpha > eps) {
                    alphaPrevNewton = alpha;
                    x.copyArray(y);
                }
                if (this.m_bDebugmessages) {
                    PsDebug.message((String)("Gradient Step decrease: " + (f.eval(x) - fx) + " factor: " + (alpha > eps ? alpha : 0.0)));
                }
            }
            if (this.m_bUseActiveSet) {
                boolean failed = true;
                PdVector rDir = this.m_subB;
                PnSparseMatrix rhessian = this.m_subMat;
                PdVector rGrad = this.m_subX;
                boolean[] inActiveSet = this.m_boolArray;
                if (this.m_bUpdateHessian) {
                    hessian = f.evalSparseHessian(x, hessian);
                    if (this.m_subSolverType != 2) {
                        if (this.m_choleskyFactorization >= 0L) {
                            PnTaucsSolver.freeFactorization(this.m_choleskyFactorization);
                            this.m_choleskyFactorization = -1L;
                        }
                        this.m_choleskyFactorization = PnTaucsSolver.getCholeksyFactorization(hessian);
                    }
                }
                failed = false;
                PdVector grad = new PdVector(m);
                int k = 0;
                while (k < this.m_dim) {
                    int j;
                    int nfv = 0;
                    i = 0;
                    while (i < m) {
                        j = this.m_dim * i + k;
                        grad.m_data[i] = this.m_gradient.m_data[j];
                        inActiveSet[i] = false;
                        if (this.m_t.m_data[j] <= alpha) {
                            inActiveSet[i] = true;
                            ++nfv;
                        }
                        ++i;
                    }
                    if ((nfv = m - nfv) != 0) {
                        if (rhessian == null) {
                            rhessian = new PnSparseMatrix(nfv, nfv);
                        }
                        rGrad.setSize(nfv);
                        rDir.setSize(nfv);
                        PuSparseMatrix.getReducedSystem(hessian, rhessian, grad, rGrad, 1, nfv, inActiveSet, this.m_sort.m_data);
                        int cnt = 0;
                        long taucsFactorReduced = -1L;
                        switch (this.m_subSolverType) {
                            case 2: {
                                if (nfv > 5) {
                                    this.m_band = PdVector.realloc((PdVector[])this.m_band, (int)5, (int)nfv);
                                    PuSparseMatrix.solvePentaDiagonalCyclic(rhessian, rGrad, this.m_band);
                                }
                                rDir.copyArray(rGrad);
                                failed = false;
                                break;
                            }
                            case 0: {
                                this.m_subPrec.m_choleskyFactorization = this.m_choleskyFactorization;
                                this.m_subSolver.solve(rhessian, rDir, rGrad);
                                failed = false;
                                break;
                            }
                            case 1: {
                                taucsFactorReduced = PnTaucsSolver.getCholeksyFactorization(rhessian);
                                PnTaucsSolver.solveUseFactorization(taucsFactorReduced, rDir.m_data, rGrad.m_data);
                            }
                        }
                        if (this.m_bDebugmessages && cnt >= 1) {
                            PsDebug.message((String)("Number off adds: " + cnt));
                        }
                        if (this.m_bDebugmessages) {
                            PdVector test = new PdVector(rDir.getSize());
                            PnSparseMatrix.rightMultVector((PnSparseMatrix)rhessian, (PdVector)rDir, (PdVector)test);
                            test.sub(rGrad);
                            PsDebug.message((String)("Residual of linear system: " + test.length() + " #addId: " + cnt));
                        }
                        if (this.m_bDecomposeHessian) {
                            cnt = 0;
                            i = 0;
                            while (i < m) {
                                j = this.m_dim * i + k;
                                if (!inActiveSet[i]) {
                                    rGrad.m_data[cnt] = this.diagonalMass.m_data[i] * rDir.m_data[cnt];
                                    ++cnt;
                                }
                                ++i;
                            }
                            switch (this.m_subSolverType) {
                                case 2: {
                                    if (nfv <= 5) break;
                                    this.m_band = PdVector.realloc((PdVector[])this.m_band, (int)5, (int)nfv);
                                    PuSparseMatrix.solvePentaDiagonalCyclic(rhessian, rGrad, this.m_band);
                                    rDir.copyArray(rGrad);
                                    break;
                                }
                                case 0: {
                                    this.m_subSolver.solve(rhessian, rDir, rGrad);
                                    break;
                                }
                                case 1: {
                                    PnTaucsSolver.solveUseFactorization(taucsFactorReduced, rDir.m_data, rGrad.m_data);
                                }
                            }
                        }
                        if (taucsFactorReduced >= 0L) {
                            PnTaucsSolver.freeFactorization(taucsFactorReduced);
                        }
                        if (!failed) {
                            cnt = 0;
                            i = 0;
                            while (i < m) {
                                j = dim * i + k;
                                this.m_gradient.m_data[j] = !inActiveSet[i] ? rDir.m_data[cnt++] : 0.0;
                                ++i;
                            }
                        }
                    }
                    ++k;
                }
                this.getPLPath(x, this.m_gradient, this.m_t);
                alpha = Math.max(betaPrev, 1.0E-8);
                this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha);
                fx = f.eval(x);
                fy = f.eval(y);
                boolean bl3 = satisfied = fy < fx;
                if (satisfied) {
                    do {
                        fyPrev = fy;
                        this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= alphaFactor);
                    } while ((fy = f.eval(y)) < fyPrev);
                    this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= 1.0 / alphaFactor);
                } else {
                    double fac = 1.0 / alphaFactor;
                    do {
                        this.evaluatePLPath(x, this.m_gradient, this.m_t, y, alpha *= fac);
                    } while ((fy = f.eval(y)) > fx && alpha > 1.0E-4);
                }
                if (alpha > 1.0E-4) {
                    alphaPrevNewton = alpha;
                    x.copyArray(y);
                }
                if (this.m_bDebugmessages) {
                    PsDebug.message((String)("Newton Step decrease: " + (f.eval(x) - fx) + " factor: " + 2.0 * alpha));
                }
            }
            ++this.m_iter;
        }
        if (this.m_choleskyFactorization >= 0L) {
            PnTaucsSolver.freeFactorization(this.m_choleskyFactorization);
            this.m_choleskyFactorization = -1L;
        }
    }

    protected static boolean cauchyPointCriterium(PnFunction f, PdVector x, PdVector y, PdVector g, double decreaseFactor, double f_x) {
        double dot = 0.0;
        int n = x.m_data.length;
        int i = 0;
        while (i < n) {
            dot += g.m_data[i] * (y.m_data[i] - x.m_data[i]);
            ++i;
        }
        double df = f.eval(y) - f_x;
        return -df >= decreaseFactor * dot;
    }

    protected static boolean newIterateCriterium(PnFunction f, PdVector x, PdVector y, double f_x) {
        double df = f_x - f.eval(y);
        return df >= 0.0;
    }

    protected static boolean cauchyPointCriterium(PnStiffMatrix hessian, PdVector v, PdVector g, double decreaseFactor, PdVector store) {
        PnSparseMatrix.rightMultVector((PnSparseMatrix)hessian, (PdVector)v, (PdVector)store);
        double vhv = PdVector.dot((PdVector)v, (PdVector)store);
        double gv = PdVector.dot((PdVector)g, (PdVector)v);
        return 0.5 * vhv - gv < -decreaseFactor * gv;
    }

    protected PdVector evaluatePLPath(PdVector x, PdVector direction, PdVector intersections, PdVector out, double t) {
        int m = x.m_data.length;
        int i = 0;
        while (i < m) {
            double s = intersections.m_data[i] < t ? intersections.m_data[i] : t;
            out.m_data[i] = x.m_data[i] + s * direction.m_data[i];
            ++i;
        }
        if (this.m_constraintType == 2) {
            PdVector[] c = this.m_sphereConstraints_centers;
            int dim = c[0].getSize();
            int n = c.length;
            double[] ab = new double[dim];
            int i2 = 0;
            while (i2 < n) {
                int di = dim * i2;
                int j = 0;
                while (j < dim) {
                    ab[j] = out.m_data[di + j] - c[i2].m_data[j];
                    ++j;
                }
                double l_ab = 0.0;
                j = 0;
                while (j < dim) {
                    l_ab += ab[j] * ab[j];
                    ++j;
                }
                if (!((l_ab = Math.sqrt(l_ab)) < this.m_sphereConstraints_globalRadius)) {
                    l_ab = this.m_sphereConstraints_globalRadius / l_ab;
                    j = 0;
                    while (j < dim) {
                        out.m_data[di + j] = c[i2].m_data[j] + ab[j] * l_ab;
                        ++j;
                    }
                }
                ++i2;
            }
        }
        return out;
    }

    protected PdVector getPLPath(PdVector x, PdVector direction, PdVector intersections) {
        int m = x.m_data.length;
        if (intersections == null) {
            intersections = new PdVector(m);
        } else if (intersections.m_data.length != m) {
            intersections.setSize(m);
        }
        return PnConstrainedNewton.getPLPath(x, this.m_boxConstraint_lower, this.m_boxConstraint_upper, direction, intersections);
    }

    protected static PdVector getPLPath(PdVector x, PdVector lower, PdVector upper, PdVector direction, PdVector intersections) {
        int n = x.m_data.length;
        double eps = 1.0E-14;
        int i = 0;
        while (i < n) {
            intersections.m_data[i] = direction.m_data[i] > eps && upper.m_data[i] < Double.POSITIVE_INFINITY ? (upper.m_data[i] - x.m_data[i]) / direction.m_data[i] : (direction.m_data[i] < -eps && lower.m_data[i] > Double.NEGATIVE_INFINITY ? (lower.m_data[i] - x.m_data[i]) / direction.m_data[i] : Double.POSITIVE_INFINITY);
            ++i;
        }
        return intersections;
    }

    protected static double lineSearch_backtracking(PnFunction f, PdVector gradDesc, PdVector p, PdVector v, double alphaMax, double c, double a, int depth, PdVector store) {
        double b;
        double en;
        double fp = f.eval(p);
        double gv = PdVector.dot((PdVector)gradDesc, (PdVector)v) / v.length();
        double lambda = a * alphaMax;
        store.blendBase(p, lambda, v);
        while ((en = f.eval(store)) > fp - c * lambda * gv) {
            lambda = a * lambda;
            store.blendBase(p, lambda, v);
        }
        lambda = b = lambda / (2.0 * a);
        int i = 0;
        while (i < depth) {
            double d;
            store.blendBase(p, lambda, v);
            b *= 0.5;
            double en_tmp = f.eval(store);
            if (d < en) {
                en = en_tmp;
                lambda += b;
            } else {
                lambda -= b;
            }
            ++i;
        }
        PsDebug.message((String)("stepwidth: " + lambda));
        return lambda;
    }

    public void setSphereConstraints(PdVector[] center, double radius) {
        this.m_sphereConstraints_globalRadius = radius;
        this.m_sphereConstraints_centers = center;
    }

    public void setSphereConstraints(PdVector[] center, PdVector radii) {
        this.m_sphereConstraints_radii = radii;
        this.m_sphereConstraints_centers = center;
    }

    public void freeSphereConstraints() {
        this.m_sphereConstraints_radii = null;
        this.m_sphereConstraints_centers = null;
    }

    public void setBoxConstraints(PdVector lower, PdVector upper) {
        this.m_boxConstraint_lower = lower;
        this.m_boxConstraint_upper = upper;
    }

    public void freeBoxConstraints() {
        this.m_boxConstraint_lower = null;
        this.m_boxConstraint_upper = null;
    }

    public void setConstraintType(int type) {
        this.m_constraintType = type;
    }

    public int getConstraintType() {
        return this.m_constraintType;
    }
}

