/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnDirichletCurve;
import dev.numeric.PnFunctionWithSparseHessian;
import dev.numeric.PnMassCurve;
import jv.geom.PgPolygon;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jvx.numeric.PnSparseMatrix;

public class PnBendingCurve
extends PnFunctionWithSparseHessian {
    protected boolean m_bEvaluable = true;
    protected boolean m_bscaleInvariant = true;
    protected PgPolygon m_geom;
    protected PnDirichletCurve m_stiff;
    protected PnSparseMatrix m_laplace;
    protected PnSparseMatrix m_hessian_1d;
    protected PdVector m_invMass;
    protected boolean m_bUseInexactHessian = true;
    double diagAdd = 1.0E-4;
    double d = -1.0;
    public static double m_lengthFactor = 0.0;

    public PnBendingCurve(PgPolygon geom) {
        this.m_geom = geom;
    }

    public boolean isEvaluable() {
        return this.m_bEvaluable;
    }

    public void enableEvaluation(boolean flag) {
        this.m_bEvaluable = flag;
    }

    public int getNumOfVariables() {
        return this.m_geom.getNumVertices();
    }

    public double eval(PdVector x) {
        return PnBendingCurve.evaluateEnergy(this.m_geom, x, this.m_bscaleInvariant);
    }

    public PdVector evalGradient(PdVector x, PdVector aGradient) {
        return PnBendingCurve.evaluateGradient(this.m_geom, x, PnBendingCurve.getCurvatureVector(this.m_geom, x, null, true), aGradient, this.m_bscaleInvariant);
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return aHessian;
    }

    @Override
    public PnSparseMatrix evalSparseHessian(PdVector x, PnSparseMatrix hessian) {
        int n = this.m_geom.getNumVertices();
        if (hessian == null) {
            hessian = new PnSparseMatrix(n, n, 5);
        }
        if (this.m_bUseInexactHessian) {
            if (this.m_stiff == null) {
                this.m_stiff = new PnDirichletCurve(this.m_geom);
            } else {
                this.m_stiff.init(this.m_geom);
            }
            this.m_invMass = PnMassCurve.getInverseOfLumpedMassMatrix(this.m_geom, this.m_invMass);
            if (this.m_laplace == null) {
                this.m_laplace = new PnDirichletCurve(this.m_geom);
            } else {
                this.m_laplace.copy((PnSparseMatrix)this.m_stiff);
            }
            PdVector[] l_values = this.m_laplace.getEntries();
            int i = 0;
            while (i < n) {
                l_values[i].multScalar(this.m_invMass.m_data[i]);
                ++i;
            }
            this.m_hessian_1d = PnSparseMatrix.multMatrices((PnSparseMatrix)this.m_stiff, (PnSparseMatrix)this.m_laplace, (PnSparseMatrix)this.m_hessian_1d);
            if (this.m_bscaleInvariant) {
                this.m_hessian_1d.multScalar(this.m_geom.getLength());
            }
            i = 0;
            while (i < n) {
                this.m_hessian_1d.addEntry(i, i, this.diagAdd);
                ++i;
            }
            return this.m_hessian_1d;
        }
        return PnBendingCurve.evalHessian(this.m_geom, hessian);
    }

    public void setScaleInvariant(boolean flag) {
        this.m_bscaleInvariant = flag;
    }

    public boolean isScalaInvariant() {
        return this.m_bscaleInvariant;
    }

    public static double evaluateEnergy(PgPolygon poly, PdVector vertPositions, boolean scaleInvariant) {
        boolean closed;
        double energy = 0.0;
        int nov = poly.getNumVertices();
        int d = poly.getDimOfVertices();
        PdVector e1 = new PdVector(d);
        PdVector e2 = new PdVector(d);
        double len = 0.0;
        boolean bUseVertPosVector = vertPositions != null;
        PdVector[] vertices = null;
        if (!bUseVertPosVector) {
            vertices = poly.getVertices();
        }
        int start = (closed = poly.isClosed()) ? 0 : 1;
        int end = closed ? nov : nov - 1;
        int i = start;
        while (i < end) {
            int im = (i + nov - 1) % nov;
            int ip = (i + 1) % nov;
            if (bUseVertPosVector) {
                int j = 0;
                while (j < d) {
                    e1.m_data[j] = vertPositions.m_data[d * i + j] - vertPositions.m_data[d * im + j];
                    e2.m_data[j] = vertPositions.m_data[d * i + j] - vertPositions.m_data[d * ip + j];
                    ++j;
                }
            } else {
                e1.sub(vertices[i], vertices[im]);
                e2.sub(vertices[i], vertices[ip]);
            }
            double l1 = e1.length();
            double l2 = e2.length();
            energy += 4.0 / (l1 + l2) * (1.0 + PdVector.dot((PdVector)e1, (PdVector)e2) / (l1 * l2));
            len += l1;
            ++i;
        }
        if (scaleInvariant) {
            return energy * len;
        }
        return energy + m_lengthFactor * len;
    }

    public static double evaluateEnergy(PgPolygon poly, boolean scaleInvariant) {
        return PnBendingCurve.evaluateEnergy(poly, null, scaleInvariant);
    }

    public static PdVector getCurvatureVector(PgPolygon poly, PdVector curvatureVector) {
        return PnBendingCurve.getCurvatureVector(poly, null, curvatureVector, true);
    }

    public static PdVector getCurvatureVector(PgPolygon poly, PdVector curvatureVector, boolean multWithInverseMass) {
        return PnBendingCurve.getCurvatureVector(poly, null, curvatureVector, multWithInverseMass);
    }

    public static PdVector getCurvatureVector(PgPolygon poly, PdVector vertexPositions, PdVector curvatureVector, boolean multWithInverseMass) {
        int nov = poly.getNumVertices();
        int d = poly.getDimOfVertices();
        if (curvatureVector == null) {
            curvatureVector = new PdVector(nov * d);
        } else if (curvatureVector.m_data.length != nov * d) {
            curvatureVector.setSize(nov * d);
        }
        PdVector e1 = new PdVector(d);
        PdVector e2 = new PdVector(d);
        boolean bUseVertPosVector = vertexPositions != null;
        PdVector[] vertices = null;
        double[] x = null;
        if (!bUseVertPosVector) {
            vertices = poly.getVertices();
        } else {
            x = vertexPositions.m_data;
        }
        boolean closed = poly.isClosed();
        int start = closed ? 0 : 1;
        int end = closed ? nov : nov - 1;
        int i = start;
        while (i < end) {
            int j;
            int im = (i + nov - 1) % nov;
            int ip = (i + 1) % nov;
            if (bUseVertPosVector) {
                j = 0;
                while (j < d) {
                    e1.m_data[j] = x[d * i + j] - x[d * im + j];
                    e2.m_data[j] = x[d * i + j] - x[d * ip + j];
                    ++j;
                }
            } else {
                e1.sub(vertices[i], vertices[im]);
                e2.sub(vertices[i], vertices[ip]);
            }
            double l1 = e1.length();
            double l2 = e2.length();
            e1.multScalar(1.0 / l1);
            e2.multScalar(1.0 / l2);
            int id = i * d;
            double mInv = 2.0 / (l1 + l2);
            if (multWithInverseMass) {
                j = 0;
                while (j < d) {
                    curvatureVector.m_data[id + j] = mInv * (e1.m_data[j] + e2.m_data[j]);
                    ++j;
                }
            } else {
                j = 0;
                while (j < d) {
                    curvatureVector.m_data[id + j] = e1.m_data[j] + e2.m_data[j];
                    ++j;
                }
            }
            ++i;
        }
        return curvatureVector;
    }

    public static PdVector evaluateGradient(PgPolygon poly, PdVector curvatureVector, PdVector gradient, boolean scaleInvariant) {
        return PnBendingCurve.evaluateGradient(poly, null, curvatureVector, gradient, scaleInvariant);
    }

    public static PdVector evaluateGradient(PgPolygon poly, PdVector vertexPositions, PdVector curvatureVector, PdVector gradient, boolean scaleInvariant) {
        int nov = poly.getNumVertices();
        int dim = poly.getDimOfVertices();
        double[] x = vertexPositions.m_data;
        int m = nov * dim;
        if (gradient == null) {
            gradient = new PdVector(m);
        } else if (gradient.getSize() != m) {
            gradient.setSize(m);
        }
        gradient.setConstant(0.0);
        PdVector hvec = new PdVector(dim);
        double[] h = hvec.m_data;
        PdVector edge1 = new PdVector(dim);
        double[] e1 = edge1.m_data;
        PdVector edge2 = new PdVector(dim);
        double[] e2 = edge2.m_data;
        double[] g = gradient.m_data;
        double[] cv = curvatureVector.m_data;
        boolean bUseVertPosVector = true;
        PdVector[] vert = null;
        if (!bUseVertPosVector) {
            vert = poly.getVertices();
        }
        boolean bClosed = poly.isClosed();
        double len = 0.0;
        int i = 0;
        while (i < nov) {
            double dot;
            double le2;
            double le1;
            int j;
            int id = dim * i;
            if (i == 0) {
                if (bClosed) {
                    if (bUseVertPosVector) {
                        j = 0;
                        while (j < dim) {
                            edge1.m_data[j] = x[j] - x[dim * (nov - 1) + j];
                            ++j;
                        }
                    } else {
                        edge1.sub(vert[0], vert[nov - 1]);
                    }
                } else {
                    edge1.setConstant(0.0);
                }
            } else if (bUseVertPosVector) {
                j = 0;
                while (j < dim) {
                    edge1.m_data[j] = x[dim * i + j] - x[dim * (i - 1) + j];
                    ++j;
                }
            } else {
                edge1.sub(vert[i], vert[i - 1]);
            }
            if (i == nov - 1) {
                if (bClosed) {
                    if (bUseVertPosVector) {
                        j = 0;
                        while (j < dim) {
                            edge2.m_data[j] = x[j] - x[dim * (nov - 1) + j];
                            ++j;
                        }
                    } else {
                        edge2.sub(vert[0], vert[nov - 1]);
                    }
                } else {
                    edge2.setConstant(0.0);
                }
            } else if (bUseVertPosVector) {
                j = 0;
                while (j < dim) {
                    edge2.m_data[j] = x[dim * (i + 1) + j] - x[dim * i + j];
                    ++j;
                }
            } else {
                edge2.sub(vert[i + 1], vert[i]);
            }
            if (i != 0 || bClosed) {
                le1 = edge1.length();
                len += le1;
                le1 = 1.0 / le1;
                edge1.multScalar(le1);
            } else {
                le1 = 0.0;
            }
            if (i != nov - 1 || bClosed) {
                le2 = 1.0 / edge2.length();
                edge2.multScalar(le2);
            } else {
                le2 = 0.0;
            }
            double kk = 0.0;
            j = 0;
            while (j < dim) {
                kk += cv[id + j] * cv[id + j] + cv[(id - dim + m) % m + j] * cv[(id - dim + m) % m + j];
                ++j;
            }
            j = 0;
            while (j < dim) {
                int n = id + j;
                g[n] = g[n] - 0.5 * kk * e1[j];
                ++j;
            }
            kk = 0.0;
            j = 0;
            while (j < dim) {
                kk += cv[id + j] * cv[id + j] + cv[(id + dim) % m + j] * cv[(id + dim) % m + j];
                ++j;
            }
            j = 0;
            while (j < dim) {
                int n = id + j;
                g[n] = g[n] + 0.5 * kk * e2[j];
                ++j;
            }
            if (i != 0 || bClosed) {
                j = 0;
                while (j < dim) {
                    h[j] = cv[id + j] - cv[(id - dim + m) % m + j];
                    ++j;
                }
                dot = -PdVector.dot((PdVector)hvec, (PdVector)edge1);
                hvec.blendBase(hvec, dot, edge1);
                j = 0;
                while (j < dim) {
                    if (i != 0 || bClosed) {
                        int n = id + j;
                        g[n] = g[n] + 2.0 * le1 * h[j];
                    }
                    ++j;
                }
            }
            if (i != nov - 1 || bClosed) {
                j = 0;
                while (j < dim) {
                    h[j] = cv[id + j] - cv[(id + dim) % m + j];
                    ++j;
                }
                dot = -PdVector.dot((PdVector)hvec, (PdVector)edge2);
                hvec.blendBase(hvec, dot, edge2);
                j = 0;
                while (j < dim) {
                    if (i != nov || bClosed) {
                        int n = id + j;
                        g[n] = g[n] + 2.0 * le2 * h[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (scaleInvariant) {
            double en = PnBendingCurve.evaluateEnergy(poly, vertexPositions, false);
            gradient.blend(len, gradient, en, PnBendingCurve.getCurvatureVector(poly, vertexPositions, null, false));
        } else {
            gradient.blendBase(gradient, -m_lengthFactor, curvatureVector);
        }
        return gradient;
    }

    public static PnSparseMatrix evalHessian(PgPolygon poly, PnSparseMatrix hessian) {
        int nov = poly.getNumVertices();
        PdVector[] vertices = poly.getVertices();
        int m = 2 * nov;
        if (hessian == null) {
            hessian = new PnSparseMatrix(m, m, 10);
        } else if (hessian.getNumRows() != m || hessian.getNumCols() != m && hessian.getNumCols() != -1) {
            hessian.setSize(m, m, 10);
        }
        int i = 0;
        while (i < nov) {
            int im = (i + nov - 1) % nov;
            int ip = (i + 1) % nov;
            double x1 = vertices[im].m_data[0];
            double y1 = vertices[im].m_data[1];
            double x2 = vertices[i].m_data[0];
            double y2 = vertices[i].m_data[1];
            double x3 = vertices[ip].m_data[0];
            double y3 = vertices[ip].m_data[1];
            double l1 = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double l2 = Math.sqrt((x2 - x3) * (x2 - x3) + (y2 - y3) * (y2 - y3));
            int j = 2 * i;
            int jm = 2 * im;
            int jp = 2 * ip;
            hessian.addEntry(jm, jm, PnBendingCurve.dx1x1(x1, y1, x2, y2, x3, y3, l1, l2));
            double entry = PnBendingCurve.dx1y1(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm + 1, jm, entry);
            hessian.addEntry(jm, jm + 1, entry);
            hessian.addEntry(jm + 1, jm + 1, PnBendingCurve.dx1x1(y1, x1, y2, x2, y3, x3, l1, l2));
            hessian.addEntry(j, j, PnBendingCurve.dx2x2(x1, y1, x2, y2, x3, y3, l1, l2));
            entry = PnBendingCurve.dx2y2(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(j + 1, j, entry);
            hessian.addEntry(j, j + 1, entry);
            hessian.addEntry(j + 1, j + 1, PnBendingCurve.dx2x2(y1, x1, y2, x2, y3, x3, l1, l2));
            hessian.addEntry(jp, jp, PnBendingCurve.dx3x3(x1, y1, x2, y2, x3, y3, l1, l2));
            entry = PnBendingCurve.dx3y3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jp + 1, jp, entry);
            hessian.addEntry(jp, jp + 1, entry);
            hessian.addEntry(jp + 1, jp + 1, PnBendingCurve.dx3x3(y1, x1, y2, x2, y3, x3, l1, l2));
            entry = PnBendingCurve.dx1x2(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm, j, entry);
            hessian.addEntry(j, jm, entry);
            entry = PnBendingCurve.dy1x2(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm + 1, j, entry);
            hessian.addEntry(j, jm + 1, entry);
            entry = PnBendingCurve.dx1y2(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm, j + 1, entry);
            hessian.addEntry(j + 1, jm, entry);
            entry = PnBendingCurve.dy1y2(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm + 1, j + 1, entry);
            hessian.addEntry(j + 1, jm + 1, entry);
            entry = PnBendingCurve.dx2x3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jp, j, entry);
            hessian.addEntry(j, jp, entry);
            entry = PnBendingCurve.dy2x3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(j + 1, jp, entry);
            hessian.addEntry(jp, j + 1, entry);
            entry = PnBendingCurve.dx2y3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(j, jp + 1, entry);
            hessian.addEntry(jp + 1, j, entry);
            entry = PnBendingCurve.dy2y3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(j + 1, jp + 1, entry);
            hessian.addEntry(jp + 1, j + 1, entry);
            entry = PnBendingCurve.dx1x3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm, jp, entry);
            hessian.addEntry(jp, jm, entry);
            entry = PnBendingCurve.dy1x3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm + 1, jp, entry);
            hessian.addEntry(jp, jm + 1, entry);
            entry = PnBendingCurve.dx1y3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm, jp + 1, entry);
            hessian.addEntry(jp + 1, jm, entry);
            entry = PnBendingCurve.dy1y3(x1, y1, x2, y2, x3, y3, l1, l2);
            hessian.addEntry(jm + 1, jp + 1, entry);
            hessian.addEntry(jp + 1, jm + 1, entry);
            ++i;
        }
        return hessian;
    }

    private static double dx2y3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * Math.pow(l1, 2.0) * l2 * (l1 + l2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * ((l2 * (-y1 + y2) + l1 * (y2 - y3)) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) + (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (x2 - x3) * (y2 - y3)) + 2.0 * l1 * Math.pow(l1 + l2, 2.0) * (Math.pow(l1, 2.0) * (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (Math.pow(l2, 2.0) - 3.0 * Math.pow(y2 - y3, 2.0)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (Math.pow(l2, 2.0) - Math.pow(y2 - y3, 2.0)) + Math.pow(l1, 2.0) * Math.pow(l2, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y2 - y3) - (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (x2 - x3) * (y2 - y3) + 3.0 * Math.pow(l1, 2.0) * Math.pow(x2 - x3, 2.0) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * (y2 - y3)) - 2.0 * l2 * (l1 + l2) * (-y2 + y3) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * Math.pow(l2, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - Math.pow(l1, 2.0) * l2 * (l1 + l2) * (-x2 + x3) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dy2y3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * Math.pow(l1, 2.0) * l2 * (l1 + l2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * ((l2 * (-y1 + y2) + l1 * (y2 - y3)) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) + (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (x2 - x3) * (y2 - y3)) - 2.0 * l2 * (l1 + l2) * (-y2 + y3) * ((l2 * (x1 - x2) + l1 * (-x2 + x3)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * Math.pow(l1 + l2, 2.0) * (Math.pow(l1, 2.0) * Math.pow(l2, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (x2 - x3) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (Math.pow(l2, 2.0) - Math.pow(y2 - y3, 2.0)) - (x2 - x3) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (y2 - y3) + 3.0 * Math.pow(l1, 2.0) * (x2 - x3) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * Math.pow(y2 - y3, 2.0) + 3.0 * Math.pow(l1, 2.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) * (y2 - y3) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + Math.pow(l1, 2.0) * Math.pow(l2, 3.0) * (l1 + l2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - Math.pow(l1, 2.0) * l2 * (l1 + l2) * Math.pow(y2 - y3, 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) + 2.0 * l1 * Math.pow(l2, 2.0) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx1x3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 4.0 * (-(Math.pow(l2, 2.0) * (l1 + l2) * (-x2 + x3) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (x1 - x2) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)))) + l1 * l2 * Math.pow(l1 + l2, 2.0) * (-((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) + (x1 - x2) * (x2 - x3) * (y1 - y2) * (y2 - y3)) + Math.pow(l1, 2.0) * (l1 + l2) * (-x1 + x2) * ((l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) + (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3)) - l1 * l2 * (-x1 + x2) * (-x2 + x3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dy1x3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 4.0 * (l1 * l2 * Math.pow(l1 + l2, 2.0) * ((x1 - x2) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) * (y1 - y2) - (x2 - x3) * (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (y2 - y3)) + Math.pow(l1, 2.0) * (l1 + l2) * (-y1 + y2) * ((l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) + (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3)) - Math.pow(l2, 2.0) * (l1 + l2) * (-x2 + x3) * ((x1 - x2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y1 - y2) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - l1 * l2 * (-x2 + x3) * (-y1 + y2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx1y3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 4.0 * (l1 * l2 * Math.pow(l1 + l2, 2.0) * ((x1 - x2) * (y1 - y2) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) - (Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (x2 - x3) * (y2 - y3)) + Math.pow(l1, 2.0) * (l1 + l2) * (-x1 + x2) * ((l2 * (-y1 + y2) + l1 * (y2 - y3)) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) + (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (x2 - x3) * (y2 - y3)) - Math.pow(l2, 2.0) * (l1 + l2) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (x1 - x2) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3))) * (-y2 + y3) - l1 * l2 * (-x1 + x2) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dy1y3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 4.0 * (Math.pow(l1, 2.0) * (l1 + l2) * (-y1 + y2) * ((l2 * (-y1 + y2) + l1 * (y2 - y3)) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) + (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (x2 - x3) * (y2 - y3)) + l1 * l2 * Math.pow(l1 + l2, 2.0) * (-((Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) + (x1 - x2) * (x2 - x3) * (y1 - y2) * (y2 - y3)) - Math.pow(l2, 2.0) * (l1 + l2) * (-y2 + y3) * ((x1 - x2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y1 - y2) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - l1 * l2 * (-y1 + y2) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx2x3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * Math.pow(l1, 2.0) * l2 * (l1 + l2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * ((l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) + (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3)) - 2.0 * l2 * (l1 + l2) * (-x2 + x3) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * Math.pow(l1 + l2, 2.0) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (Math.pow(l2, 2.0) - Math.pow(x2 - x3, 2.0)) + 3.0 * Math.pow(l1, 2.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) * (x2 - x3) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + Math.pow(l1, 2.0) * Math.pow(l2, 2.0) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3) - (x2 - x3) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (y2 - y3) + 3.0 * Math.pow(l1, 2.0) * Math.pow(x2 - x3, 2.0) * (y2 - y3) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + Math.pow(l1, 2.0) * Math.pow(l2, 3.0) * (l1 + l2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - Math.pow(l1, 2.0) * l2 * (l1 + l2) * Math.pow(x2 - x3, 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) + 2.0 * l1 * Math.pow(l2, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-x2 + x3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dy2x3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * Math.pow(l1, 2.0) * l2 * (l1 + l2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * ((l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) + (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3)) - 2.0 * l2 * (l1 + l2) * (-x2 + x3) * ((l2 * (x1 - x2) + l1 * (-x2 + x3)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * Math.pow(l1 + l2, 2.0) * (Math.pow(l1, 2.0) * Math.pow(l2, 2.0) * (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) + (Math.pow(l2, 2.0) - Math.pow(x2 - x3, 2.0)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + Math.pow(l1, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (Math.pow(l2, 2.0) - 3.0 * Math.pow(x2 - x3, 2.0)) * (y2 - y3) - (x2 - x3) * (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (y2 - y3) + 3.0 * Math.pow(l1, 2.0) * (x2 - x3) * Math.pow(y2 - y3, 2.0) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * Math.pow(l2, 2.0) * (-x2 + x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - Math.pow(l1, 2.0) * l2 * (l1 + l2) * (-x2 + x3) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 4.0) * Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dy1x2(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (2.0 * l2 * Math.pow(l1 + l2, 2.0) * (-((x1 - x2) * (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (y1 - y2)) + Math.pow(l2, 2.0) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * (y1 - y2) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + Math.pow(l2, 2.0) * (x1 - x2) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - 2.0 * l1 * Math.pow(l2, 2.0) * (l1 + l2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * ((x1 - x2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y1 - y2) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * (l1 + l2) * (-y1 + y2) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - l1 * Math.pow(l2, 2.0) * (l1 + l2) * (-x1 + x2) * (-y1 + y2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - 2.0 * Math.pow(l1, 2.0) * l2 * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-y1 + y2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 6.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dy1y2(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * l1 * Math.pow(l2, 2.0) * (l1 + l2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * ((x1 - x2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y1 - y2) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l2 * Math.pow(l1 + l2, 2.0) * (Math.pow(l2, 2.0) * (x1 - x2) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(y1 - y2, 2.0)) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) - (x1 - x2) * (y1 - y2) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) - 3.0 * Math.pow(l2, 2.0) * (-Math.pow(l1, 2.0) + Math.pow(y1 - y2, 2.0)) * (y1 - y2) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * (l1 + l2) * (-y1 + y2) * ((l2 * (x1 - x2) + l1 * (-x2 + x3)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - l1 * Math.pow(l2, 2.0) * (l1 + l2) * (-Math.pow(l1, 2.0) + Math.pow(y1 - y2, 2.0)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - 2.0 * Math.pow(l1, 2.0) * l2 * (-y1 + y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 6.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx1x1(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (4.0 * l1 * (l1 + l2) * (-x1 + x2) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (x1 - x2) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3))) / l2 + 2.0 * Math.pow(l1 + l2, 2.0) * (Math.pow(Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0), 2.0) + 3.0 * (-Math.pow(l1, 2.0) + Math.pow(x1 - x2, 2.0)) * (x1 - x2) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) / l2 + Math.pow(x1 - x2, 2.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 2.0) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) / l2 + 3.0 * Math.pow(x1 - x2, 2.0) * (y1 - y2) * (l2 * (y1 - y2) + l1 * (-y2 + y3)) / l2) - Math.pow(l1, 3.0) * (l1 + l2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l2, 2.0) + 2.0 * Math.pow(l1, 2.0) * Math.pow(x1 - x2, 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l2, 2.0) + l1 * (l1 + l2) * Math.pow(x1 - x2, 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l2, 2.0)) / (Math.pow(l1, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx1y1(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (2.0 * Math.pow(l1 + l2, 2.0) * ((-Math.pow(l1, 2.0) + Math.pow(x1 - x2, 2.0)) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y1 - y2) / l2 + 3.0 * Math.pow(x1 - x2, 2.0) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * (y1 - y2) / l2 + (x1 - x2) * (-Math.pow(l1, 2.0) + Math.pow(y1 - y2, 2.0)) * (y1 - y2) + (x1 - x2) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(y1 - y2, 2.0)) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) / l2) + 2.0 * l1 * (l1 + l2) * (-y1 + y2) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (x1 - x2) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3))) / l2 + 2.0 * l1 * (l1 + l2) * (-x1 + x2) * ((x1 - x2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (y1 - y2) + (Math.pow(l1, 2.0) - Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) / l2 + 2.0 * Math.pow(l1, 2.0) * (-x1 + x2) * (-y1 + y2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l2, 2.0) + l1 * (l1 + l2) * (-x1 + x2) * (-y1 + y2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l2, 2.0)) / (Math.pow(l1, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx2x2(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (2.0 * Math.pow(l1 + l2, 2.0) * (Math.pow(Math.pow(l1, 2.0) * Math.pow(l2, 3.0) - Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (Math.pow(l2, 2.0) - Math.pow(x2 - x3, 2.0)), 2.0) / (Math.pow(l1, 6.0) * Math.pow(l2, 6.0)) + 3.0 * (Math.pow(l2, 5.0) * Math.pow(x1 - x2, 3.0) + Math.pow(l1, 2.0) * Math.pow(l2, 5.0) * (-x1 + x2) - Math.pow(l1, 5.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) * (x2 - x3)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) / (Math.pow(l1, 6.0) * Math.pow(l2, 6.0)) + Math.pow((x1 - x2) * (y1 - y2) / Math.pow(l1, 3.0) + (x2 - x3) * (y2 - y3) / Math.pow(l2, 3.0), 2.0) - (Math.pow(l1, 2.0) * Math.pow(l2, 5.0) * (y1 - y2) - 3.0 * Math.pow(l2, 5.0) * Math.pow(x1 - x2, 2.0) * (y1 - y2) - Math.pow(l1, 5.0) * (Math.pow(l2, 2.0) - 3.0 * Math.pow(x2 - x3, 2.0)) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3)) / (Math.pow(l1, 6.0) * Math.pow(l2, 6.0))) - 4.0 * (l1 + l2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) / (Math.pow(l1, 5.0) * Math.pow(l2, 5.0)) - (l1 + l2) * (1.0 / l1 + 1.0 / l2 - Math.pow(x1 - x2, 2.0) / Math.pow(l1, 3.0) - Math.pow(x2 - x3, 2.0) / Math.pow(l2, 3.0)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / (Math.pow(l1, 2.0) * Math.pow(l2, 2.0)) + 2.0 * Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / (Math.pow(l1, 4.0) * Math.pow(l2, 4.0))) / Math.pow(l1 + l2, 3.0);
    }

    private static double dx2y2(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (2.0 * Math.pow(l1 + l2, 2.0) * ((l2 * (x1 - x2) + l1 * (-x2 + x3)) * (3.0 * Math.pow(l2, 5.0) * Math.pow(x1 - x2, 2.0) * (y1 - y2) + Math.pow(l1, 2.0) * Math.pow(l2, 5.0) * (-y1 + y2) + Math.pow(l1, 5.0) * (Math.pow(l2, 2.0) - 3.0 * Math.pow(x2 - x3, 2.0)) * (y2 - y3)) - (Math.pow(l1, 2.0) * Math.pow(l2, 3.0) - Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (Math.pow(l2, 2.0) - Math.pow(x2 - x3, 2.0))) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (Math.pow(l1, 2.0) * Math.pow(l2, 5.0) * (-x1 + x2) + 3.0 * Math.pow(l2, 5.0) * (x1 - x2) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 5.0) * (x2 - x3) * (Math.pow(l2, 2.0) - 3.0 * Math.pow(y2 - y3, 2.0))) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - 2.0 * l1 * l2 * (l1 + l2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * ((l2 * (x1 - x2) + l1 * (-x2 + x3)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - 2.0 * l1 * l2 * (l1 + l2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * Math.pow(l1, 2.0) * Math.pow(l2, 2.0) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - Math.pow(l1, 4.0) * Math.pow(l2, 4.0) * (l1 + l2) * (-((x1 - x2) * (y1 - y2) / Math.pow(l1, 3.0)) - (x2 - x3) * (y2 - y3) / Math.pow(l2, 3.0)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 6.0) * Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx3x3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-4.0 * l2 * (l1 + l2) * (-x2 + x3) * ((l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) + (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3)) / l1 + 2.0 * Math.pow(l1 + l2, 2.0) * (Math.pow(Math.pow(l2, 2.0) - Math.pow(x2 - x3, 2.0), 2.0) + 3.0 * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) * (x2 - x3) / l1 + 3.0 * Math.pow(x2 - x3, 2.0) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3) / l1 + Math.pow(x2 - x3, 2.0) * Math.pow(y2 - y3, 2.0) + Math.pow(l2, 2.0) * (y2 - y3) * (l2 * (y1 - y2) + l1 * (-y2 + y3)) / l1) - Math.pow(l2, 3.0) * (l1 + l2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l1, 2.0) + 2.0 * Math.pow(l2, 2.0) * Math.pow(x2 - x3, 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l1, 2.0) + l2 * (l1 + l2) * Math.pow(x2 - x3, 2.0) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l1, 2.0)) / (Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx3y3(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * l2 * (l1 + l2) * (-x2 + x3) * ((l2 * (-y1 + y2) + l1 * (y2 - y3)) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) + (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (x2 - x3) * (y2 - y3)) / l1 - 2.0 * l2 * (l1 + l2) * ((l2 * (-x1 + x2) + l1 * (x2 - x3)) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) + (x2 - x3) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (y2 - y3)) * (-y2 + y3) / l1 + 2.0 * Math.pow(l1 + l2, 2.0) * ((-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0)) * (x2 - x3) * (y2 - y3) + 3.0 * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * Math.pow(x2 - x3, 2.0) * (y2 - y3) / l1 + Math.pow(l2, 2.0) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * (y2 - y3) / l1 + (x2 - x3) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0)) * (y2 - y3) + (x2 - x3) * (Math.pow(l2, 2.0) - 3.0 * Math.pow(y2 - y3, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3)) / l1) + 2.0 * Math.pow(l2, 2.0) * (-x2 + x3) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l1, 2.0) + l2 * (l1 + l2) * (-x2 + x3) * (-y2 + y3) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) / Math.pow(l1, 2.0)) / (Math.pow(l2, 6.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx1x2(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * l1 * Math.pow(l2, 2.0) * (l1 + l2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (x1 - x2) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3))) + 2.0 * l2 * Math.pow(l1 + l2, 2.0) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) - 3.0 * Math.pow(l2, 2.0) * (-Math.pow(l1, 2.0) + Math.pow(x1 - x2, 2.0)) * (x1 - x2) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) - (x1 - x2) * (y1 - y2) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + Math.pow(l2, 2.0) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(x1 - x2, 2.0)) * (y1 - y2) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * (l1 + l2) * (-x1 + x2) * ((-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(x1 - x2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(x2 - x3, 2.0))) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - l1 * Math.pow(l2, 2.0) * (l1 + l2) * (-Math.pow(l1, 2.0) + Math.pow(x1 - x2, 2.0)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - 2.0 * Math.pow(l1, 2.0) * l2 * (-x1 + x2) * (l2 * (-x1 + x2) + l1 * (x2 - x3)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 6.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }

    private static double dx1y2(double x1, double y1, double x2, double y2, double x3, double y3, double l1, double l2) {
        return 2.0 * (-2.0 * l1 * Math.pow(l2, 2.0) * (l1 + l2) * ((Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) + (x1 - x2) * (y1 - y2) * (l2 * (-y1 + y2) + l1 * (y2 - y3))) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) + 2.0 * l2 * Math.pow(l1 + l2, 2.0) * (Math.pow(l2, 2.0) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(x1 - x2, 2.0)) * (l2 * (x1 - x2) + l1 * (-x2 + x3)) * (y1 - y2) - (x1 - x2) * (y1 - y2) * (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) + (Math.pow(l1, 2.0) - Math.pow(x1 - x2, 2.0)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + Math.pow(l2, 2.0) * (x1 - x2) * (Math.pow(l1, 2.0) - 3.0 * Math.pow(y1 - y2, 2.0)) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) + 2.0 * l1 * (l1 + l2) * (-x1 + x2) * ((l2 * (x1 - x2) + l1 * (-x2 + x3)) * (Math.pow(l2, 3.0) * (x1 - x2) * (y1 - y2) + Math.pow(l1, 3.0) * (x2 - x3) * (y2 - y3)) + (-(Math.pow(l1, 2.0) * Math.pow(l2, 3.0)) + Math.pow(l2, 3.0) * Math.pow(y1 - y2, 2.0) + Math.pow(l1, 3.0) * (-Math.pow(l2, 2.0) + Math.pow(y2 - y3, 2.0))) * (l2 * (y1 - y2) + l1 * (-y2 + y3))) - l1 * Math.pow(l2, 2.0) * (l1 + l2) * (-x1 + x2) * (-y1 + y2) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0)) - 2.0 * Math.pow(l1, 2.0) * l2 * (-x1 + x2) * (l2 * (-y1 + y2) + l1 * (y2 - y3)) * (Math.pow(l2 * (x1 - x2) + l1 * (-x2 + x3), 2.0) + Math.pow(l2 * (y1 - y2) + l1 * (-y2 + y3), 2.0))) / (Math.pow(l1, 6.0) * Math.pow(l2, 4.0) * Math.pow(l1 + l2, 3.0));
    }
}

