/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnFunctionWithSparseHessian;
import dev.numeric.PuSparseMatrix;
import jv.geom.PgElementSet;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnMassMatrix;
import jvx.numeric.PnSparseMatrix;
import jvx.numeric.PnStiffDiriConforming;

public class PnBending
extends PnFunctionWithSparseHessian {
    protected boolean m_bEvaluable = true;
    protected PgElementSet m_geom;
    protected PnStiffDiriConforming m_stiff;
    protected PnSparseMatrix m_laplace;
    protected PnSparseMatrix m_hessian_1d;
    protected PdVector m_invMass;
    protected boolean m_bUseInexactHessian = true;
    public boolean bTest = true;
    private static PdVector e;
    private static PdVector je;
    private static PdVector vec;

    public PnBending(PgElementSet geom) {
        this.m_geom = geom;
    }

    public boolean isEvaluable() {
        return this.m_bEvaluable;
    }

    public void enableEvaluation(boolean flag) {
        this.m_bEvaluable = flag;
    }

    public int getNumOfVariables() {
        return this.m_geom.getNumVertices();
    }

    public double eval(PdVector x) {
        return PnBending.evaluateEnergy(this.m_geom, x);
    }

    public PdVector evalGradient(PdVector x, PdVector aGradient) {
        return PnBending.evaluateGradient(this.m_geom, x, aGradient);
    }

    public PdMatrix evalHessian(PdMatrix aHessian) {
        return aHessian;
    }

    @Override
    public PnSparseMatrix evalSparseHessian(PdVector x, PnSparseMatrix hessian) {
        int n = this.m_geom.getNumVertices();
        if (this.m_bUseInexactHessian) {
            if (this.m_stiff == null) {
                this.m_stiff = new PnStiffDiriConforming(this.m_geom);
            } else {
                this.m_stiff.init(this.m_geom);
            }
            int i = 0;
            while (i < n) {
                this.m_stiff.addEntry(i, i, 0.1);
                ++i;
            }
            this.m_invMass = PnMassMatrix.getInvLumpedMassMatrix((PgElementSet)this.m_geom, (PdVector)this.m_invMass);
            if (this.m_laplace == null) {
                this.m_laplace = new PnSparseMatrix(n, n, 0);
            }
            this.m_laplace.copy((PnSparseMatrix)this.m_stiff);
            PdVector[] l_values = this.m_laplace.getEntries();
            int i2 = 0;
            while (i2 < n) {
                l_values[i2].multScalar(this.m_invMass.m_data[i2]);
                ++i2;
            }
            this.m_hessian_1d = PnSparseMatrix.multMatrices((PnSparseMatrix)this.m_stiff, (PnSparseMatrix)this.m_laplace, (PnSparseMatrix)this.m_hessian_1d);
            if (this.bTest) {
                return this.m_hessian_1d;
            }
            return PuSparseMatrix.one2nD(this.m_hessian_1d, hessian, this.m_geom.getDimOfVertices());
        }
        return null;
    }

    public static double evaluateEnergy(PgElementSet geom, PdVector vertPositions) {
        if (e == null) {
            e = new PdVector(3);
        }
        if (vec == null) {
            vec = new PdVector(3);
        }
        if (je == null) {
            je = new PdVector(3);
        }
        int noe = geom.getNumElements();
        PiVector[] elements = geom.getElements();
        PiVector[] neighbor = geom.getNeighbours();
        PdVector[] p = PdVector.realloc(null, (int)4, (int)3);
        double energy = 0.0;
        int i = 0;
        while (i < noe) {
            int size = elements[i].m_data.length;
            int j = 0;
            while (j < size) {
                if (neighbor[i].m_data[j] >= i) {
                    int h = 3 * elements[i].m_data[j];
                    int k = 0;
                    while (k < 3) {
                        p[0].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    int jp = (j + 1) % size;
                    h = 3 * elements[i].m_data[jp];
                    k = 0;
                    while (k < 3) {
                        p[1].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    jp = (j + 2) % size;
                    h = 3 * elements[i].m_data[jp];
                    k = 0;
                    while (k < 3) {
                        p[2].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    int o = geom.getOppVertexInd(i, j);
                    h = 3 * o;
                    k = 0;
                    while (k < 3) {
                        p[3].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    energy += PnBending.atomicEnergy(p[0], p[1], p[2], p[3]);
                }
                ++j;
            }
            ++i;
        }
        return energy;
    }

    public static double evaluateEnergy(PgElementSet geom) {
        if (e == null) {
            e = new PdVector(3);
        }
        if (vec == null) {
            vec = new PdVector(3);
        }
        if (je == null) {
            je = new PdVector(3);
        }
        int noe = geom.getNumElements();
        PdVector[] vertices = geom.getVertices();
        PiVector[] elements = geom.getElements();
        PiVector[] neighbor = geom.getNeighbours();
        double energy = 0.0;
        int i = 0;
        while (i < noe) {
            int size = elements[i].m_data.length;
            int j = 0;
            while (j < size) {
                if (neighbor[i].m_data[j] >= i) {
                    PdVector p1 = vertices[elements[i].m_data[j]];
                    PdVector p2 = vertices[elements[i].m_data[(j + 1) % size]];
                    PdVector p3 = vertices[elements[i].m_data[(j + 2) % size]];
                    int o = geom.getOppVertexInd(i, j);
                    PdVector p4 = vertices[o];
                    energy += PnBending.atomicEnergy(p1, p2, p3, p4);
                }
                ++j;
            }
            ++i;
        }
        return energy;
    }

    private static final double atomicEnergy(PdVector a, PdVector b, PdVector c, PdVector d) {
        e.sub(b, c);
        je.sub(a, b);
        vec.cross(e, je);
        double areaStar = vec.length();
        je.sub(d, b);
        vec.cross(e, je);
        areaStar += vec.length();
        PdVector he = je;
        PdVector store = e;
        PuVectorGeom.ctg((double[])store.m_data, (PdVector)a, (PdVector)b, (PdVector)c);
        int i = 0;
        while (i < a.m_data.length) {
            he.m_data[i] = store.m_data[1] * (c.m_data[i] - a.m_data[i]) + store.m_data[2] * (b.m_data[i] - a.m_data[i]);
            ++i;
        }
        PuVectorGeom.ctg((double[])store.m_data, (PdVector)d, (PdVector)c, (PdVector)b);
        i = 0;
        while (i < a.m_data.length) {
            int n = i;
            he.m_data[n] = he.m_data[n] + (store.m_data[2] * (c.m_data[i] - d.m_data[i]) + store.m_data[1] * (b.m_data[i] - d.m_data[i]));
            ++i;
        }
        return 1.5 * PdVector.dot((PdVector)he, (PdVector)he) / areaStar;
    }

    public static PdVector evaluateGradient(PgElementSet geom, PdVector vertPositions, PdVector gradient) {
        int nov = geom.getNumVertices();
        int m = nov * 3;
        if (gradient == null) {
            gradient = new PdVector(m);
        } else if (gradient.getSize() != m) {
            gradient.setSize(m);
        }
        gradient.setConstant(0.0);
        if (e == null) {
            e = new PdVector(3);
        }
        if (je == null) {
            je = new PdVector(3);
        }
        if (vec == null) {
            vec = new PdVector(3);
        }
        PdVector g = new PdVector(3);
        int noe = geom.getNumElements();
        PiVector[] elements = geom.getElements();
        PiVector[] neighbor = geom.getNeighbours();
        PdVector[] p = PdVector.realloc(null, (int)4, (int)3);
        PdVector[] n = PdVector.realloc(null, (int)2, (int)3);
        int i = 0;
        while (i < noe) {
            int size = elements[i].m_data.length;
            int j = 0;
            while (j < size) {
                if (neighbor[i].m_data[j] >= i) {
                    int h = 3 * elements[i].m_data[j];
                    int k = 0;
                    while (k < 3) {
                        p[0].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    int jp = (j + 1) % size;
                    h = 3 * elements[i].m_data[jp];
                    k = 0;
                    while (k < 3) {
                        p[1].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    jp = (j + 2) % size;
                    h = 3 * elements[i].m_data[jp];
                    k = 0;
                    while (k < 3) {
                        p[2].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    int o = geom.getOppVertexInd(i, j);
                    h = 3 * o;
                    k = 0;
                    while (k < 3) {
                        p[3].m_data[k] = vertPositions.m_data[h + k];
                        ++k;
                    }
                    e.sub(p[2], p[1]);
                    je.sub(p[1], p[0]);
                    n[0].cross(je, e);
                    double a0 = n[0].length();
                    n[0].multScalar(1.0 / a0);
                    a0 *= 0.5;
                    je.sub(p[3], p[1]);
                    n[1].cross(je, e);
                    double a1 = n[1].length();
                    n[1].multScalar(1.0 / a1);
                    PnBending.gradP1(p[0], p[1], p[2], p[3], n[0], n[1], a0, a1 *= 0.5, g);
                    int v = 3 * elements[i].m_data[j];
                    k = 0;
                    while (k < 3) {
                        int n2 = v + k;
                        gradient.m_data[n2] = gradient.m_data[n2] + g.m_data[k];
                        ++k;
                    }
                    PnBending.gradP2(p[0], p[1], p[2], p[3], n[0], n[1], a0, a1, g);
                    v = 3 * elements[i].m_data[(j + 1) % size];
                    k = 0;
                    while (k < 3) {
                        int n3 = v + k;
                        gradient.m_data[n3] = gradient.m_data[n3] + g.m_data[k];
                        ++k;
                    }
                    PnBending.gradP1(p[3], p[2], p[1], p[0], n[1], n[0], a1, a0, g);
                    v = 3 * o;
                    k = 0;
                    while (k < 3) {
                        int n4 = v + k;
                        gradient.m_data[n4] = gradient.m_data[n4] + g.m_data[k];
                        ++k;
                    }
                    PnBending.gradP2(p[3], p[2], p[1], p[0], n[1], n[0], a1, a0, g);
                    v = 3 * elements[i].m_data[(j + 2) % size];
                    k = 0;
                    while (k < 3) {
                        int n5 = v + k;
                        gradient.m_data[n5] = gradient.m_data[n5] + g.m_data[k];
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return gradient;
    }

    public static PdVector evaluateGradient(PgElementSet geom, PdVector gradient) {
        int nov = geom.getNumVertices();
        int m = nov * 3;
        if (gradient == null) {
            gradient = new PdVector(m);
        } else if (gradient.getSize() != m) {
            gradient.setSize(m);
        }
        gradient.setConstant(0.0);
        if (e == null) {
            e = new PdVector(3);
        }
        if (je == null) {
            je = new PdVector(3);
        }
        if (vec == null) {
            vec = new PdVector(3);
        }
        PdVector g = new PdVector(3);
        int noe = geom.getNumElements();
        PdVector[] vertices = geom.getVertices();
        PiVector[] elements = geom.getElements();
        PiVector[] neighbor = geom.getNeighbours();
        PdVector[] normals = geom.getElementNormals();
        int i = 0;
        while (i < noe) {
            int size = elements[i].m_data.length;
            int j = 0;
            while (j < size) {
                if (neighbor[i].m_data[j] >= i) {
                    PdVector p1 = vertices[elements[i].m_data[j]];
                    PdVector p2 = vertices[elements[i].m_data[(j + 1) % size]];
                    PdVector p3 = vertices[elements[i].m_data[(j + 2) % size]];
                    int o = geom.getOppVertexInd(i, j);
                    PdVector p4 = vertices[o];
                    int n = neighbor[i].m_data[j];
                    PdVector n1 = normals[i];
                    PdVector n2 = normals[n];
                    double a1 = geom.getAreaOfElement(i);
                    double a2 = geom.getAreaOfElement(n);
                    PnBending.gradP1(p1, p2, p3, p4, n1, n2, a1, a2, g);
                    int v = 3 * elements[i].m_data[j];
                    int k = 0;
                    while (k < 3) {
                        int n3 = v + k;
                        gradient.m_data[n3] = gradient.m_data[n3] + g.m_data[k];
                        ++k;
                    }
                    PnBending.gradP2(p1, p2, p3, p4, n1, n2, a1, a2, g);
                    v = 3 * elements[i].m_data[(j + 1) % size];
                    k = 0;
                    while (k < 3) {
                        int n4 = v + k;
                        gradient.m_data[n4] = gradient.m_data[n4] + g.m_data[k];
                        ++k;
                    }
                    PnBending.gradP1(p4, p3, p2, p1, n2, n1, a2, a1, g);
                    v = 3 * o;
                    k = 0;
                    while (k < 3) {
                        int n5 = v + k;
                        gradient.m_data[n5] = gradient.m_data[n5] + g.m_data[k];
                        ++k;
                    }
                    PnBending.gradP2(p4, p3, p2, p1, n2, n1, a2, a1, g);
                    v = 3 * elements[i].m_data[(j + 2) % size];
                    k = 0;
                    while (k < 3) {
                        int n6 = v + k;
                        gradient.m_data[n6] = gradient.m_data[n6] + g.m_data[k];
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return gradient;
    }

    private static PdVector gradP1(PdVector p1, PdVector p2, PdVector p3, PdVector p4, PdVector n1, PdVector n2, double a1, double a2, PdVector gradient) {
        double w = (1.0 - PdVector.dot((PdVector)n1, (PdVector)n2)) / (2.0 * (a1 + a2));
        e.sub(p3, p2);
        je.cross(n1, e);
        gradient.multScalar(je, w);
        w = -PdVector.dot((PdVector)n2, (PdVector)je) / (2.0 * a1);
        vec.multScalar(n1, w);
        gradient.add(vec);
        w = -3.0 * PdVector.dot((PdVector)e, (PdVector)e) / (a1 + a2);
        gradient.multScalar(w);
        return gradient;
    }

    private static PdVector gradP2(PdVector p1, PdVector p2, PdVector p3, PdVector p4, PdVector n1, PdVector n2, double a1, double a2, PdVector gradient) {
        double w = 6.0 * (1.0 - PdVector.dot((PdVector)n1, (PdVector)n2)) / (a1 + a2);
        e.sub(p2, p3);
        gradient.multScalar(e, w);
        w *= -0.25 * PdVector.dot((PdVector)e, (PdVector)e) / (a1 + a2);
        e.sub(p1, p3);
        je.cross(n1, e);
        e.sub(p3, p4);
        vec.cross(n2, e);
        vec.add(je);
        vec.multScalar(w);
        gradient.add(vec);
        w = PdVector.dot((PdVector)je, (PdVector)n2) / a1;
        vec.multScalar(n1, w);
        je.cross(n2, e);
        w = PdVector.dot((PdVector)je, (PdVector)n1) / a2;
        je.multScalar(n2, w);
        vec.add(je);
        e.sub(p3, p2);
        w = 1.5 * PdVector.dot((PdVector)e, (PdVector)e) / (a1 + a2);
        vec.multScalar(w);
        gradient.add(vec);
        return gradient;
    }
}

