/*
 * Decompiled with CFR 0.152.
 */
package dev.numeric;

import dev.numeric.PnTaucsSolver;
import dev.numeric.PnTaucsSparseLDLTFactorization;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.numeric.PnBandEigenSolver;
import jvx.numeric.PnLanczos;
import jvx.numeric.PnSparseMatrix;

public class PnBandEigenSolverTaucs
extends PnBandEigenSolver
implements PnLanczos.PnMatrixVectorProductIf {
    protected PnSparseMatrix m_matrix;
    protected PnTaucsSparseLDLTFactorization m_LDLt;

    public PnBandEigenSolverTaucs() {
        this.setName("band-by-band Taucs");
        if (((Object)((Object)this)).getClass() == PnBandEigenSolverTaucs.class) {
            this.init();
        }
    }

    protected PnLanczos getLanczos() {
        return new PnLanczos((PnLanczos.PnMatrixVectorProductIf)this);
    }

    protected void shiftSpectrum(double shift) {
        PdVector[] entries = this.m_matrix.getEntries();
        int i = 0;
        while (i < this.m_matrix.getNumRows()) {
            PiVector indices = this.m_matrix.getColIndices(i);
            int j = 0;
            while (j < indices.getSize()) {
                if (indices.m_data[j] == i) {
                    int n = j;
                    entries[i].m_data[n] = entries[i].m_data[n] - shift;
                }
                ++j;
            }
            ++i;
        }
        if (this.m_LDLt != null) {
            this.m_LDLt.freeFactorization();
            this.m_LDLt = null;
        }
    }

    public void init() {
        super.init();
    }

    protected void destroy() {
        this.m_LDLt.freeFactorization();
        this.m_LDLt = null;
    }

    public int getDimension() {
        return this.m_matrix.getNumRows();
    }

    public PdVector run(PdVector v) {
        if (this.m_LDLt == null) {
            try {
                this.m_LDLt = new PnTaucsSparseLDLTFactorization(this.m_matrix);
            }
            catch (Exception e) {
                PsDebug.error((String)"Unable to factorize matrix with TAUCS.", (Object)e);
            }
        }
        PdVector w = new PdVector(v.getSize());
        try {
            this.m_LDLt.solveUseFactorization(w, v);
        }
        catch (Exception e) {
            PsDebug.error((String)"Unable to solve linear system using TAUCS.", (Object)e);
        }
        return w;
    }

    public Object getMatrix() {
        return this.m_matrix;
    }

    public void setMatrix(Object matrix) {
        this.m_matrix = (PnSparseMatrix)matrix;
    }

    public boolean isAvailable() {
        return PnTaucsSolver.isAvailable();
    }

    public int getInputType() {
        return 1;
    }
}

